/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/mgr/EmailAccountManagerModel
 */
define(['baja!', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel'], function (baja, MgrModel) {
  'use strict';

  /**
   * `MgrModel` for the Email Account Manager.
    * @class
   * @alias module:nmodule/email/rc/mgr/EmailAccountManagerModel
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrModel
   */
  var EmailAccountManagerModel = function EmailAccountManagerModel() {
    MgrModel.apply(this, arguments);
  };
  EmailAccountManagerModel.prototype = Object.create(MgrModel.prototype);
  EmailAccountManagerModel.prototype.constructor = EmailAccountManagerModel;

  /**
   * Creates a new instances of the given typeInfo.
   *
   * @returns a newly created instance of the given type
   */
  EmailAccountManagerModel.prototype.newInstance = function (typeInfo) {
    return MgrModel.prototype.newInstance.apply(this, arguments).then(function (newInstance) {
      // USER_DEFINED_2 flag must be set in order to skip migration of values of deprecated
      // account/password properties to the authenticator instances' properties.
      var newFlags = newInstance.getEmailAuthenticator().getFlags() | baja.Flags.USER_DEFINED_2;
      newInstance.setFlags({
        slot: 'emailAuthenticator',
        flags: newFlags
      });
      var oauthClientSecretAuthenticatorTypeSpec = baja.$('baja:TypeSpec', 'email:OAuthEmailClientSecretAuthenticator');
      newInstance.getEmailAuthenticator().setTypeSpec(oauthClientSecretAuthenticatorTypeSpec);
      newInstance.setUseSsl(true);
      return baja.importTypes(['email:Store']).then(function () {
        if (baja.hasType(newInstance, 'email:IncomingAccount')) {
          newInstance.setStore(baja.$('email:Store').get('imap'));
          var defaultIMAPSPort = 993;
          newInstance.setPort(defaultIMAPSPort);
        } else {
          // Outgoing Accounts use SMTP exclusively.
          var defaultSMTPSPort = 587;
          newInstance.setPort(defaultSMTPSPort);
        }
        return newInstance;
      });
    });
  };
  return EmailAccountManagerModel;
});
