function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/mgr/EmailAccountManager
 */
define(['baja!', 'baja!email:EmailAccount,email:IncomingAccount,email:OutgoingAccount', 'lex!email', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/email/rc/mgr/EmailAccountManagerModel', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/email/rc/mgr/EmailAccountColumn', 'nmodule/email/rc/mgr/EmailAuthenticationColumn', 'nmodule/email/rc/mgr/EmailProtocolColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils'], function (baja, types, lex, Promise, _, mgrUtils, Manager, EmailAccountManagerModel, MgrTypeInfo, ContainerComponentSource, IconMgrColumn, NameMgrColumn, PropertyMgrColumn, EmailAccountColumn, EmailAuthenticationColumn, EmailProtocolColumn, Column, DepthSubscriber, addContextMenuSupport, componentStatusUtils) {
  'use strict';

  var _lex = _slicedToArray(lex, 1),
    emailLexicon = _lex[0];
  var IN_ACCOUNT_TYPE = baja.lt("email:IncomingAccount"),
    OUT_ACCOUNT_TYPE = baja.lt("email:OutgoingAccount"),
    INBOX_ICON = baja.Icon.make('module://icons/x16/inbox.png'),
    OUTBOX_ICON = baja.Icon.make('module://icons/x16/outbox.png'),
    EDITABLE = Column.flags.EDITABLE,
    UNSEEN = Column.flags.UNSEEN,
    READONLY = Column.flags.READONLY,
    EDITABLE_UNSEEN = EDITABLE | UNSEEN;
  function makeColumns() {
    function toColumn(slot, params) {
      params = params || {};
      var Ctor = params.ctor || PropertyMgrColumn,
        flags = params.flags || EDITABLE,
        type = params.type || IN_ACCOUNT_TYPE,
        displayName = params.displayName;
      return new Ctor(slot, {
        type: type,
        flags: flags,
        displayName: displayName
      });
    }

    //READONLY
    var icon = new IconMgrColumn(),
      status = toColumn('status', {
        flags: READONLY
      }),
      //EDITABLE
      name = new NameMgrColumn({
        flags: EDITABLE
      }),
      hostName = toColumn('hostname'),
      account = toColumn('account', {
        ctor: EmailAccountColumn,
        flags: READONLY
      }),
      pollrate = toColumn('pollrate'),
      transport = toColumn('transport', {
        ctor: EmailProtocolColumn,
        type: OUT_ACCOUNT_TYPE
      }),
      auth = toColumn('emailAuthenticator', {
        ctor: EmailAuthenticationColumn,
        flags: EDITABLE,
        displayName: emailLexicon.get('EmailAccountManager.column.authenticationType')
      }),
      //EDITABLE + UNSEEN
      enabled = toColumn('enabled', {
        flags: EDITABLE_UNSEEN
      }),
      port = toColumn('port', {
        flags: EDITABLE_UNSEEN
      }),
      password = toColumn('password', {
        flags: EDITABLE_UNSEEN
      }),
      useSsl = toColumn('useSsl', {
        flags: EDITABLE_UNSEEN
      });
    icon.getValueFor = function (row) {
      var subject = row.getSubject();
      return baja.hasType(subject, IN_ACCOUNT_TYPE) ? INBOX_ICON : baja.hasType(subject, OUT_ACCOUNT_TYPE) ? OUTBOX_ICON : row.getIcon();
    };
    return [icon, name, enabled, transport, hostName, port, auth, account, password, pollrate, status, useSsl];
  }

  /**
   * EmailAccountManager
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   * @alias module:nmodule/history/rc/EmailAccountManager
   */
  var EmailAccountManager = function EmailAccountManager(params) {
    Manager.call(this, _.extend({
      moduleName: 'email',
      keyName: 'EmailAccountUxManager'
    }, params));
    this.$sub = new DepthSubscriber(3);
    addContextMenuSupport(this);
  };

  //extend and set up prototype chain
  EmailAccountManager.prototype = Object.create(Manager.prototype);
  EmailAccountManager.prototype.constructor = EmailAccountManager;

  /**
   * Returns a reference to the Edit command
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  EmailAccountManager.prototype.$getEditCommand = function () {
    return this.getCommandGroup().get(1);
  };

  /**
   * Create a MgrModel instance from a email:EmailService component source
   * @private
   * @param emailService
   */
  EmailAccountManager.prototype.makeModel = function (emailService) {
    return MgrTypeInfo.make(['email:IncomingAccount', 'email:OutgoingAccount']).then(function (newTypes) {
      return new EmailAccountManagerModel({
        componentSource: new ContainerComponentSource({
          container: emailService,
          filter: ['email:IncomingAccount', 'email:OutgoingAccount']
        }),
        newTypes: newTypes,
        columns: makeColumns()
      });
    });
  };

  /**
   * Override load() method from parent to map email:EmailService
   * load value to a MgrModel instance
   * @param emailService
   * @returns {Promise}
   */
  EmailAccountManager.prototype.doLoad = function (emailService) {
    var that = this;
    return that.$sub.subscribe(emailService).then(function () {
      return Manager.prototype.doLoad.call(that, emailService);
    }).then(function () {
      var selection = mgrUtils.getMainTableSelection(that),
        editCmd = that.$getEditCommand();
      selection.on('changed', function () {
        editCmd.setEnabled(!selection.isEmpty());
      });
    });
  };

  /**
   * Override to update manager row color based on the corresponding email account's status
   * @param row
   * @param dom
   * @returns {jQuery} dom element with updated status coloring
   */
  EmailAccountManager.prototype.finishMainTableRow = function (row, dom) {
    var account = row.getSubject(),
      status = baja.Status.getStatusFromIStatus(account);
    componentStatusUtils.addComponentStatusCss(status, dom);
    return dom;
  };

  /**
   * Destroy the main view table / unsubscribe
   * @returns {Promise}
   */
  EmailAccountManager.prototype.doDestroy = function () {
    return Promise.all([this.$sub.unsubscribeAll(), Manager.prototype.doDestroy.apply(this, arguments)]);
  };

  ////////////////////////////////////////////////////////////
  //Context Menu Support
  ////////////////////////////////////////////////////////////

  /**
   * Callback from CommandGroupContextMenu. Trigger context menus specifically on table row right clicks
   * @override
   * @returns {string}
   */
  EmailAccountManager.prototype.getContextMenuSelector = function () {
    return 'tr';
  };

  /**
   * Overrides the default onMainTableDblClicked and invokes the EditCommand
   * @inheritDoc
   */
  EmailAccountManager.prototype.onMainTableDblClicked = function (event, subjects) {
    return this.$getEditCommand().invoke();
  };

  /**
   * Overrides the default onTableSelectionChanged and enables/disables the EditCommand
   * @inheritDoc
   */
  EmailAccountManager.prototype.onTableSelectionChanged = function (selectedSubjects) {
    var mainTableSelection = selectedSubjects.mainTableSelection;
    var editCmd = this.$getEditCommand();
    editCmd.setEnabled(!(mainTableSelection.length === 0));
    return Promise.resolve();
  };

  /**
   * Callback from ContextMenuSupport to provide a chance to pre-process
   * the right click menu's CommandGroup prior to displaying it
   *
   * @param {module:bajaux/commands/CommandGroup} group default CommandGroup
   * consisting of subject's menu agents
   * @returns {module:bajaux/commands/CommandGroup} updated CommandGroup
   */
  EmailAccountManager.prototype.updateMenuCommandGroup = function (group) {
    if (group) {
      group.add(this.$getEditCommand());
    }
    return group;
  };

  /////////////////////////////////////////////////////////////////

  return EmailAccountManager;
});
