function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/** @jsx UxModel.jsx */
/* eslint-env browser */
/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/jobBuilder/NiagaraNetworkJobEditor
 * @since Niagara 4.14
 */

define(['baja!', 'baja!bajaui:Orientation,batchJob:NetworkJobStep,batchJob:DeviceJobStep', 'lex!bajaui,batchJob,provisioningNiagara', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/spandrel', 'bajaux/util/CommandButtonGroup', 'bajaux/Widget', 'dialogs', 'Promise', 'underscore', 'nmodule/bajaui/rc/model/UxModel', 'nmodule/bajaui/rc/ux/SplitPane', 'nmodule/batchJob/rc/baja/ValueList', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/provisioningNiagara/rc/wb/jobBuilder/DeviceTree', 'nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget', 'nmodule/provisioningNiagara/rc/util/provisioningNiagaraUtils', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/servlets/registry', 'nmodule/webEditors/rc/servlets/resolveServerSide', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn'], function (baja, types, lexs, Command, CommandGroup, spandrel, CommandButtonGroup, Widget, dialogs, Promise, _, UxModel, SplitPane, ValueList, asyncUtils, DeviceTree, ListWidget, provisioningNiagaraUtils, BaseWidget, feDialogs, BooleanEditor, DepthSubscriber, spaceUtils, registry, resolveServerSide, addContextMenuSupport, Table, Row, TableModel, IconColumn, JsonObjectPropertyColumn) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-NiagaraNetworkJobEditor'
      }
    };
  };
  var saveStepsToJob = provisioningNiagaraUtils.saveStepsToJob,
    saveStationsToJob = provisioningNiagaraUtils.saveStationsToJob;
  var pluck = _.pluck;
  var resolveToString = resolveServerSide.resolveToString;
  var doRequire = asyncUtils.doRequire;
  var getTypes = registry.getTypes,
    getTypeInfo = registry.getTypeInfo,
    getAgentOnInfo = registry.getAgentOnInfo;
  var resolveService = spaceUtils.resolveService;
  var VERTICAL = baja.$('bajaui:Orientation', 'vertical');
  var _lexs = _slicedToArray(lexs, 3),
    LEX_BAJAUI = _lexs[0],
    LEX_BATCHJOB = _lexs[1],
    LEX_PROVISIONING = _lexs[2],
    JOB_FAIL_ALARM_LABEL = LEX_PROVISIONING.get("NiagaraNetworkJobEditor.alertOnStepFailure"),
    JOB_SUCCESS_ALARM_LABEL = LEX_PROVISIONING.get("NiagaraNetworkJobEditor.alertOnJobSuccess"),
    STEPS_TITLE = LEX_PROVISIONING.get('NiagaraNetworkJobEditor.provisioningSteps.header'),
    STATIONS_TITLE = LEX_PROVISIONING.get('NiagaraNetworkJobEditor.stationList.header');
  function hasNiagaraStationDevices(comp) {
    var hasStations = false;
    if (baja.hasType(comp, 'niagaraDriver:NiagaraStation')) {
      hasStations = true;
    } else if (comp.getType().isComponent()) {
      comp.getSlots().properties().each(function (slot) {
        if (hasNiagaraStationDevices(comp.get(slot))) {
          hasStations = true;
        }
      });
    }
    return hasStations;
  }
  function getStageSteps(stage, stepTypeFilter) {
    var steps = stage.get('steps');
    return steps && steps.getSlots().properties().is(stepTypeFilter).toValueArray() || [];
  }
  function stepToDisplayString(jobStep) {
    return resolveToString([jobStep]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        displayName = _ref2[0];
      return displayName;
    });
  }
  function getIcon(device) {
    // TODO Get the correct device icon
    return Promise.resolve(device.getIcon());
  }

  /**
   * This class functions as a base class building all the necessary UI and any common functionality
   *
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/jobBuilder/NiagaraNetworkJobEditor
   * @extends {module:bajaux/spandrel}
   */
  return /*#__PURE__*/function (_spandrel) {
    function NiagaraNetworkJobEditor(params) {
      var _this;
      _classCallCheck(this, NiagaraNetworkJobEditor);
      _this = _callSuper(this, NiagaraNetworkJobEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$makeViewCommands();
      addContextMenuSupport(_this);
      _this.$deviceContainerSubscriber = new DepthSubscriber({
        depth: Number.MAX_VALUE,
        subscriptionFilter: function subscriptionFilter(_ref3) {
          var component = _ref3.component;
          var type = component.getType();
          return type.is('niagaraDriver:NiagaraStation') || type.is('niagaraDriver:NiagaraStationFolder');
        }
      });
      return _this;
    }

    /**
     * @returns {Promise}
     */
    _inherits(NiagaraNetworkJobEditor, _spandrel);
    return _createClass(NiagaraNetworkJobEditor, [{
      key: "doDestroy",
      value: function doDestroy() {
        return Promise.all([this.$deviceContainerSubscriber.unsubscribeAll(), _superPropGet(NiagaraNetworkJobEditor, "doDestroy", this, 3)(arguments)]);
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "runNow",
      value: function runNow() {
        // Get all steps from listOfSteps
        // Get all stations from listOfStations
        // Call doRunNow implementation
        return this.doRunNow([], [], {});
      }

      /**
       * @param {Array.<object>} allSteps
       * @param {Array.<object>} allStations
       * @param {object} [params]
       */
    }, {
      key: "doRunNow",
      value: function doRunNow(allSteps, allStations, params) {
        throw new Error('Not Implemented');
      }

      /**
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "getRunNowCommand",
      value: function getRunNowCommand() {
        return this.$editorCmdGroup.get(0);
      }

      /**
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getStepFailBooleanEditor",
      value: function getStepFailBooleanEditor() {
        return this.queryWidget('header/alertOnStepFailure');
      }

      /**
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getJobSuccessBooleanEditor",
      value: function getJobSuccessBooleanEditor() {
        return this.queryWidget('header/alertOnJobSuccess');
      }

      /**
       * @returns {module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget}
       */
    }, {
      key: "getStepsListWidget",
      value: function getStepsListWidget() {
        return this.queryWidget('splitPane').$getWidget1();
      }

      /**
       * @returns {module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget}
       */
    }, {
      key: "getStationsListWidget",
      value: function getStationsListWidget() {
        return this.queryWidget('splitPane').$getWidget2();
      }

      /**
       * @override
       * @returns {string}
       */
    }, {
      key: "getContextMenuSelector",
      value: function getContextMenuSelector() {
        return 'tr';
      }

      /**
       * @private
       * @param {baja.Component} job the `provisioningNiagara:NiagaraNetworkJob` to save to
       * @returns {Promise}
       */
    }, {
      key: "$saveJob",
      value: function $saveJob(job) {
        var _this$state = this.state(),
          alertOnStepFailure = _this$state.alertOnStepFailure,
          alertOnJobSuccess = _this$state.alertOnJobSuccess,
          steps = _this$state.steps,
          stations = _this$state.stations;
        return Promise.all([job.set({
          slot: 'alertOnStepFailure',
          value: alertOnStepFailure
        }), job.set({
          slot: 'alertOnJobSuccess',
          value: alertOnJobSuccess
        }), this.$saveStepsToJob(job, pluck(steps, 'value')), this.$saveStationsToJob(job, pluck(stations, 'value').map(function (station) {
          return station.deviceId;
        }))]);
      }

      /**
       * Save stations to the job. The job may be a prototype job or an in-memory network job.
       *
       * @private
       * @param {baja.Component} job the `provisioningNiagara:NiagaraNetworkJob` to save to
       * @param {Array.<string>} stationNames
       * @returns {Promise}
       */
    }, {
      key: "$saveStationsToJob",
      value: function $saveStationsToJob(job, stationNames) {
        var stationList = ValueList.make(stationNames);
        return saveStationsToJob(stationList, job);
      }

      /**
       * Save steps to the job. The job may be a prototype job or an in-memory network job.
       *
       * @private
       * @param {baja.Component} job the `provisioningNiagara:NiagaraNetworkJob` to save to
       * @param {Array.<baja.Component>} steps the `batchJob:JobStep`s to save
       * @returns {Promise}
       */
    }, {
      key: "$saveStepsToJob",
      value: function $saveStepsToJob(job, steps) {
        return saveStepsToJob(steps, job);
      }

      /**
       * Resolves the Ux implementations for batchJob:IUxJobStepFactory.
       *
       * @private
       * @returns {Promise.<Array.<module:nmodule/batchJob/rc/baja/UxJobStepFactory>>}
       */
    }, {
      key: "$getUxJobStepFactories",
      value: function $getUxJobStepFactories() {
        return getTypes({
          targetType: 'batchJob:IUxJobStepFactory',
          showAbstract: false,
          showInterface: false
        }).then(function (jobSteps) {
          return getTypeInfo(jobSteps.map(function (jobStep) {
            return jobStep.type;
          }));
        }).then(function (jobStepTypeInfos) {
          return Promise.all(jobStepTypeInfos.map(function (jobStepTypeInfo) {
            return doRequire(jobStepTypeInfo.js.id, jobStepTypeInfo.js.deps).then(function (Factory) {
              return new Factory();
            });
          })).then(function (factories) {
            return factories.filter(function (factory) {
              return factory.$isValidFor();
            });
          });
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$getBatchJobService",
      value: function $getBatchJobService() {
        return resolveService('batchJob:BatchJobService');
      }

      /**
       * @private
       * @param {module:nmodule/batchJob/rc/baja/UxJobStepFactory} factory
       * @returns {Promise<module:nmodule/webEditors/rc/wb/table/model/Row>}
       */
    }, {
      key: "$makeRow",
      value: function $makeRow(factory) {
        if (factory) {
          return Promise.all([factory.toDisplayName(), factory.toDescription(), factory.toIcon()]).then(function (_ref4) {
            var _ref5 = _slicedToArray(_ref4, 3),
              displayName = _ref5[0],
              description = _ref5[1],
              icon = _ref5[2];
            return new Row({
              factory: factory,
              displayName: displayName,
              description: description,
              icon: icon
            }, icon);
          });
        }
      }

      /**
       * Prompts user to choose a factory implementation of UxJobStepFactory.
       *
       * @private
       * @param {Array.<module:nmodule/batchJob/rc/baja/UxJobStepFactory>} factories
       * @returns {Promise.<module:nmodule/batchJob/rc/baja/UxJobStepFactory|null>}
       */
    }, {
      key: "$promptUserToChooseAFactory",
      value: function $promptUserToChooseAFactory(factories) {
        var _this2 = this;
        return Promise.all(factories.map(function (factory) {
          return _this2.$makeRow(factory);
        })).then(function (rows) {
          var typeColumn = new JsonObjectPropertyColumn('displayName', {
            displayName: LEX_BATCHJOB.get('JobStepChooser.name')
          });
          var descriptionColumn = new JsonObjectPropertyColumn('description', {
            displayName: LEX_BATCHJOB.get('JobStepChooser.summary')
          });
          var iconColumn = new IconColumn('icon');
          var columns = [iconColumn, typeColumn, descriptionColumn];
          var tableModel = new TableModel({
            rows: rows,
            columns: columns
          });
          //Sort rows by display anme
          tableModel.sort(function (rowToCompare, rowToBeComparedWith) {
            return rowToCompare.getSubject().displayName.localeCompare(rowToBeComparedWith.getSubject().displayName);
          });
          return feDialogs.showFor({
            title: LEX_BATCHJOB.get('JobStageBuilder.add.label'),
            summary: LEX_BATCHJOB.get('JobStepChooser.dlgMessage'),
            type: _this2.$getSelectedStepsTable(),
            value: tableModel,
            formFactor: 'mini'
          }).then(function (factories) {
            //Returns null if factories is empty or null
            return factories && factories[0] || null;
          });
        });
      }

      /**
       * Adds jobStep to the steps in the widget state.
       *
       * @private
       * @param {module:nmodule/batchJob/rc/baja/UxJobStepFactory} selectedFactory
       * @returns {Promise}
       */
    }, {
      key: "$addStepsFromSelectedFactory",
      value: function $addStepsFromSelectedFactory(selectedFactory) {
        var _this3 = this;
        var _this$state2 = this.state(),
          deviceContainer = _this$state2.deviceContainer;
        return Promise.resolve(selectedFactory.makeStep({
          deviceContainer: deviceContainer
        })).then(function (steps) {
          if (steps) {
            return _this3.$convertJobStepsToListWidgetObjects(steps).then(function (listWidgetObjs) {
              var _this3$state = _this3.state(),
                steps = _this3$state.steps;
              return _this3.state({
                steps: [].concat(_toConsumableArray(steps), _toConsumableArray(listWidgetObjs))
              });
            }).then(function () {
              return _this3.setModified(true);
            });
          }
        });
      }

      /**
       * Converts one or more JobStep objects to ListWidgetObjects
       *
       * @private
       * @param {Array<baja.Component> | baja.Component} jobSteps
       * @returns {Promise.<Array.<module:nmodule/provisioningNiagara/rc/wb/jobBuilder/NiagaraNetworkJobEditor~ListWidgetObject>>}
       */
    }, {
      key: "$convertJobStepsToListWidgetObjects",
      value: function $convertJobStepsToListWidgetObjects(jobSteps) {
        var _this4 = this;
        var promises = [];
        jobSteps = Array.isArray(jobSteps) ? jobSteps : [jobSteps];
        jobSteps.forEach(function (jobStep) {
          var promise = _this4.$convertJobStepToListWidgetObject(jobStep);
          promises.push(promise);
        });
        return Promise.all(promises);
      }

      /**
       * Converts JobStep object to ListWidgetObject.
       *
       * @private
       * @param {baja.Component} jobStep
       * @returns {Promise.<module:nmodule/provisioningNiagara/rc/wb/jobBuilder/NiagaraNetworkJobEditor~ListWidgetObject>}
       */
    }, {
      key: "$convertJobStepToListWidgetObject",
      value: function $convertJobStepToListWidgetObject(jobStep) {
        return resolveToString([jobStep]).then(function (_ref6) {
          var _ref7 = _slicedToArray(_ref6, 1),
            displayName = _ref7[0];
          return {
            displayName: displayName,
            icon: jobStep.getIcon(),
            value: jobStep
          };
        });
      }

      /**
       * Handler for the steps list widget add command
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$promptUserToAddSteps",
      value: function $promptUserToAddSteps() {
        var _this5 = this;
        return this.$getBatchJobService().then(function (service) {
          if (!service.getEnabled()) {
            //Error will be displayed if BatchJobService is disabled
            return feDialogs.error(LEX_PROVISIONING.get('batchJobService.disabled.message'));
          }
          //Proceed only if BatchJobService is available and enabled.
          return _this5.$getUxJobStepFactories().then(function (factories) {
            return _this5.$promptUserToChooseAFactory(factories);
          }).then(function (selectedFactory) {
            if (selectedFactory) {
              return _this5.$addStepsFromSelectedFactory(selectedFactory);
            }
          });
        });
      }

      /**
       * @private
       * @returns {SelectedStepsTable}
       */
    }, {
      key: "$getSelectedStepsTable",
      value: function $getSelectedStepsTable() {
        /**
         * @inner
         * @class
         * @extends {module:nmodule/webEditors/rc/wb/table/Table}
         */
        var SelectedStepsTable = /*#__PURE__*/function (_Table) {
          function SelectedStepsTable() {
            var _this6;
            _classCallCheck(this, SelectedStepsTable);
            _this6 = _callSuper(this, SelectedStepsTable, arguments);
            //Dialog can be submitted only if a row is selected.
            _this6.validators().add(function (readRows) {
              if (readRows.length !== 1) {
                throw new Error(LEX_PROVISIONING.get('NiagaraNetworkJobEditor.oneRowAllowedMsg'));
              }
            });
            return _this6;
          }

          /**
           * @param {JQuery} dom
           * @returns {Promise}
           */
          _inherits(SelectedStepsTable, _Table);
          return _createClass(SelectedStepsTable, [{
            key: "doInitialize",
            value: function doInitialize(dom) {
              var _this7 = this;
              //Double-click on a row will validate the row length and trigger value_ready_event,
              //which will submit dialog that has this table and resolves to JobStepFactory.
              dom.on('dblclick', function () {
                _this7.validate().then(function (result) {
                  return dom.trigger(BaseWidget.VALUE_READY_EVENT, [result]);
                })["catch"](function (ignore) {});
              });
              //When user selects on the row, table will be set to modified,
              //and in turn that calls validate(), which will throw error and disables OK button
              //if more than one row was selected at any point.
              dom.on(Table.ROW_SELECTION_CHANGED_EVENT, function () {
                return _this7.setModified(true);
              });
              return _superPropGet(SelectedStepsTable, "doInitialize", this, 3)(arguments);
            }

            /**
             * @returns {Array.<baja.Component>}
             */
          }, {
            key: "doRead",
            value: function doRead() {
              return this.getSelectedRows().map(function (row) {
                return row.getSubject().factory;
              });
            }
          }]);
        }(Table);
        return SelectedStepsTable;
      }

      /**
       * Handler for the stations list widget add command
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$promptUserToAddStations",
      value: function $promptUserToAddStations() {
        var _this8 = this;
        var _this$state3 = this.state(),
          stations = _this$state3.stations,
          deviceContainer = _this$state3.deviceContainer;
        if (!this.$hasStationsToAdd(deviceContainer)) {
          return dialogs.showOk({
            title: LEX_BATCHJOB.get('DeviceList.add.noDevices.dlgTitle'),
            text: LEX_BATCHJOB.get('DeviceList.add.noDevices.dlgMessage')
          });
        } else {
          return feDialogs.showFor({
            title: LEX_BATCHJOB.get('DeviceList.add.dlgTitle'),
            summary: LEX_BATCHJOB.get('DeviceList.add.dlgMessage'),
            type: DeviceTree,
            value: {
              deviceContainer: deviceContainer,
              devicesInJob: stations
            },
            buttons: {
              checkAll: {
                displayName: LEX_BATCHJOB.get('DeviceList.add.checkAll.label'),
                handler: function handler(dlg) {
                  var deviceTreeEd = Widget["in"](dlg.content().find('.-t-DeviceTree'));
                  deviceTreeEd instanceof DeviceTree && deviceTreeEd.checkAll();
                  dlg.keepOpen();
                }
              },
              ok: {
                handler: function handler(dlg) {
                  var deviceTreeEd = Widget["in"](dlg.content().find('.-t-DeviceTree'));
                  if (deviceTreeEd instanceof DeviceTree) {
                    return deviceTreeEd.getSelectedDevices().then(function (selectedDevices) {
                      return _this8.$addStationsToList(selectedDevices);
                    });
                  }
                }
              },
              cancel: {}
            }
          });
        }
      }

      /**
       * @private
       * @param {Array.<module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget~ListWidgetObject>} selectedDevices
       * @returns {Promise}
       */
    }, {
      key: "$addStationsToList",
      value: function $addStationsToList(selectedDevices) {
        var _this$state4 = this.state(),
          stations = _this$state4.stations,
          stationsToAdd = selectedDevices.filter(function (selectedDevice) {
            return !stations.some(function (existing) {
              return existing.value.deviceId === selectedDevice.value.deviceId;
            });
          });
        var updatedStationList = [].concat(_toConsumableArray(stations), _toConsumableArray(stationsToAdd));
        return Promise.all([this.state({
          stations: updatedStationList
        }), this.getStationsListWidget().loadAndModify(updatedStationList)]);
      }

      /**
       * @private
       * @param {baja.NavNode} nw the NiagaraNetwork node
       * @returns {boolean} true if there is at least one NiagaraStation in the network
       */
    }, {
      key: "$hasStationsToAdd",
      value: function $hasStationsToAdd(nw) {
        return baja.hasType(nw, 'driver:DeviceNetwork') && hasNiagaraStationDevices(nw);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$promptUserToEditStep",
      value: function $promptUserToEditStep() {
        var _this9 = this;
        return this.$resolveUxStepFactoryForSelection().then(function (uxStepFactory) {
          if (!uxStepFactory) {
            throw new Error(LEX_PROVISIONING.get('NiagaraNetworkJobEditor.cannotEditStep'));
          }
          var _this9$state = _this9.state(),
            deviceContainer = _this9$state.deviceContainer;
          var selectedStep = _this9.$getSelectedStep();

          //pass a copy of the step for editing
          var step = selectedStep.newCopy(true);
          return Promise.resolve(uxStepFactory.editStep({
            step: step,
            deviceContainer: deviceContainer
          })).then(function (editStep) {
            if (!editStep) {
              return;
            }
            return _this9.$convertJobStepToListWidgetObject(editStep).then(function (listWidgetObj) {
              var steps = _this9.state().steps.slice();
              var index = _this9.$getSelectedStepIndex();
              steps[index] = listWidgetObj;
              return _this9.state({
                steps: steps
              });
            }).then(function () {
              return _this9.setModified(true);
            });
          });
        });
      }

      /**
       * @private
       * @returns {baja.Component}
       */
    }, {
      key: "$getSelectedStep",
      value: function $getSelectedStep() {
        var selectedRow = this.$getSelectedRow();
        return selectedRow && selectedRow.value || undefined;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/model/Row}
       */
    }, {
      key: "$getSelectedRow",
      value: function $getSelectedRow() {
        var selectedRows = this.getStepsListWidget().$getTable().getSelectedRows();
        return selectedRows.length === 1 && selectedRows[0].getSubject() || undefined;
      }

      /**
       * @private
       * @returns {Number}
       */
    }, {
      key: "$getSelectedStepIndex",
      value: function $getSelectedStepIndex() {
        var table = this.getStepsListWidget().$getTable();
        var selectedRows = table.getSelectedRows();
        var model = table.value();
        if (selectedRows.length === 1) {
          return model.getRowIndex(selectedRows[0]);
        }
        return -1;
      }

      /**
       * @private
       * @param {String} typeSpec
       * @returns {Promise.<Function|undefined>} Resolves to the default `UxJobStepFactory` Constructor if
       * there is at least one `batchJob:IUxJobStepFactory` registered.
       */
    }, {
      key: "$getUxFactoryForStep",
      value: function $getUxFactoryForStep(typeSpec) {
        return getAgentOnInfo(typeSpec, {
          is: 'batchJob:IUxJobStepFactory'
        }).then(function (agents) {
          if (agents.length > 0) {
            var agent = agents[0];
            return doRequire(agent.js.id, agent.js.deps);
          }
        });
      }

      /**
       * @private
       * @returns {Promise.<module:nmodule/batchJob/rc/baja/UxJobStepFactory|undefined>}
       */
    }, {
      key: "$resolveUxStepFactoryForSelection",
      value: function $resolveUxStepFactoryForSelection() {
        var step = this.$getSelectedStep();
        return Promise.resolve(step && this.$getUxFactoryForStep(step.getType().getTypeSpec())).then(function (UxStepFactory) {
          if (UxStepFactory) {
            return new UxStepFactory();
          }
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$editStepSelectionHandler",
      value: function $editStepSelectionHandler() {
        var _this10 = this;
        return this.$resolveUxStepFactoryForSelection().then(function (uxStepFactory) {
          var enabled = !!(uxStepFactory && uxStepFactory.editStep);
          _this10.getStepsListWidget().$getEditCommand().setEnabled(enabled);
        });
      }

      /**
       * @private
       * @param {Event} e
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$toContextMenu",
      value: function $toContextMenu(e) {
        var listEl = e.currentTarget.closest('.' + ListWidget.ROOT_CSS);
        var listCmdGroup = Widget["in"](listEl).$getListCommandGroup();
        return listCmdGroup.filter({
          include: function include(cmd) {
            return cmd.isEnabled();
          }
        });
      }

      /**
       * @private
       */
    }, {
      key: "$makeViewCommands",
      value: function $makeViewCommands() {
        var _this11 = this;
        this.$editorCmdGroup = new CommandGroup({
          commands: [new Command({
            displayName: LEX_PROVISIONING.get('NiagaraNetworkJobBuilder.submit.label'),
            module: 'provisioningNiagara',
            lex: 'NiagaraNetworkJobBuilder.submit',
            func: function func() {
              return _this11.runNow();
            }
          }), new Command({
            displayName: LEX_BAJAUI.get('commands.refresh.label'),
            module: 'bajaui',
            lex: 'commands.refresh',
            func: this.$doRefresh
          })]
        });
      }

      /**
       * @private
       * @param {baja.Component} job a `provisioningNiagara:NiagaraNetworkJob`
       * @returns {Promise.<Array.<module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget~ListWidgetObject>>} the
       * job steps, ready to load into a ListWidget
       */
    }, {
      key: "$loadJobSteps",
      value: function $loadJobSteps(job) {
        var jobStages = job.getStages(),
          // initialStage is of type "batchJob:NetworkJobStage"
          // forEachStationStage is of type "provisioningNiagara:ForEachStationStage"
          initialStage = jobStages && jobStages.get("initial"),
          initialStageSteps = initialStage && getStageSteps(initialStage, 'batchJob:NetworkJobStep') || [],
          forEachStationStage = jobStages && jobStages.get("forEachStation"),
          forEachStationStageSteps = forEachStationStage && getStageSteps(forEachStationStage, 'batchJob:DeviceJobStep') || [];
        var jobSteps = initialStageSteps.concat(forEachStationStageSteps);
        return Promise.all(jobSteps.map(function (jobStep) {
          return stepToDisplayString(jobStep).then(function (jobStepDisplay) {
            return {
              displayName: jobStepDisplay,
              icon: jobStep.getIcon(),
              value: jobStep
            };
          });
        }));
      }

      /**
       * @private
       * @param {baja.Component} job
       * @returns {Promise.<Array.<object>>} job
       */
    }, {
      key: "$getDevicesToProcess",
      value: function $getDevicesToProcess(job) {
        var devices = job.getDevicesToProcess().toArray();
        return Promise.all(devices.map(function (device) {
          return getIcon(device).then(function (icon) {
            return {
              displayName: String(device),
              icon: icon,
              value: String(device)
            };
          });
        }));
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doRefresh",
      value: function $doRefresh() {
        return niagara.env.reload();
      }

      /**
       * @private
       */
    }, {
      key: "$setCommandsEnabled",
      value: function $setCommandsEnabled() {
        var _this$state5 = this.state(),
          steps = _this$state5.steps,
          stations = _this$state5.stations;
        this.getRunNowCommand().setEnabled(steps.length > 0 && stations.length > 0);
      }
    }]);
  }(spandrel(function (comp, _ref8) {
    var alertOnStepFailure = _ref8.alertOnStepFailure,
      alertOnJobSuccess = _ref8.alertOnJobSuccess,
      _ref8$steps = _ref8.steps,
      steps = _ref8$steps === void 0 ? [] : _ref8$steps,
      _ref8$stations = _ref8.stations,
      stations = _ref8$stations === void 0 ? [] : _ref8$stations,
      self = _ref8.self;
    var $editorCmdGroup = self.$editorCmdGroup;
    self.$setCommandsEnabled();
    return [UxModel.jsx("div", {
      className: "-t-NiagaraNetworkJobEditor-header",
      spandrelKey: "header"
    }, UxModel.jsx(BooleanEditor, {
      bind: true,
      spandrelKey: "alertOnStepFailure",
      "class": "-t-NiagaraNetworkJobEditor-option",
      value: alertOnStepFailure,
      properties: {
        displayType: "checkbox",
        trueText: JOB_FAIL_ALARM_LABEL,
        falseText: JOB_FAIL_ALARM_LABEL
      }
    }), UxModel.jsx(BooleanEditor, {
      bind: true,
      spandrelKey: "alertOnJobSuccess",
      "class": "-t-NiagaraNetworkJobEditor-option",
      value: alertOnJobSuccess,
      properties: {
        displayType: "checkbox",
        trueText: JOB_SUCCESS_ALARM_LABEL,
        falseText: JOB_SUCCESS_ALARM_LABEL
      }
    })), UxModel.jsx(SplitPane, {
      spandrelKey: "splitPane",
      lax: true,
      className: "-t-NiagaraNetworkJobEditor-SplitPane",
      properties: {
        orientation: VERTICAL
      }
    }, UxModel.jsx(ListWidget, {
      name: "widget1",
      value: steps,
      lax: true,
      bindKey: "steps",
      properties: {
        title: STEPS_TITLE,
        addHandler: function addHandler() {
          return self.$promptUserToAddSteps()["catch"](feDialogs.error);
        },
        editHandler: function editHandler() {
          return self.$promptUserToEditStep()["catch"](feDialogs.error);
        },
        editSelectionHandler: self.$editStepSelectionHandler.bind(self),
        lexProps: {
          prefix: 'JobStageBuilder',
          module: 'batchJob'
        }
      }
    }), UxModel.jsx(ListWidget, {
      name: "widget2",
      value: stations,
      lax: true,
      bindKey: "stations",
      properties: {
        title: STATIONS_TITLE,
        addHandler: self.$promptUserToAddStations.bind(self),
        lexProps: {
          prefix: 'DeviceList',
          module: 'batchJob'
        }
      }
    })), UxModel.jsx("div", {
      className: "-t-NiagaraNetworkJobEditor-commands",
      spandrelKey: "commands"
    }, UxModel.jsx(CommandButtonGroup, {
      value: $editorCmdGroup
    }))];
  }));
});
