function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget
 * @since Niagara 4.14
 */

define(['baja!', 'bajaux/events', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/table/commands/MoveDownCommand', 'nmodule/webEditors/rc/wb/table/commands/MoveUpCommand', 'nmodule/webEditors/rc/wb/table/commands/RemoveCommand', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/Table'], function (baja, events, spandrel, Command, CommandGroup, CommandButton, feDialogs, MoveDownCommand, MoveUpCommand, RemoveCommand, IconColumn, JsonObjectPropertyColumn, Row, TableModel, Table) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var defaultAddHandler = function defaultAddHandler() {};
  var defaultEditHandler = function defaultEditHandler() {};
  var defaulteditSelectionHandler = function defaulteditSelectionHandler() {};
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ListWidget ux-select-none',
        addHandler: defaultAddHandler,
        editHandler: defaultEditHandler,
        editSelectionHandler: defaulteditSelectionHandler,
        lexProps: {}
      }
    };
  };
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  function getIcon(icon) {
    if (icon) {
      return icon instanceof baja.Icon ? icon : baja.Icon.make([icon]);
    }
  }

  /**
   * @param {Array.<module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget~ListWidgetObject>} listOfObjects
   * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
   */
  function listOfObjectToTableModel(listOfObjects) {
    // TODO Maybe add a showHeader option to Table instead of doing this
    var nameColumn = new JsonObjectPropertyColumn('displayName', {
      displayName: ' '
    });
    nameColumn.setSortable(false);
    var iconColumn = new IconColumn('icon');
    var columns = [iconColumn, nameColumn];
    return new TableModel({
      rows: listOfObjects.map(function (obj) {
        return new Row(obj, getIcon(obj.icon));
      }),
      columns: columns
    });
  }

  /**
   * @inner
   * @class
   * @extends {module:bajaux/commands/Command}
   */
  var AddCommand = /*#__PURE__*/function (_Command) {
    function AddCommand(addHandler) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'webEditors' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'commands.add' : _ref$lex;
      _classCallCheck(this, AddCommand);
      return _callSuper(this, AddCommand, [{
        module: module,
        lex: lex,
        func: function func() {
          return addHandler();
        }
      }]);
    }
    _inherits(AddCommand, _Command);
    return _createClass(AddCommand);
  }(Command);
  /**
   * @inner
   * @class
   * @extends {module:bajaux/commands/Command}
   */
  var EditCommand = /*#__PURE__*/function (_Command2) {
    function EditCommand(editHandler) {
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref2$module = _ref2.module,
        module = _ref2$module === void 0 ? 'provisioningNiagara' : _ref2$module,
        _ref2$lex = _ref2.lex,
        lex = _ref2$lex === void 0 ? 'commands.edit' : _ref2$lex;
      _classCallCheck(this, EditCommand);
      return _callSuper(this, EditCommand, [{
        module: module,
        lex: lex,
        enabled: false,
        func: function func() {
          return editHandler();
        }
      }]);
    }
    _inherits(EditCommand, _Command2);
    return _createClass(EditCommand);
  }(Command);
  /**
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget
   * @extends {module:bajaux/spandrel}
   */
  var ListWidget = /*#__PURE__*/function (_spandrel) {
    function ListWidget(params) {
      var _this;
      _classCallCheck(this, ListWidget);
      _this = _callSuper(this, ListWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      var addHandler = _this.properties().getValue("addHandler");
      var editHandler = _this.properties().getValue("editHandler");
      var _this$properties$getV = _this.properties().getValue('lexProps'),
        prefix = _this$properties$getV.prefix,
        module = _this$properties$getV.module;
      var getTable = function getTable() {
        return _this.$getTable();
      };
      var commands = [];
      if (addHandler !== defaultAddHandler) {
        commands.push(new AddCommand(addHandler, {
          module: module,
          lex: prefix + '.add'
        }));
      }
      commands.push(new MoveUpCommand(getTable, {
        module: module,
        lex: prefix + '.moveUp'
      }));
      commands.push(new MoveDownCommand(getTable, {
        module: module,
        lex: prefix + '.moveDown'
      }));
      commands.push(new RemoveCommand(getTable, {
        module: module,
        lex: prefix + '.remove'
      }));
      if (editHandler !== defaultEditHandler) {
        commands.push(new EditCommand(editHandler, {
          module: module,
          lex: prefix + '.details'
        }));
      }
      _this.$listCmdGroup = new CommandGroup({
        commands: commands
      });
      return _this;
    }

    /**
     * @returns {Array.<module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget~ListWidgetObject>} the
     * objects currently in the table
     */
    _inherits(ListWidget, _spandrel);
    return _createClass(ListWidget, [{
      key: "doRead",
      value: function doRead() {
        return this.$getTable().getModel().getRows().map(function (row) {
          return row.getSubject();
        });
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget('container/table');
      }

      /**
       * @private
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$getListCommandGroup",
      value: function $getListCommandGroup() {
        return this.$listCmdGroup;
      }

      /**
       * @private
       * @returns {module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget~AddCommand}
       */
    }, {
      key: "$getAddCommand",
      value: function $getAddCommand() {
        return this.$listCmdGroup.findCommand(AddCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/commands/RemoveCommand}
       */
    }, {
      key: "$getRemoveCommand",
      value: function $getRemoveCommand() {
        return this.$listCmdGroup.findCommand(RemoveCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/commands/MoveUpCommand}
       */
    }, {
      key: "$getMoveUpCommand",
      value: function $getMoveUpCommand() {
        return this.$listCmdGroup.findCommand(MoveUpCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/commands/MoveDownCommand}
       */
    }, {
      key: "$getMoveDownCommand",
      value: function $getMoveDownCommand() {
        return this.$listCmdGroup.findCommand(MoveDownCommand);
      }

      /**
       * @private
       * @returns {EditCommand}
       */
    }, {
      key: "$getEditCommand",
      value: function $getEditCommand() {
        return this.$listCmdGroup.findCommand(EditCommand);
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       */
    }, {
      key: "$setCommandsEnabled",
      value: function $setCommandsEnabled(table) {
        var model = table.getModel(),
          rows = model.getRows(),
          selectedRows = table.getSelectedRows(),
          editEnabled = selectedRows && selectedRows.length === 1,
          removeCmdEnabled = !!selectedRows.length,
          isRowSelected = selectedRows && selectedRows.length,
          // Move up will be enabled only when the selected row is not the first row
          moveUpEnabled = isRowSelected && !(model.getRowIndex(selectedRows[0]) === 0),
          // Move down will be enabled only when the selected row is not the last row
          moveDownEnabled = isRowSelected && !(model.getRowIndex(selectedRows[selectedRows.length - 1]) === rows.length - 1);
        this.$getRemoveCommand().setEnabled(removeCmdEnabled);
        this.$getMoveUpCommand().setEnabled(moveUpEnabled);
        this.$getMoveDownCommand().setEnabled(moveDownEnabled);
        var editSelectionHandler = this.properties().getValue("editSelectionHandler");
        if (editSelectionHandler !== defaulteditSelectionHandler) {
          return editSelectionHandler();
        } else if (this.$getEditCommand()) {
          this.$getEditCommand().setEnabled(editEnabled);
        }
      }
    }]);
  }(spandrel(function (listofObjects, _ref3) {
    var self = _ref3.self,
      properties = _ref3.properties;
    var title = properties.title;
    var model = listOfObjectToTableModel(listofObjects);
    return [spandrel.jsx("div", {
      className: "-t-ListWidget-container",
      spandrelKey: "container"
    }, spandrel.jsx("div", {
      className: "-t-ListWidget-title"
    }, spandrel.jsx("span", null, title)), spandrel.jsx(Table, {
      className: "-t-ListWidget-table",
      value: model,
      spandrelKey: "table",
      lax: true,
      on: _defineProperty(_defineProperty(_defineProperty({}, MODIFY_EVENT, function () {
        //Although this override doesn't seem important since its just setting itself to modified,
        //it's required for NiagaraNetworkJobEditor to settle its state properly after the modify
        //event of a Command like the RemoveCommand.
        self.setModified(true);
        return false;
      }), ROW_SELECTION_CHANGED_EVENT, function (e, table) {
        self.$setCommandsEnabled(table);
      }), 'dblclick', function dblclick() {
        var editCommand = self.$getEditCommand();
        editCommand && editCommand.isEnabled() && editCommand.invoke()["catch"](feDialogs.error);
      })
    }), spandrel.jsx("div", {
      spandrelKey: "commands",
      className: "-t-ListWidget-commands"
    }, self.$listCmdGroup.flatten().map(function (command) {
      return spandrel.jsx(CommandButton, {
        "class": "ux-btn-tb",
        tagName: "button",
        type: "button",
        value: command
      });
    })))];
  }, {
    strategy: 'niagara'
  }));
  ListWidget.ROOT_CSS = '-t-ListWidget';
  return ListWidget;
});

/**
 * @typedef module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget~ListWidgetObject
 * @property {string} displayName
 * @property {baja.Icon} icon
 * @property {*} value
 */
