function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/jobBuilder/DeviceTree
 * @since Niagara 4.14
 */

define(['baja!', 'jquery', 'Promise', 'bajaux/spandrel', 'bajaux/Widget', 'nmodule/provisioningNiagara/rc/wb/jobBuilder/CheckedNavTree', 'nmodule/webEditors/rc/wb/tree/BajaNavTreeNode'], function (baja, $, Promise, spandrel, Widget, CheckedNavTree, BajaNavTreeNode) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-DeviceTree'
      }
    };
  };
  var BajaNavStatusTreeNode = /*#__PURE__*/function (_BajaNavTreeNode) {
    function BajaNavStatusTreeNode() {
      _classCallCheck(this, BajaNavStatusTreeNode);
      return _callSuper(this, BajaNavStatusTreeNode, arguments);
    }
    _inherits(BajaNavStatusTreeNode, _BajaNavTreeNode);
    return _createClass(BajaNavStatusTreeNode, [{
      key: "toDisplay",
      value: function toDisplay() {
        var value = this.value();
        if (baja.hasType(value, 'driver:Device')) {
          return Promise.resolve(value.getNavDisplayName() + ' ' + value.getStatusDisplay());
        }
        return _superPropGet(BajaNavStatusTreeNode, "toDisplay", this, 3)(arguments);
      }

      /**
       * @private
       * @returns {Boolean} false if node is a station device node.
       */
    }, {
      key: "mayHaveKids",
      value: function mayHaveKids() {
        var value = this.value();
        //the station device nodes cannot not have kids.
        return baja.hasType(value, 'driver:Device') ? false : _superPropGet(BajaNavStatusTreeNode, "mayHaveKids", this, 3)([]);
      }
    }]);
  }(BajaNavTreeNode);
  /**
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/jobBuilder/DeviceTree
   * @extends {module:bajaux/spandrel}
   */
  return /*#__PURE__*/function (_spandrel) {
    function DeviceTree(params) {
      _classCallCheck(this, DeviceTree);
      return _callSuper(this, DeviceTree, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(DeviceTree, _spandrel);
    return _createClass(DeviceTree, [{
      key: "getCheckedNavTree",
      value: function getCheckedNavTree() {
        return this.queryWidget(0);
      }
    }, {
      key: "checkAll",
      value: function checkAll() {
        var root = this.getCheckedNavTree();
        root && root.$checkAll();
      }

      /**
       * 
       * @returns {Promise.<Array.<module:nmodule/provisioningNiagara/rc/wb/jobBuilder/ListWidget~ListWidgetObject>>}
       */
    }, {
      key: "getSelectedDevices",
      value: function getSelectedDevices() {
        var _this = this;
        var _this$value = this.value(),
          deviceContainer = _this$value.deviceContainer;
        var checkedTrees = this.getCheckedNavTree().jq().find('.-t-CheckedNavTree-checkbox:checkbox:checked').map(function (i, checkbox) {
          var navTreeJq = $(checkbox).closest('.-t-CheckedNavTree');
          return navTreeJq.length > 0 && Widget["in"](navTreeJq);
        });
        return Promise.all(checkedTrees.get().filter(function (navTree) {
          return baja.hasType(navTree.value().value(), 'driver:Device');
        }).map(function (navTree) {
          var device = navTree.value().value();
          return _this.$getDeviceId(deviceContainer, device).then(function (deviceId) {
            return {
              displayName: deviceId,
              icon: device.getIcon(),
              value: {
                navOrd: String(device.getNavOrd()),
                deviceId: deviceId
              }
            };
          });
        }));
      }

      /**
       * @private
       * @param {Array.<Object>} devicesInJob 
       * @returns {Promise}
       */
    }, {
      key: "$preSelect",
      value: function $preSelect(devicesInJob) {
        var _this2 = this;
        var _this$value2 = this.value(),
          deviceContainer = _this$value2.deviceContainer;
        var getAllCheckedTrees = function getAllCheckedTrees() {
          return _this2.getCheckedNavTree().jq().find('.-t-CheckedNavTree-checkbox').map(function (i, checkbox) {
            var navTreeJq = $(checkbox).closest('.-t-CheckedNavTree');
            return navTreeJq && Widget["in"](navTreeJq);
          });
        };
        return Promise.all(getAllCheckedTrees().get().map(function (checkedTree) {
          // Get the deviceId
          var value = checkedTree.value().value();
          if (baja.hasType(value, 'driver:Device')) {
            return _this2.$getDeviceId(deviceContainer, value).then(function (deviceId) {
              return {
                deviceId: deviceId,
                checkedTree: checkedTree
              };
            });
          }
        })).then(function (objs) {
          objs.forEach(function () {
            var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
              deviceId = _ref.deviceId,
              checkedTree = _ref.checkedTree;
            if (devicesInJob.some(function (_ref2) {
              var value = _ref2.value;
              return deviceId && deviceId === value.deviceId;
            })) {
              checkedTree.$toggle(true);
            }
          });
        });
      }

      /**
       * @private
       * @param {baja.Component} deviceContainer
       * @param {baja.Component} device
       * @returns Promise.<String>
       */
    }, {
      key: "$getDeviceId",
      value: function $getDeviceId(deviceContainer, device) {
        // TODO memoize this?
        return baja.rpc({
          typeSpec: "provisioningNiagara:ProvisioningNiagaraRpcUtil",
          method: "getDeviceId",
          args: [String(deviceContainer.getNavOrd()), String(device.getNavOrd())]
        });
      }
    }]);
  }(spandrel(function (_ref3, _ref4) {
    var deviceContainer = _ref3.deviceContainer,
      devicesInJob = _ref3.devicesInJob;
    var properties = _ref4.properties,
      self = _ref4.self;
    return [{
      dom: '<div spandrelKey="deviceTree"></div>',
      type: CheckedNavTree,
      value: new BajaNavStatusTreeNode(deviceContainer),
      spandrelKey: 'deviceTree',
      properties: {
        hideRoot: true,
        displayFilter: function displayFilter(parent, child) {
          if (child instanceof BajaNavStatusTreeNode) {
            var value = child.value();
            return baja.hasType(value, 'niagaraDriver:NiagaraStation') || baja.hasType(value, 'niagaraDriver:NiagaraStationFolder');
          }
          return false;
        }
      },
      hooks: {
        postLoad: function postLoad() {
          return self.$preSelect(devicesInJob);
        }
      }
    }];
  }));
});
