function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/fe/SetTimeEditor
 */
define(["baja!", 'baja!provisioningNiagara:SetTimeJobStep,provisioningNiagara:TimeStepEnum,' + 'provisioningNiagara:SetTimeStepFactory', 'lex!provisioningNiagara', 'bajaux/spandrel', 'underscore', 'nmodule/webEditors/rc/fe/baja/AbsTimeEditor', 'nmodule/provisioningNiagara/rc/wb/fe/NtpEditor', 'nmodule/webEditors/rc/fe/baja/TimeZoneEditor'], function (baja, types, lexs, spandrel, _, AbsTimeEditor, NtpEditor, TimeZoneEditor) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-SetTimeEditor"
      }
    };
  };
  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];
  var SUPERVISOR_TIME_LABEL = provisioningNiagaraLex.get('SetTimeStepDialog.supervisorTime');
  var SET_TIME_LABEL = provisioningNiagaraLex.get('SetTimeStepDialog.selectedTime');
  var NTP_TIME_LABEL = provisioningNiagaraLex.get('SetTimeStepDialog.ntpTime');
  var timeStepTags = ['supervisor', 'selected', 'ntp'];
  function isSetTimeSelected(timeSetMethodTag) {
    return timeSetMethodTag === 'selected';
  }
  function isNtpSelected(timeSetMethodTag) {
    return timeSetMethodTag === 'ntp';
  }
  /**
   * Editor for setTimeJobStep
   *
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/fe/SetTimeEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  var SetTimeEditor = /*#__PURE__*/function (_spandrel) {
    function SetTimeEditor(params) {
      _classCallCheck(this, SetTimeEditor);
      return _callSuper(this, SetTimeEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @returns {Object}
     */
    _inherits(SetTimeEditor, _spandrel);
    return _createClass(SetTimeEditor, [{
      key: "$makeNtpEditor",
      value: function $makeNtpEditor() {
        var _this$state = this.state(),
          ntpSettings = _this$state.ntpSettings,
          timeSetMethodTag = _this$state.timeSetMethodTag;
        return spandrel.jsx(NtpEditor, {
          value: ntpSettings,
          bindKey: "ntpSettings",
          spandrelKey: "ntpSettingsEditor",
          enabled: isNtpSelected(timeSetMethodTag)
        });
      }

      /**
       * @private
       * @returns {Object}
       */
    }, {
      key: "$makeTimeWidget",
      value: function $makeTimeWidget() {
        var _this$state2 = this.state(),
          dateTime = _this$state2.dateTime,
          timeZone = _this$state2.timeZone,
          timeSetMethodTag = _this$state2.timeSetMethodTag;
        var setTimeEnabled = isSetTimeSelected(timeSetMethodTag);
        return spandrel.jsx("div", null, spandrel.jsx(AbsTimeEditor, {
          value: dateTime,
          bindKey: "dateTime",
          enabled: setTimeEnabled,
          spandrelKey: "dateTimeEditor"
        }), spandrel.jsx(TimeZoneEditor, {
          value: timeZone,
          enabled: setTimeEnabled,
          bindKey: "timeZone",
          spandrelKey: "timeZoneEditor"
        }));
      }

      /**
       * @private
       * @param {Object} [params]
       * @param {String} [params.name] name of the radio button group
       * @param {String} [params.id] unique id for the input element
       * @param {String} [params.tag]
       * @param {String} [params.label] label to be shown for the radio button
       * @param {Object} [params.contents] widget to be shown
       * @returns {Object}
       */
    }, {
      key: "$makeTogglePane",
      value: function $makeTogglePane(params) {
        var _this = this;
        var name = params.name,
          id = params.id,
          tag = params.tag,
          label = params.label,
          contents = params.contents;
        var _this$state3 = this.state(),
          timeSetMethodTag = _this$state3.timeSetMethodTag;
        return spandrel.jsx("div", {
          className: "-t-SetTimeEditor-block"
        }, spandrel.jsx("input", {
          type: "radio",
          id: id,
          name: name,
          checked: timeSetMethodTag === tag,
          onClick: function onClick() {
            return _this.state({
              timeSetMethodTag: tag
            });
          }
        }), spandrel.jsx("label", {
          "for": id
        }, label), contents);
      }

      /**
       * @param {Object} jobStep object format of step
       * @returns {Promise<Object>}
       */
    }, {
      key: "toState",
      value: function toState(jobStep) {
        return baja.TimeZoneDatabase.get().then(function (db) {
          var jobDateTime = jobStep.get('dateTime');
          var jobTimeZone = jobStep.get('timeZone');
          return {
            timeSetMethodTag: jobStep.get('timeSetMethod').getTag(),
            dateTime: jobDateTime.equals(baja.AbsTime.DEFAULT) ? baja.AbsTime.now() : jobDateTime,
            timeZone: jobTimeZone.equals(baja.TimeZone.NULL) ? db.getLocalTimeZone() : jobTimeZone,
            ntpSettings: jobStep.get('ntpSettings').newCopy()
          };
        });
      }

      /**
       * @param {Object} state
       * @returns {Object}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var timeSetMethodTag = state.timeSetMethodTag,
          dateTime = state.dateTime,
          timeZone = state.timeZone,
          ntpSettings = state.ntpSettings;
        return baja.$('provisioningNiagara:SetTimeJobStep', {
          dateTime: isSetTimeSelected(timeSetMethodTag) ? dateTime : baja.AbsTime.DEFAULT,
          timeZone: isSetTimeSelected(timeSetMethodTag) ? timeZone : baja.TimeZone.NULL,
          ntpSettings: isNtpSelected(timeSetMethodTag) ? ntpSettings.newCopy() : baja.$('provisioningNiagara:NtpSettings'),
          timeSetMethod: baja.$('provisioningNiagara:TimeStepEnum', timeSetMethodTag),
          factoryType: baja.$('baja:TypeSpec', 'provisioningNiagara:SetTimeStepFactory')
        });
      }

      /**
       * @private
       * @returns {HTMLElement}
       */
    }, {
      key: "getSupervisorPane",
      value: function getSupervisorPane() {
        return this.jq().find('.-t-SetTimeEditor-block')[0];
      }

      /**
       * @private
       * @returns {HTMLElement}
       */
    }, {
      key: "getSetTimePane",
      value: function getSetTimePane() {
        return this.jq().find('.-t-SetTimeEditor-block')[1];
      }

      /**
       * @private
       * @returns {HTMLElement}
       */
    }, {
      key: "getNtpPane",
      value: function getNtpPane() {
        return this.jq().find('.-t-SetTimeEditor-block')[2];
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getDateTimeEditor",
      value: function getDateTimeEditor() {
        return this.queryWidget('SetTimeEditor-layout/**/dateTimeEditor');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getTimeZoneEditor",
      value: function getTimeZoneEditor() {
        return this.queryWidget('SetTimeEditor-layout/**/timeZoneEditor');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getNtpEditor",
      value: function getNtpEditor() {
        return this.queryWidget('SetTimeEditor-layout/**/ntpSettingsEditor');
      }
    }]);
  }(spandrel(function (value, _ref) {
    var self = _ref.self;
    var timeWidget = self.$makeTimeWidget();
    var ntpWidget = self.$makeNtpEditor();
    var name = self.generateId();
    var supervisorId = self.generateId();
    var selectedId = self.generateId();
    var ntpId = self.generateId();
    return [spandrel.jsx("div", {
      className: "-t-SetTimeEditor-layout",
      spandrelKey: "SetTimeEditor-layout"
    }, self.$makeTogglePane({
      name: name,
      id: supervisorId,
      tag: timeStepTags[0],
      label: SUPERVISOR_TIME_LABEL
    }), self.$makeTogglePane({
      name: name,
      id: selectedId,
      tag: timeStepTags[1],
      label: SET_TIME_LABEL,
      contents: timeWidget
    }), self.$makeTogglePane({
      name: name,
      id: ntpId,
      tag: timeStepTags[2],
      label: NTP_TIME_LABEL,
      contents: ntpWidget
    }))];
  }, {
    strategy: 'niagara'
  }));
  return SetTimeEditor;
});
