function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/fe/NtpServerEditor
 */

define(["baja!", 'baja!platform:NtpServerQnx,platform:NtpModePosix', 'lex!provisioningNiagara,platform', 'bajaux/spandrel', 'underscore', 'nmodule/webEditors/rc/fe/baja/BooleanEditor'], function (baja, types, lexs, spandrel, _, BooleanEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    provisioningNiagaraLex = _lexs[0],
    platformLex = _lexs[1];
  var ADDRESS_LABEL = platformLex.get("NtpPlatformService.address.label");
  var PEER_MODE_LABEL = platformLex.get("NtpPlatformServicePosix.peerMode.label");
  var BURST_LABEL = platformLex.get("NtpPlatformServicePosix.burst.label");
  var PREFER_LABEL = platformLex.get("NtpPlatformServicePosix.prefer.label");
  var MIN_POLL_LABEL = platformLex.get("NtpPlatformServicePosix.minPollInterval.label");
  var MAX_POLL_LABEL = platformLex.get("NtpPlatformServicePosix.maxPollInterval.label");
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-NtpServerEditor"
      }
    };
  };
  var PEER_MODE_RANGE = baja.EnumRange.make({
    ordinals: [1, 2],
    tags: ['peer', 'server']
  });
  var MIN_POLL_INTERVAL_PROPS = Object.assign(baja.$('platform:NtpServerQnx').getFacets('minPollInterval').toObject(), {
    precision: 0
  });
  var MAX_POLL_INTERVAL_PROPS = Object.assign(baja.$('platform:NtpServerQnx').getFacets('maxPollInterval').toObject(), {
    precision: 0
  });

  /**
   * Editor for adding or editing NtpServer details.
   *
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/fe/NtpServerEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  var NtpServerEditor = /*#__PURE__*/function (_spandrel) {
    function NtpServerEditor(params) {
      var _this;
      _classCallCheck(this, NtpServerEditor);
      _this = _callSuper(this, NtpServerEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        return _this.$validateEditor();
      });
      return _this;
    }

    /**
     * @private
     * @throws {Error}
     */
    _inherits(NtpServerEditor, _spandrel);
    return _createClass(NtpServerEditor, [{
      key: "$validateEditor",
      value: function $validateEditor() {
        var _this$state = this.state(),
          address = _this$state.address,
          minPollInterval = _this$state.minPollInterval,
          maxPollInterval = _this$state.maxPollInterval;
        if (!address) {
          throw new Error(provisioningNiagaraLex.get("SetTimeStepDialog.editor.serverEmpty"));
        }
        if (minPollInterval < 4 || minPollInterval > 16 || minPollInterval > maxPollInterval) {
          throw new Error(provisioningNiagaraLex.get("SetTimeStepDialog.editor.error"));
        }
        if (maxPollInterval > 17 || maxPollInterval < 5 || maxPollInterval < minPollInterval) {
          throw new Error(provisioningNiagaraLex.get("SetTimeStepDialog.editor.error"));
        }
      }

      /**
       * @param {Object} value object format of NtpServerQnx
       * @returns {Object}
       */
    }, {
      key: "toState",
      value: function toState(value) {
        return value;
      }

      /**
       * @param {Object} state
       * @returns {Object}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        return {
          address: state.address,
          peerMode: baja.$('platform:NtpModePosix', state.peerMode.getOrdinal()),
          useBurst: state.useBurst,
          serverPreferred: state.serverPreferred,
          minPollInterval: state.minPollInterval,
          maxPollInterval: state.maxPollInterval
        };
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAddressEditor",
      value: function $getAddressEditor() {
        return this.queryWidget('NtpServerEditor-layout/**/address');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPeerModeEditor",
      value: function $getPeerModeEditor() {
        return this.queryWidget('NtpServerEditor-layout/**/peerMode');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUseBurstEditor",
      value: function $getUseBurstEditor() {
        return this.queryWidget('NtpServerEditor-layout/**/useBurst');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getServerPreferredEditor",
      value: function $getServerPreferredEditor() {
        return this.queryWidget('NtpServerEditor-layout/**/serverPreferred');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMinPollIntervalEditor",
      value: function $getMinPollIntervalEditor() {
        return this.queryWidget('NtpServerEditor-layout/**/minPollInterval');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMaxPollIntervalEditor",
      value: function $getMaxPollIntervalEditor() {
        return this.queryWidget('NtpServerEditor-layout/**/maxPollInterval');
      }
    }]);
  }(spandrel(function (value) {
    var address = value.address,
      peerMode = value.peerMode,
      useBurst = value.useBurst,
      serverPreferred = value.serverPreferred,
      minPollInterval = value.minPollInterval,
      maxPollInterval = value.maxPollInterval;
    var peerModeEnum = baja.DynamicEnum.make({
      ordinal: peerMode.getOrdinal(),
      range: PEER_MODE_RANGE
    });
    return [spandrel.jsx("div", {
      className: "-t-NtpServerEditor-layout",
      spandrelKey: "NtpServerEditor-layout"
    }, spandrel.jsx("div", {
      className: "-t-NtpServerEditor-flex-container"
    }, spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-block"
    }, spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-item-bold"
    }, ADDRESS_LABEL), spandrel.jsx("any", {
      className: "-t-NtpServerEditor-grid-item address-editor",
      value: address,
      bind: true,
      spandrelKey: "address"
    })), spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-block"
    }, spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-item-bold"
    }, PEER_MODE_LABEL), spandrel.jsx("any", {
      className: "-t-NtpServerEditor-grid-item",
      value: peerModeEnum,
      bind: true,
      spandrelKey: "peerMode"
    })), spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-block"
    }, spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-item-bold"
    }, BURST_LABEL), spandrel.jsx("any", {
      className: "-t-NtpServerEditor-grid-item",
      value: useBurst,
      properties: {
        displayType: 'slider'
      },
      bind: true,
      spandrelKey: "useBurst"
    })), spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-block"
    }, spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-item-bold"
    }, PREFER_LABEL), spandrel.jsx("any", {
      className: "-t-NtpServerEditor-grid-item",
      value: serverPreferred,
      properties: {
        displayType: 'slider'
      },
      bind: true,
      spandrelKey: "serverPreferred"
    })), spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-block"
    }, spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-item-bold"
    }, MIN_POLL_LABEL), spandrel.jsx("any", {
      className: "-t-NtpServerEditor-poll-item",
      value: minPollInterval,
      bind: true,
      spandrelKey: "minPollInterval",
      properties: MIN_POLL_INTERVAL_PROPS
    })), spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-block"
    }, spandrel.jsx("div", {
      className: "-t-NtpServerEditor-grid-item-bold"
    }, MAX_POLL_LABEL), spandrel.jsx("any", {
      className: "-t-NtpServerEditor-poll-item",
      value: maxPollInterval,
      bind: true,
      spandrelKey: "maxPollInterval",
      properties: MAX_POLL_INTERVAL_PROPS
    }))))];
  }, {
    strategy: 'niagara'
  }));
  return NtpServerEditor;
});
