function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/fe/NtpEditor
 */
define(["baja!", 'baja!provisioningNiagara:NtpSettings,platform:NtpServerQnx,platform:NtpModePosix', 'bajaux/commands/Command', 'bajaux/util/CommandButtonGroup', 'bajaux/commands/CommandGroup', 'lex!provisioningNiagara,platform', 'bajaux/spandrel', 'bajaux/util/CommandButton', 'jquery', 'Promise', 'underscore', 'nmodule/provisioningNiagara/rc/wb/fe/NtpServerEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/ipAddressUtil', 'nmodule/webEditors/rc/wb/table/commands/MoveDownCommand', 'nmodule/webEditors/rc/wb/table/commands/MoveUpCommand', 'nmodule/webEditors/rc/wb/table/commands/RemoveCommand', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn'], function (baja, types, Command, CommandButtonGroup, CommandGroup, lexs, spandrel, CommandButton, $, Promise, _, NtpServerEditor, BooleanEditor, compUtils, feDialogs, ipAddressUtil, MoveDownCommand, MoveUpCommand, RemoveCommand, Column, Row, Table, TableModel, JsonObjectPropertyColumn) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-NtpEditor"
      }
    };
  };
  var toObject = compUtils.toObject;
  var _lexs = _slicedToArray(lexs, 2),
    provisioningNiagaraLex = _lexs[0],
    platformLex = _lexs[1];
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var NTP_ENABLED_TXT = platformLex.get("NtpPlatformService.enabled.label");
  var NTP_HOST_MODE_TXT = platformLex.get("NtpPlatformServicePosix.hostMode.label");
  var NTP_SYNC_LOCAL_TXT = platformLex.get("NtpPlatformServicePosix.ntp.label");
  var NTP_SYNC_BOOT_TXT = platformLex.get("NtpPlatformService.syncAtBoot.label");
  var NTP_LOCAL_BACKUP_TXT = platformLex.get("NtpPlatformServicePosix.localBackup.label");
  var NTP_STATS_TXT = platformLex.get("NtpPlatformServicePosix.stats.label");
  var ADDRESS_LABEL = platformLex.get("NtpPlatformService.address.label");
  var PEER_MODE_LABEL = platformLex.get("NtpPlatformServicePosix.peerMode.label");
  var BURST_LABEL = platformLex.get("NtpPlatformServicePosix.burst.label");
  var PREFER_LABEL = platformLex.get("NtpPlatformServicePosix.prefer.label");
  var MIN_POLL_LABEL = platformLex.get("NtpPlatformServicePosix.minPollInterval.label");
  var MAX_POLL_LABEL = platformLex.get("NtpPlatformServicePosix.maxPollInterval.label");

  /**
   * Implementation of AddCommand.
   * @inner
   * @class
   * @extends {module:bajaux/commands/Command}
   * @param {Function} getTable a function that returns the target table of this command.
   * @param {Object} [params]
   * @param {String} [params.module='webEditors'] the module to look up the commands lexicon entry
   * @param {String} [params.lex='commands.moveDown'] the lexicon key to look up the command with
   */
  var AddCommand = /*#__PURE__*/function (_Command) {
    function AddCommand(getTable) {
      var _this;
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'webEditors' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'commands.addItem' : _ref$lex;
      _classCallCheck(this, AddCommand);
      return _this = _callSuper(this, AddCommand, [{
        module: module,
        lex: lex,
        enabled: false,
        func: function func() {
          return _this.$addServer(getTable);
        }
      }]);
    }

    /**
     * @private
     * @param {Function} getTable
     * @returns {Promise}
     */
    _inherits(AddCommand, _Command);
    return _createClass(AddCommand, [{
      key: "$addServer",
      value: function $addServer(getTable) {
        var server = baja.$('platform:NtpServerQnx');
        return showDialog(toObject(server)).then(function (server) {
          if (!server) {
            return null;
          }
          var row = new Row(server);
          var table = getTable();
          return table.getModel().insertRows([row]).then(function () {
            return table.setModified(true);
          });
        });
      }
    }]);
  }(Command);
  /**
   * Implementation of EditCommand
   * @inner
   * @class
   * @extends {module:bajaux/commands/Command}
   * @param {Object} [params]
   * @param {String} [params.module='webEditors'] the module to look up the commands lexicon entry
   * @param {String} [params.lex='commands.moveDown'] the lexicon key to look up the command with
   */
  var EditCommand = /*#__PURE__*/function (_Command2) {
    function EditCommand(getTable) {
      var _this2;
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref2$module = _ref2.module,
        module = _ref2$module === void 0 ? 'webEditors' : _ref2$module,
        _ref2$lex = _ref2.lex,
        lex = _ref2$lex === void 0 ? 'commands.mgr.edit' : _ref2$lex;
      _classCallCheck(this, EditCommand);
      return _this2 = _callSuper(this, EditCommand, [{
        module: module,
        lex: lex,
        enabled: false,
        func: function func() {
          return _this2.$editServer(getTable);
        }
      }]);
    }

    /**
     * @private
     * @param {Function} getTable
     * @returns {Promise}
     */
    _inherits(EditCommand, _Command2);
    return _createClass(EditCommand, [{
      key: "$editServer",
      value: function $editServer(getTable) {
        var table = getTable();
        var selectedRow = table.getSelectedRows()[0];
        var selectedItem = selectedRow.getSubject();
        var model = table.getModel();
        var rowIndex = model.getRowIndex(selectedRow);
        return showDialog(selectedItem).then(function (server) {
          if (!server) {
            return null;
          }
          var row = new Row(server);
          return Promise.all([model.removeRows([selectedRow]), model.insertRows([row], rowIndex)]).then(function () {
            return table.setModified(true);
          });
        });
      }
    }]);
  }(Command);
  /**
   * @param {baja.Component} server
   * @returns {Promise}
   */
  function showDialog(server) {
    var dom = $('<div class="-t-SetTimeDialog"></div>');
    return feDialogs.showFor({
      dom: dom,
      title: provisioningNiagaraLex.get('SetTimeStepDialog.editor.editServer'),
      type: NtpServerEditor,
      formFactor: 'compact',
      value: server
    });
  }

  /**
   * Converts NtpServerQnx object notation to a string format
   * @param {Object} ntpServer
   * @returns {String}
   */
  function convertNtpToString(ntpServer) {
    var peerMode = ntpServer.peerMode,
      useBurst = ntpServer.useBurst,
      serverPreferred = ntpServer.serverPreferred,
      address = ntpServer.address,
      minPollInterval = ntpServer.minPollInterval,
      maxPollInterval = ntpServer.maxPollInterval;
    var result = "";
    result += peerMode.getTag();
    //NOTE: hostnames are assumed to be IPv4 resolution until such time that IPv6 support is clarified
    if (ipAddressUtil.isIpv4(address) || ipAddressUtil.isIpv6(address)) {
      result += " -6";
    }
    //append address
    result += " " + address;
    if (useBurst) {
      result += " burst";
    }

    //append preferred
    if (serverPreferred && peerMode.getTag() !== "manycastclient" && peerMode.getTag() !== "broadcast") {
      result += " prefer";
    }

    //append minPollInterval and maxPollInterval
    if (minPollInterval !== 6 && minPollInterval >= 4 && minPollInterval < 17 && minPollInterval < maxPollInterval) {
      result += " minpoll " + minPollInterval;
    }
    if (maxPollInterval !== 10 && maxPollInterval <= 17 && maxPollInterval > 4 && maxPollInterval > minPollInterval) {
      result += " maxpoll " + maxPollInterval;
    }
    return result;
  }

  /**
   * Editor for NtpSettings
   *
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/fe/NtpEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  var NtpEditor = /*#__PURE__*/function (_spandrel) {
    function NtpEditor(params) {
      var _this3;
      _classCallCheck(this, NtpEditor);
      _this3 = _callSuper(this, NtpEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      var getTable = function getTable() {
        return _this3.$getTable();
      };
      _this3.$serverTableCmdGroup = new CommandGroup({
        commands: [new AddCommand(getTable), new RemoveCommand(getTable), new EditCommand(getTable), new MoveUpCommand(getTable), new MoveDownCommand(getTable)]
      });
      return _this3;
    }

    /**
     * @private
     * @returns {Promise}
     */
    _inherits(NtpEditor, _spandrel);
    return _createClass(NtpEditor, [{
      key: "$handleRowsModified",
      value: function $handleRowsModified() {
        return this.state({
          servers: this.$getTable().getModel().getRows().map(function (row) {
            return row.getSubject();
          })
        });
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       */
    }, {
      key: "$setCommandsEnabled",
      value: function $setCommandsEnabled(table) {
        var model = table.getModel(),
          rows = model.getRows(),
          selectedRows = table.getSelectedRows(),
          editCmdEnabled = selectedRows && selectedRows.length > 0,
          removeCmdEnabled = !!selectedRows.length,
          isRowSelected = selectedRows && selectedRows.length,
          moveUpEnabled = isRowSelected && !(model.getRowIndex(selectedRows[0]) === 0),
          moveDownEnabled = isRowSelected && !(model.getRowIndex(selectedRows[selectedRows.length - 1]) === rows.length - 1);
        this.$getRemoveCommand().setEnabled(removeCmdEnabled);
        this.$getEditCommand().setEnabled(editCmdEnabled);
        this.$getMoveUpCommand().setEnabled(moveUpEnabled);
        this.$getMoveDownCommand().setEnabled(moveDownEnabled);
      }

      /**
       * @private
       * @param {Array} servers
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
       */
    }, {
      key: "$buildModel",
      value: function $buildModel(servers) {
        var rows = servers.map(function (server) {
          var peerMode = server.peerMode;
          if (!peerMode.getType().is('platform:NtpModePosix')) {
            server.peerMode = baja.$('platform:NtpModePosix', peerMode);
          }
          return new Row(server);
        });
        var columns = this.$buildTableCols();
        return new TableModel({
          rows: rows,
          columns: columns
        });
      }

      /**
       * @private
       * @param {String} serverString
       * @returns {Array.<Object>} array of NtpServer objects.
       */
    }, {
      key: "$getNtpServers",
      value: function $getNtpServers(serverString) {
        return baja.rpc({
          typeSpec: "provisioningNiagara:ProvisioningNiagaraRpcUtil",
          method: "getNtpServers",
          args: [String(serverString)]
        });
      }

      /**
       * @private
       * @returns {Array<module:nmodule/webEditors/rc/wb/table/model/Column>}
       */
    }, {
      key: "$buildTableCols",
      value: function $buildTableCols() {
        var addressCol = new JsonObjectPropertyColumn('address', {
          displayName: ADDRESS_LABEL
        });
        var peerModeCol = new JsonObjectPropertyColumn('peerMode', {
          displayName: PEER_MODE_LABEL
        });
        var useBurstCol = new JsonObjectPropertyColumn('useBurst', {
          displayName: BURST_LABEL
        });
        var serverPreferredCol = new JsonObjectPropertyColumn('serverPreferred', {
          displayName: PREFER_LABEL
        });
        var minPollIntervalCol = new JsonObjectPropertyColumn('minPollInterval', {
          displayName: MIN_POLL_LABEL
        });
        var maxPollIntervalCol = new JsonObjectPropertyColumn('maxPollInterval', {
          displayName: MAX_POLL_LABEL
        });
        return [addressCol, peerModeCol, useBurstCol, serverPreferredCol, minPollIntervalCol, maxPollIntervalCol];
      }

      /**
       * @private
       * @param {String} text
       * @param {boolean} value
       * @param {String} key
       * @returns {Object}
       */
    }, {
      key: "$makeBooleanEditor",
      value: function $makeBooleanEditor(text, value, key) {
        return spandrel.jsx("div", {
          className: "-t-NtpEditor-row",
          spandrelKey: "ntpSettings" + key
        }, spandrel.jsx("span", {
          className: "-t-NtpEditor-label"
        }, text), spandrel.jsx(BooleanEditor, {
          className: "-t-NtpEditor-" + key,
          value: value,
          bindKey: key,
          properties: {
            displayType: 'slider'
          },
          spandrelKey: "slider" + key
        }));
      }

      /**
       * @param {Object} ntpSettings object format of NtpSettings
       * @returns {Object}
       */
    }, {
      key: "toState",
      value: function toState(ntpSettings) {
        return this.$getNtpServers(ntpSettings.get('servers')).then(function (servers) {
          return {
            ntpEnabled: ntpSettings.get('ntpEnabled'),
            syncLocal: ntpSettings.get('syncLocal'),
            localAsBackup: ntpSettings.get('localAsBackup'),
            ntpStats: ntpSettings.get('ntpStats'),
            syncAtBoot: ntpSettings.get('syncAtBoot'),
            hostMode: ntpSettings.get('hostMode'),
            servers: servers
          };
        });
      }

      /**
       * @param {Object} state
       * @returns {Object}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var servers = state.servers;
        var serverString = "";
        //convert the servers object to string format
        servers.forEach(function (server) {
          var str = convertNtpToString(server);
          serverString += str + ";";
        });
        return baja.$('provisioningNiagara:NtpSettings', {
          ntpEnabled: state.ntpEnabled,
          syncLocal: state.syncLocal,
          localAsBackup: state.localAsBackup,
          ntpStats: state.ntpStats,
          syncAtBoot: state.syncAtBoot,
          hostMode: state.hostMode,
          servers: serverString
        });
      }

      /**
       * @private
       * @returns {AddCommand}
       */
    }, {
      key: "$getAddCommand",
      value: function $getAddCommand() {
        return this.$serverTableCmdGroup.findCommand(AddCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/commands/RemoveCommand}
       */
    }, {
      key: "$getRemoveCommand",
      value: function $getRemoveCommand() {
        return this.$serverTableCmdGroup.findCommand(RemoveCommand);
      }

      /**
       * @private
       * @returns {EditCommand}
       */
    }, {
      key: "$getEditCommand",
      value: function $getEditCommand() {
        return this.$serverTableCmdGroup.findCommand(EditCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/commands/MoveUpCommand}
       */
    }, {
      key: "$getMoveUpCommand",
      value: function $getMoveUpCommand() {
        return this.$serverTableCmdGroup.findCommand(MoveUpCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/commands/MoveDownCommand}
       */
    }, {
      key: "$getMoveDownCommand",
      value: function $getMoveDownCommand() {
        return this.$serverTableCmdGroup.findCommand(MoveDownCommand);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget('NtpEditor-layout/**/serverTable');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHostModeEditor",
      value: function $getHostModeEditor() {
        return this.queryWidget('NtpEditor-layout/**/hostMode');
      }
    }]);
  }(spandrel(function (value, _ref3) {
    var self = _ref3.self,
      ntpEnabled = _ref3.ntpEnabled,
      syncLocal = _ref3.syncLocal,
      localAsBackup = _ref3.localAsBackup,
      ntpStats = _ref3.ntpStats,
      syncAtBoot = _ref3.syncAtBoot,
      hostMode = _ref3.hostMode,
      servers = _ref3.servers;
    var model = self.$buildModel(servers);
    //enable AddCmd when the editor is enabled
    self.$getAddCommand().setEnabled(self.isEnabled());
    return [spandrel.jsx("div", {
      className: "-t-NtpEditor-layout",
      spandrelKey: "NtpEditor-layout"
    }, self.$makeBooleanEditor(NTP_ENABLED_TXT, ntpEnabled, "ntpEnabled"), spandrel.jsx("div", {
      className: "-t-NtpEditor-row",
      spandrelKey: "ntpSettingsHostMode"
    }, spandrel.jsx("span", {
      className: "-t-NtpEditor-label"
    }, NTP_HOST_MODE_TXT), spandrel.jsx("any", {
      tagName: "span",
      value: hostMode,
      bind: true,
      spandrelKey: "hostMode"
    })), self.$makeBooleanEditor(NTP_SYNC_LOCAL_TXT, syncLocal, "syncLocal"), self.$makeBooleanEditor(NTP_SYNC_BOOT_TXT, syncAtBoot, "syncAtBoot"), self.$makeBooleanEditor(NTP_LOCAL_BACKUP_TXT, localAsBackup, "localAsBackup"), self.$makeBooleanEditor(NTP_STATS_TXT, ntpStats, "ntpStats"), spandrel.jsx("div", {
      className: "tableContainer"
    }, spandrel.jsx(Table, {
      value: model,
      className: "-t-NtpEditor-server-table",
      spandrelKey: "serverTable",
      on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (e, table) {
        self.$setCommandsEnabled(table);
      }),
      onUxModify: function onUxModify() {
        return self.$handleRowsModified();
      },
      properties: {
        fixedHeaders: true
      }
    }), spandrel.jsx(CommandButtonGroup, {
      className: "-t-NtpEditor-serverTable-commands",
      value: self.$serverTableCmdGroup,
      properties: {
        toolbar: true
      }
    })))];
  }, {
    strategy: 'niagara'
  }));
  return NtpEditor;
});
