function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/commands/RestoreBackupCommand
 */

define(['baja!', 'lex!provisioningNiagara', 'dialogs', 'Promise', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, lexs, dialogs, Promise, Command, feDialogs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    BATCH_JOB_LEX = _lexs[0];
  var Password = require('bajaScript/baja/obj/Password');

  /**
   * Restores a backup created from a batch job
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/commands/RestoreBackupCommand
   * @extends module:bajaux/commands/Command
   */
  var RestoreBackupCommand = /*#__PURE__*/function (_Command) {
    function RestoreBackupCommand(params) {
      var _this;
      _classCallCheck(this, RestoreBackupCommand);
      _this = _callSuper(this, RestoreBackupCommand, [{
        module: 'provisioningNiagara',
        lex: 'BackupStepDetailsView.restoreCommand',
        enabled: true,
        func: function func() {
          return _this.$invoke();
        }
      }]);
      var success = baja.$('baja:JobState').get('success');
      params = params || {};
      _this.$jobStepLogFile = params.jobStepLogFile;
      _this.$step = params.stepDetails;
      _this.setEnabled(_this.$step.getState() === success);
      return _this;
    }

    /**
     * sets the enabled state of the command when the step's state changes
     * @private
     */
    _inherits(RestoreBackupCommand, _Command);
    return _createClass(RestoreBackupCommand, [{
      key: "$onStepStateChanged",
      value: function $onStepStateChanged() {
        var success = baja.$('baja:JobState').get('success');
        var state = this.$step.getState();
        this.setEnabled(state === success);
      }

      /**
       * @private
       * @param {String} stationName the name of the station
       * @param {String} distributionFileOrd the ord of the ditribution file encoded as atring
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$validateDistPassphraseToPlatform",
      value: function $validateDistPassphraseToPlatform(stationName, distributionFileOrd) {
        return baja.rpc({
          typeSpec: "provisioningNiagara:BackupStepDetailsRpc",
          method: "validateDistPassphraseToPlatform",
          args: [stationName, distributionFileOrd]
        });
      }

      /**
       * @private
       * @param {String} distributionFileOrd the ord of the ditribution file encoded as atring
       * @param {module:baja/obj/Password} passphrase the baja:Password passphrase that needs to be checked
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$validatePassphraseToDist",
      value: function $validatePassphraseToDist(distributionFileOrd, passphrase) {
        return baja.rpc({
          typeSpec: "provisioningNiagara:BackupStepDetailsRpc",
          method: "validatePassphraseToDist",
          args: [distributionFileOrd, passphrase.encodeToString()]
        });
      }

      /**
       *
       * @param {String} jobStepLogFile the log file for the job
       * @param {baja.Component} backupStepDetails the backup step details of the type
       * 'provisioningNiagara:BackupStepDetails'
       * @param {baja.Simple} passphrase the baja:Password passphrase to be used to restore the job
       * @returns {*}
       */
    }, {
      key: "$startRestoreJob",
      value: function $startRestoreJob(jobStepLogFile, backupStepDetails, passphrase) {
        var backupStepDetailsJson = JSON.stringify(baja.bson.encodeValue(backupStepDetails));
        var passphraseStr = passphrase ? passphrase.encodeToString() : "";
        var logFileNavOrd = jobStepLogFile ? jobStepLogFile.getNavOrd().encodeToString() : "";
        return baja.rpc({
          typeSpec: "provisioningNiagara:BackupStepDetailsRpc",
          method: "startRestoreJob",
          args: [logFileNavOrd, backupStepDetailsJson, passphraseStr]
        })["catch"](function (err) {
          return feDialogs.error(err);
        });
      }

      /**
       * @private
       * @returns {*}
       */
    }, {
      key: "$invoke",
      value: function $invoke() {
        var _this2 = this;
        var step = this.$step;
        var filePath = this.$getFilePath();
        var fileName = filePath.getBody();
        var deviceName = step.get('deviceDisplayName');
        dialogs.showOkCancel({
          title: BATCH_JOB_LEX.get('BackupStepDetailsView.restoreCommand.confirmTitle'),
          text: BATCH_JOB_LEX.get('BackupStepDetailsView.restoreCommand.confirmMessage', deviceName, fileName)
        }).ok(function () {
          return _this2.$restore();
        });
      }

      /**
       * @private
       * @returns {baja.OrdQuery}
       */
    }, {
      key: "$getFilePath",
      value: function $getFilePath() {
        var fileOrd = this.$step.get('backupFileOrd');
        var fileOrdQuery = fileOrd.parse();
        return fileOrdQuery.get(fileOrdQuery.size() - 1);
      }

      /**
       * Performs additional validation and starts the restore process running
       * @private
       * @returns {Promise<*>}
       */
    }, {
      key: "$restore",
      value: function $restore() {
        var _this3 = this;
        var filePath = this.$getFilePath();
        var passphrase;
        if (!this.$validPath(filePath)) {
          dialogs.showOk({
            title: BATCH_JOB_LEX.get('RestoreBackupCommand.ordFailure.dlgTitle'),
            text: BATCH_JOB_LEX.get('RestoreBackupCommand.ordFailure.dlgMessage')
          });
          return Promise.resolve();
        }
        var step = this.$step;
        var stationName = step.get('deviceId');
        var backupOrd = step.get("backupFileOrd").encodeToString();
        return this.$validateDistPassphraseToPlatform(stationName, backupOrd).then(function (passphraseNotReq) {
          if (passphraseNotReq) {
            return true;
          } else {
            return _this3.$promptForPassphrase(backupOrd).then(function (passwordResult) {
              passphrase = passwordResult;
              return !!passphrase;
            });
          }
        }).then(function (success) {
          if (success) {
            return _this3.$startRestoreJob(_this3.$jobStepLogFile, step, passphrase).then(function (jobOrd) {
              if (jobOrd) {
                return window.niagara.env.hyperlink(jobOrd);
              }
            });
          }
        })["catch"](function (err) {
          return feDialogs.error(err);
        });
      }

      /**
       * Prompts for the passphrase until the correct one is entered or the maximum retries exceeded
       * @param {String} backupOrd the ord encoded as string for the backup file
       * @returns {Promise<boolean>}
       */
    }, {
      key: "$promptForPassphrase",
      value: function $promptForPassphrase(backupOrd) {
        var _this4 = this;
        var password;
        return feDialogs.showFor({
          value: Password.DEFAULT,
          formFactor: 'mini',
          title: BATCH_JOB_LEX.get('BackupStepDetailsView.passphrase.title'),
          summary: BATCH_JOB_LEX.get('BackupStepDetailsView.passphrase.desc'),
          properties: {
            prelabel: BATCH_JOB_LEX.get('BackupStepDetailsView.passphrase.prompt')
          },
          buttons: {
            ok: function ok(dialog, event, editor) {
              return editor.save().then(function () {
                return editor.read();
              }).then(function (passwordResult) {
                password = passwordResult;
                return _this4.$validatePassphraseToDist(backupOrd, password);
              }).then(function (success) {
                if (!success) {
                  dialog.keepOpen();
                  return dialogs.showOk({
                    text: BATCH_JOB_LEX.get('BackupStepDetailsView.passphrase.invalid', backupOrd)
                  });
                } else {
                  return password;
                }
              })["catch"](function (err) {
                return feDialogs.error(err);
              });
            },
            cancel: {}
          }
        });
      }

      /**
       * Checks to see if the filePath is valid.
       * @private
       * @param {baja.OrdQuery} filePath
       * @returns {boolean}
       */
    }, {
      key: "$validPath",
      value: function $validPath(filePath) {
        return filePath.getScheme().getType().getTypeSpec() === 'baja:FileScheme';
      }
    }]);
  }(Command);
  return RestoreBackupCommand;
});
