function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/software/InstallSoftwareFactory
 */

define(['baja!', 'baja!baja:Vector,' + 'provisioningNiagara:InstallCombinedBySpecStep,' + 'provisioningNiagara:InstallBySpecStep,' + 'provisioningNiagara:InstallSoftwareFactory,' + 'provisioningNiagara:InstallableSummary', 'dialogs', 'lex!provisioningNiagara', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/provisioningNiagara/rc/baja/software/InstallSoftwareWidget', 'nmodule/provisioningNiagara/rc/baja/software/SoftwareValidationStatusWidget', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, types, dialogs, lexs, Promise, asyncUtils, UxJobStepFactory, InstallSoftwareWidget, SoftwareValidationStatusWidget, feDialogs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];
  var LOAD_SLOTS_PROGRESS_DELAY_MS = 500;
  var LOAD_SLOTS_TIMEOUT_MS = 30000;
  var LEASE_UNTIL_MS = 90000;
  var waitForTrue = asyncUtils.waitForTrue;

  /**
   * @class
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   * @alias module:nmodule/provisioningNiagara/rc/baja/software/InstallSoftwareFactory
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_UxJobStepFactory) {
    function InstallSoftwareFactory() {
      _classCallCheck(this, InstallSoftwareFactory);
      return _callSuper(this, InstallSoftwareFactory, [{
        module: 'provisioningNiagara',
        lex: 'InstallSoftwareFactory'
      }]);
    }

    /**
     * 
     * @param {object} params 
     * @returns {Promise<baja.Component>} of base type provisioningNiagara:AbstractSoftwareStep
     */
    _inherits(InstallSoftwareFactory, _UxJobStepFactory);
    return _createClass(InstallSoftwareFactory, [{
      key: "makeStep",
      value: function makeStep(params) {
        var _this = this;
        return this.$getSoftwareContainer().then(function (softwareContainer) {
          return feDialogs.showFor({
            title: provisioningNiagaraLex.get('InstallSoftwareStep.displayName'),
            summary: provisioningNiagaraLex.get('InstallSoftwareFactory.chooseSoftware.dlgMessage'),
            type: InstallSoftwareWidget,
            value: softwareContainer,
            formFactor: 'mini',
            validate: function validate(specsToInstall) {
              return specsToInstall.length > 0;
            }
          }).then(function (specsToInstall) {
            if (specsToInstall) {
              return _this.$makeInstallBySpecStep(specsToInstall);
            }
          });
        });
      }

      /**
       * @param {object} params 
       * @returns {Promise<baja.Component>} of base type provisioningNiagara:AbstractSoftwareStep
       */
    }, {
      key: "editStep",
      value: function editStep(params) {
        return this.makeStep.apply(this, arguments);
      }

      /**
       * Returns the software container component of the provisioning extension and waits until 
       * all the installable software has been retrieved.
       * @private
       * @param {object} params 
       * @returns {Promise<baja.Component>} leased "software" component of the provisioning network ext
       */
    }, {
      key: "$getSoftwareContainer",
      value: function $getSoftwareContainer() {
        var software;
        var promise = this.$getProvisioningNwExt().then(function (provisioningNwExt) {
          software = provisioningNwExt.getSoftware();
          return software.lease(LEASE_UNTIL_MS);
        }).then(function () {
          return waitForTrue(function () {
            return software.get('loaded');
          }, LOAD_SLOTS_TIMEOUT_MS);
        }).then(function () {
          return software;
        });
        dialogs.showLoading(LOAD_SLOTS_PROGRESS_DELAY_MS, promise);
        return promise;
      }

      /**
       * @private
       * @param {Array.<baja.Struct>} installableSpecs of type platform:InstallableSpec
       * @returns {Promise<baja.Component>} of base type provisioningNiagara:AbstractSoftwareStep 
       */
    }, {
      key: "$makeInstallBySpecStep",
      value: function $makeInstallBySpecStep(installableSpecs) {
        if (!installableSpecs.length) {
          return;
        }

        // Check for software signature validity
        // If there are failures for e.g. if a module installable has been tampered with then 
        // show the failure message and exit.
        // If there are warning, for e.g. if a module installable has been self signed then 
        // show the warning but allow to proceed.

        return this.$checkSoftwareSignatureStatus(installableSpecs).then(function (canProceed) {
          if (!canProceed) {
            return;
          }
          var factoryTypeObj = {
            slot: 'factoryType',
            value: baja.$('baja:TypeSpec', 'provisioningNiagara:InstallSoftwareFactory')
          };
          if (installableSpecs.length === 1) {
            var _installableSpecs = _slicedToArray(installableSpecs, 1),
              toInstall = _installableSpecs[0];
            var specStep = baja.$('provisioningNiagara:InstallBySpecStep');
            return Promise.all([specStep.set({
              slot: 'toInstall',
              value: toInstall.newCopy()
            }), specStep.set(factoryTypeObj)]).then(function () {
              return specStep;
            });
          } else {
            var installCombinedBySpecStep = baja.$('provisioningNiagara:InstallCombinedBySpecStep');
            var specsVector = baja.$('baja:Vector');
            installableSpecs.forEach(function (spec) {
              //Note that the spec.getName only includes the version number, so use the toString
              //to obtain a unique string that includes the module name and the version number that
              //won't prevent multiple modules with the same version
              //from being installed.
              var specName = baja.SlotPath.escape(spec.toString()),
                existing = specsVector.get(specName);
              if (!existing) {
                specsVector.add({
                  slot: specName,
                  value: spec.newCopy()
                });
              }
            });
            return Promise.all([installCombinedBySpecStep.set({
              slot: 'toInstallList',
              value: specsVector
            }), installCombinedBySpecStep.set(factoryTypeObj)]).then(function () {
              return installCombinedBySpecStep;
            });
          }
        });
      }

      /**
       * @private
       * @returns {baja.Component} 
       */
    }, {
      key: "$getProvisioningNwExt",
      value: function $getProvisioningNwExt() {
        return baja.Ord.make('service:provisioningNiagara:ProvisioningNiagaraNetworkExt').get();
      }

      /**
       * @private
       * @param {Array.<baja.Struct>} installableSpecs
       * @returns {Promise.<boolean|object>} resolves to either false or a validation object
       */
    }, {
      key: "$checkSoftwareSignatureStatus",
      value: function $checkSoftwareSignatureStatus(installableSpecs) {
        var _this2 = this;
        return this.$getProvisioningNwExt().then(function (nwExt) {
          return nwExt.rpc('getSoftwareValidationStatus', installableSpecs.map(function (spec) {
            return JSON.stringify(baja.bson.encodeValue(spec));
          }));
        }).then(function (statusInfo) {
          return _this2.$showSignatureWarningsOrErrors(statusInfo);
        });
      }

      /**
       * @private
       * @param {Object} softwareValidationStatus 
       * @returns {Promise.<boolean|Object>} resolves to either false (for validation failures) or a 
       * validation object (for validation warning)
       */
    }, {
      key: "$showSignatureWarningsOrErrors",
      value: function $showSignatureWarningsOrErrors(softwareValidationStatus) {
        var failures = softwareValidationStatus.failures,
          warnings = softwareValidationStatus.warnings;
        if (!failures && !warnings) {
          return true;
        }
        var dialogConfig = {
          title: failures ? provisioningNiagaraLex.get('InstallSoftwareFactory.signingError.title') : provisioningNiagaraLex.get('InstallSoftwareFactory.signingWarning.title'),
          type: SoftwareValidationStatusWidget,
          value: softwareValidationStatus,
          formFactor: 'compact'
        };
        if (failures) {
          dialogConfig['buttons'] = {
            ok: function ok() {
              return false;
            }
          };
        }
        return feDialogs.showFor(dialogConfig);
      }
    }]);
  }(UxJobStepFactory);
});
