function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/UpdateLicensesStepFactory
 */

define(['baja!', 'baja!provisioningNiagara:UpdateLicensesJobStep,provisioningNiagara:UpdateLicensesStepFactory', 'lex!provisioningNiagara', 'jquery', 'Promise', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/PropertySheet'], function (baja, types, lexs, $, Promise, UxJobStepFactory, feDialogs, PropertySheet) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];

  /**
   * A 'provisioningNiagara:UpdateLicensesJobStepFactory` editor
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/UpdateLicensesStepFactory
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   */
  return /*#__PURE__*/function (_UxJobStepFactory) {
    function UpdateLicensesStepFactory() {
      _classCallCheck(this, UpdateLicensesStepFactory);
      return _callSuper(this, UpdateLicensesStepFactory, [{
        module: 'provisioningNiagara',
        lex: 'UpdateLicensesStepFactory'
      }]);
    }

    /**
     * Resolves to a 'provisioningNiagara:UpdateLicensesJobStep'.
     *
     * @returns {Promise.<baja.Component|undefined>}
     */
    _inherits(UpdateLicensesStepFactory, _UxJobStepFactory);
    return _createClass(UpdateLicensesStepFactory, [{
      key: "makeStep",
      value: function makeStep() {
        return this.$makeStep({
          restartRequired: true,
          changeBrand: false,
          brandName: ''
        });
      }

      /**
       * Resolves to a new 'provisioningNiagara:UpdateLicensesJobStep'.
       *
       * @param {Object} params
       * @param {baja.Component} params.step an instance of `provisioningNiagara:UpdateLicensesJobStep`.
       * @returns {Promise.<baja.Component|undefined>}
       */
    }, {
      key: "editStep",
      value: function editStep(_ref) {
        var step = _ref.step;
        return this.$makeStep({
          restartRequired: step.getRestartRequired(),
          changeBrand: step.getChangeBrand(),
          brandName: step.getBrandName()
        });
      }

      /**
       * Prompts for the should the step use 'Hostname'(true) or 'IP Address'(false) and creates the
       * new step value
       * @private
       * @param {Object} params the update parameters
       * @param {String} params.brandName the default brand name or the brand name from the step that
       * is being edited, just to maintain data integrity if something changes
       * @param {Boolean} params.changeBrand the default flag to tell us if the brand name should
       * be changed, just to maintain data integrity if something changes
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "$makeStep",
      value: function $makeStep(_ref2) {
        var _this = this;
        var brandName = _ref2.brandName,
          changeBrand = _ref2.changeBrand,
          restartRequired = _ref2.restartRequired;
        var comp = baja.$('baja:Component');
        return comp.add({
          slot: 'restartRequired',
          value: restartRequired,
          cx: {
            displayName: provisioningNiagaraLex.get('UpdateLicensesStepDialog.checkboxMessage')
          }
        }).then(function () {
          return _this.$showDialog(comp, brandName, changeBrand);
        });
      }

      /**
       * Shows the defined component in the dialog and applies the user's changes
       * @private
       * @param {baja.Component} comp
       * @param {String} brandName the default brand name or the brand name from the step that
       * is being edited, just to maintain data integrity if something changes
       * @param {Boolean} changeBrand the default flag to tell us if the brand name should
       * be changed, just to maintain data integrity if something changes
       * @returns {Promise<*>}
       */
    }, {
      key: "$showDialog",
      value: function $showDialog(comp, brandName, changeBrand) {
        var dom = $('<div class="-t-UpdateLicenseStepFactory"></div>');
        return feDialogs.showFor({
          dom: dom,
          title: provisioningNiagaraLex.get('UpdateLicensesStepFactory.dialogTitle'),
          summary: provisioningNiagaraLex.get('UpdateLicensesStepFactory.description') + '\n\n' + provisioningNiagaraLex.get('UpdateLicensesStepDialog.dialogMessage'),
          value: comp,
          type: PropertySheet,
          properties: {
            showHeader: false,
            showControls: false
          }
        }).then(function (results) {
          if (!results) {
            return;
          }
          return results.apply(comp).then(function (comp) {
            var restartRequired = comp.get('restartRequired');
            var step = baja.$('provisioningNiagara:UpdateLicensesJobStep');
            step.setFactoryType(baja.$('baja:TypeSpec', 'provisioningNiagara:UpdateLicensesStepFactory'));
            step.setRestartRequired(restartRequired);
            step.setChangeBrand(changeBrand);
            step.setBrandName(brandName);
            return step;
          });
        });
      }
    }]);
  }(UxJobStepFactory);
});
