function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/SignCertFactory
 */

define(['baja!', 'baja!provisioningNiagara:SignCertFactory,provisioningNiagara:SignCertJobStep', 'lex!provisioningNiagara,platCrypto', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/commands/NewCertCommand', 'nmodule/provisioningNiagara/rc/baja/SignCertEditor', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, types, lexs, Widget, Promise, _, UxJobStepFactory, certManagement, NewCertCommand, SignCertEditor, feDialogs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    provisioningNiagaraLex = _lexs[0],
    platCryptoLex = _lexs[1],
    GENERATE_NEW = platCryptoLex.get('CertAlias.generateNew'),
    USER_KEY_STORE = 'userKeyStore',
    passwordStrength = certManagement.passwordStrength,
    getCertStoreData = certManagement.getCertStoreData,
    getPasswordStrength = _.once(passwordStrength);

  /**
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/SignCertFactory
   * @extends {module:nmodule/batchJob/rc/baja/UxJobStepFactory}
   */
  var SignCertFactory = /*#__PURE__*/function (_UxJobStepFactory) {
    function SignCertFactory() {
      _classCallCheck(this, SignCertFactory);
      return _callSuper(this, SignCertFactory, [{
        module: 'provisioningNiagara',
        lex: 'SignCertFactory'
      }]);
    }

    /**
     * Resolves to 'provisioningNiagara:SignCertFactory'.
     *
     * @returns {Promise.<baja.Component|null>} resolves to a provisioningNiagara:RemovePropertyJobStep
     * or null if the user cancels the dialog.
     */
    _inherits(SignCertFactory, _UxJobStepFactory);
    return _createClass(SignCertFactory, [{
      key: "makeStep",
      value: function makeStep() {
        return this.$promptSignCertificateDialog();
      }

      /**
       * @param {baja.Component} step
       * @returns {Promise<baja.Component|null>} the edited step, or null if the user cancels the
       * dialog.
       */
    }, {
      key: "editStep",
      value: function editStep(_ref) {
        var step = _ref.step;
        return this.$promptSignCertificateDialog(step);
      }

      /**
       * @private
       * @param {baja.Component} [step]
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$promptSignCertificateDialog",
      value: function $promptSignCertificateDialog(step) {
        var _this = this;
        step = step || baja.$('provisioningNiagara:SignCertJobStep', {
          notBefore: baja.AbsTime.now(),
          notAfter: baja.AbsTime.now().prevDay().nextYear()
        });
        return Promise.all([this.$makeCaCertAliasArray(), this.$getPasswordStrength()]).then(function (args) {
          var _args = _slicedToArray(args, 2),
            caCertificateArray = _args[0],
            passwordStrength = _args[1];
          return feDialogs.showFor({
            title: provisioningNiagaraLex.get('SignCertDialog.title'),
            summary: provisioningNiagaraLex.get('SignCertDialog.description'),
            type: SignCertEditor,
            value: step,
            properties: {
              caCertificateArray: caCertificateArray,
              passwordStrength: passwordStrength
            },
            buttons: {
              ok: function ok(dialog, event, editor) {
                return _this.$promptNewCertDialog(dialog, event, editor);
              },
              cancel: function cancel() {
                return false;
              }
            }
          });
        });
      }

      /**
       * @private
       * @param {module:bajaux/Widget} dialog
       * @param {Event} event
       * @param {module:nmodule/provisioningNiagara/rc/baja/SignCertEditor} editor
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$promptNewCertDialog",
      value: function $promptNewCertDialog(dialog, event, editor) {
        var _this2 = this;
        return editor.read().then(function (step) {
          if (step.getCaCertAlias() === GENERATE_NEW) {
            _this2.$newCertCommand = _this2.$getNewCaCertCommand(editor);
            return _this2.$newCertCommand.invoke().then(function (val) {
              if (!val) {
                dialog.keepOpen();
              } else {
                return step;
              }
            });
          }
          return step;
        });
      }

      /**
       * @private
       * @param {module:bajaux/Widget} editor
       * @returns {module:nmodule/provisioningNiagara/rc/baja/SignCertFactory~NewCaCertCommand}
       */
    }, {
      key: "$getNewCaCertCommand",
      value: function $getNewCaCertCommand(editor) {
        return new NewCaCertCommand(editor);
      }

      /**
       * @private
       * @returns {Promise.<Array.<string>>}
       */
    }, {
      key: "$makeCaCertAliasArray",
      value: function $makeCaCertAliasArray() {
        var _this3 = this;
        return this.$getCertsFromUserKeyStore().then(function (certsObj) {
          var caCertificateArray = [GENERATE_NEW],
            certArray = certsObj.certs.filter(_this3.$isValidCaCert);
          certArray.forEach(function (cert) {
            return caCertificateArray.push(cert.alias);
          });
          return caCertificateArray;
        });
      }

      /**
       * @private
       * @returns {Promise.<module:nmodule/webEditors/rc/baja/PasswordStrength>}
       */
    }, {
      key: "$getPasswordStrength",
      value: function $getPasswordStrength() {
        return getPasswordStrength();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$getCertsFromUserKeyStore",
      value: function $getCertsFromUserKeyStore() {
        return getCertStoreData(USER_KEY_STORE);
      }

      /**
       * @private
       * @param {baja.Component} cert
       * @returns {boolean}
       */
    }, {
      key: "$isValidCaCert",
      value: function $isValidCaCert(cert) {
        return cert && cert.keyUsage && cert.keyUsage.indexOf('keyCertSign') !== -1;
      }
    }]);
  }(UxJobStepFactory);
  /**
   * @private
   * @inner
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/SignCertFactory~NewCaCertCommand
   * @extends {module:nmodule/platCrypto/rc/wb/cert/commands/NewCertCommand}
   */
  var NewCaCertCommand = /*#__PURE__*/function (_NewCertCommand) {
    function NewCaCertCommand() {
      _classCallCheck(this, NewCaCertCommand);
      return _callSuper(this, NewCaCertCommand, arguments);
    }
    _inherits(NewCaCertCommand, _NewCertCommand);
    return _createClass(NewCaCertCommand, [{
      key: "$getReadonlyProperties",
      value: function $getReadonlyProperties() {
        return Promise.resolve({
          'certificateUsages': {
            readonly: true,
            enabled: false
          }
        });
      }
    }, {
      key: "$getCertificateUsages",
      value: function $getCertificateUsages() {
        return _superPropGet(NewCaCertCommand, "$getCertificateUsages", this, 3)([]).then(function (certUsages) {
          return certUsages.map(function (usage) {
            usage.selected = usage.value === 'ca';
            return usage;
          });
        });
      }
    }]);
  }(NewCertCommand);
  return SignCertFactory;
});
