function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/SetTimeStepFactory
 */

define(['baja!', 'baja!provisioningNiagara:SetTimeJobStep,provisioningNiagara:NtpSettings', 'dialogs', 'jquery', 'Promise', 'lex!provisioningNiagara', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/provisioningNiagara/rc/wb/fe/SetTimeEditor', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, types, dialogs, $, Promise, lexs, UxJobStepFactory, SetTimeEditor, feDialogs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];

  /**
   * A 'provisioningNiagara:SetTimeStepFactory' factory implementation.
   *
   * @since Niagara 4.14
   * @class
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   * @alias module:nmodule/provisioningNiagara/rc/baja/SetTimeStepFactory
   */
  var SetTimeStepFactory = /*#__PURE__*/function (_UxJobStepFactory) {
    function SetTimeStepFactory() {
      _classCallCheck(this, SetTimeStepFactory);
      return _callSuper(this, SetTimeStepFactory, [{
        module: 'provisioningNiagara',
        lex: 'SetTimeStepFactory'
      }]);
    }

    /**
     * @returns {Promise<baja.Component|undefined>}
     */
    _inherits(SetTimeStepFactory, _UxJobStepFactory);
    return _createClass(SetTimeStepFactory, [{
      key: "makeStep",
      value: function makeStep(params) {
        return this.$makeStep(params);
      }

      /**
       * @param {Object} params
       * @param {baja.Component} params.step
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "editStep",
      value: function editStep(params) {
        return this.$makeStep(params);
      }

      /**
       * Resolves to the step configured
       * @private
       * @param {Object} params
       * @param {baja.Component} params.step
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$makeStep",
      value: function $makeStep(_ref) {
        var _this = this;
        var _ref$step = _ref.step,
          step = _ref$step === void 0 ? baja.$('provisioningNiagara:SetTimeJobStep') : _ref$step;
        var timeSetMethodTag = step.get('timeSetMethod').getTag();
        if (timeSetMethodTag !== 'ntp') {
          //set default ntp settings
          return step.set({
            slot: 'ntpSettings',
            value: baja.$('provisioningNiagara:NtpSettings', {
              ntpEnabled: true,
              syncLocal: true
            })
          }).then(function () {
            return _this.$promptSetTimeDialog(step);
          });
        } else {
          return this.$promptSetTimeDialog(step);
        }
      }

      /**
       * @private
       * @return {Promise.<baja.Component>}
       */
    }, {
      key: "$promptSetTimeDialog",
      value: function $promptSetTimeDialog(step) {
        var _this2 = this;
        var dom = $('<div class="-t-SetTimeDialog"></div>');
        return feDialogs.showFor({
          dom: dom,
          title: provisioningNiagaraLex.get('SetTimeStepDialog.title'),
          summary: provisioningNiagaraLex.get('SetTimeStepDialog.description'),
          type: SetTimeEditor,
          formFactor: 'compact',
          value: step,
          buttons: {
            ok: function ok(dialog, event, editor) {
              return editor.read().then(function (stepDetails) {
                var timeSetMethodTag = stepDetails.get('timeSetMethod').getTag();
                var ntpSettings = stepDetails.get('ntpSettings');
                //show error message if timeSetMethod is ntp and server details are empty
                if (timeSetMethodTag === 'ntp') {
                  if (ntpSettings.getServers() === '') {
                    return _this2.$showNoServerErrorDialog(dialog);
                  }
                  //show warning message if timeSetMethod is ntp
                  return _this2.$showRebootRequiredDialog().then(function () {
                    return stepDetails;
                  });
                } else {
                  return stepDetails;
                }
              });
            },
            cancel: function cancel() {
              return null;
            }
          }
        });
      }

      /**
       * Shows no server error dialog
       * @private
       * @param {Dialog} dlg
       * @returns {Promise}
       */
    }, {
      key: "$showNoServerErrorDialog",
      value: function $showNoServerErrorDialog(dlg) {
        return dialogs.showOk({
          title: provisioningNiagaraLex.get('SetTimeStepDialog.noServersTitle'),
          text: provisioningNiagaraLex.get('SetTimeStepDialog.noServersMessage')
        }).ok(function () {
          return dlg.keepOpen();
        }).promise();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showRebootRequiredDialog",
      value: function $showRebootRequiredDialog() {
        return dialogs.showOk({
          title: provisioningNiagaraLex.get('SetTimeStepDialog.rebootTitle'),
          text: provisioningNiagaraLex.get('SetTimeStepDialog.rebootMessage')
        }).promise();
      }

      /**
       * @returns {module:nmodule/js/rc/lex/lex}
       */
    }, {
      key: "getLex",
      value: function getLex() {
        return provisioningNiagaraLex;
      }
    }]);
  }(UxJobStepFactory);
  return SetTimeStepFactory;
});
