function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/AbstractUpgradeTemplateFactory
 */

define(['baja!', 'baja!provisioningNiagara:UpgradeApplicationStep,provisioningNiagara:UpgradeApplicationFactory,' + 'provisioningNiagara:UpgradeTemplateStep,provisioningNiagara:UpgradeTemplateFactory', 'lex!provisioningNiagara', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/links/OrdChooser'], function (baja, types, lexs, UxJobStepFactory, feDialogs, OrdChooser) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];

  /**
   * An abstract class for implementing upgrade templates
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/AbstractUpgradeTemplateFactory
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   * @param {Object} params parameters used to step up and specify the type of job the factory is for
   * @param {String} params.jobType the type of job the factory is handling
   * - 'upgradeApplication' handles a 'provisioningNiagara:UpgradeApplicationStep'
   * - 'upgradeTemplate' handles a 'provisioningNiagara:UpgradeTemplateStep'
   */
  return /*#__PURE__*/function (_UxJobStepFactory) {
    function AbstractUpgradeTemplateFactory(params) {
      var _this;
      _classCallCheck(this, AbstractUpgradeTemplateFactory);
      _this = _callSuper(this, AbstractUpgradeTemplateFactory, [params]);
      var jobType = params.jobType;
      switch (jobType) {
        case 'upgradeApplication':
          _this.$stepType = 'provisioningNiagara:UpgradeApplicationStep';
          _this.$factoryType = 'provisioningNiagara:UpgradeApplicationFactory';
          _this.$fileType = 'napl';
          _this.$extnRegx = new RegExp('.(' + _this.$fileType + ')$', 'i');
          _this.$title = provisioningNiagaraLex.get('UpgradeApplicationFactory.displayName');
          _this.$summary = provisioningNiagaraLex.get('UpgradeApplicationFactory.description');
          _this.$slotName = 'applicationFileOrd';
          break;
        case 'upgradeTemplate':
          _this.$stepType = 'provisioningNiagara:UpgradeTemplateStep';
          _this.$factoryType = 'provisioningNiagara:UpgradeTemplateFactory';
          _this.$fileType = 'ntpl';
          _this.$extnRegx = new RegExp('.(' + _this.$fileType + ')$', 'i');
          _this.$title = provisioningNiagaraLex.get('UpgradeTemplateFactory.displayName');
          _this.$summary = provisioningNiagaraLex.get('UpgradeTemplateFactory.description');
          _this.$slotName = 'templateFileOrd';
          break;
      }
      return _this;
    }

    /**
     * Makes the step of the type specified by the class implementing this abstract class
     * @param {Object} params the parameters passed to the makeStep function\
     * @returns {Promise.<baja.Component|undefined>}
     */
    _inherits(AbstractUpgradeTemplateFactory, _UxJobStepFactory);
    return _createClass(AbstractUpgradeTemplateFactory, [{
      key: "makeStep",
      value: function makeStep(params) {
        return this.$makeStep(params);
      }

      /**
       * Edits the supplied step and returns a new step of the type specified by the class implementing
       * this abstract class
       * @param {Object} params the parameters passed to the editStep function
       * @param {baja.Component} params.step the step to be edited
       * @returns {Promise.<baja.Component|undefined>}
       */
    }, {
      key: "editStep",
      value: function editStep(params) {
        return this.$makeStep(params);
      }

      /**
       * Prompts the user for the necessary information and uses that information to make a new step
       * of the type specified by the implementing class
       * @private
       * @param {Object} params
       * @param {baja.Component} [params.step] the step to be edited
       */
    }, {
      key: "$makeStep",
      value: function $makeStep(params) {
        var _this2 = this;
        params = params || {};
        var _params = params,
          step = _params.step;
        var fileOrd = step ? step.get(this.$slotName) : baja.Ord.make();
        return this.$selectFile(fileOrd).then(function (fileOrd) {
          if (!fileOrd || fileOrd.isNull()) {
            return;
          }
          var step = baja.$(_this2.$stepType);
          step.setFactoryType(baja.$('baja:TypeSpec', _this2.$factoryType));
          step.set({
            slot: _this2.$slotName,
            value: fileOrd
          });
          return step;
        });
      }

      /**
       * Allows the user to select the template file they want
       * @param {baja.Ord} fileOrd the starting file ord
       * @returns {Promise<baja.Ord>}
       */
    }, {
      key: "$selectFile",
      value: function $selectFile(fileOrd) {
        var _this3 = this;
        return feDialogs.showFor({
          title: this.$title,
          summary: this.$summary,
          value: fileOrd,
          type: OrdChooser,
          formFactor: 'compact',
          properties: {
            displayFilter: function displayFilter(parent, child) {
              return _this3.$displayFilter(parent, child);
            },
            selectFilter: function selectFilter(selected) {
              return _this3.$selectFilter(selected);
            },
            rootNode: 'file:^',
            hideOrdType: true
          }
        });
      }

      /**
       * determines if an items should be displayed or not
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} parent
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} child
       * @returns {boolean}
       */
    }, {
      key: "$displayFilter",
      value: function $displayFilter(parent, child) {
        var childVal = child.value();
        var navTypeSpec = childVal.getNavTypeSpec();
        var navName = childVal.getNavName();
        if (navTypeSpec === 'baja:FileSystem' || navTypeSpec === 'baja:Directory' || navName.match(this.$extnRegx)) {
          return true;
        }
      }

      /**
       * checks to see if the selected node is the correct type
       * @param selected
       */
    }, {
      key: "$selectFilter",
      value: function $selectFilter(selected) {
        if (!selected.toString().match(this.$extnRegx)) {
          throw new Error(provisioningNiagaraLex.get('AbstractTemplateFactory.chooser.error', this.$fileType));
        }
      }
    }]);
  }(UxJobStepFactory);
});
