/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * A Base class for information about Tags
 *
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin
 */
define(['underscore'], function (_) {
  'use strict';

  /**
   * A Base class for information about Tags
   *
   * @class
   * @abstract
   * @alias module:nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin
   */
  var BaseTagInfoMixin = function BaseTagInfoMixin(tagId, defaultValue, tagBType, isIdealFor, isValidFor, tagType) {
    this.$tagId = tagId;
    this.$defaultValue = defaultValue;
    this.$tagBType = tagBType;
    this.$isIdealFor = isIdealFor;
    this.$isValidFor = isValidFor;
    this.$tagType = tagType;
    this.$isTagGroup = false;
    this.$isAdHoc = false;
  };
  BaseTagInfoMixin.prototype.getTagName = function () {
    return this.getTagId().getName();
  };
  BaseTagInfoMixin.prototype.getName = function () {
    return this.getTagName();
  };
  BaseTagInfoMixin.prototype.getDictionary = function () {
    return this.getTagId().getDictionary();
  };
  BaseTagInfoMixin.prototype.getTagId = function () {
    return this.$tagId;
  };
  BaseTagInfoMixin.prototype.getDefaultValue = function () {
    return this.$defaultValue;
  };

  /*
   * The tag value's type
   *
   * @return String typeSpec
   */
  BaseTagInfoMixin.prototype.getTagType = function () {
    return this.$tagType;
  };

  /*
   * The tag's type
   *
   * @return String typeSpec
   */
  BaseTagInfoMixin.prototype.getTagBType = function () {
    return this.$tagBType;
  };
  BaseTagInfoMixin.prototype.isIdealFor = function () {
    return this.$isIdealFor;
  };
  BaseTagInfoMixin.prototype.isValidFor = function () {
    return this.$isValidFor;
  };
  BaseTagInfoMixin.prototype.isTagGroup = function () {
    return this.$isTagGroup;
  };

  /**
   * Sets whether this tagInfo relates to an ad hoc tag.
   * @param {Boolean} value
   */
  BaseTagInfoMixin.prototype.setIsAdHoc = function (value) {
    this.$isAdHoc = value;
  };
  BaseTagInfoMixin.prototype.mixinTagInfo = function (component) {
    component.getTagId = _.constant(this.getTagId());
    component.getDefaultValue = _.constant(this.getDefaultValue());
    component.getTagName = _.constant(this.getTagName());
    component.$isTagGroup = this.isTagGroup();

    // override getName to return the tag name
    component.getName = _.constant(this.getTagName());
    component.$tagInfoMixedIn = true;
    component.isAdHocTag = _.constant(this.$isAdHoc);
  };
  return BaseTagInfoMixin;
});
