/**
 * @file The base ViewManager class, used for management of and
 * navigation between views.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'bajaux/Widget', 'Promise'], function (baja, Widget, Promise) {

  "use strict";

  /*
   * view manager is-a view!
   * 
   * things a view manager can do:
   * - load a view
   * - destroy a view
   * - switch between views (activate/deactivate)
   * - optionally, manage a view history stack 
   */

  var ViewManager = function ViewManager() {
    baja.callSuper(ViewManager, this, arguments);

    this.$selectedView = undefined;
  };

  ViewManager = baja.subclass(ViewManager, Widget);

  /**
   * things this might do:
   * - replace current, only view
   * - push view onto stack
   */
  ViewManager.prototype.loadView = function (options) {
    return Promise.resolve();
  };

  ViewManager.prototype.getSelectedView = function () {
    return Promise.resolve(this.$selectedView);
  };

  ViewManager.prototype.setSelectedView = function (view) {
    var that = this;

    return that.getSelectedView().then(function (oldView) {
      if (view instanceof Widget && view !== oldView) {
        that.$selectedView = view;
      }
    });
  };

  return ViewManager;
});
