/**
 * @file Custom nextToLast jQuery selector.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['jquery'], function ($) {

  "use strict";

  /**
   * jQuery custom selector that returns the next-to-last element in a 
   * stack of elements. If the stack has only one element in it, that
   * element will be returned. Installed using the standard 
   * `$.expr[':'].nextToLast = nextToLast`
   *  
   * @memberOf niagara.util.customSelectors
   */

  function nextToLast(obj, index, meta, stack) {
    return stack.length === 1 || index === stack.length - 2;
  }

  $.extend($.expr[':'], {
    nextToLast: nextToLast
  });

  return $;
});
