/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global baja, niagara, describe, it, expect, beforeEach */

(function testSchedule() {
  "use strict";

  var util = niagara.util,
      mock = niagara.test.mock.mock,
      mockSchedule = util.test.schedule.mockSchedule,
      makeDay = util.test.schedule.makeDay,
      Schedule = niagara.schedule.Schedule,
      dayNames = 'sunday monday tuesday wednesday thursday friday saturday'.split(' ');

  describe("Schedule", function testSchedule() {
    var schedule;
    beforeEach(function () {
      schedule = new Schedule(mockSchedule('schedule:BooleanSchedule'));
      schedule.dayEditors.monday = makeDay({
        start: util.time.MILLIS_IN_HOUR * 1,
        finish: util.time.MILLIS_IN_HOUR * 3,
        value: mock('baja:StatusString').addProp('value', 'block1to3')
      }, {
        start: util.time.MILLIS_IN_HOUR * 5,
        finish: util.time.MILLIS_IN_HOUR * 8,
        value: mock('baja:StatusString').addProp('value', 'block5to8')
      }, {
        start: util.time.MILLIS_IN_HOUR * 20,
        finish: util.time.MILLIS_IN_HOUR * 0,
        value: mock('baja:StatusString').addProp('value', 'block20toMid')
      });
    });

    it("can be created", function canBeCreated() {
      expect(schedule).toBeDefined();
    });

    describe("applyMF", function applyMF() {
      it("overwrites monday to friday", function overwritesMF() {
        expect(schedule.dayEditors.monday.getBlocks().length).toEqual(3);
        util.iterate(dayNames, 2, 6, function (dayName) {
          expect(schedule.dayEditors[dayName].getBlocks().length).toEqual(0);
        });

        schedule.dayEditors.tuesday = makeDay({
          start: util.time.MILLIS_IN_HOUR * 6,
          finish: util.time.MILLIS_IN_HOUR * 10,
          value: mock('baja:StatusString').addProp('value', 'totally new day')
        });

        schedule.applyMF(schedule.dayEditors.monday);

        util.iterate(dayNames, 1, 6, function (dayName) {
          var day = schedule.dayEditors[dayName],
              blocks = day.getBlocks();
          expect(blocks.length).toEqual(3);
          expect(blocks[0].getValue().getValue()).toEqual('block1to3');
          expect(blocks[1].getValue().getValue()).toEqual('block5to8');
          expect(blocks[2].getValue().getValue()).toEqual('block20toMid');
        });
      });
    });

    describe("empty", function empty() {
      it("empties out all days", function emptiesDays() {
        schedule.empty();

        util.iterate(schedule.dayEditors, function (day) {
          day.addTimeSchedule(baja.Time.make(0), baja.Time.make(1), 'hi');
          expect(day.getBlocks().length).toEqual(1);
        });

        schedule.empty();

        util.iterate(schedule.dayEditors, function (day) {
          expect(day.getBlocks().length).toEqual(0);
        });
      });
    });

    describe("overwrite", function overwrite() {
      it("overwrites one day with another", function overwrites() {
        expect(schedule.dayEditors.monday.getBlocks().length).toEqual(3);
        expect(schedule.dayEditors.tuesday.getBlocks().length).toEqual(0);
        schedule.overwrite(schedule.dayEditors.monday, 'tuesday');

        expect(schedule.dayEditors.monday.equivalent(schedule.dayEditors.tuesday)).toBeTruthy();
      });
    });
  });
})();
