var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*jshint strict: false */
define(['baja!', 'jquery', 'Promise', 'underscore', 'mobile/util/aop', 'mobile/fieldeditors/fieldeditors', 'mobile/fieldeditors/fieldeditors.mobile', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/fieldeditors/fieldeditors.composite', 'mobile/fieldeditors/mobile/feUtils', 'mobile/util/mobile/dialogs', 'lex!schedule,mobile,baja', 'baja!baja:EnumSet,baja:Month,baja:Weekday,schedule:YearSchedule,schedule:MonthSchedule,' + 'schedule:DayOfMonthSchedule,schedule:WeekOfMonthSchedule,' + 'schedule:WeekdaySchedule,schedule:DateSchedule,' + 'schedule:DateRangeSchedule,schedule:WeekAndDaySchedule,' + 'schedule:TimeSchedule,schedule:CustomSchedule,' + 'schedule:ScheduleReference'], function schedFEs(baja, $, Promise, _, aop, fe, mobileFE, MobileFieldEditor, compositeFE, feUtils, dialogs, lexs) {
  var getEnumRangeDisplay = feUtils.getEnumRangeDisplay,
      _lexs = _slicedToArray(lexs, 3),
      scheduleLex = _lexs[0],
      mobileLex = _lexs[1],
      bajaLex = _lexs[2];


  var anyDay = scheduleLex.get({
    key: 'dayofmonth.anyDay',
    def: 'Any Day'
  }),
      anyMonth = scheduleLex.get({
    key: 'month.anyMonth',
    def: 'Any Month'
  }),
      anyWeek = scheduleLex.get({
    key: 'week.anyWeek',
    def: 'Any Week'
  }),
      anyWeekday = scheduleLex.get({
    key: 'weekday.anyWeekday',
    def: 'Any Weekday'
  }),
      anyYear = scheduleLex.get({
    key: 'year.anyYear',
    def: 'Any Year'
  }),
      calendarWeek = scheduleLex.get({
    key: 'week.calendarWeek',
    def: 'Calendar Week'
  }),
      lastDay = scheduleLex.get({
    key: 'dayofmonth.last_day',
    def: 'Last Day'
  }),
      last7Days = scheduleLex.get({
    key: 'dayofmonth.last7days',
    def: 'Last 7 Days'
  }),
      oddDays = scheduleLex.get({
    key: 'dayofmonth.oddDays',
    def: 'Odd Days'
  }),
      evenDays = scheduleLex.get({
    key: 'dayofmonth.evenDays',
    def: 'Even Days'
  }),
      monthsEven = scheduleLex.get({
    key: 'month.feb_apr_jun_aug_oct_dec',
    def: 'Feb-Apr-Jun-Aug-Oct-Dec'
  }),
      monthsOdd = scheduleLex.get({
    key: 'month.jan_mar_may_jul_sep_nov',
    def: 'Jan-Mar-May-Jul-Sep-Nov'
  }),
      through = scheduleLex.get({
    key: 'daterange.through',
    def: 'Through'
  }),
      week = scheduleLex.get({
    key: 'week.week',
    def: 'week'
  }),
      ENUMSET_HTML = '<select data-theme="a" name="enumset_{id}" id="enumset_{id}">' + '<option value="-1">' + mobileLex.get('loading') + '</option>' + '</select>';

  function getSlotFacets(component, slot) {
    if (component && slot && component.has(slot)) {
      return component.getSlot(slot).getFacets();
    }
  }

  /**
   * Populates the select dropdown when loading a single-value EnumSet into
   * a field editor (used for DateSchedule, DateRangeSchedule, and
   * WeekAndDaySchedule).
   * @param editor the field editor to load
   * @param od ordinals and display values used to build up the dropdown
   * @param {baja.EnumSet} enumSet the EnumSet being loaded
   * @private
   * @inner
   * @see getOrdinalsAndDisplays
   */
  function populateSelect(editor, od, enumSet) {
    var select = editor.jq().find('select').empty(),
        ordinals = od.ordinals,
        displays = od.displays,
        selectedValue;

    baja.iterate(ordinals, function (ordinal, i) {
      var option = $('<option/>').val(ordinal).text(displays[i]);
      select.append(option);
    });

    if (enumSet === baja.EnumSet.NULL) {
      //NULL indicates "Any" selection which is always at the top
      selectedValue = ordinals[0];
    } else {
      selectedValue = enumSet.encodeToString();
    }
    select.val(selectedValue).trigger('change');
  }

  /**
   * Get the ordinals and display values from the EnumSet currently loaded
   * in the given field editor. Will return an object with 'ordinals' and
   * 'displays' array properties. You can splice or push additional values
   * onto these before loading them into a checkbox multiselect dialog.
   * 
   * Optionally, pass in an `anyDisplay` to prepend an 'any' value to the head
   * of the ordinals/displays.
   * 
   * @param editor the field editor to edit
   * @param [anyDisplay] the display of the 'any' value
   * @returns {Promise}
   * @private
   * @inner
   */
  function getOrdinalsAndDisplays(editor, anyDisplay, getDisplay) {
    var slotFacets = getSlotFacets(editor.container, editor.slot),
        range = slotFacets && slotFacets.get('range'),
        ordinals = range.getOrdinals();

    getDisplay = getDisplay || getEnumRangeDisplay;

    var proms = _.map(ordinals, function (ordinal) {
      return Promise.resolve(getDisplay(ordinal, range) || getEnumRangeDisplay(ordinal, range)).then(function (display) {
        return [ordinal, display];
      });
    });

    return Promise.all(proms).then(function (arrs) {
      var ordinals = _.map(arrs, function (arr) {
        return arr[0];
      }),
          displays = _.map(arrs, function (arr) {
        return arr[1];
      });

      if (anyDisplay) {
        ordinals.splice(0, 0, 'any');
        displays.splice(0, 0, anyDisplay);
      }

      return { ordinals: ordinals, displays: displays };
    });
  }

  function makeSingleEnumSet(val, nullVal) {
    if (val === nullVal) {
      return baja.EnumSet.NULL;
    } else {
      return baja.EnumSet.make([val]);
    }
  }

  /**
   * Edit the current value of the given EnumSet field editor using a dialog.
   * The dialog will allow you to select members of the EnumSet individually 
   * using checkboxes.
   * 
   * @param editor the field editor we're editing
   * @param od ordinals and display values to load into the checkboxes
   * @param anyVal the value representing 'any' (will be either 'any' or '0',
   * depending on the EnumSet)
   * @private
   * @inner
   * @see getOrdinalsAndDisplays
   */
  function dialogEdit(editor, od, anyVal) {
    var ordinals = od.ordinals,
        displays = od.displays,
        enumSet = editor.value(),
        setOrdinals = enumSet.getOrdinals(),
        div = $('<div data-role="fieldcontain"/>'),
        fieldset = $('<fieldset data-role="controlgroup"/>').appendTo(div);

    baja.iterate(ordinals, function (ordinal, i) {
      var display = displays[i],
          id = "checkbox" + ordinal,
          input = $('<input type="checkbox"/>').attr('id', id).attr('value', ordinal),
          label = $('<label/>').attr('for', id).text(display);

      if (_.indexOf(setOrdinals, ordinal) >= 0 || String(ordinal) === anyVal && setOrdinals.length === 0) {
        input.prop('checked', 'checked');
      }

      fieldset.append(input).append(label);
    });

    fieldset.on('change', 'input', function () {
      var val = $(this).val();
      if (val === anyVal) {
        fieldset.find('input[value!=' + anyVal + ']').prop('checked', false);
      } else {
        fieldset.find('input[value=' + anyVal + ']').prop('checked', false);
      }

      if (fieldset.find('input:checked').length === 0) {
        fieldset.find('input[value=' + anyVal + ']').prop('checked', true);
      }

      fieldset.find('input').checkboxradio('refresh');
      editor.setModified(true);
    });

    dialogs.okCancel({
      content: function content(div) {
        div.append(fieldset).trigger('create');
      },
      title: editor.label,
      ok: function ok(cb) {
        var selectedOrdinals = [],
            enumSet;
        fieldset.find('input:checked').each(function () {
          var val = $(this).val();
          if (val !== anyVal) {
            selectedOrdinals.push(Number(val));
          }
        });

        enumSet = baja.EnumSet.make(selectedOrdinals);

        editor.load(enumSet).then(cb.ok, cb.fail);
      }
    });
  }

  /** 
   * Default field editor HTML for an EnumSet.
   * @memberOf niagara.fieldEditors.schedule.simple
   */
  function schedulerEnumSetInitialize(targetElement) {
    targetElement.append(ENUMSET_HTML.patternReplace({ id: this.name }));
  }

  /**
   * Create a button that when clicked will allow the editor's EnumSet to be
   * edited using a dialog with multiple checkboxes.
   *  
   * @param editor an editor for an EnumSet inside a CustomSchedule
   * @param div the div in which the editor will be loaded
   * @param od ordinals and display values for the EnumSet
   * @param anyVal the value representing 'any' (either 'any' or '0')
   */
  function doMultiInitialize(editor, div, od, anyVal) {
    var a = $('<a data-role="button" data-theme="a"/>');

    editor.label = editor.container.getDisplayName();

    a.text(editor.label);

    a.click(function () {
      dialogEdit(editor, od, anyVal);
    });

    a.appendTo(div);
  }

  /**
   * Initializes a multiselect editor for a MonthSchedule in a CustomSchedule.
   */
  function schedulerMonthMultiInitialize(targetElement) {
    var that = this;

    return getOrdinalsAndDisplays(that, anyMonth, getMonthDisplay).then(function (od) {
      od.ordinals.pop(); //remove "12" - no groups
      od.ordinals.pop(); //remove "13" - no groups

      doMultiInitialize(that, targetElement, od, 'any');
    });
  }

  function getWeekDisplay(ordinal, range) {
    if (ordinal === 0) {
      return anyWeek;
    }
    if (ordinal === 6) {
      return last7Days;
    }
    if (ordinal < 6) {
      return week + ' ' + ordinal;
    }
    return calendarWeek + ' ' + (ordinal - 6);
  }

  /**
   * Loads an EnumSet into a dropdown for editing a WeekSchedule inside a 
   * WeekAndDaySchedule.
   */
  function schedulerWeekLoad(enumSet) {
    var that = this;
    return getOrdinalsAndDisplays(that, null, getWeekDisplay).then(function (od) {
      populateSelect(that, od, enumSet);
    });
  }

  /**
   * load() doesn't need to do anything on a multi-select editor.
   */
  function nopLoad() {}

  function getDayDisplay(ordinal, range) {
    if (ordinal === 0) {
      return anyDay;
    }
  }
  /**
   * Loads an EnumSet into a dropdown for editing a DayOfMonthSchedule inside
   * a DateSchedule, DateRangeSchedule, or WeekAndDaySchedule.
   */
  function schedulerDayLoad(enumSet) {
    var that = this;
    return getOrdinalsAndDisplays(that, null, getDayDisplay).then(function (od) {
      populateSelect(that, od, enumSet);
    });
  }

  /**
   * Initializes a multiselect editor for a DayOfMonthSchedule inside a
   * CustomSchedule.
   */
  function schedulerDayMultiInitialize(targetElement) {
    var that = this;
    return getOrdinalsAndDisplays(that, null, getDayDisplay).then(function (od) {
      od.ordinals.push(32, 33, 34, 35);
      od.displays.push(lastDay, last7Days, oddDays, evenDays);
      doMultiInitialize(that, targetElement, od, '0');
    });
  }

  function getMonthDisplay(ordinal, range) {
    if (ordinal === 12) {
      return monthsOdd;
    }
    if (ordinal === 13) {
      return monthsEven;
    }
    var tag = baja.$('baja:Month').get(ordinal).getTag() + '.short';
    return bajaLex.get(tag);
  }
  /**
   * Loads a dropdown for a MonthSchedule inside a DateSchedule or
   * DateRangeSchedule.
   */
  function schedulerMonthLoad(enumSet) {
    var that = this;
    return getOrdinalsAndDisplays(that, anyMonth, getMonthDisplay).then(function (od) {
      od.ordinals.pop(); //remove "12" - no groups
      od.ordinals.pop(); //remove "13" - no groups

      populateSelect(that, od, enumSet);
    });
  }

  /**
   * Loads a dropdown for a MonthSchedule inside a WeekAndDaySchedule
   * (includes month groups).
   */
  function schedulerGroupsMonthLoad(enumSet) {
    var that = this;
    return getOrdinalsAndDisplays(that, anyMonth, getMonthDisplay).then(function (od) {
      populateSelect(that, od, enumSet);
    });
  }

  function getWeekdayDisplay(ordinal, range) {
    if (ordinal >= 7) {
      return null;
    }

    var tag = baja.$('baja:Weekday').get(ordinal).getTag() + '.short';
    return bajaLex.get(tag);
  }

  /**
   * Loads a dropdown for a WeekdaySchedule inside a WeekAndDaySchedule.
   */
  function schedulerWeekdayLoad(enumSet) {
    var that = this;
    return getOrdinalsAndDisplays(that, anyWeekday, getWeekdayDisplay).then(function (od) {
      populateSelect(that, od, enumSet);
    });
  }

  /**
   * Initializes a multiselect editor for a WeekdaySchedule inside a
   * CustomSchedule.
   */
  function schedulerWeekdayMultiInitialize(targetElement) {
    var that = this;
    return getOrdinalsAndDisplays(that, anyWeekday, getWeekdayDisplay).then(function (od) {
      doMultiInitialize(that, targetElement, od, 'any');
    });
  }

  /**
   * Initializes a multiselect editor for a WeekSchedule inside a
   * CustomSchedule.
   */
  function schedulerWeekMultiInitialize(targetElement) {
    var that = this;
    return getOrdinalsAndDisplays(that, null, getWeekDisplay).then(function (od) {
      doMultiInitialize(that, targetElement, od, '0');
    });
  }

  /**
   * Just returns this.value() (editing is already done on
   * multiselect editors).
   */
  function nopRead() {
    return this.value();
  }

  /** Get the value of the editor's dropdown */
  function getSelectValue(editor) {
    return editor.jq().find('select').val();
  }

  /**
   * Reads an EnumSet with a single ordinal, for a MonthSchedule inside a
   * DateSchedule, DateRangeSchedule, or WeekAndDaySchedule. 
   */
  function schedulerMonthRead() {
    var val = getSelectValue(this);
    return makeSingleEnumSet(val, 'any');
  }

  /**
   * Reads an EnumSet with a single ordinal, for a DayOfMonthSchedule inside a
   * DateSchedule or DateRangeSchedule.
   */
  function schedulerDayRead() {
    var val = getSelectValue(this);
    return makeSingleEnumSet(val, '0');
  }

  /**
   * Reads an EnumSet with a single ordinal, for a WeekdaySchedule inside a
   * WeekAndDaySchedule.
   */
  function schedulerWeekdayRead() {
    var val = getSelectValue(this);
    return makeSingleEnumSet(val, 'any');
  }

  /**
   * reads an EnumSet with a single ordinal, for a WeekSchedule inside a
   * WeekAndDaySchedule.
   */
  function schedulerWeekOfMonthRead() {
    var val = getSelectValue(this);
    return makeSingleEnumSet(val, '0');
  }

  /**
   * Initializes a dropdown for a YearSchedule inside a DateSchedule,
   * DateRangeSchedule, or CustomSchedule.
   */
  function schedulerYearInitialize(targetElement) {
    var currentYear = new Date().getFullYear(),
        select = $('<select data-theme="a" name="year" />');

    $('<option />').val('any').text(anyYear).appendTo(select);

    baja.iterate(currentYear, currentYear + 10, function (year) {
      $('<option />').val(String(year)).text(String(year)).appendTo(select);
    });

    select.appendTo(targetElement);
  }

  /**
   * Loads a dropdown for a YearSchedule inside a DateSchedule,
   * DateRangeSchedule, or CustomSchedule.
   */
  function schedulerYearLoad(value) {
    var yearSchedule = value,
        select = this.jq().find('select');

    if (yearSchedule.getAlwaysEffective()) {
      select.val('any');
    } else {
      select.val(String(yearSchedule.getYear()));
    }
  }

  /**
   * Reads a YearSchedule for a DateSchedule, DateRangeSchedule, or
   * CustomSchedule.
   */
  function schedulerYearRead() {
    var yearSchedule = fe.toSaveDataComponent(this.value()),
        val = this.jq().find('select').val();

    if (val === 'any') {
      yearSchedule.setAlwaysEffective(true);
    } else {
      yearSchedule.setAlwaysEffective(false);
      yearSchedule.setYear(Number(val));
    }

    return yearSchedule;
  }

  (function registerFEs() {
    /** EnumSet for month slot on a MonthSchedule */
    var EnumSetMonthEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerEnumSetInitialize,
      doLoad: schedulerMonthLoad,
      doRead: schedulerMonthRead
    });
    fe.register('baja:EnumSet', EnumSetMonthEditor, 'enumset-month');

    /** EnumSet for month slot on a CustomSchedule */
    var EnumSetMonthMultiEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerMonthMultiInitialize,
      doLoad: nopLoad,
      doRead: nopRead
    });
    fe.register('baja:EnumSet', EnumSetMonthMultiEditor, 'enumset-month-multi');

    /** EnumSet for month slot on a MonthSchedule in a WeekAndDaySchedule, includes groups */
    var EnumSetGroupsMonthEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerEnumSetInitialize,
      doLoad: schedulerGroupsMonthLoad,
      doRead: schedulerMonthRead
    });
    fe.register('baja:EnumSet', EnumSetGroupsMonthEditor, 'enumset-month-groups');

    /** EnumSet for a DayOfMonthSchedule */
    var EnumSetDayEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerEnumSetInitialize,
      doLoad: schedulerDayLoad,
      doRead: schedulerDayRead
    });
    fe.register('baja:EnumSet', EnumSetDayEditor, 'enumset-day');

    /** EnumSet for day slot on a DayOfMonthSchedule in a CustomSchedule */
    var EnumSetCustomDayEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerDayMultiInitialize,
      doLoad: nopLoad,
      doRead: nopRead
    });
    fe.register('baja:EnumSet', EnumSetCustomDayEditor, 'enumset-day-custom');

    /** EnumSet for week slot on a WeekOfMonthSchedule on a WeekAndDaySchedule */
    var EnumSetWeekEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerEnumSetInitialize,
      doLoad: schedulerWeekLoad,
      doRead: schedulerWeekOfMonthRead
    });
    fe.register('baja:EnumSet', EnumSetWeekEditor, 'enumset-weekofmonth');

    /** EnumSet for week slot on a WeekOfMonthSchedule on a CustomSchedule */
    var EnumSetWeekMultiEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerWeekMultiInitialize,
      doLoad: nopLoad,
      doRead: nopRead
    });
    fe.register('baja:EnumSet', EnumSetWeekMultiEditor, 'enumset-weekofmonth-multi');

    /** EnumSet for weekday slot on a WeekdaySchedule, except for CustomSchedules */
    var EnumSetWeekdayEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerEnumSetInitialize,
      doLoad: schedulerWeekdayLoad,
      doRead: schedulerWeekdayRead
    });
    fe.register('baja:EnumSet', EnumSetWeekdayEditor, 'enumset-weekday');

    /** EnumSet for weekday slot on a WeekdaySchedule in a CustomSchedules */
    var EnumSetWeekdayMultiEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerWeekdayMultiInitialize,
      doLoad: nopLoad,
      doRead: nopRead
    });
    fe.register('baja:EnumSet', EnumSetWeekdayMultiEditor, 'enumset-weekday-multi');

    /** YearSchedule editor, same everywhere */
    var YearScheduleEditor = fe.defineEditor(MobileFieldEditor, {
      doInitialize: schedulerYearInitialize,
      doLoad: schedulerYearLoad,
      doRead: schedulerYearRead
    });
    fe.register('schedule:YearSchedule', YearScheduleEditor);

    /** MonthSchedule for DateSchedule, DateRangeSchedule  */
    var MonthScheduleEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-month' }]);
    fe.register('schedule:MonthSchedule', MonthScheduleEditor);

    /** MonthSchedule for CustomSchedule */
    var MonthScheduleMultiEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-month-multi' }]);
    fe.register('schedule:MonthSchedule', MonthScheduleMultiEditor, 'month-multi');

    /** MonthSchedule for WeekAndDaySchedule */
    var MonthGroupsScheduleEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-month-groups' }]);
    fe.register('schedule:MonthSchedule', MonthGroupsScheduleEditor, 'month-groups');

    /** DayOfMonthSchedule for DateSchedule, DateRangeSchedule */
    var DayOfMonthScheduleEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-day' }]);
    fe.register('schedule:DayOfMonthSchedule', DayOfMonthScheduleEditor);

    /** DayOfMonthSchedule for CustomSchedule */
    var CustomDayOfMonthScheduleEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-day-custom' }]);
    fe.register('schedule:DayOfMonthSchedule', CustomDayOfMonthScheduleEditor, 'day-custom');

    /** WeekOfMonthSchedule for WeekAndDaySchedule */
    var WeekOfMonthScheduleEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-weekofmonth' }]);
    fe.register('schedule:WeekOfMonthSchedule', WeekOfMonthScheduleEditor);

    /** WeekOfMonthSchedule for CustomSchedule */
    var WeekOfMonthScheduleMultiEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-weekofmonth-multi' }]);
    fe.register('schedule:WeekOfMonthSchedule', WeekOfMonthScheduleMultiEditor, 'week-multi');

    /** WeekdaySchedule for DateSchedule, WeekAndDaySchedule */
    var WeekdayScheduleEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-weekday' }]);
    fe.register('schedule:WeekdaySchedule', WeekdayScheduleEditor);

    /** WeekdaySchedule for CustomSchedule */
    var WeekdayScheduleMultiEditor = compositeFE.makeComposite([{ slot: 'set', key: 'enumset-weekday-multi' }]);
    fe.register('schedule:WeekdaySchedule', WeekdayScheduleMultiEditor, 'weekday-multi');

    /** DateSchedule */
    var DateScheduleEditor = compositeFE.makeComposite(['weekdaySchedule', 'daySchedule', 'monthSchedule', 'yearSchedule']);

    /** DateSchedule: start/end field of a DateRangeSchedule */
    var DateScheduleNoWeekdaysEditor = compositeFE.makeComposite(['daySchedule', 'monthSchedule', 'yearSchedule']);

    /** DateRangeSchedule */
    var DateRangeScheduleEditor = compositeFE.makeComposite([{ slot: 'start', key: 'noweekdays' }, { slot: 'end', key: 'noweekdays' }], MobileFieldEditor);

    /** WeekAndDaySchedule */
    var WeekAndDayScheduleEditor = compositeFE.makeComposite(['weekdays', 'weeksOfMonth', { slot: 'months', key: 'month-groups' }]);

    /** TimeSchedule (for schedule blocks in day editor) */
    var TimeScheduleEditor = compositeFE.makeComposite(['start', 'finish', 'effectiveValue']);

    /** CustomSchedule */
    var CustomScheduleEditor = compositeFE.makeComposite([{ slot: 'daysOfMonth', key: 'day-custom' }, { slot: 'months', key: 'month-multi' }, { slot: 'weekdays', key: 'weekday-multi' }, { slot: 'weeksOfMonth', key: 'week-multi' }, 'year']);

    /** ScheduleReference */
    var ScheduleReferenceEditor = compositeFE.makeComposite([{
      slot: 'ref',
      key: 'componentSelector',
      defaultValue: baja.Ord.make('station:|slot:/|bql: ' + 'select displayName, slotPathOrd from schedule:CalendarSchedule ' + 'where parent.type != schedule:AbstractSchedule')
    }]);

    aop.after(DateScheduleNoWeekdaysEditor.prototype, 'doInitialize', function (args, df) {
      var targetElement = args[0];
      return df.then(function () {
        targetElement.wrapInner('<fieldset data-role="controlgroup"/>');
      });
    });

    aop.after(DateRangeScheduleEditor.prototype, 'doInitialize', function (args, df) {
      var targetElement = args[0];
      return df.then(function () {
        targetElement.children('div.subEditor').eq(0).after($('<div class="through"/>').text(through));
      });
    });

    fe.register('schedule:DateSchedule', DateScheduleEditor);
    fe.register('schedule:DateSchedule', DateScheduleNoWeekdaysEditor, 'noweekdays');
    fe.register('schedule:DateRangeSchedule', DateRangeScheduleEditor);

    fe.register('schedule:WeekAndDaySchedule', WeekAndDayScheduleEditor);
    fe.register("schedule:TimeSchedule", TimeScheduleEditor);
    fe.register("schedule:CustomSchedule", CustomScheduleEditor);
    fe.register("schedule:ScheduleReference", ScheduleReferenceEditor);
  })();

  /**
   * @namespace
   * @name niagara.fieldEditors.schedule
   */
  return {
    schedulerDayLoad: schedulerDayLoad,
    schedulerEnumSetInitialize: schedulerEnumSetInitialize,
    schedulerMonthLoad: schedulerMonthLoad,
    schedulerGroupsMonthLoad: schedulerGroupsMonthLoad,
    schedulerWeekdayLoad: schedulerWeekdayLoad,
    schedulerWeekLoad: schedulerWeekLoad,
    schedulerMonthRead: schedulerMonthRead,
    schedulerDayRead: schedulerDayRead,
    schedulerWeekdayRead: schedulerWeekdayRead,
    schedulerWeekOfMonthRead: schedulerWeekOfMonthRead,

    schedulerYearInitialize: schedulerYearInitialize,
    schedulerYearLoad: schedulerYearLoad,
    schedulerYearRead: schedulerYearRead
  };
});
