var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @file Functions relating to the ScheduleBlock object that contains a
 * BTimeSchedule component within a Day.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/schedule/ScheduleBlock
 */
define(['baja!', 'jquery', 'Promise', 'mobile/util/time', 'mobile/schedule/ScheduleColors', 'mobile/fieldeditors/mobile/feUtils', 'lex!baja,schedule', 'css!mobile/schedule/ScheduleBlock'], function (baja, $, Promise, timeUtil, ScheduleColors, feUtils, lexs) {

  "use strict";

  var getBajaTimeFormat = feUtils.getBajaTimeFormat,
      _lexs = _slicedToArray(lexs, 2),
      bajaLex = _lexs[0],
      scheduleLex = _lexs[1];

  /**
   * Represents one schedule block in a day object.
   * 
   * The constructor can also take a component of type `schedule:TimeSchedule`,
   * in which case the fields will be populated using its `start`, `finish`, and 
   * `effectiveValue` slots.
   *
   * @private 
   * @class
   * @alias module:mobile/schedule/ScheduleBlock
   * @param {baja.Time|baja.Complex} start start time, or a
   * `schedule:TimeSchedule`
   * @param {baja.Time} finish
   * @param {baja.Struct} value (`baja:StatusValue`)
   */
  function ScheduleBlock(start, finish, value) {
    var that = this,
        timeSchedule;

    if (start.getType().is('schedule:TimeSchedule')) {
      timeSchedule = start;
      that.start = timeSchedule.get('start');
      that.finish = timeSchedule.get('finish');
      that.value = timeSchedule.get('effectiveValue');
    } else {
      that.start = start;
      that.finish = finish;
      that.value = value;
    }

    that.$colors = new ScheduleColors(that.value);
  }

  /**
   * Creates a div to display this schedule block - a simple div with two child
   * "grab" divs to use for resizing. The returned div's 
   * `data('scheduleBlock')` will be set to `this`.
   *
   * @param {JQuery} targetElement the div into which to insert our own div
   * @returns {JQuery} a div representing this schedule block
   */
  ScheduleBlock.prototype.generateDiv = function generateDiv(targetElement) {
    var containerDiv = $('<div class="scheduleBlockContainer" />').append($('<div class="grab top" />')).append($('<div class="grab bottom" />')).appendTo(targetElement),
        blockDiv = $('<div class="scheduleBlock" />').appendTo(containerDiv),
        displayDiv = $('<div class="display" />').appendTo(blockDiv);

    displayDiv.append('<span class="valueDisplay"/>&nbsp;<span class="timeDisplay"/>');

    containerDiv.data('scheduleBlock', this);
    return containerDiv;
  };

  /**
   * Returns the BTimeSchedule component represented by this block.
   * 
   * @returns {baja.Component} the `schedule:TimeSchedule` component
   * represented by this block
   */
  ScheduleBlock.prototype.createTimeSchedule = function createTimeSchedule() {

    var ev = 'effectiveValue',
        ts = baja.$('schedule:TimeSchedule', {
      start: this.start,
      finish: this.finish
    });

    ts.add({
      slot: ev,
      value: this.value.newCopy(),
      cx: {
        displayName: scheduleLex.get(ev) || ev
      }
    });

    return ts;
  };

  /**
   * Checks to see if this block overlaps with a time period defined by the
   * given start and finish times.
   * 
   * @param {Number} startms the start time to check (in ms past midnight)
   * @param {Number} finishms the finish time to check (in ms past midnight)
   * @returns {Boolean} true if this block overlaps with the specified time
   * period
   */
  ScheduleBlock.prototype.overlaps = function overlaps(startms, finishms) {
    var s1 = this.start.getTimeOfDayMillis(),
        f1 = this.finish.getTimeOfDayMillis(),
        s2 = startms,
        f2 = finishms;

    if (f1 === 0) {
      f1 = timeUtil.MILLIS_IN_DAY;
    }

    if (f2 === 0) {
      f2 = timeUtil.MILLIS_IN_DAY;
    }

    if (f1 < s1) {
      f1 += timeUtil.MILLIS_IN_DAY;
    }
    if (f2 < s2) {
      f2 += timeUtil.MILLIS_IN_DAY;
    }

    return f1 > s2 && f2 > s1;
  };

  /**
   * Shows this block's time range and effective value. Calls the (async) 
   * `formatDisplayString` function which requires the `baja` lexicon to be
   * pre-loaded.
   */
  ScheduleBlock.prototype.toString = function toString() {
    function timeString(time) {
      return time && time.toTimeStringSync({ textPattern: getBajaTimeFormat() || 'HH:mm', lex: bajaLex });
    }

    var startStr = timeString(this.start),
        finishStr = timeString(this.finish),
        display = '';

    if (startStr) {
      display += startStr + ' - ';
    }

    if (finishStr) {
      display += finishStr;
    }

    return display;
  };

  return ScheduleBlock;
});
