/**
 * @file A view for navigating between property sheets.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'jquery', 'Promise', 'mobile/util/ord', 'mobile/util/aop', 'mobile/util/nav', 'mobile/util/mobile/nav', 'mobile/util/mobile/views/PageViewManager', 'mobile/propsheet/PropertySheet'], function (baja, $, Promise, ordUtil, aop, nav, mobileNav, PageViewManager, PropertySheet) {

  "use strict";

  var ComponentSpaceNavModel = nav.ComponentSpaceNavModel,
      PropertySheetManager;

  /**
   * Given a property sheet object, adds the appropriate jQuery event handlers
   * to enable navigation and editing abilities.
   * 
   * @private
   * @memberOf niagara.propSheet.ui
   * @param {niagara.propSheet.PropertySheet} sheet the sheet to enable
   * jQuery events on
   */
  function armPropSheetHandlers(sheet) {
    var sub = sheet.contentView.getSubscriber();

    sub.attach('reordered flagsChanged facetsChanged', function (slot, cx) {
      sheet.contentView.refresh();
    });

    sub.attach('added removed changed', function (prop) {
      if (prop.getName() === "displayNames") {
        sheet.refresh();
      }
    });
  }

  PropertySheetManager = baja.subclass(function PropertySheetManager() {
    baja.callSuper(PropertySheetManager, this, arguments);

    var that = this,
        navModel = new ComponentSpaceNavModel();

    PageViewManager.call(that, navModel);

    that.navbar = new mobileNav.NavBar(navModel);
    that.navbar.attach('click', function (obj) {
      var node = obj.node,
          children = node.getNavChildren(),
          linkActive = ordUtil.equivalent(node.getNavOrd(), ordUtil.deriveOrd(that.$selectedView.value()));

      if (linkActive && children.length) {
        that.showNavChildren(node);
      } else {
        that.linkToOrd(node.getNavOrd());
      }
    });
  }, PageViewManager);

  PropertySheetManager.prototype.instantiateView = function instantiateView(component, pageData) {
    return Promise.resolve(new PropertySheet());
  };

  aop.advisePrototype(PropertySheetManager, {
    after: {
      attachSubscriberEvents: function attachSubscriberEvents(args, noReturn) {
        var sheet = args[0];
        armPropSheetHandlers(sheet);
      },
      setSelectedView: function setSelectedView(args, noReturn) {
        var sheet = args[0];
        this.navbar.refresh(sheet.getPage());
      }
    }
  });

  return PropertySheetManager;
});
