/**
 * @file Universal requireJS config for mobile apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global require:true*/

require = {
  deps: ['css!/module/mobile/ext/jqm/jquery.mobile.structure-1.4.5.min', 'css!/module/mobile/ext/jqm/jquery.mobile.icons-1.4.5.min'],
  paths: {
    'bajaux': '/module/bajaux/rc',
    'mobile': '/module/mobile/rc',
    'jquery': '/module/mobile/ext/jquery/jquery-2.2.4',
    'jquerymobile': '/module/mobile/ext/jqm/jquery.mobile-1.4.5',
    'jqmDatebox': '/module/mobile/ext/shims/jqmDatebox-4.2.3',
    'underscore': '/module/js/rc/underscore/underscore.min'
  },
  config: {
    baja: {
      start: {
        commFail: function commFail() {
          "use strict";

          require(['mobile/util/mobile/mobile'], function (mobileUtil) {
            mobileUtil.showPageLoadingMsg();
          });
        }
      }
    }
  }
};
