/**
 * @file ORD-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Mobile-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - Pages
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Functions related to the management and display of JQM
 * dialog boxes.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - functions relating to the
 * "available commands" button and associated dialog in our JQM page headers
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file AOP utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Slot-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the BaseFieldEditor object that all
 * field editors in Niagara mobile apps extend from. Also, functions relating
 * to registering field editors on Types.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A base class for views used in JQM apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view for constructing a JQM list.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view to take up an entire JQM page.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to navbar management in Niagara apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file The base ViewManager class, used for management of and
 * navigation between views.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A manager for navigating back and forth between PageViews.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Base field editor from which all others inherit.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Composite field editors.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Field editors for use in a JQM app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Time-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file The built-in field editors available to all Niagara Mobile
 * apps. These field editors make use of jQuery Mobile with the Datebox plugin.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file History app utilities
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson and Jason Spangler
 */

/**
 * @file Start the history nav app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define("mobile/util/ord",["baja!"],function(e){"use strict";function t(e){if(!e)return"";e=String(e);var t=e.length,n=e.substring(t-1,t),i=e.substring(t-2,t-1);return"/"===n&&":"!==i?e=e.substring(0,t-1):":"===n&&(e+="/"),e}function n(t,n){return t=e.Ord.make(t),void 0===n&&(n=!0),t.get({lease:n})}function i(e){e=unescape(String(e)),e.match(/\/$/)&&(e=e.substring(0,e.length-1));var n=e.split("/"),i=0,r=[];for(i=0;i<n.length;i++)r.push(t(n.slice(0,i+1).join("/")));return r}function r(t,n){return!(!t||!n)&&e.Ord.make(t).relativizeToSession().equals(e.Ord.make(n).relativizeToSession())}function o(t){if(t){if(t instanceof e.Ord||"string"==typeof t)return t.toString();if(t.getType().isComponent()&&t.isMounted())return t.getNavOrd().relativizeToSession().toString();if(t.getType().isComplex()){var n=o(t.getParent());if(n)return n+"/"+t.getPropertyInParent()}}}return{chopLastSlash:t,deriveOrd:o,equivalent:r,get:n,makeOrdHistory:i}}),define("mobile/util/mobile/mobile",["baja!","jquery","jquerymobile","Promise"],function(e,t,n,i){"use strict";function r(e){return String(e).replace(/[&<>"'\/]/g,function(e){return E[e]})}function o(){n.loading("show")}function a(){n.loading("hide")}function l(e){var n=e.find(':jqmData(role="header")'),i=e.find(':jqmData(role="footer")'),r=window.innerHeight||t(window).height();return n.length&&(r-=n.outerHeight()),i.length&&(r-=i.outerHeight()),r}function u(e,t){var n=t||e.children(':jqmData(role="content")'),i=l(e),r=n.outerHeight()-n.height();n.height(i-r),n.parent().height(Math.max(n.parent().height(),i)),setTimeout(function(){n.trigger("updatelayout")},100)}function s(e,n,i){e.on(n,i);var r=t._data(e[0]),o=r.events,a=o[n];a.length>1&&a.splice(0,0,a.pop())}function d(t,n,i){var r=this;r.$ticket=setTimeout(function(){r.$ticket&&o()},t),n&&(r.$timeoutTicket=setTimeout(function(){if(r.$ticket){var t="timeout "+n+"ms reached";"function"==typeof i?i(t):e.error(t)}r.hide()},n))}function c(e,t,n){return new d(e||1e3,t,n)}function p(e,t){e.toggleClass("ui-listview-inset ui-corner-all ui-shadow",t);var n=e.children("li"),i=n.first(),r=n.last();i.toggleClass("ui-corner-top",t),r.toggleClass("ui-corner-bottom",t),i.children("a").last().toggleClass("ui-corner-tr",t),r.children("a").last().toggleClass("ui-corner-br",t)}function f(e){p(e,!0)}function m(e){p(e,!1)}function h(e){e.on("click","a",function(){var e=t(this);setTimeout(function(){e.removeClass(function(e,t){return"ui-btn-active "+(t.match(/\bui-btn-hover-\w/g)||[]).join(" ")})},100)})}function g(e){return e=String(e),"#"===e.charAt(0)&&(e=e.substring(1)),e.replace(D,function(e){return"_"+e.charCodeAt(0).toString(16).toUpperCase()})}function v(e){if(!e)return e;e=e instanceof t?e.attr("id"):String(e);var n=/\_([A-Z0-9][A-Z0-9])/g;return e=e.replace(n,function(e){return String.fromCharCode(parseInt(e.substring(1,e.length),16))}),unescape(e)}function y(t){var n=t&&t.viewQuery;return n||(t=e.objectify(t,"viewQuery"),n=t.viewQuery),"string"==typeof n||n&&n.id?n=new e.ViewQuery(n):!n&&t.id&&(n=new e.ViewQuery(t)),t.viewQuery=n,t}function b(t,n){n=y(n);var i;i=n.viewQuery?e.Ord.make({base:t,child:n.viewQuery}):e.Ord.make(t),window.location.assign(i.toUri())}function j(n,i){i=y(i);var r;r=i.viewQuery?e.Ord.make({base:n,child:i.viewQuery}):e.Ord.make(n),t.mobile.changePage(r.toUri(),i)}function T(n,r){var o=c(1e3);return i.resolve(t.ajax({url:e.Ord.make(n).toUri(),type:"POST",headers:{"niagara-mobile-rpc":"typeSpec"}})).then(function(e){return o.hide(),e.typeSpec===niagara.view.typeSpec?j(n,r):b(n,r)},function(e){return o.hide(),b(n,r)})}function w(e,t){x().pagecontainer("change",e,t)}function x(){return t(":mobile-pagecontainer")}function S(){return x().pagecontainer("getActivePage")}function k(e){x().length?e():t(window).one("pagecontainercreate",e)}var D=/[^\w-_]/g,E={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};return d.prototype.hide=function(){a();var e=this;clearTimeout(e.$ticket),delete e.$ticket,clearTimeout(e.$timeoutTicket),delete e.$timeoutTicket},{applyListviewInset:f,changePage:w,decodePageId:v,encodePageId:g,escapeHtml:r,getActivePage:S,getPageContainer:x,getVisibleHeight:l,hidePageLoadingMsg:a,linkToOrd:T,linkToOrdExternal:b,linkToOrdInternal:j,onPageContainerCreate:k,prependEventHandler:s,preventNavbarHighlight:h,removeListviewInset:m,setContentHeight:u,showPageLoadingMsg:o,spinnerTicket:c}}),define("mobile/util/mobile/pages",["baja!","jquery","jquerymobile","mobile/util/mobile/mobile"],function(e,t,n,i){"use strict";function r(e,t){1===arguments.length&&(t=e,e=$);var n=e;return"string"==typeof n&&(n=function(t){return e===t}),C.push({isMatch:n,handler:t}),t}function o(e){if(!e)return null;var t;for(t=0;t<C.length;++t)if(C[t].isMatch(e))return C[t].handler;return null}function a(e){var t=e.page.attr("id")||$,n=o(t);n&&"function"==typeof n[e.eventName]&&n[e.eventName](e)}function l(t){t=e.objectify(t,"eventName");var n;for(n=0;n<C.length;++n)"function"==typeof C[n].handler[t.eventName]&&C[n].handler[t.eventName](t)}function u(){return E.attr("id")||""}function s(){return o(u())}function d(){return E}function c(){return O.attr("id")||""}function p(){return O}function f(){return o(c())}function m(){return D}function h(e,n){var i,r=n.toPage;n&&n.prevPage&&(i=t(n.prevPage)),E||(i=r),a({page:r,prevPage:i,event:e,eventName:"pageshow"}),"dialog"!==r.jqmData("role")&&(E=O,O=r)}function g(e,n){var i,r=t(e.target);r&&(n&&n.prevPage&&(i=t(n.prevPage)),E||(i=r),a({page:r,prevPage:i,event:e,eventName:e.type}))}function v(e,n){var i;n&&n.nextPage&&(i=t(n.nextPage)),a({page:O,nextPage:i,event:e,eventName:"pagehide"})}function y(e,n){D=!1;var i;n&&n.nextPage&&(i=t(n.nextPage)),a({page:O,nextPage:i,event:e,eventName:e.type})}function b(e,n){a({page:t(e.target),event:e,eventName:e.type})}function j(e){return e=decodeURIComponent(e),"/"!==e.charAt(0)&&"#"!==e.charAt(0)||(e=e.substring(1)),e.match(/^ord[\?\/]/)?"ord?"+encodeURI(e.substring(4)):encodeURI(e)}function T(e){return I(j(e))}function w(e,t,n){if(!e||"function"!=typeof e.createPage)throw new Error("No page handler (or no createPage function) found for id "+t);e.createPage(n)}function x(n,i){if(!N){var r,a=o(n),l=P();N=!0,i.pageData&&a&&"function"==typeof a.encodeUrl&&(n=a.encodeUrl(i.pageData)),r=T(n),l.children("#"+r).length||w(a,r,t.extend(i,{ok:function(e){e.attr("id",r),l.append(e),e.jqmData("pageData",i.pageData),e.page(),N=!1,t.mobile.changePage(e,i)},fail:function(t){N=!1,e.fail(t)}}))}}function S(n,i){if("string"==typeof i.toPage){var r,l,u,s=t.mobile.path.parseUrl(i.toPage),d=j(s.pathname+s.search),c=j(s.hash||""),p=j(s.pathname||""),f=c,m=P();if(!(c.indexOf("&ui-state=dialog")>-1)&&(r=o(f),r||(f=p,r=o(f)),r||(f=d,r=o(f)),r)){if(l=m.children("#"+T(f)),!l.length&&c&&(l=m.children("#"+T(c))),l.length||(l=m.children("#"+T(d))),c&&l.length||(i.options.dataUrl="/"+d),!l.length){if("function"!=typeof r.createPage)return;u=r.decodeUrl&&r.decodeUrl(s),i.options.pageData=u,i.options.url=s,e.started(function(){x(f,i.options)})}i.options.role&&"dialog"===i.options.role||l.is(".ui-dialog")||(l.length&&t.mobile.changePage(l,i.options),n.preventDefault())}}else if(i.toPage instanceof t){if(i.consumed)return;i.consumed=!0,"dialog"!==i.toPage.jqmData("role")&&(i.options.fromPage&&"dialog"!==i.options.fromPage.jqmData("role")&&a({page:i.options.fromPage,nextPage:i.toPage,event:n,eventName:"pagebeforechange",options:i.options}),n.isDefaultPrevented()||setTimeout(function(){i.toPage.trigger("pagelayout")},0))}}function k(){var e=P();e.on("pagebeforecreate pagecreate pageinit pagelayout","div",b).on("pagecontainershow",h).on("pagebeforeshow","div",g).on("pagecontainerhide",v).on("pagebeforehide","div",y),e.on("pagecontainerbeforechange",S)}var D=!0,E=null,O=null,C=[],N=!1,I=i.encodePageId,P=i.getPageContainer,q=i.onPageContainerCreate,$="____DEFAULT_PAGE_$_$";return q(k),{register:r,getPrevName:u,getPrev:d,getPrevHandler:s,getCurrentName:c,getCurrent:p,getCurrentHandler:f,getHandler:o,fire:a,fireAll:l,isFirst:m}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/util/mobile/dialogs",["baja!","lex!mobile","jquery","jquerymobile","Promise","mobile/util/mobile/pages","mobile/util/mobile/mobile","css!mobile/util/mobile/dialogs"],function(e,t,n,i,r,o,a){"use strict";function l(t,i){return t instanceof n?(i.html(t),r.resolve()):"object"===(void 0===t?"undefined":_typeof(t))||"string"==typeof t?(t instanceof Error&&e.error(t),i.text(String(t)),r.resolve()):"function"==typeof t?r.try(function(){return t(i.empty())}):void 0}function u(e){var t=o.getCurrent();return"string"==typeof e&&(e=p(e),e=n("#"===e.charAt(0)?e:"#"+e)),!t||!e||t[0]!==e[0]}function s(t,i){var r=n(j.patternReplace({theme:"a"})),o=r.children(":jqmData(role=content)").children(".dialogButtons");return e.iterate(i,function(e,t){var i=n(T.patternReplace({value:e}));i.text(v.get({key:e,def:e})),i.appendTo(o)}),r.attr("id",t),0===t.indexOf("error")&&r.addClass("error"),r.appendTo(m()),r}var d=e.callbackify,c=a.decodePageId,p=a.encodePageId,f=a.getActivePage,m=a.getPageContainer,h=a.hidePageLoadingMsg,g=_slicedToArray(t,1),v=g[0],y={},b=void 0,j=void 0,T=void 0,w=!1;j='<div data-role="dialog" class="dynamicDialog" data-overlay-theme="b">\n<div class="dynamicDialogHeader" data-role="header" data-theme="a">\n<h1 class="title" />\n</div>\n<div class="dynamicDialogContent" data-role="content" data-theme="c">\n<div class="dialogDisplay"></div>\n<div class="dialogButtons" data-role="controlgroup" data-type="horizontal"></div>\n</div>\n</div>',T='<a data-value="{value}" data-role="button" data-theme="a"></a>';var x=function(t,n){this.$params=e.objectify(t,"content"),this.$returnPage=t.returnPage,this.$page=n,w=!0};y.DialogInvocation=x,x.prototype.close=function(e){e=e||"cancel";var t=this,r=t.$options,o=t.$returnPage;"string"==typeof o&&0!==o.indexOf("ord?")&&"#"!==o.charAt(0)&&(o="#"+o),o instanceof n||"string"==typeof o?i.changePage(o,n.extend({transition:"none",changeHash:u(o)},r)):"function"==typeof o?o.call(this,e):i.changePage(location.href,{transition:"none",changeHash:!1}),b=void 0},x.prototype.invoke=function(t,n){function i(e){w=!1,u.fail(e),n.fail(e),w||a.close(t)}var r=e.ok,o=y.error;n=d(n,r,o);var a=this,l=a.$params,u=d(l.callbacks,r,o),s="function"==typeof t?t:l[t];"function"!=typeof s&&(s=function(e){e.ok()});try{w=!1,s.call(a,{ok:function(){w||a.close(t),u.ok(),n.ok()},fail:i})}catch(e){i(e)}},x.prototype.redirect=function(e,t){this.$returnPage=e,this.$options=t||{}},x.prototype.load=function(){var e=this,t=e.$page,i=e.$params,r=t.find(":jqmData(role=header)"),o=t.find(":jqmData(role=content)"),a=o.children(".dialogDisplay"),u=r.find("a:jqmData(icon=delete)"),s=o.find(".dialogButtons a");return r.find("h1.title").text(i.title||""),s.off("click").addClass("ui-disabled"),u.off().on("click",function(){return e.invoke("cancel"),!1}),l(i.content||"",a).then(function(){s.on("click",function(){var t=n(this).jqmData("value");e.invoke(t)}),s.removeClass("ui-disabled"),y.repositionDialog(t)},function(e){y.error("Failed to load dynamic dialog content: "+e)})},y.repositionDialog=function(e){var t=e.children(".ui-dialog-contain"),i=e.find(":jqmData(role=header)"),r=t.outerHeight(),o=n(window).height(),a=(o-r)/2,l=Math.max(a,15);t.css("margin-top",l),i.css("margin-top",l)},y.closeCurrent=function(){b&&b.close()},y.registerDialog=function(e,t){function r(e){b?b.load():e.page.find(".dialogDisplay").empty()}function a(r){var o=n("#"+e);return o.length||(o=s(e,t)),r.returnPage=b&&b.$returnPage||r.returnPage,b=new x(r,o),i.changePage(o,{changeHash:!1,allowSamePageTransition:!0,transition:"none"}),b}var l;l={load:a,pagebeforeshow:r},o.register(e,l)},function(){var e=y.registerDialog;e("yesNoCancelDialog",["yes","no","cancel"]),e("yesNoDialog",["yes","no"]),e("okCancelDialog",["ok","cancel"]),e("okDialog",["ok"]),e("errorDialog",["ok"]),e("cancelDialog",["cancel"])}();var S=function(e,t){return o.getHandler(e).load(t)};return y.yesNoCancel=function(e){return S("yesNoCancelDialog",e)},y.ok=function(e){return S("okDialog",e)},y.okCancel=function(e){return S("okCancelDialog",e)},y.cancel=function(e){return S("cancelDialog",e)},y.yesNo=function(e){return S("yesNoDialog",e)},y.error=function(t,n){return n=n||function(e){e.ok()},"function"!=typeof t&&e.error(t),h(),S("errorDialog",{title:v.get("appError"),content:t,ok:n})},y.unrecoverableError=function(t){var i,r=function(){location.reload()};return"function"==typeof t?i=t:(i=function(e){var i=n("<div/>").css({"margin-bottom":"1em"}).text(String(t)),r=n("<div/>").text(v.get("message.clickOKToReload"));e.append(i),e.append(r)},e.error(t)),h(),S("errorDialog",{title:v.get("unrecoverableError"),content:i,ok:r})},y.confirmAbandonChanges=function(t){t=e.objectify(t);var n=function(e){e.ok()},i=t.yes||n,r=t.no||n,a=t.redirect;return t.title=v.get("abandonChanges"),t.content=v.get({key:"message.confirmUnsavedChanges",args:[t.viewName]}),t.returnPage||(t.returnPage=c(o.getCurrent())),t.yes=function(e){a&&this.redirect(a),i.call(this,e)},t.no=function(e){a&&this.redirect(a),r.call(this,e)},y.yesNoCancel(t)},y.showDialog=function(e,t){var n=o.getHandler(e);return n?n.load(t):y.error(v.get({key:"dialogs.noPageRegistered",args:[e]}))},function(){n(window).on("resize",e.throttle(function(){var e=f();"dialog"===e.jqmData("role")&&y.repositionDialog(e)},500))}(),function(){var t=window.location.hash;t.indexOf("&ui-state=dialog")>0&&e.started(function(){i.changePage(t.replace("&ui-state=dialog",""),{changeHash:!0,transition:"none"})})}(),y}),define("mobile/util/mobile/commands",["require","css!mobile/util/mobile/commands","jquerymobile","baja!","jquery","Promise","underscore","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/mobile","lex!mobile"],function(e){"use strict";function t(){return m(S.patternReplace({title:T.get("menu")}))}function n(e,t,n){if(e=g.filter(e,function(e){return e.isEnabled()}),m("a.commandsButton").trigger("onShowCommands",e),n=w(n),t=t||T.get("commands.title"),0===e.length)y.ok({title:t,content:T.get("commands.noneAvailable")});else var i=y.cancel({title:t,content:function(t){var n=g.map(e,function(e){var t=m("<li/>"),n=m("<a/>").appendTo(t);return e.toDisplayName().then(function(r){return n.text(r),n.click(function(){i.invoke(function(t){e.invoke().then(t.ok,t.fail)})}),t})});return h.all(n).then(function(e){var n=m('<ul data-role="listview" data-theme="c" />').html(e);t.html(n),n.listview()})},callbacks:n})}function i(){var e=Array.prototype.slice.call(arguments);f.iterate(e,function(e){x.contains(e)||x.push(e)})}function r(){var e=Array.prototype.slice.call(arguments);f.iterate(e,function(e){x.contains(e)||(x.length?x.splice(0,0,e):x.push(e))})}function o(e){var t=Array.prototype.slice.call(arguments);t.length>1?f.iterate(t,function(e){o(e)}):f.iterate(x,function(t,n){if(t===e)return x.splice(n,1),!0})}function a(){return x.slice(0)}function l(e){x=e}function u(){var e=a(),t=b.getCurrentHandler();return t&&"function"==typeof t.getCommands&&(e=t.getCommands({commands:e,page:b.getCurrent()})),n(e),!1}function s(){return c}function d(){return p}e("css!mobile/util/mobile/commands"),e("jquerymobile");var c,p,f=e("baja!"),m=e("jquery"),h=e("Promise"),g=e("underscore"),v=e("bajaux/commands/Command"),y=e("mobile/util/mobile/dialogs"),b=e("mobile/util/mobile/pages"),j=e("mobile/util/mobile/mobile"),T=e("lex!mobile")[0],w=f.callbackify,x=[],S="<a class='commandsButton profileHeader' title='{title}' data-icon='bars' data-role='button' data-iconpos='notext'></a>";return p=new v("%lexicon(mobile:commands.logout)%",function(e){var t=location.protocol+"//"+location.host+"/logout";window.location.assign(t+"?csrfToken="+encodeURIComponent(m("#csrfToken").val()))}),"undefined"!=typeof niagara&&niagara.view.profile.showLogoutCmd&&r(p),c=new v("%lexicon(mobile:commands.home)%",function(e){j.linkToOrd(f.getUserHome())}),"undefined"!=typeof niagara&&niagara.view.profile.showHome&&r(c),{getCommandsButton:t,getHomeCmd:s,getLogoutCmd:d,showCommandsDialog:n,addDefaultCommand:i,prependDefaultCommand:r,removeDefaultCommand:o,getDefaultCommands:a,setDefaultCommands:l,showCommandsHandler:u}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};define("mobile/util/aop",["baja!"],function(e){"use strict";function t(t,n){return e.iterate(t,function(e){return e[n]},function(e){return e.prototype})}function n(e,i,r,o){if("function"!=typeof o)throw"missing AOP function wrapper";var a,l;if("function"==typeof e&&"function"==typeof i)return r=e,a=i,l=o(r,a),l.prototype=a.prototype,l;if("object"!==(void 0===e?"undefined":_typeof(e))&&"function"!=typeof e||"string"!=typeof i||"function"!=typeof r)throw"AOP functions must be called with argument signature [Function, Function] or [Object, String, Function]";a=t(e,i),e[i]=n(r,a,null,o)}function i(e,t,i){return n(e,t,i,function(e,t){return function(){var n=Array.prototype.slice.call(arguments),i=e.call(this,n);if(!1!==i)return t.apply(this,i||n)}})}function r(e,t,i){return n(e,t,i,function(e,t){return function(){var n=Array.prototype.slice.call(arguments),i=t.apply(this,n),r=e.call(this,n,i);return void 0===r?i:r}})}function o(t,n){e.strictArg(t,Object),n=e.objectify(n);var o=n.before||{},a=n.after||{};return e.iterate(o,function(e,n){i(t,n,e)}),e.iterate(a,function(e,n){r(t,n,e)}),t}function a(t,n){return e.strictArg(t,Function),o(t.prototype,n),t}return{advise:o,advisePrototype:a,after:r,before:i}}),define("mobile/util/slot",["baja!","jquery","Promise","underscore","baja!baja:Link,baja:Password,control:IWritablePoint"],function(e,t,n,i){"use strict";function r(e,t,n){if(t===n||t<0||n<0||t>=e.length||n>=e.length)return!1;var i=e.splice(t,1);return e.splice(n,0,i[0]),!0}function o(e,r,o,a){var l=e.getSlots().dynamic().toArray();return a(l,i.indexOf(l,e.getSlot(r)))?e.reorder(t.extend(o,{dynamicProperties:l})):n.resolve()}function a(e,t,n){return o(e,t,n,function(e,t){return r(e,t,t-1)})}function l(e,t,n){return o(e,t,n,function(e,t){return r(e,t,t+1)})}function u(e,t,n){return o(e,t,n,function(e,t){return r(e,t,0)})}function s(e,t,n){return o(e,t,n,function(e,t){return r(e,t,e.length-1)})}function d(t){var n=t.getFlags();return!!(e.Flags.CONFIRM_REQUIRED&n)}function c(t){return!!t.getType().is("baja:Password")||e.Flags.READONLY&t.getFlags()}function p(t){var n=t.getFlags();return!!(e.Flags.HIDDEN&n)||(!(!t.isProperty()||!t.getType().is("baja:Link"))||("wsAnnotation"===t.getName()||"displayNames"===t.getName()))}function f(e){return!e.getType().is("baja:Password")&&(!c(e)&&!p(e))}function m(e){return e.isAction()&&!p(e)}function h(t){var n,i,r=e.Facets.DEFAULT;return t&&t.getType().isComplex()&&(i=t.getSlots().properties().frozen().is("baja:Facets").firstValue(),"function"==typeof t.getFacets&&(n=t.getFacets())&&(r=e.Facets.make(r,n)),i&&(r=e.Facets.make(r,i))),r}function g(e){var t=e&&e.getType();if(t)return t.isComponent()?e:t.isComplex()?g(e.getParent()):void 0}function v(t,n){var i,r,o,a,l=e.Facets.DEFAULT,u=t&&t.getType();if(n&&t.getType().isComplex()&&(n=t.getSlot(n),n.isProperty()&&n.getType().isComplex()&&(t=t.get(n))),u&&u.isComplex()&&(i=g(t))&&(o=i.getType(),(r=h(i))&&(l=e.Facets.make(l,r))),n instanceof e.Slot){if(a=String(n),o&&o.is("control:IWritablePoint")&&(n.isFrozen()&&0===a.indexOf("in")||"set"===a||"fallback"===a||"override"===a||"emergencyOverride"===a))return l;l=e.Facets.make(l,n.getFacets())}return l}return{getFacets:v,isConfirmRequired:d,isEditable:f,isFireable:m,isHidden:p,isReadonly:c,moveDown:l,moveUp:a,moveToTop:u,moveToBottom:s}}),define("mobile/fieldeditors/fieldeditors",["baja!mobile:MobileFieldEditor","baja!","jquery","Promise","underscore","mobile/util/aop","mobile/util/slot","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,o,a,l){"use strict";function u(e,t){var i=n('<div class="labeledEditor"/>').appendTo(t),r=n('<label class="editorLabel" />'),o=n('<div class="editorContainer"/>');return void 0!==e&&r.text(e),i.append(r).append(o),o}function s(e){var t=e.newCopy(!0);return t.editedSlots={},t.getSlots().properties().isComplex().each(function(e){var n=t.get(e);t.set({slot:e,value:s(n)})}),o.after(t,"set",function(e,t){var n=e[0];return this.editedSlots[String(n.slot)]=n.value,t}),t}function d(e,n){n=t.objectify(n);var r,a=n.doInitialize,l=n.doLoad,u=n.doRead,s=n.doSave;return t.strictAllArgs([a,l],[Function,Function]),r=t.subclass(function(){t.callSuper(r,this,arguments)},e),r.prototype.doInitialize=function(t){var n=this;return i.resolve(e.prototype.doInitialize.call(n,t)).then(function(){return a.call(n,t)})},r.prototype.doLoad=function(t){var n=this;return i.resolve(e.prototype.doLoad.call(n,t)).then(function(){return l.call(n,t)})},"function"==typeof u&&(r.prototype.doRead=u),"function"==typeof s&&(r.prototype.doSave=s),n.validate&&o.after(r.prototype,"postCreate",function(e){this.validators().add(n.validate)}),n.postCreate&&o.after(r.prototype,"postCreate",function(e){n.postCreate.call(this)}),n.doEnabled&&o.after(r.prototype,"doEnabled",function(e){n.doEnabled.apply(this,e)}),r}function c(e){return e?t.importTypes({typeSpecs:[e]}).then(function(e){var n=e[0];return!!n.is(C)||(!!n.is(N)||(t.error("fieldEditor facet "+n+" does not reference a sub-Type of MobileFieldEditor."),!1))},function(n){return t.error("fieldEditor facet "+e+" does not reference a known Type."),!1}):i.resolve(!1)}function p(e){function n(e){for(var t=x();e;){if(D[String(e)])return!0;if(t[String(e)])return!0;e=e.getSuperType()}}return null!==e&&void 0!==e?function(){return"string"==typeof e?t.importTypes({typeSpecs:[e]}).then(function(e){return e[0]}):e.getType?i.resolve(e.getType()):i.resolve(e)}().then(function(t){if(n(t))return!0;var i=e.getFacets&&e.getFacets();return c(i&&i.get(I))}):i.resolve(!1)}function f(e){return c(e).then(function(t){return!!t&&p(e)})}function m(e,t,n){var i="/ord/"+e;return i+="|view:mobile:MobileFieldEditorView%3FfeTypeSpec="+t+";typeSpecs="+n.join(",")}function h(e){e=String(e);var t=S(),n=x(),o=t&&t[e],a=[];return o?(r.each(o.js,function(t){a.push(m(t,e,o.agentOn))}),r.each(o.css,function(e){e.indexOf(".css")===e.length-4&&(e=e.substring(0,e.length-4)),a.push("css!"+e)}),O(a).then(function(){delete t[e],delete n[e]})):i.resolve()}function g(e){e=String(e);var t=x(),n=t&&t[e];if(!n)return i.resolve();var o=r.map(n,function(e){return h(e)});return i.all(o).then(function(){delete t[e]})}function v(e){return e.is(C)?h(e):g(e)}function y(e){return e?v(e).then(function(){return y(e.getSuperType())}):i.resolve()}function b(e,n){var r;return e?("string"==typeof e&&(e=t.lt(e)),n=n||"default",y(e).then(function(){for(;!r&&e;){if((r=D[String(e)])&&r[n])return r[n];e=e.getSuperType()}return b("baja:String","default")})):i.reject("cannot get field editor for null type")}function j(e,t,n){if(!e)throw new Error("cannot register field editor for null type");if("function"!=typeof t)throw new Error("editor is required");e=String(e),n=n||"default";var i=D[e]||{};return i[n]=t,D[e]=i,t}function T(e,n,i,r){var o,l=E;return o=n&&i?a.getFacets(n,i):a.getFacets(e),o&&(l=t.Facets.make(l,o)),r&&(l=t.Facets.make(l,r)),l}function w(){return"undefined"!=typeof niagara&&niagara.view||{}}function x(){return w().customFieldEditors||{}}function S(){return w().fieldEditorResources||{}}function k(e,n){arguments.length<2&&(n=e,e=null);try{t.strictArg(n),!1!==n.autoInitialize&&t.strictArg(n.element)}catch(e){return i.reject("element is required to initialize - did you mean to set autoInitialize = false?")}if(void 0===n.value){try{t.strictArg(n.container,t.Complex)}catch(e){return i.reject("container is required when value is undefined")}n.value=n.container.get(n.slot)}var r,o,a,l=n.value,u=!1!==n.autoInitialize,s=n.element,d=n.type||l.getType(),c=n.key;return o=n.container||l.getParent&&l.getParent(),a=n.slot||l.getPropertyInParent&&l.getPropertyInParent(),n.facets=T(l,o,a,n.facets),r=n.facets.get(I),f(r).then(function(i){function p(e){var t=new e(l,o,a,n);return u?t.initialize(s).then(function(){return t.load(l)}).then(function(){return t}):t}return i&&(d=t.lt(r)),e?p(e):b(d,c).then(p)})}var D={},E=t.Facets.make({timeFormat:t.getTimeFormatPattern(),unitConversion:t.getUnitConversion()}),O=l.doRequire,C="mobile:MobileFieldEditor",N="workbench:WbFieldEditor",I="fieldEditor";return{composite:{},defineEditor:d,isRegistered:p,makeFor:k,register:j,toLabeledEditorContainer:u,toSaveDataComponent:s}}),define("mobile/util/mobile/views/MobileView",["baja!","jquery","Promise","bajaux/Widget"],function(e,t,n,i){"use strict";var r=function(){i.apply(this,arguments)};return r.prototype=Object.create(i.prototype),r.prototype.constructor=r,r.prototype.doInitialize=function(e){return n.resolve(i.prototype.doInitialize.call(this,e)).then(function(){e.enhanceWithin()})},r}),define("mobile/util/mobile/views/ListView",["baja!","jquery","jquerymobile","Promise","underscore","mobile/util/slot","mobile/util/ord","mobile/util/mobile/mobile","mobile/util/mobile/views/MobileView","bajaux/icon/iconUtils","bajaux/mixin/subscriberMixIn"],function(e,t,n,i,r,o,a,l,u,s,d){"use strict";function c(e){return e.getType().isComplex()}var p=l.encodePageId,f=l.decodePageId,m=l.getActivePage,h=s.toHtml,g=function(){u.apply(this,arguments),d(this)};return g.prototype=Object.create(u.prototype),g.prototype.constructor=g,g.prototype.shouldIncludeSlot=function(e){return e.isProperty()&&!e.isAction()&&!e.isTopic()},g.prototype.doInitialize=function(n){var i=this;return u.prototype.doInitialize.call(this,n).then(function(){n.on("click","a.expandable",function(){var n=t(this).children("span.slotName").text();return i.doExpand(n).catch(e.error),!1}),n.on("click","a.link",function(e){var n=t(this),r=n.parents("li.property").attr("id");i.linkClicked(f(r),n)})})},g.prototype.doLoad=function(t){var n=this;e.strictArg(t,e.Complex);var i=this.$highlightedSlot;return this.makeListView(t).then(function(e){n.$ul=e,n.jq().empty().append(e).enhanceWithin(),i&&n.highlight(i)})},g.prototype.scrollExpandedDivIntoView=function(e){var i=m(),r=e.offset().top+e.height(),o=i.children(":jqmData(role=header)").height(),a=i.children(":jqmData(role=footer)").height(),l=t(window),u=l.scrollTop(),s=u+l.height()-a;if(r>s){var d=e.prev().offset().top-o;n.silentScroll(Math.min(d,u+(r-s)))}},g.prototype.doExpand=function(e){var n=this,r=function(e){return"ui-icon-carat-"+e},o=this.value().getSlot(e),a=p(o.getName()),l=this.$ul.children("li#"+a),u=l.children(".expandable").removeClass("udrl".split("").map(r).join(" ")),s=l.next(".expanded");return new i(function(e){var i=function(t){u.addClass(r(t)),n.scrollExpandedDivIntoView(s),e()};s.length?s.is(":visible")?s.hide("fast",function(){return i("d")}):s.show("fast",function(){return i("u")}):(s=t('<div class="expanded"/>').insertAfter(l).hide(),n.populateExpandedDiv(o,s),s.show("fast",function(){return i("u")}))})},g.prototype.highlight=function(e){this.removeHighlight();var t=this.$ul,n=p(e);this.$highlightedSlot=e,t.children("li#"+n).addClass("ui-btn-active")},g.prototype.removeHighlight=function(){delete this.$highlightedSlot,this.$ul.children().removeClass("ui-btn-active")},g.prototype.linkClicked=function(e,t){this.highlight(e)},g.prototype.populateExpandedDiv=function(e,t){},g.prototype.makeListView=function(e){var n=this,a=e.getSlots(function(e){return n.shouldIncludeSlot(e)&&!o.isHidden(e)}).toArray(),l=r.map(a,function(t){return n.makeListItem(e,t)});return i.all(l).then(function(e){return t('<ul data-role="listview" data-theme="c" />').html(e)})},g.prototype.prependIcons=function(e,t){return t?h(t).then(function(t){return e.find(".bajaImage").html(t)}):i.resolve()},g.prototype.makeListItem=function(e,n){var i=this,r=t('<li class="property" data-icon="carat-r"/>').attr("id",p(String(n))).append('<span class="bajaImage"></span>');return this.makeListItemParams(e,n).then(function(e){return i.prependIcons(r,e.icon).then(function(){if(t('<label class="title" />').text(e.title||"").appendTo(r),t('<span class="hidden slotName" />').text(String(n)).appendTo(r),t('<div class="display" />').text(e.display||"").appendTo(r),e.linkable||e.expandable){var i=t("<a />");i.jqmData("ord",e.ord),e.expandable?(i.addClass("expandable"),r.attr("data-icon","carat-d")):i.addClass("link"),r.wrapInner(i)}return r})})},g.prototype.makeListItemParams=function(t,n){var r=t.get(n),l=a.deriveOrd(r);return n.getType().is("baja:VirtualGateway")&&(l+="|virtual:/"),i.resolve({ord:l,title:t.getDisplayName(n),display:e.SlotPath.unescape(t.getDisplay(n)),icon:r.getIcon(),expandable:o.isEditable(n),linkable:c(n)&&!o.isReadonly(n)})},g.prototype.updateDisplay=function(e){if(!this.$ul)return i.resolve();var t=p(String(e)),n=this.$ul.find("li.property#"+t),r=n.find("div.display"),o=this.value(),a=o.get(e);return r.length&&r.text(o.getDisplay(e)),i.resolve(a&&a.getType().isComponent()&&this.prependIcons(n,a.getIcon()))},g.prototype.getSubscriber=function(){var t=this,n=this.$subscriber;return n||(n=this.$subscriber=new e.Subscriber,n.attach("changed",function(e){return t.updateDisplay(e)}),n.attach("renamed",function(e,n){var i=p(e.getName()),r=p(n),o=t.$ul.children("li.property#"+r),l=t.value(),u=a.deriveOrd(l.get(e));o.find("label.title").addClass("renamed").text(l.getDisplayName(e)),o.find("span.slotName").text(e.getName()),o.find("a.link").jqmData("ord",u),o.attr("id",i)}),n.attach("removed",function(e){var n=p(e.getName()),i=t.$ul.children("li.property#"+n);i.find("a").removeClass("link expandable"),i.find("label.title").addClass("removed").append(" (removed)")}),n.attach("added",function(n){var i=t.value();t.makeListItem(i,n).then(function(e){return t.$ul.append(e).listview("refresh")}).catch(e.error)}),n)},g}),define("mobile/util/mobile/views/PageView",["baja!","bajaux/Widget","jquery","jquerymobile","Promise","css!mobile/util/mobile/views/PageView"],function(e,t,n,i,r){"use strict";var o=function(n){t.call(this,"mobile","PageView"),n=e.objectify(n,"contentViewConstructor"),this.contentViewConstructor=n.contentViewConstructor,this.$title=n.title,this.$ignoreProfileClasses=""};return o.prototype=Object.create(t.prototype),o.prototype.constructor=o,o.prototype.ignoreProfileClasses=function(e){this.$ignoreProfileClasses=e||""},o.prototype.createPage=function(){var e=n('<div class="ux-fullscreen-support" data-role="page" data-theme="c" />'),t=n('<div data-role="header" data-position="fixed" data-tap-toggle="false" data-theme="a" />').appendTo(e),i=n('<a href="#" class="profileHeader profileHeaderBack" data-rel="back" data-icon="arrow-l" data-iconpos="notext"></a>').appendTo(t),r=n('<h1 class="profileHeader viewName"/>').appendTo(t);return n('<div data-role="content" class="ux-root ux-fullscreen"/>').appendTo(e),i.removeClass(this.$ignoreProfileClasses),r.removeClass(this.$ignoreProfileClasses),e},o.prototype.toDisplayName=function(){return r.resolve(this.$title||this.contentView&&this.contentView.toDisplayName()||void 0)},o.prototype.getPage=function(){return this.jq()},o.prototype.getHeaderDiv=function(){return this.jq().children(":jqmData(role=header)")},o.prototype.getContentDiv=function(){return this.jq().children(":jqmData(role=content)")},o.prototype.getFooterDiv=function(){return this.jq().children(":jqmData(role=footer)")},o.prototype.getViewQuery=function(){
return this.viewQuery},o.prototype.instantiateContentView=function(e){var t=this.contentViewConstructor;if(t)return new t;throw new Error("instantiateContentView not implemented")},o.prototype.isModified=function(){var e=this.contentView;return e&&e.isModified()},o.prototype.doInitialize=function(e){var t,n=this;if("page"!==e.jqmData("role"))throw new Error("PageView requires a JQM page (data-role='page')");t=e.data("pageData"),n.viewQuery=t&&t.viewQuery,n.pageId=e.attr("id")},o.prototype.doLoad=function(e){var t=this,n=t.contentView;return r.resolve(n&&n.destroy()).then(function(){n=t.contentView=t.instantiateContentView(e);var i=t.getPage().data("ord");return r.all([i?n.resolve(i):r.resolve(e),n.initialize(t.getContentDiv())])}).then(function(t){var i=t[0];return i.getType().is(e.getType())||(i=e),n.load(i)}).then(function(){return n.toDisplayName()}).then(function(e){t.getHeaderDiv().find("h1").text(e)})},o.prototype.destroy=function(){var e=this,n=e.contentView,i=arguments;return r.resolve(n&&n.destroy()).then(function(){return t.prototype.destroy.apply(e,i)})},o.prototype.save=function(e){var t=this;return t.contentView.save(e).then(function(e){return r.resolve(t.setModified(!1)).then(function(){return e})})},o.prototype.getCommandGroup=function(){return this.contentView.getCommandGroup()},o.prototype.doLayout=function(){return r.resolve(this.contentView&&this.contentView.layout())},o}),define("mobile/util/views/views",["baja!","lex!mobile"],function(e,t){"use strict";function n(t){if(t instanceof e.Complex)return t.getDisplayName()||t.getName()||i.get("propsheet.station")}var i=t[0];return{getComponentName:n}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};define("mobile/util/nav",["baja!","bajaux/Widget","Promise","underscore","mobile/util/views/views","mobile/util/ord","mobile/util/mobile/mobile"],function(e,t,n,i,r,o,a){"use strict";function l(n){return n instanceof d?n:n instanceof e.Ord||"string"==typeof n?new c(n):n instanceof t?new f(n):n instanceof e.Complex?new p(n):n&&"object"===(void 0===n?"undefined":_typeof(n))?new m(n):void 0}function u(e,t){return e?o.equivalent(e.getNavOrd(),t)?e:i.find(e.getNavChildren(),function(e){return u(e,t)}):null}var s=r.getComponentName,d=function(e){this.$navChildren=[],this.$value=e};d.prototype.getNavOrd=function(){return this.$navOrd},d.prototype.setNavOrd=function(e){this.$navOrd=e},d.prototype.getNavDescription=function(){return this.$navDescription},d.prototype.setNavDescription=function(e){this.$navDescription=e},d.prototype.getNavIcon=function(){return this.$navIcon},d.prototype.setNavIcon=function(e){this.$navIcon=e},d.prototype.getNavChildren=function(){return this.$navChildren},d.prototype.setNavChildren=function(e){this.$navChildren=e},d.prototype.getNavParent=function(){return this.$navParent},d.prototype.setNavParent=function(e){this.$navParent=e},d.prototype.getValue=function(){return this.$value},d.prototype.setValue=function(e){this.$value=e},d.prototype.toString=function(){return String(this.$navOrd)},d.prototype.toDisplayName=function(){return n.resolve(this.$navDescription)};var c=function(t){d.apply(this,arguments);var n=e.Ord.make(t),i=String(n),r=i.split("/");this.$navOrd=n,this.$navDescription=r[r.length-1]};c.prototype=Object.create(d.prototype),c.prototype.constructor=c;var p=function(e){d.apply(this,arguments),this.$navDescription=s(e),this.$navOrd=o.deriveOrd(e),this.$navIcon=e.getIcon()};p.prototype=Object.create(d.prototype),p.prototype.constructor=c;var f=function(t){d.apply(this,arguments);var n,i,r=t.value();this.$view=t,r instanceof e.Complex&&(n=o.deriveOrd(r),i=r.getIcon()),!n&&t.pageId&&(n=a.decodePageId(t.pageId),0===n.indexOf("ord?")&&(n=n.substring(4))),this.$navOrd=n,this.$navIcon=i};f.prototype=Object.create(d.prototype),f.prototype.constructor=f,f.prototype.toDisplayName=function(){var e=this,t=e.$displayName;return t?n.resolve(t):e.$view.toDisplayName().then(function(t){return e.$displayName=t,t})};var m=function(e){this.$navOrd=e.$navOrd,this.$navDescription=e.$navDescription,this.$navIcon=e.$navIcon,this.$navChildren=e.$navChildren||[],this.$navParent=e.$navParent,this.$value=e.$value};m.prototype=Object.create(d.prototype);var h=function(){this.$selectedNode=null,this.$nodes=[],this.$changeListeners=[],this.$cutListeners=[]};e.event.mixin(h.prototype),h.prototype.add=function(e){var t=l(e);return this.pruneOtherBranch(t),this.$nodes.push(t),this},h.prototype.cut=function(t){if(!t||this.indexOf(t)<0)return this;t=l(t);var n=this,i=n.next(t);return i&&n.cut(i),n.$nodes.pop(),n.fireHandlers("cut",e.error,this,t),n},h.prototype.getSelectedNode=function(){return this.$selectedNode},h.prototype.getSelectedIndex=function(){return this.indexOf(this.getSelectedNode())},h.prototype.setSelectedNode=function(t){t=l(t),this.indexOf(t)<0&&this.add(t),this.$selectedNode=t,this.fireHandlers("change",e.error,this)},h.prototype.getNodes=function(){return this.$nodes},h.prototype.getOrds=function(){var e=[];return this.each(function(t){e.push(t.getNavOrd())}),e},h.prototype.each=function(t){return e.iterate(this.$nodes,t)},h.prototype.isEmpty=function(){return 0===this.$nodes.length},h.prototype.first=function(){return this.get(0)},h.prototype.last=function(){return this.get(this.size()-1)},h.prototype.indexOf=function(e){if(!e)return-1;e=l(e);var t,n=this,i=e.getNavOrd();return t=n.each(function(e,t){var n=e.getNavOrd();if(o.equivalent(i,n))return t}),void 0===t?-1:t},h.prototype.get=function(e){return this.$nodes[e]},h.prototype.next=function(e){var t=this.indexOf(e);return t>=0?this.get(t+1):void 0},h.prototype.prev=function(e){var t=this.indexOf(e);return t>=0?this.get(t-1):void 0},h.prototype.size=function(){return this.$nodes.length},h.prototype.pruneOtherBranch=function(t){var n=this;n.isEmpty()||n.sameBranch(t,n.last())||e.iterate(1,this.size(),function(e){var i=n.get(e);if(!n.sameBranch(t,i))return n.cut(i)})},h.prototype.sameBranch=function(e,t){var n=decodeURIComponent(String(e.getNavOrd())),i=decodeURIComponent(String(t.getNavOrd()));return n=n.replace(/\/+/g,"/"),i=i.replace(/\/+/g,"/"),0===n.indexOf(i)||0===i.indexOf(n)};var g=function(){h.call(this)};g.prototype=Object.create(h.prototype),g.prototype.constructor=g,g.prototype.add=function(t){var n=this,i=l(t),r=n.$nodes,a={},u=[],s=i.getNavOrd(),d=o.makeOrdHistory(s);return n.pruneOtherBranch(i),e.iterate(0,d.length-1,function(e){if(!r[e]){var t=d[e],n=u.length;r[e]=l(t),a["ord"+n]={ord:t,origIndex:e},u.push(t)}}),u.length&&new e.BatchResolve(u).resolve({ok:function(){var t=this.getTargetObjects();e.iterate(t,function(e,t){var n=a["ord"+t];r[n.origIndex]=l(e)}),n.fireHandlers("change",e.error,this)},fail:e.error}),r[d.length-1]=i,n.fireHandlers("change",e.error,this),this};var v=function(){var t=this;h.call(t),t.$flattenedNavFile=void 0,e.nav.navfile.getRootNode()};return v.prototype=Object.create(h.prototype),v.prototype.constructor=v,v.prototype.makeNavFileOrdHistory=function(t){var n=this,i=o.makeOrdHistory(t),r=i.length,a=[],s=[];return e.iterate(0,r,function(e){var t=i[r-1-e],o=u(n.$flattenedNavFile,t);if(o){for(;o;)a.push(o),o=o.getNavParent();return!0}a.push(l(t))}),r=a.length,e.iterate(0,r,function(e){s.push(a[r-1-e])}),s},v.prototype.add=function(t){var n,i=l(t),r=this,a={},u=[],s=i.getNavOrd(),d=r.makeNavFileOrdHistory(s);return r.pruneOtherBranch(i),n=r.$nodes[d.length-1]||d[d.length-1],n&&n.$fromNavFile&&o.equivalent(n.getNavOrd(),i.getNavOrd())&&(i=n,i.setValue(t)),d[d.length-1]=i,r.$nodes.splice(0,d.length),r.$nodes=d.concat(r.$nodes),e.iterate(0,r.$nodes.length,function(t){var n=r.$nodes[t].getValue(),i=u.length;(n instanceof e.Ord||"string"==typeof n)&&(a["ord"+i]={ord:n,origIndex:t},u.push(n))}),u.length&&new e.BatchResolve(u).resolve({ok:function(){var t=this.getTargetObjects();e.iterate(t,function(e,t){var n=a["ord"+t];r.$nodes[n.origIndex]=l(e)}),r.fireHandlers("change",e.error,this)},fail:e.error}),r.fireHandlers("change",e.error,this),this},v.prototype.sameBranch=function(t,n){var i=this,r=t.getNavOrd(),a=n.getNavOrd(),l=i.makeNavFileOrdHistory(r),u=i.makeNavFileOrdHistory(a),s=l.length,d=u.length;return!e.iterate(0,Math.min(s,d),function(e){if(!o.equivalent(l[e],u[e]))return!0})},{NavModel:h,ComponentSpaceNavModel:g,NavFileNavModel:v}}),define("mobile/util/views/ViewManager",["baja!","bajaux/Widget","Promise"],function(e,t,n){"use strict";var i=function t(){e.callSuper(t,this,arguments),this.$selectedView=void 0};return i=e.subclass(i,t),i.prototype.loadView=function(e){return n.resolve()},i.prototype.getSelectedView=function(){return n.resolve(this.$selectedView)},i.prototype.setSelectedView=function(e){var n=this;return n.getSelectedView().then(function(i){e instanceof t&&e!==i&&(n.$selectedView=e)})},i}),define("mobile/util/mobile/views/PageViewManager",["baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/util/mobile/mobile","mobile/util/ord","mobile/util/nav","mobile/util/mobile/commands","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/views/PageView","mobile/util/views/ViewManager"],function(e,t,n,i,r,o,a,l,u,s,d,c,p,f){"use strict";function m(e,t){var n,i,r,a=e,u=a.$selectedView;return!!(u&&(n=a.navModel.getOrds(),i=o.indexOf(n,l.deriveOrd(u.value())),(r=o.indexOf(n,t))>=0&&i>=0&&r<i))}var h,g=a.encodePageId,v=a.decodePageId,y=t[0];return h=e.subclass(function t(i){e.callSuper(t,this,["mobile","PageViewManager "]);var r=this;r.navModel=i||new u.NavModel,r.navModel.attach("cut",function(e){var t=e.getValue();t instanceof p&&(t.destroy(),n("#"+t.pageId).remove())}),window.onbeforeunload=function(){var e=r.$selectedView;if(e.isModified()){var t;return e.toDisplayName().then(function(e){t=e}),y.get({key:"message.viewModified",args:[t]})}},e.iterate(s.getDefaultCommands(),function(e){r.getCommandGroup().add(e)})},f),h.prototype.doResolveOrd=function(t){return e.Ord.make(t).get({lease:!0})},h.prototype.createPagesHandlers=function(){function t(t){var n,i=a.spinnerTicket(1e3,5e3),r=t.pageData,o=r.ord;d.doResolveOrd(o).then(function(e){return n=e,d.instantiateView(n,r)}).then(function(e){var i=e.createPage();i.jqmData("view",e),i.jqmData("value",n),i.jqmData("ord",o),t.ok(i)}).catch(e.error).finally(function(){i.hide()})}function n(e){return"/ord/"+(e.ord||"station:|slot")}function i(t){var n,i,r=decodeURIComponent(t.pathname+t.search).replace("&ui-state=dialog","");return 0!==r.indexOf("/ord?")&&0!==r.indexOf("/ord/")?{ord:"station:|slot:"}:(n=r.substring(5),i=e.Ord.make(n).parse().get("view"),{ord:n,viewQuery:i})}function r(t){function n(t){d.addView(r,i,o,a).catch(e.error),i.off("pagelayout",n)}var i=t.page,r=i.jqmData("view"),o=i.jqmData("value"),a=i.jqmData("ord");i.on("pagelayout",n)}function o(e){var t=e.page,n=t.jqmData("view"),i=n.value(),r=i&&i.getType();r&&n.$layoutDone&&r.isComponent()&&r.is("baja:VirtualComponent")&&d.refresh(n),n.$layoutDone=!0}function l(t){var n=t.page,i=n.jqmData("view");i&&i.pageId&&(d.setSelectedView(i).catch(e.error),i.layout())}function u(e){var t,n=d.selectedView;n&&n.isModified()&&(t=v(e.nextPage.attr("id")),d.confirmAbandonChanges(t),e.event.preventDefault())}function s(e){return e.commands}var d=this;return{createPage:t,encodeUrl:n,decodeUrl:i,pagelayout:o,pageshow:l,pagecreate:r,pagebeforechange:u,getCommands:s}},h.prototype.registerPages=function(e){c.register(e||function(e){return e.match(/^ord/)},this.createPagesHandlers())},h.prototype.initializeView=function(e,t,n,i){var r=this;return e.initialize(t).then(function(){return e.load(n)}).then(function(){return r.armHandlers(e),r.attachSubscriberEvents(e),e})},h.prototype.instantiateView=function(e,t){return r.reject("instantiateView not implemented")},h.prototype.addView=function(e,t,n,i){var r=this;return r.initializeView(e,t,n,i).then(function(e){return r.navModel.add(e),r.setSelectedView(e).then(function(){return e})})},h.prototype.armHandlers=function(e){var t=this,i=e.jq();i.on("click","a.link",function(){t.linkToOrd(n(this).jqmData("ord"))}),i.on("click","a.commandsButton",function(){t.showCommands(e)})},h.prototype.showCommands=function(e){var t=e.getCommandGroup(),n=this.getCommandGroup(),i=t.merge(n,{mergeCommands:!1}).flatten({recurse:!0});s.showCommandsDialog(i)},h.prototype.attachSubscriberEvents=function(e){var t=this,i=t.navModel,r=e.contentView.getSubscriber&&e.contentView.getSubscriber();r&&(r.attach("renamed",function(t,i,r){var o=g(t.getName()),a=e.pageId+"_2F"+o,l=g(i),u=e.pageId+"_2F"+l;n("#"+u).attr("id",a)}),r.attach("unmount",function(){var n,r=i.prev(e),o=i.indexOf(r),a=i.indexOf(t.selectedView);a>o?(n=y.get({key:"propsheet.message.unmounted",def:'Component "{0}" has been unmounted.',args:[e.getDisplayName()]}),d.ok({content:n,ok:function(n){for(;r&&!r.getNavOrd();)r=i.prev(r),e=i.prev(e);var o=l.deriveOrd(r.getValue().value());o&&"null"!==o&&t.linkToOrdInternal(o),i.cut(e),n.ok()}})):i.cut(e)}))},h.prototype.confirmAbandonChanges=function(e){var t=this,n=this.$selectedView;return new r(function(i,r){n.isModified()?n.toDisplayName().then(function(o){return d.confirmAbandonChanges({yes:function(e){var o=this;n.save().then(function(){t.refresh(n).then(function(){i(),e.ok()},function(t){r(t),e.fail(t)})},function(t){o.redirect(v(n.pageId)),r(t),e.fail(t)})},no:function(e){n.setModified(!1),t.refresh(n).then(function(){i(),e.ok()},function(t){r(t),e.fail(t)})},viewName:o,redirect:e})}):i()})},h.prototype.save=function(e){return e.save()},h.prototype.saveSelected=function(){var e=this;return e.getSelectedView().then(function(t){return e.save(t)})},h.prototype.setSelectedView=function(t){var i=this;return e.callSuper("setSelectedView",h,this,[t]).then(function(){return t.toDisplayName()}).then(function(e){var r;document.title=e,r=n("#"+t.pageId.replace(/(:|\.)/g,"\\$1")),r.children(":jqmData(role=header)").children("h1.viewName").text(e),i.currentPage=r,i.navModel.setSelectedNode(t)})},h.prototype.refresh=function(e){var t=this;return e.load(e.value()).then(function(){t.attachSubscriberEvents(e)})},h.prototype.refreshSelected=function(){var e=this;return e.getSelectedView().then(function(t){return t.isModified()?e.confirmAbandonChanges(void 0):e.refresh(t)})},h.prototype.linkToOrd=function(e,t){function n(){return a.linkToOrd(e,{viewQuery:t,reverse:m(i,e)})}var i=this;return i.getSelectedView().then(function(e){return e.isModified()?i.confirmAbandonChanges(n):n()})},h.prototype.linkToOrdInternal=function(t,n){n=e.objectify(n),n.reverse=m(this,t),a.linkToOrdInternal(t,n)},h.prototype.linkToOrdExternal=function(e,t){a.linkToOrdExternal(e,t)},h.prototype.layout=function(){return this.getSelectedView().then(function(e){if(e)return e.layout()})},h}),define("mobile/fieldeditors/BaseFieldEditor",["baja!","bajaux/Widget","jquery","Promise","underscore","bajaux/events","bajaux/mixin/batchSaveMixin","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,o,a,l){"use strict";function u(e){return e.is('input[type="checkbox"]')||e.is('input[type="radio"]')}function s(t,n){e.iterate(n,function(e){t.addClass(String(e.getTypeSpec()).replace(":","-"))},function(e){return e.getSuperType()})}function d(t,n){var i=e.$(n).decodeFromString(t),r=m[n.toString()];return i.getDataTypeSymbol=function(){return r},i}function c(e,t){var n=e.getType&&e.getType();return!(!n||!n.isComponent())&&(!e.editedSlots&&e!==t)}var p=l.doRequire,f=a.COMMIT_READY,m={"baja.Boolean":"b","baja:Integer":"i","baja:Long":"l","baja:Float":"f","baja:Double":"d","baja:String":"s","baja:DynamicEnum":"e","baja:EnumRange":"E","baja:AbsTime":"a","baja:RelTime":"r","baja:TimeZone":"z","baja:Unit":"u"},h=r.once(function(){return p("mobile/fieldeditors/fieldeditors")}),g=function(n,i,r,o){if(t.call(this,"mobile","BaseFieldEditor"),void 0===n||null===n)return this;o=e.objectify(o),n.getType().isComplex()&&!n.getType().isComponent()&&(n=n.newCopy()),this.$value=n,this.container=i||n.getParent&&n.getParent(),this.slot=r||n.getName&&n.getName(),this.name=String(this.slot),this.params=o,this.facets=o.facets||e.Facets.DEFAULT,this.label=o.label||i&&i.getDisplayName&&r&&i.getDisplayName(r)||n.getName&&n.getName()||r&&String(r),this.parent=o.parent,this.$enabled=!o.readonly,this.$kids=[],this.postCreate(),a(this)};return g.prototype=Object.create(t.prototype),g.prototype.constructor=g,g.prototype.setModified=function(i,r){if(!this.isLoading()){t.prototype.setModified.apply(this,[i]),r=e.objectify(r);var o=this,a=o.parent,l=o.jq();i&&(a&&a.setModified(!0,n.extend({silent:!0},r)),l&&!r.silent&&l.trigger("modified.view",[o,r]))}},g.prototype.postCreate=function(){},g.prototype.doEnabled=function(e){var t=this.jq(),n=t&&t.find("select,input,textarea");n&&(e?n.removeAttr("disabled"):n.attr("disabled","disabled"))},g.$detectChangeEvent=function(){var e,t=n(this),i=t.closest("div.editor"),r=i.data("editor"),o=t.data("oldValue");e=u(t)?t.is(":checked"):t.val(),r.isLoading()||void 0===o||o===e||r.setModified(!0,{oldValue:o,newValue:e,element:t}),t.data("oldValue",e)},g.prototype.buildAndLoad=function(e){var t=this;return t.initialize(e).then(function(){return t.load(t.value())})},g.prototype.load=function(e){var i=this;return t.prototype.load.apply(i,arguments).then(function(e){var t=i.jq();return null!==e&&void 0!==e&&s(t,e.getType()),t.find("input,select,textarea").each(function(){var e=n(this);u(e)?e.data("oldValue",e.is(":checked")):e.data("oldValue",e.val())}),e})},g.prototype.initialize=function(e){return e=n('<div class="editor ui-field-contain"/>').data("editor",this).appendTo(e),e.on("change keyup","input,select,textarea",g.$detectChangeEvent),t.prototype.initialize.apply(this,[e])},g.prototype.read=function(){var n=this,i=n.value(),r=e.hasType(i)&&i.getType();return t.prototype.read.apply(n,arguments).then(function(e){return r&&r.is("baja:Simple")&&!r.is("baja:String")&&e.getType().is("baja:String")?d(e,r):e})},g.prototype.save=function(e){var t,n,i=this;return i.validate().then(function(r){if(t=r,n=r.getType&&r.getType(),c(t,i.value()))throw new Error("Component editors must support edit-by-ref semantics");return i.doSave(t,e)}).then(function(){var r=i.container,o=i.slot,a=e&&e.batch,l=e&&e.progressCallback;if(n&&!n.isComponent()&&r&&o){var u=r.set({slot:o,value:t,batch:a});return l&&l(f),u}return t}).then(function(){i.trigger(o.SAVE_EVENT),i.setModified(!1),i.$value=t})},g.prototype.doSave=function(t,n){var r=[],o=this.value();if(o.getType().isSimple())return t;if(t instanceof e.Component&&!t.editedSlots)throw new Error("provided raw instance of Component (type "+t.getType()+") to defaultDoSave - does your field editor use niagara.fieldEditors.toSaveDataComponent()?");var a=new e.comm.Batch;return e.iterate(t.editedSlots||t,function(e,t){r.push(o.set({slot:t,value:e.newCopy(!0),batch:a}))}),a.commit(),i.all(r).then(function(){return o})},g.prototype.makeChildFor=function(e){var t=this,n=t.$kids;return e.element=e.element||t.jq(),void 0===e.readonly&&(e.readonly=!t.isEnabled()),h().then(function(t){return t.makeFor(e)}).then(function(e){return n.push(e),e.parent=t,e})},g}),define("mobile/fieldeditors/fieldeditors.composite",["baja!","jquery","Promise","underscore","mobile/util/slot","mobile/fieldeditors/BaseFieldEditor","mobile/fieldeditors/fieldeditors"],function(e,t,n,i,r,o,a){"use strict";function l(e){var t={};return e.getSlots().properties().each(function(e){r.isEditable(e)&&(t[String(e)]="default")}),t}function u(i){return function(r,o){var u=this,s=u.value(),d=[],c=[];return e.iterate(i||l(s),function(e,n){var i=t('<div class="subEditor"/>').appendTo(r),l=s.getSlot(n),p=s.getDisplayName(l);d.push(u.makeChildFor({key:e.key,value:e.defaultValue||s.get(n),slot:l,container:s,facets:u.facets,autoInitialize:!1}).then(function(e){var t=a.toLabeledEditorContainer(p,i);return u.subEditorMap[l]=e,c.push(e.initialize(t,o)),e}))}),n.all(d).then(function(){return n.all(c)})}}function s(t){return function(i,r){var o=this,a=[],u=o.subEditorMap;return null===i||void 0===i?n.resolve(i):(e.iterate(t||l(i),function(e,t){var n=u[t],o=e.defaultValue||i.get(t);a.push(n.load(o,r))}),n.all(a))}}function d(t){return function(){var i=this.subEditorMap,r=[],o=this.value(),u=a.toSaveDataComponent(o);return e.iterate(t||l(o),function(e,t){var n=i[t];r.push(n.read().then(function(e){return u.set({slot:t,value:e})}))}),n.all(r).then(function(){return u})}}function c(t){return function(n){var i=this.subEditorMap,r=this.value();e.iterate(t||l(r),function(e,t){i[t].setEnabled(n)})}}function p(t){return function(){var i=[],r=this.subEditorMap,o=this.value();return e.iterate(t||l(o),function(e,t){var n=r[t];i.push(n.validate())}),n.all(i)}}var f={};return f.makeComposite=function(t,n,i){t=t||[],e.strictArg(t,Array);var r;return t.length&&(r={},e.iterate(t,function(e){"string"==typeof e?r[e]={key:"default"}:r[e.slot]={key:e.key||"default",defaultValue:e.defaultValue}})),a.defineEditor(n||o,{doInitialize:u(r),doLoad:s(r),doRead:d(r),doEnabled:c(r),validate:p(r),postCreate:function(){this.subEditorMap={},i&&i.validate&&this.validators().add(i.validate)}})},f.allSlots=function(){var e=f.makeComposite(),t=e.prototype.doInitialize;return e.prototype.doInitialize=function(e){e.addClass("allSlots"),t.call(this,e)},e},f}),define("mobile/fieldeditors/MobileFieldEditor",["baja!","jquery","jquerymobile","mobile/fieldeditors/BaseFieldEditor"],function(e,t,n,i){"use strict";var r=e.subclass(function(e,t,n,r){i.call(this,e,t,n,r)},i);return r.prototype.refreshWidgets=function(){var e=this.jq(),t=e.find("select"),n=e.find("input"),i=t.filter(".ui-slider-switch"),r=t.filter(".ui-select select"),o=n.filter(".ui-checkbox input"),a=n.filter(".ui-input-datebox input");i.length&&i.slider("refresh"),r.length&&r.selectmenu("refresh"),o.length&&o.checkboxradio("refresh"),a.length&&a.datebox("refresh"),e.removeClass("ui-br")},r.prototype.doEnabled=function(e){var t=this,n=this.jq();n&&t.updateReadonlyStatus(n)},r.prototype.updateReadonlyStatus=function(e){var t=this.isEnabled(),n=e.find("select"),i=e.find("input"),r=t?"enable":"disable",o=e.find("textarea"),a=n.filter(":jqmData(role=slider)"),l=n.filter(":jqmData(role!=slider)"),u=i.filter('[type="checkbox"]'),s=i.filter(':jqmData(role="datebox")'),d=i.filter('[type="text"]');a.length&&a.slider(r),l.length&&l.selectmenu(r),u.length&&u.checkboxradio(r),s.length&&s.datebox(r),d.length&&d.textinput(r),o.length&&o.textinput(r)},r.prototype.initialize=function(e){var t=this;return i.prototype.initialize.call(this,e).then(function(){e.enhanceWithin(),t.updateReadonlyStatus(e)})},r.prototype.load=function(e){var t=this;return i.prototype.load.call(t,e).then(function(){t.refreshWidgets()})},r});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/AbsTimeEditor",["baja!","bajaux/events","jquery","Promise","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n,i,r){"use strict";var o=t.MODIFY_EVENT,a=function(){r.apply(this,arguments)};return a.prototype=Object.create(r.prototype),a.prototype.constructor=a,a.prototype.doLoad=function(e){var t=this,n=t.jq(),r=e.getDate(),a=e.getTime();return n.empty(),t.$offset=e.$offset||0,i.join(t.makeChildFor({value:r,element:n}),t.makeChildFor({value:a,element:n})).spread(function(e,n){function i(){return t.setModified(!0),!1}t.$dateEditor=e,t.$timeEditor=n,e.jq().on(o,i),n.jq().on(o,i)})},a.prototype.doRead=function(){var t=this.$offset;return i.all([this.$dateEditor.read(),this.$timeEditor.read()]).then(function(n){var i=_slicedToArray(n,2),r=i[0],o=i[1];return e.AbsTime.make({date:r,time:o,offset:t})})},a.prototype.doEnabled=function(e){var t=this;t.$dateEditor&&t.$dateEditor.doEnabled(e),t.$timeEditor&&t.$timeEditor.doEnabled(e)},a});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/feUtils",["baja!","lex!mobile","jquery","Promise","mobile/util/slot","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,o){"use strict";function a(e){var t,n,i="",r="",o=0;for(n=0;n<e.length;n++)switch(t=e.charAt(n)){case"Y":case"M":case"D":case"W":case"w":case"z":case"s":i="";break;case"h":case"H":case"m":case"a":i.length&&(r+=i,i=""),r+=t,o++;break;default:o>0&&(i+=t)}return r}function l(){var e,t,n,i=f.getBajaTimeFormat(),r=[],o="",a=[],l=12;for(e=0;e<i.length;e++)n=i.charAt(e),r.length>0&&r[r.length-1].ch===n?r[r.length-1].count++:r.push({ch:n,count:1});for(e=0;e<r.length;e++)switch(r[e].ch){case"Y":o+=r[e].count<=2?"%y":"%Y";break;case"M":switch(r[e].count){case 1:o+="%-m";break;case 2:o+="%m";break;case 3:o+="%b";break;case 4:default:o+="%B"}break;case"D":o+=1===r[e].count?"%-d":"%d";break;case"h":o+=1===r[e].count?"%-l":"%l",a.push("h"),l=12;break;case"H":o+=1===r[e].count?"%-k":"%k",a.push("h"),l=24;break;case"m":o+=1===r[e].count?"%-M":"%M",a.push("i");break;case"s":o+="ss";break;case"a":o+="%p",a.push("a");break;case"z":case"Z":break;case"W":o+=1===r[e].count?"%a":"%A";break;case"w":o+="%W";break;case"%":for(t=0;t<r[e].count;t++)o+="%%";break;default:for(t=0;t<r[e].count;t++)o+=r[e].ch}return{timeOutput:o,timeFieldOrder:a,timeFormat:l}}var u=o.doRequire,s=_slicedToArray(t,1),d=s[0],c=void 0,p=void 0,f={};return f.dateboxArmHandlers=function(e){e.find("input:jqmData(role=datebox)").on("keyup",function(){var e=n(this),t=e.val();e.trigger("datebox",{method:"set",value:t})})},f.getBajaTimeFormat=function(){return c||(c=e.getTimeFormatPattern()||"HH:mm",c=a(c),c.match(/a\S+/g)&&(c=c.replace("a","a "))),c},f.getDateboxDefaultOptions=function(){var e={centerHoriz:!0,centerVert:!0,daysOfWeek:d.get({key:"propsheet.datebox.daysOfWeek",def:"Sunday Monday Tuesday Wednesday Thursday Friday Saturday"}).split(" "),daysOfWeekShort:d.get({key:"propsheet.datebox.daysOfWeekShort",def:"Su Mo Tu We Th Fr Sa"}).split(" "),monthsOfYear:d.get({key:"propsheet.datebox.monthsOfYear",def:"January February March April May June July August September October November December"}).split(" "),monthsOfYearShort:d.get({key:"propsheet.datebox.monthsOfYearShort",def:"Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec"}).split(" "),setDateButtonLabel:d.get({key:"propsheet.datebox.setDateButtonLabel",def:"Set Date"})};return p=p||l(),e.overrideTimeOutput=p.timeOutput,e.overrideTimeFieldOrder=p.timeFieldOrder,e.overrideTimeFormat=p.timeFormat,e},f.getEnumRangeDisplay=function(t,n){return i.try(function(){var i=n.getOptions().get("lexicon"),r=n.get(t),o=r.getTag();return i?u(["lex!"+i]).spread(function(e){return e.get({key:o,def:o})}):e.SlotPath.unescape(r.toString())}).catch(function(){return String(t)})},f.getFacets=function(t){var n=t.facets,i=t.container;return n&&n!==e.Facets.NULL?n:i?r.getFacets(i,t.slot):e.Facets.DEFAULT},f.minMaxCheck=function(e,t,n,r){return new i(function(i,o){var a;void 0!==t&&null!==t&&r<t||void 0!==n&&null!==n&&r>n?(a='Cannot save property "'+e.slot+'". ',a+=r<t?r+" < "+t:r+" > "+n,a+=" ["+t+" - "+n+"]",o(new Error(a))):i()})},f});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/BooleanEditor",["baja!","lex!baja","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,o){"use strict";function a(t){var n,r,o=t.facets;return o&&o.get("trueText")&&o.get("falseText")||(o=l(t)),o&&(n=o.get("trueText"),r=o.get("falseText")),n&&r||(n=s.get("true"),r=s.get("false")),i.join(e.Format.format({pattern:n}),e.Format.format({pattern:r}))}var l=o.getFacets,u=_slicedToArray(t,1),s=u[0],d=function(){r.apply(this,arguments)};return d.prototype=Object.create(r.prototype),d.prototype.constructor=d,d.prototype.doInitialize=function(e){var t=this;return a(t).spread(function(i,r){var o=t.name,a=n('<select data-role="slider" />').attr("name",o),l=n("<option/>").val("true").text(i),u=n("<option/>").val("false").text(r);a.append(u).append(l).appendTo(e)})},d.prototype.doLoad=function(e){this.jq().find("select").val(e?"true":"false")},d.prototype.doRead=function(){return"true"===this.jq().find("select").val()},d}),define("mobile/fieldeditors/mobile/BooleanCheckboxEditor",["baja!","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/util/mobile/mobile"],function(e,t,n,i){"use strict";var r=i.encodePageId,o=function(){n.apply(this,arguments)};return o.prototype=Object.create(n.prototype),o.prototype.constructor=o,o.prototype.doInitialize=function(e){var n=this.label,i=r(n),o=t('<fieldset data-role="controlgroup"/>'),a=t("<label/>").attr("for",i).text(n),l=t('<input type="checkbox" data-theme="b"/>').attr("name",i).attr("id",i);o.append(l).append(a),e.append(o)},o.prototype.doLoad=function(e){this.jq().find("input").attr("checked",e).checkboxradio("refresh")},o.prototype.doRead=function(){return this.jq().find("input").is(":checked")},o}),define("mobile/fieldeditors/mobile/DateEditor",["baja!","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i){"use strict";function r(t){var n=t.jq().find("input[name$=date]"),i=n.datebox("getTheDate");return e.Date.make({year:i.getFullYear(),month:i.getMonth(),day:i.getDate()})}function o(e){var n=t('<input type="date" data-role="datebox" name="'+e+'_date" />'),i=l();return i.mode="calbox",i.useDialogForceFalse=!0,i.calHighToday=!1,n.attr("data-options",JSON.stringify(i)),n}var a=i.dateboxArmHandlers,l=i.getDateboxDefaultOptions,u=function(){n.apply(this,arguments)};return u.prototype=Object.create(n.prototype),u.prototype.constructor=u,u.prototype.doInitialize=function(e){e.append(o(this.name)),a(e)},u.prototype.doLoad=function(e){var t=this.jq().find("input:jqmData(role=datebox)");return e.toDateString({textPattern:"YYYY-MM-DD"}).then(function(e){t.trigger("datebox",{method:"set",value:e})})},u.prototype.doRead=function(){return r(this)},u});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/EnumEditor",["baja!","lex!mobile","jquery","Promise","underscore","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,o,a){"use strict";var l=a.getEnumRangeDisplay,u=_slicedToArray(t,1),s=u[0],d=function(){o.apply(this,arguments)};return d.prototype=Object.create(o.prototype),d.prototype.constructor=d,d.prototype.doInitialize=function(e){var t=n('<select data-theme="a" />').attr("name",this.name);n("<option/>").attr("value","n/a").val(s.get("loading")).appendTo(t),t.appendTo(e)},d.prototype.doLoad=function(t){
var o=this.jq().find("select").empty(),a=this.facets.get("range")||t.getRange(),u=a.getOrdinals();this.range=a;var s=r.map(u,function(e){return l(e,a)});return i.all(s).then(function(i){var a=r.map(i,function(t,i){return n("<option/>").val(u[i]).text(e.SlotPath.unescape(t))});o.html(a),o.val(String(t.getOrdinal())).selectmenu("refresh")})},d}),define("mobile/fieldeditors/mobile/DynamicEnumEditor",["baja!","mobile/fieldeditors/mobile/EnumEditor"],function(e,t){"use strict";var n=function(){t.apply(this,arguments)};return n.prototype=Object.create(t.prototype),n.prototype.constructor=n,n.prototype.doRead=function(){var t=this.jq().find("select"),n=this.range;return e.DynamicEnum.make({ordinal:Number(t.val()),range:n})},n}),define("mobile/fieldeditors/mobile/FacetsEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/util/mobile/dialogs"],function(e,t,n,i,r){"use strict";function o(e,t,n){var i=e.jq(),r=e.facetValues[n];void 0!==r&&e.makeChildFor({value:r,element:t.empty()}).then(function(t){delete e.currentEditor,delete e.currentKey,i.trigger("create"),i.trigger("updatelayout"),e.currentEditor=t,e.currentKey=n})}function a(e,t){return t&&t.isModified()?t.read().then(function(t){e.facetValues[e.currentKey]=t}):n.resolve()}var l=function(){i.apply(this,arguments),this.currentEditor=null,this.currentKey=null};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var n=this,i=t('<select data-role="selectmenu" data-theme="a"><option value="-1">loading</option></select>'),l=t('<div class="subEditor"/>');i.appendTo(e),l.appendTo(e),e.undelegate(),i.on("change",function(){var e=t(this).val();a(n,n.currentEditor).then(function(){o(n,l,e),n.$lastKey=e},function(e){r.error(e),i.val(n.$lastKey)})})},l.prototype.doLoad=function(n){var i=this,r=i.jq().find("select"),o=i.facetValues={},a=n,l=null;r.empty(),e.iterate(a.getKeys(),function(e){var n=t("<option/>").attr("value",e).text(e);r.append(n),o[e]=a.get(e),l=l||e}),r.val(l).trigger("change"),i.$lastKey=l},l.prototype.doRead=function(){var t=this;return a(t,t.currentEditor).then(function(){var n=[],i=[];return e.iterate(t.facetValues,function(e,t){n.push(t),i.push(e)}),e.Facets.make(n,i)})},l}),define("mobile/fieldeditors/mobile/FrozenEnumEditor",["mobile/fieldeditors/mobile/EnumEditor"],function(e){"use strict";var t=function(){e.apply(this,arguments)};return t.prototype=Object.create(e.prototype),t.prototype.constructor=t,t.prototype.doRead=function(){var e=this.jq().find("select");return this.value().get(Number(e.val()))},t});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/NonEditableEditor",["lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n){"use strict";var i=_slicedToArray(e,1),r=i[0],o=function(){n.apply(this,arguments)};return o.prototype=Object.create(n.prototype),o.prototype.constructor=o,o.prototype.doInitialize=function(e){e.append('<span class="nonEditable" />')},o.prototype.doLoad=function(e){var t=this.jq().find("span"),n=r.get({key:"propsheet.message.nonEditable",def:"Not Editable In Mobile Property Sheet"});t.text(e.getType()+" "+n)},o}),define("mobile/fieldeditors/mobile/StringEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r){"use strict";var o=r.getFacets,a=r.minMaxCheck,l=function(){var e=this;i.apply(this,arguments),this.validators().add(function(t){var n=o(e);if(n)return a(e,n.get("min"),n.get("max"),t.length)})};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var n,i,r=o(this);r&&r.get("multiLine")?(i=r.get("fieldWidth"),n=t('<textarea cols="40" rows="10"></textarea>'),i&&n.attr("cols",i)):n=t('<input type="text"/>'),n.attr("name",this.name).appendTo(e).textinput()},l.prototype.doLoad=function(t){if(null!==t&&void 0!==t){var n;"function"==typeof t.encodeToString?n=t.encodeToString():(n=JSON.stringify(e.bson.encodeValue(t)),this.setEnabled(!1)),this.jq().find("input,textarea").val(n)}},l.prototype.doRead=function(){return this.jq().find("input,textarea").val()},l}),define("mobile/fieldeditors/mobile/NumericEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/StringEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,o){"use strict";function a(t){var i=c(t),r=i.get("units"),o=i.get("unitConversion");return!r||r.equals(e.Unit.NULL)?n.resolve(null):o?e.UnitDatabase.get().then(function(t){var n=l(o),i=e.$("baja:UnitConversion",n).getTag();return t.convertUnit(i,r)}):n.resolve(r)}function l(t){return e.hasType(t,"baja:Enum")?t.getOrdinal():e.hasType(t,"baja:Number")?t.valueOf():null}function u(t){var n=c(t).get("units");return n&&!n.equals(e.Unit.NULL)?n:null}function s(e){var t=Number(r.prototype.doRead.call(e));return a(e).then(function(n){return n&&!isNaN(t)&&(t=n.convertTo(u(e),t)),t})}function d(t){return e.hasType(t,"baja:Number")}var c=o.getFacets,p=o.minMaxCheck,f=function(){var e=this;i.apply(this,arguments),this.validators().add(function(t){var n=c(e);if(n)return p(e,n.get("min"),n.get("max"),t)})};return f.prototype=Object.create(i.prototype),f.prototype.constructor=f,f.prototype.doInitialize=function(e){var n=t('<div class="numericWrapper"/>'),i=t('<label class="unitsDisplay"/>').appendTo(n),r=t('<span class="inputWrapper"/>').appendTo(n),o=t('<input type="text" data-theme="c"/>').attr("name",this.name).appendTo(r);return a(this).then(function(t){t?(t.getIsPrefix()&&(i.css("order","0"),o.css("text-align","left")),i.text(t.getSymbol()),i.show()):i.hide(),n.appendTo(e)})},f.prototype.doLoad=function(e){var t=this,n=e.valueOf(),i=c(t),o=i&&i.get("precision");return a(t).then(function(e){if(e){var i=u(t);n=i.convertTo(e,n)}return d(n)&&d(o)&&(n=n.toFixed(Math.min(o,20))),r.prototype.doLoad.call(t,n)})},f.prototype.doRead=function(){var t=this.value().getType(),n=r.prototype.doRead.call(this);return s(this).then(function(i){if(t.is("baja:Integer"))switch(n.toLowerCase()){case"min":return e.Integer.MIN_VALUE;case"max":return e.Integer.MAX_VALUE;default:if(isNaN(i))throw new Error(n+" is not a valid Integer value");return e.Integer.make(i)}else if(t.is("baja:Long"))switch(n.toLowerCase()){case"min":return e.Long.MIN_VALUE;case"max":return e.Long.MAX_VALUE;default:if(isNaN(i))throw new Error(n+" is not a valid Long value");return e.Long.make(i)}else if(t.is("baja:Float"))switch(n.toLowerCase()){case"nan":return e.Float.NAN;case"-inf":return e.Float.NEGATIVE_INFINITY;case"+inf":return e.Float.POSITIVE_INFINITY;default:if(isNaN(i))throw new Error(n+" is not a valid Float value");return e.Float.make(i)}else{if(!t.is("baja:Double")){if(isNaN(i))throw new Error(n+" is not a valid numeric value");return i}switch(n.toLowerCase()){case"nan":return e.Double.NaN;case"-inf":return e.Double.NEGATIVE_INFINITY;case"+inf":return e.Double.POSITIVE_INFINITY;default:if(isNaN(i))throw new Error(n+" is not a valid Double value");return e.Double.make(i)}}})},f});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/OrdComponentSelector",["baja!","lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/util/ord"],function(e,t,n,i,r){"use strict";function o(e){if(e=String(e),e.indexOf("slotPathOrd")<0||e.indexOf("displayName")<0)throw"Must select slotPathOrd and displayName"}var a=r.equivalent,l=_slicedToArray(t,1),u=l[0],s=function(){i.apply(this,arguments)};return s.prototype=Object.create(i.prototype),s.prototype.constructor=s,s.prototype.doInitialize=function(e){n('<select data-role="selectmenu" data-theme="a" />').attr("name",this.name).appendTo(e).append(n("<option/>").text(u.get("loading")))},s.prototype.doLoad=function(t){var i=this.jq(),r=i.find("select");r.html(n("<option/>").text(u.get("loading")));try{o(t)}catch(e){i.text(e)}return e.Ord.make(String(t)).get({cursor:{before:function(){r.empty()},each:function(){var e=this.get("slotPathOrd"),i=this.get("displayName"),o=n("<option/>").val(e).text(i);a(t,e)&&o.attr("selected","selected"),o.appendTo(r)},after:function(){r.selectmenu("refresh")},limit:100}})},s.prototype.doRead=function(){return e.Ord.make(this.jq().find("select").val())},s}),define("mobile/util/time",["baja!"],function(e){"use strict";function t(t){return t=(t+l)%l,e.Time.make(t)}function n(n){return n instanceof Date?n.getTime()%l:n instanceof e.Time?n.getTimeOfDayMillis():"number"==typeof n?t(n).getTimeOfDayMillis():void 0}function i(n){return n instanceof Date?n.getTime()%u:n instanceof e.Time?n.getTimeOfDayMillis()%u:"number"==typeof n?t(n).getTimeOfDayMillis()%u:void 0}function r(t){var i=n(t),r=Math.round(i/s)*s;return t instanceof Date?new Date(r):t instanceof e.Time?e.Time.make({relTime:e.RelTime.make(r)}):"number"==typeof t?r:void 0}function o(e){return(e<10?"0":"")+e}function a(e,t,n){return[o(e),o(t),o(n||0)].join(":")}var l=864e5,u=36e5,s=18e5;return{MILLIS_IN_DAY:l,MILLIS_IN_HOUR:u,MILLIS_IN_HALF_HOUR:s,MILLIS_IN_MINUTE:6e4,MILLIS_IN_SECOND:1e3,makeTime:t,millisOfDay:n,millisOfHour:i,roundToHalfHour:r,toTimeString:a,zeroPad:o}});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/RelTimeEditor",["baja!","lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils","mobile/util/time"],function(e,t,n,i,r,o){"use strict";function a(t){var n,i=l(t),r=i.get("max"),o=i.get("min"),a=null,u=null;return r&&r.getType().is("baja:RelTime")&&(a=r.getMillis()),o&&o.getType().is("baja:RelTime")&&(u=o.getMillis()),null!==u&&null!==a&&u>a&&(u=null,a=null),null===a&&null===u||(n="["+(u===e.Long.MIN_VALUE?"-inf":e.RelTime.make(u).encodeToString()+"ms")+" - "+(a===e.Long.MAX_VALUE?"+inf":e.RelTime.make(a).encodeToString()+"ms")+"]"),{min:u,max:a,str:n,normalize:function(e){return null!==a&&e>a?a:null!==u&&e<u?u:e}}}var l=r.getFacets,u=r.minMaxCheck,s=o.toTimeString,d=_slicedToArray(t,1),c=d[0],p=function(){i.apply(this,arguments),this.validators().add(function(e){var t=a(this);return u.call(this,t.min,t.max,e.getMillis())})};return p.prototype=Object.create(i.prototype),p.prototype.constructor=p,p.prototype.doInitialize=function(e){var t,i,r=this,o=r.name,l=r.params,u=n('<input type="text" data-role="datebox" />').attr("name",o),s=a(r);t={mode:"durationbox",useDialogForceFalse:!0,lockInput:!1,defaultValue:new Date,durationLabel:c.get({key:"propsheet.datebox.durationLabel",def:"Days Hours Minutes Seconds"}).split(" "),setDurationButtonLabel:c.get({key:"propsheet.datebox.setDurationButtonLabel",def:"Set Duration"}),durationFormat:l.durationFormat,durationOrder:l.durationOrder},u.attr("data-options",JSON.stringify(t)),u.appendTo(e),e.on("datebox",'input:jqmData(role="datebox")',function(e,t){function r(){var e=n(".ui-datebox-container .ui-datebox-controls"),t=e.prev();t.hasClass("relTimeRange")||(t=n('<div class="relTimeRange"></div>').insertBefore(e)),t.text(s.str)}var o=n(this);"open"===t.method&&r(),"open"===t.method||"offset"===t.method?i=function(){var e,t=o.datebox("getTheDate"),n=new Date(o.datebox("getOption","defaultValue")),i=t-n,r=i%1e3,a=i-r+(r?1e3:0);(e=s.normalize(a))!==a&&(o.datebox("setTheDate",new Date(n.getTime()+e)),o.datebox("refresh"))}:"postrefresh"===t.method&&i&&(i(),i=void 0,r())})},p.prototype.doLoad=function(e){if(e){var t=this,n=t.jq(),i=n.find('input:jqmData(role="datebox")'),r=e.getDaysPart(),o=e.getHoursPart(),a=e.getMinutesPart(),l=e.getSecondsPart(),u="";u+=r+" Day"+(r>1?"s":"")+", ",u+=s(o,a,l),i.trigger("datebox",{method:"set",value:u})}},p.prototype.doRead=function(){var t=this.jq().find('input:jqmData(role="datebox")'),n=new Date(t.datebox("getOption","defaultValue")),i=t.datebox("getTheDate"),r=i.getTime()-n.getTime();return r=1e3*Math.ceil(r/1e3),e.RelTime.make(r)},p}),define("mobile/fieldeditors/mobile/DurationSelectRelTimeEditor",["baja!","jquery","underscore","mobile/fieldeditors/mobile/RelTimeEditor","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r){"use strict";var o=r.doRequire,a=[["override.perm",0],["override.min1",6e4],["override.min15",9e5],["override.min30",18e5],["override.hour1",36e5],["override.hour2",72e5],["override.hour3",108e5],["override.custom",-1]],l=function(){i.apply(this,arguments)};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var i=t('<select class="durationChoice" data-theme="a" />'),r=this;return o("lex!control").spread(function(o){function l(e,n){var r=t('<option value="'+n+'"/>');r.text(o.get(e)),r.appendTo(i)}var u=r.facets.get("max");null===u||u.getType().is("baja:RelTime")||(u=null),n.each(a,function(e){var t=e[0],n=e[1];(null===u||-1===n||n>0&&n<=u.getMillis())&&l(t,n)}),e.append(i)})},l.prototype.doLoad=function(e){var t=e?e.getMillis():"-1",n=this.jq().find("select");n.find('option[value="'+t+'"]').length?n.val(String(t)):n.val("-1"),n.trigger("change"),n.selectmenu("refresh")},l.prototype.doRead=function(){var t=this.jq().find("select"),n=Number(t.val());return-1===n?-1:e.RelTime.make(Number(n))},l}),define("mobile/fieldeditors/mobile/OverrideRelTimeEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/DurationSelectRelTimeEditor","mobile/fieldeditors/mobile/RelTimeEditor"],function(e,t,n,i,r,o){"use strict";var a=function(){i.apply(this,arguments)};return a.prototype=Object.create(i.prototype),a.prototype.constructor=a,a.prototype.doInitialize=function(n){function i(i){return null!==i&&(s.facets=e.Facets.make(s.facets,{max:i,min:e.RelTime.make(1e3)}),s.maxOverride=i,u.facets=e.Facets.make(u.facets,{max:i,min:e.RelTime.make(1e3)})),u.initialize(n).then(function(){return s.initialize(n).then(function(){return i&&s.load(i)})}).then(function(){a.$durationSelectEditor=u,a.$relTimeEditor=s,n.on("change","select",function(){var n=t(this).val();"-1"===n?(s.setEnabled(!0),s.load(e.RelTime.make(0))):(s.setEnabled(!1),s.load(e.RelTime.make(Number(n)))),a.setModified(!0)})})}var a=this,l=a.value(),u=new r(e.RelTime.make(0),l,"duration",{parent:a}),s=new o(e.RelTime.make(0),l,"duration",{parent:a}),d=a.facets.get("maxOverrideDuration");return null!==d?i(d):e.Ord.make("station:|slot:/").get({lease:100}).then(function(e){return i(e.get("sysInfo").get("maxOverrideDuration"))})},a.prototype.doLoad=function(e){var t=this,i=t.$durationSelectEditor,r=t.$relTimeEditor,o=r.maxOverride;return delete r.maxOverride,i.load(o||e).then(function(){return i.read()}).then(function(i){return n.join(r.load(o||e),r.setEnabled(!t.isEnabled()||-1===i))})},a.prototype.doRead=function(){return this.$relTimeEditor.read()},a});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/TimeEditor",["baja!","lex!mobile","jquery","jqmDatebox","underscore","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils","mobile/util/time"],function(e,t,n,i,r,o,a,l){"use strict";function u(t,n){var i=t.jq().find("input[name$=time]"),o=i.datebox("getTheDate"),a=0,l=r.indexOf(["hour","minute","second","millisecond"],n||"millisecond");if(l<0)throw new Error("invalid accuracy argument "+n);return l>=0&&(a+=o.getHours()*f),l>=1&&(a+=o.getMinutes()*m),l>=2&&(a+=o.getSeconds()*h),l>=3&&(a+=o.getMilliseconds()),e.Time.make(a)}function s(e){var t=n('<input type="text" data-role="datebox" id="'+e+'_time" name="'+e+'_time"/>'),i=p();return i.mode="timebox",i.useDialogForceFalse=!0,i.lockInput=!1,i.centerHoriz=!0,i.centerVert=!0,i.setTimeButtonLabel=v.get({key:"propsheet.datebox.setTimeButtonLabel",def:"Set Time"}),t.attr("data-options",JSON.stringify(i)),t}var d=a.dateboxArmHandlers,c=a.getBajaTimeFormat,p=a.getDateboxDefaultOptions,f=l.MILLIS_IN_HOUR,m=l.MILLIS_IN_MINUTE,h=l.MILLIS_IN_SECOND,g=_slicedToArray(t,1),v=g[0],y=function(){o.apply(this,arguments)};return y.prototype=Object.create(o.prototype),y.prototype.constructor=y,y.prototype.doInitialize=function(e){e.append(s(this.name)),d(e)},y.prototype.doLoad=function(e){if(null!==e&&void 0!==e){var t=this.jq().find('input:jqmData(role="datebox")');return e.toTimeString({textPattern:c()||"HH:mm"}).then(function(e){t.trigger("datebox",{method:"set",value:e})})}},y.prototype.doRead=function(){return u(this,"minute")},y}),define("mobile/fieldeditors/mobile/UnitEditor",["baja!","jquery","underscore","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n,i){"use strict";function r(){return e.UnitDatabase.get().then(function(e){function t(){return s}function i(e){return n.filter(s,function(e){var t=e.getName(),n=t.match(o);return n&&n[0]})}function r(e){return n.find(s,function(t){return t.getName()===e})}function a(e){var t=i(String(e.getDimension()));return n.find(t,function(t){return n.find(t.getUnits(),function(t){return e.equivalent(t)})})}function l(e){var t=r(e);return t&&t.getUnits()}function u(e,t){function r(t){return t.getSymbol()===e}for(var o=i(t),a=0;a<o.length;a++){var l=n.find(o[a].getUnits(),r);if(l)return l}}var s=e.getQuantities();return{getQuantities:t,getQuantityFromUnit:a,getUnits:l,getUnitFromSymbolAndDimension:u}})}var o=/\(\S*\)/,a=n.once(r),l=function(){i.apply(this,arguments)};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var i=t('<select data-role="selectmenu" data-theme="a" name="quantity" />').append("<option>loading</option>"),r=t('<select data-role="selectmenu" data-theme="a" name="units" />').append("<option>loading</option>");return e.append(i),e.append(r),a().then(function(o){i.html(n.map(o.getQuantities(),function(e){var n=e.getName();return t("<option/>").attr("value",n||"").text(n)})),i.on("change",function(){var e=t(this).find("option:selected").text(),i=o.getUnits(e);r.html(n.map(i,function(e){return t("<option/>").val(e.getUnitName()).text(e.getUnitName()+" ("+e.getSymbol()+")").jqmData("unit",e)})),r.selectmenu("refresh").trigger("updatelayout")}),i.appendTo(e),r.appendTo(e)})},l.prototype.doLoad=function(e){var t=this.jq(),n=t.find("select[name=quantity]"),i=t.find("select[name=units]");return a().then(function(t){var r=t.getQuantityFromUnit(e);r&&(n.val(r.getName()).trigger("change"),i.val(e.getUnitName()).trigger("change"))})},l.prototype.doRead=function(){return this.jq().find("select[name=units]").find("option:selected").jqmData("unit")},l});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/fieldeditors.mobile",["baja!baja:Month,baja:UnitConversion","jqmDatebox","css!mobile/fieldeditors/fieldeditors","baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.composite","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/AbsTimeEditor","mobile/fieldeditors/mobile/BooleanEditor","mobile/fieldeditors/mobile/BooleanCheckboxEditor","mobile/fieldeditors/mobile/DateEditor","mobile/fieldeditors/mobile/DynamicEnumEditor","mobile/fieldeditors/mobile/FacetsEditor","mobile/fieldeditors/mobile/FrozenEnumEditor","mobile/fieldeditors/mobile/NonEditableEditor","mobile/fieldeditors/mobile/NumericEditor","mobile/fieldeditors/mobile/OrdComponentSelector","mobile/fieldeditors/mobile/OverrideRelTimeEditor","mobile/fieldeditors/mobile/RelTimeEditor","mobile/fieldeditors/mobile/StringEditor","mobile/fieldeditors/mobile/TimeEditor","mobile/fieldeditors/mobile/UnitEditor"],function(e,t,n,i,r,o,a,l,u,s,d,c,p,f,m,h,g,v,y,b,j,T,w,x,S,k,D){var E=s.register,O=s.toSaveDataComponent,C=_slicedToArray(r,1),N=C[0],I={};return I=function(){function e(e){var t="nulldefault"+a++,n=o('<fieldset data-role="controlgroup" class="nulldefault"/>'),i=o('<input type="checkbox" data-theme="a" name="nulldefault"/>').attr("id",t).addClass("hidden"),r=o("<label/>").attr("for",t).text(N.get("propsheet.nullDefault"));n.append(i).append(r),e.append(n)}function t(e){return e.find("input[name=nulldefault]").is(":checked")?i.Status.nullStatus:i.Status.ok}function n(e){var t=e.find("input[type=text], textarea"),n=e.find("select");e.find("input[type=checkbox]").is(":checked")?(t.attr("disabled","disabled"),n.filter(':jqmData(role="slider")').slider("disable"),n.filter(':jqmData(role!="slider")').selectmenu("disable")):(t.removeAttr("disabled"),n.filter(':jqmData(role="slider")').slider("enable"),n.filter(':jqmData(role!="slider")').selectmenu("enable"))}function r(r){return function(o,a,u,s){var d=new r(o,a,u,s),c=d.$validators.$validators;return d.doInitialize=function(t){var i=this;return l.resolve(r.prototype.doInitialize.call(i,t)).then(function(){e(t),t.find('input[type="checkbox"]').change(function(){i.isEnabled()&&n(t)})})},i.iterate(c,function(e,t){c[t]=function(t){return e.call(this,t.getValue())}}),d.doEnabled=function(){var e=this;r.prototype.doEnabled.apply(e,arguments),e.isEnabled()&&n(e.jq())},d.doLoad=function(e){var t=e;if(t)return l.resolve(r.prototype.doLoad.call(this,t.getValue())).then(function(){var e=t.getStatus();d.jq().find('input[type="checkbox"]').prop("checked",e.isNull())})},d.doRead=function(){return l.resolve(r.prototype.doRead.call(this)).then(function(e){var n=t(d.jq()),i=d.value(),r=O(i);return r.set({slot:"value",value:e}),r.set({slot:"status",value:n}),r})},d.refreshWidgets=function(){var e=this;r.prototype.refreshWidgets.apply(e,arguments),e.isEnabled()&&n(e.jq())},d}}var a=0;return{wrapWithStatus:r}}(),function(){function e(e){i.iterate(e,function(e,t){E(t,e)})}var t,n,r,o;t={"baja:AbsTime":p,"baja:Boolean":f,"baja:Date":h,"baja:DynamicEnum":g,"baja:FrozenEnum":y,"baja:Number":j,"baja:RelTime":x,"baja:String":S,"baja:Time":k,"baja:Facets":v,"baja:Unit":D},n={"baja:StatusBoolean":I.wrapWithStatus(t["baja:Boolean"]),"baja:StatusEnum":I.wrapWithStatus(t["baja:DynamicEnum"]),"baja:StatusNumeric":I.wrapWithStatus(t["baja:Number"]),"baja:StatusString":I.wrapWithStatus(t["baja:String"])},r={"control:BooleanOverride":d.makeComposite([{slot:"duration",key:"override"},"value"]),"control:EnumOverride":d.makeComposite([{slot:"duration",key:"override"},"value"]),"control:NumericOverride":d.makeComposite([{slot:"duration",key:"override"},"value"]),"control:Override":d.makeComposite([{slot:"duration",key:"override"}]),"control:StringOverride":d.makeComposite([{slot:"duration",key:"override"},"value"]),"baja:AbsTimeRange":d.makeComposite(["startTime","endTime"]),"baja:TimeRange":d.makeComposite(["startTime","endTime"])},o={"baja:EnumRange":b,"baja:Password":b,"baja:TimeZone":b},e(t),e(n),e(r),e(o),E("baja:Boolean",m,"checkbox")}(),function(){E("baja:RelTime",w,"override"),E("baja:Ord",T,"componentSelector")}(),{status:I}}),define("mobile/history/util.mobile.history",["baja!baja:AbsTimeRange,mobile:HistoryServerSideHandler,bql:DynamicTimeRangeType","baja!","lex!mobile","jquery","Promise","mobile/util/ord","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.mobile","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n,i,r,o,a,l,u){function s(e){var t=D.exec(e);if(t)return t[1]}function d(e){var n=k.exec(decodeURI(e)),i=t.AbsTime.DEFAULT.decodeFromString;if(n)return t.$(y,{startTime:i(decodeURIComponent(n[1])),endTime:i(decodeURIComponent(n[2]))})}function c(e){var n,i,r=new Date,o=r.getFullYear(),a=r.getMonth(),l=r.getDate(),u=r.getDay(),s=r.getTime(),d=-6e4*r.getTimezoneOffset();switch(e){case"today":n=new Date(o,a,l),i=new Date(o,a,l+1);break;case"last24Hours":n=new Date(s-g),i=r;break;case"yesterday":n=new Date(o,a,l-1),i=new Date(o,a,l);break;case"weekToDate":n=new Date(o,a,l-u),i=r;break;case"lastWeek":n=new Date(o,a,l-u-7),i=new Date(o,a,l-u);break;case"last7Days":n=new Date(o,a,l-7),i=new Date(o,a,l);break;case"monthToDate":n=new Date(o,a,1),i=r;break;case"lastMonth":n=new Date(o,a-1,1),i=new Date(o,a,1);break;case"yearToDate":n=new Date(o,0,1),i=r;break;case"lastYear":n=new Date(o-1,0,1),i=new Date(o,0,1);break;default:n=r,i=r}return t.$("baja:AbsTimeRange",{startTime:t.AbsTime.make({jsDate:n,offset:d}),endTime:t.AbsTime.make({jsDate:i,offset:d})})}function p(e){var t,n=d(e);return n||((t=s(e))?c(t):void 0)}function f(e,t){var n,i,r,o,a="",l=t?"delta=true":"";return e.getType().is(y)?(n=e.getStartTime(),i=e.getEndTime(),r=n.encodeToString(),o=i.encodeToString(),a="?start="+r+";end="+o):"none"!==e&&"timeRange"!==e&&(a="?period="+e),t&&(a?a+=";"+l:a="?"+l),a}function m(){return t.Ord.make(niagara.view.app.appOrd).get({lease:!0}).then(function(e){return e.serverSideCall({typeSpec:T,methodName:j,value:t.Ord.make(niagara.view.history.query)})})}var h,g=t.RelTime.MILLIS_IN_DAY,v=n[0],y="baja:AbsTimeRange",b="bql:DynamicTimeRangeType",j="getHistoryRange",T="mobile:HistoryServerSideHandler",w="history.message.startAfterEnd",x="baja:String",S="timeRange",k=/start=([^;]*);end=([^;\|]*)/,D=/period=([^;\|%]*)/;return h=function(){function e(e){var t,n,i=e.getType(),o=!1;return i.is(x)?(t=s(e),t||(n=d(e))&&(t="timeRange"),o=e.indexOf("delta=true")>=0):i.is(y)&&(n=e),n?r.resolve([n,t,o]):m().then(function(e){return[e,t,o]})}function n(){var e=i('<option value="none"/>').text(v.get("loading")),t=i('<select data-role="selectmenu" data-theme="b"/>');return t.append(e),t}function o(e){var n=t.$(b),r=n.getRange();e.empty(),i("<option/>").attr("value","none").text(v.get("history.selectTimeRange")).appendTo(e),t.iterate(r.getOrdinals(),function(t){i("<option/>").attr("value",r.getTag(t)).text(n.make(t).getDisplayTag()).appendTo(e)}),e.trigger("change")}function l(e){var t=this,r=t.$select=n(),o=i(j);t.$deltaButton=o.children("a"),e.append(r),t.params.showDelta&&e.append(o),e.addClass("historyQueryParams"),r.change(function(){t.updateReadonlyStatus()}),o.click(function(){t.setDelta(!t.$isDelta)})}function c(t){var n=this;return e(t).spread(function(e,t,i){return o(n.$select),t&&(n.$select.val(t).selectmenu("refresh"),n.updateReadonlyStatus()),n.setDelta(i),n.makeChildFor({value:e}).then(function(e){n.$editor=e})})}function p(){var e=this,t=e.$select.val(),n=e.$isDelta;return t===S?this.$editor.read().then(function(e){return f(e,n)}):f(t,n)}function h(e){return new r(function(n,i){var r,o,a,l,u,s=d(e);if(!s)return void n();r=s.getStartTime(),o=r.getJsDate().getTime(),a=s.getEndTime(),l=a.getJsDate().getTime(),o>=l?(u=t.TimeFormat.SHOW_DATE|t.TimeFormat.SHOW_TIME,r.toDateTimeString({show:u,ok:function(e){a.toDateTimeString({show:u,ok:function(t){i(v.get({key:w,args:[e,t]}))}})}})):n()})}function g(){this.$isDelta=!1,this.updateReadonlyStatus=function(){var e,t,n=this,i=n.$editor;i&&(e=n.$select.val(),t=e===S,i.setReadonly(!t))},this.setDelta=function(e){this.$isDelta=e,this.$deltaButton.toggleClass("ui-btn-active",!!e),this.setModified(!0)}}var j='<div class="deltaButtonContainer"><a data-theme="a" data-role="button" data-icon="delta" title="Delta" data-iconpos="notext"/></div>';return a.defineEditor(u,{doInitialize:l,doLoad:c,doRead:p,postCreate:g,validate:h})}(),a.register(x,h,"historyQueryParams"),{HistoryQueryParamsEditor:h,parsePeriodId:s,parseStartEnd:d,toParamString:f,toTimeRange:p}}),define("mobile/history/nav/historyNav",["baja!history:HistoryRecord,history:NumericTrendRecord,history:BooleanTrendRecord,history:EnumTrendRecord,history:StringTrendRecord,history:AuditRecord,history:LogRecord","css!mobile/history/HistoryApp","css!mobile/history/chart/HistoryChart","baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/util/ord","mobile/util/mobile/mobile","mobile/util/mobile/commands","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/fieldeditors/fieldeditors","mobile/util/mobile/views/ListView","mobile/util/mobile/views/PageView","mobile/util/mobile/views/PageViewManager","mobile/history/util.mobile.history"],function(e,t,n,i,r,o,a,l,u,s,d,c,p,f,m,h,g,v,y){"use strict";function b(e,t){function n(){d.linkToOrd("/ord?"+s+"%7Cview:"+t)}var i,r=e.parents("li"),o=r.next(".expanded"),a=r.find(".timeButton.ui-btn-active").length>0,l=e.jqmData("historyId"),u=/\/\/.*\/\//,s=l.$ord.replace(u,"/");a?(i=o.find(".editor.baja-String").data("editor"),i.validate().then(function(){return i.read()}).then(function(e){s+=e.replace(/\+/g,"%2B"),n()}).catch(p.error)):n()}function j(){v.call(this)}function T(){f.register({pageshow:function(){o.mobile.changePage(i.Ord.make(niagara.view.ord).toUri(),{transition:"none",changeHash:!1})}}),w=new j,w.registerPages()}var w,x,S,k=r[0],D={},E={},O="mobile:HistoryServerSideHandler",C="<a data-role='button' class='ui-btn-up-c ui-btn-corner-all' data-inline='true' data-icon='{icon}' data-iconpos='notext' data-theme='c'>{id}</a>";return x=i.subclass(function e(){i.callSuper(e,this,arguments)},h),x.prototype.toDisplayName=function(){return l.resolve(k.get("history.title"))},x.prototype.shouldIncludeSlot=function(e){return e.getType().is("baja:Folder")},x.prototype.makeListItemParams=function(e,t){var n=e.get("displayName"),r=e.get("id"),o=e.get("ord"),a=e.get("recordType");return null!==r&&(D[r]=!1),l.resolve(a&&i.importTypes([a])).then(function(){return{ord:null!==o?o:"history:"+r,title:null!==n?n:r,id:t,recordType:a,linkable:null===r}})},x.prototype.populateExpandedDiv=function(e,t){var n=o('<div class="property"/>'),r=e.getFacets(),a=r.get("START_TIME")||i.AbsTime.DEFAULT,l=r.get("END_TIME")||i.AbsTime.now(),u=i.$("baja:AbsTimeRange",{startTime:a,endTime:l}),s=t.prev().data("params").recordType;return s=i.lt(s.toString()),m.makeFor({value:y.toParamString(u),showDelta:s.is("history:NumericTrendRecord"),key:"historyQueryParams",element:n.appendTo(t)})},x.prototype.makeListItem=function(e,t){var n=this;return n.makeListItemParams(e,t).then(function(e){var r,a=o('<li class="property"/>').attr("id",e.id||""),l=e.recordType,u=o('<div data-role="controlgroup" data-type="horizontal" />').addClass("historyViewSelector"),s=e.ord,d=null!==l;return a.data("params",e),o('<label class="title" />').text(e.title||"").addClass(d?"historyViewSelectorLabel":"").appendTo(a),o('<div class="display" />').text(e.display||"").appendTo(a),(e.linkable||e.expandable)&&(r=o("<a />"),r.jqmData("ord",e.ord),r.jqmData("title",e.title),E[e.ord]=e.title,e.expandable?(r.addClass("expandable"),
a.attr("data-icon","arrow-d")):r.addClass("link"),a.wrapInner(r)),d&&(l=i.lt(l.toString()),u.appendTo(a),a.css("overflow","auto"),(l.is("history:NumericTrendRecord")||l.is("history:EnumTrendRecord")||l.is("history:BooleanTrendRecord"))&&o(C.patternReplace({id:k.getSafe("history.chart.select"),icon:"chart"})).addClass("chartButton").jqmData("historyId",s).appendTo(u).click(function(){b(o(this),"mobile:MobileHistoryAppChartView")}),o(C.patternReplace({id:k.getSafe("history.table.select"),icon:"grid"})).addClass("tableButton").jqmData("historyId",s).appendTo(u).click(function(){b(o(this),"mobile:MobileHistoryAppTableView")}),o(C.patternReplace({id:k.getSafe("history.timeRange.select"),icon:"gear"})).addClass("timeButton").appendTo(u).click(function(){n.doExpand(t.getName()),o(this).toggleClass("ui-btn-active"),D[t.getName()]=o(this).hasClass("ui-btn-active")})),a})},x.prototype.makeListView=function(e){function t(e){return i.makeListItem(e,e.getPropertyInParent())}function n(e){var n=e.getSlots().is("baja:Folder").toValueArray(),i=u.map(n,t);return l.all(i).then(function(e){return o('<ul data-role="listview" data-theme="c"/>').html(e)})}var i=this;return e.getType().is("mobile:MobileHistoryApp")?e.serverSideCall({typeSpec:O,methodName:"getHistoryNavList"}).then(n):n(e)},x.prototype.isModified=function(){return!1},S=i.subclass(function e(t){var n=this;i.callSuper(e,this,arguments),i.strictArg(t,"baja:String"),this.$title=E[t],this.ord=t,void 0===this.$title&&s.get(niagara.view.app.appOrd,function(e){e.serverSideCall({typeSpec:O,methodName:"getOrdDisplayName",value:i.Ord.make(t),ok:function(e){n.$title=e,n.jq()&&n.getHeaderDiv().find("h1").text(e)}})})},g),S.prototype.instantiateContentView=function(){return new x},S.prototype.createPage=function(){var e=g.prototype.createPage.call(this),t=c.getCommandsButton();return e.children(":jqmData(role=header)").append(t),e},j.prototype=new v,j.prototype.instantiateView=function(e,t){var n=e.getType();return n.is("mobile:MobileHistoryApp")||"deviceList"===e.get("resultType")||"navNodeList"===e.get("resultType")?l.resolve(new S(t.ord)):l.reject("Could not instantiate view for type "+n)},j.prototype.doResolveOrd=function(e){var t,n=/history:\/[^\W\/]*/,r=/display=table/,o=/history:\/\//,a=/history:\/\/$/,u=e.match(a),d=e.match(r),c=e.match(o),p=e.match(n);return u&&(e+="/"),p&&p[0].length===e.length?(t=e.substring(e.indexOf("/")+1),s.get(niagara.view.app.appOrd).then(function(e){return e.serverSideCall({typeSpec:O,methodName:"getDeviceHistories",value:t})}).then(function(e){return e.add({slot:"resultType",value:"deviceList"}).then(function(){return e})})):d?l.resolve(i.Ord.make(e)):c?s.get(niagara.view.app.appOrd).then(function(t){return t.serverSideCall({typeSpec:O,methodName:"getNavChildren",value:i.Ord.make(e)})}).then(function(e){return e.add({slot:"resultType",value:"navNodeList"}).then(function(){return e})}):i.Ord.make(e).get()},T}),require(["jquery","bajaux/bajaux.built.min"],function(e){"use strict";e(document).on("mobileinit",function(){e.mobile.autoInitializePage=!1,e.mobile.defaultPageTransition="slide"}),require(["jquerymobile","mobile/history/nav/historyNav"],function(e,t){t(),e.initializePage()})}),define("mobile/history/nav/historynav.run",function(){});