var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/RelTimeEditor
 */
define(['baja!', 'lex!mobile', 'jquery', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/fieldeditors/mobile/feUtils', 'mobile/util/time'], function (baja, lexs, $, MobileFieldEditor, feUtils, timeUtil) {

  'use strict';

  var getFacets = feUtils.getFacets,
      minMaxCheck = feUtils.minMaxCheck,
      toTimeString = timeUtil.toTimeString,
      _lexs = _slicedToArray(lexs, 1),
      mobileLex = _lexs[0];

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/RelTimeEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */


  var RelTimeEditor = function RelTimeEditor() {
    MobileFieldEditor.apply(this, arguments);
    this.validators().add(function (value) {
      var minMax = getRelTimeMinMax(this);
      return minMaxCheck.call(this, minMax.min, minMax.max, value.getMillis());
    });
  };
  RelTimeEditor.prototype = Object.create(MobileFieldEditor.prototype);
  RelTimeEditor.prototype.constructor = RelTimeEditor;

  /**
   * @param {JQuery} dom
   */
  RelTimeEditor.prototype.doInitialize = function (dom) {
    var that = this,
        name = that.name,
        params = that.params,
        input = $('<input type="text" data-role="datebox" />').attr('name', name),
        options,
        minMax = getRelTimeMinMax(that),
        postRefreshHandler;

    options = {
      mode: 'durationbox',
      useDialogForceFalse: true,
      lockInput: false,
      defaultValue: new Date(),
      durationLabel: mobileLex.get({
        key: 'propsheet.datebox.durationLabel',
        def: 'Days Hours Minutes Seconds'
      }).split(' '),
      setDurationButtonLabel: mobileLex.get({
        key: 'propsheet.datebox.setDurationButtonLabel',
        def: 'Set Duration'
      }),
      durationFormat: params.durationFormat,
      durationOrder: params.durationOrder
    };

    //TODO: document use of 
    input.attr('data-options', JSON.stringify(options));

    input.appendTo(dom);

    dom.on('datebox', 'input:jqmData(role="datebox")', function (e, passed) {
      var $this = $(this);

      function updateRangeDiv() {
        var dateboxControls = $('.ui-datebox-container .ui-datebox-controls'),
            rangeDiv = dateboxControls.prev();

        if (!rangeDiv.hasClass('relTimeRange')) {
          rangeDiv = $('<div class="relTimeRange"></div>').insertBefore(dateboxControls);
        }

        rangeDiv.text(minMax.str);
      }

      if (passed.method === 'open') {
        updateRangeDiv();
      }

      if (passed.method === 'open' || passed.method === 'offset') {
        postRefreshHandler = function postRefreshHandler() {
          // re-validate on open and every spinner click.
          var oldTheDate = $this.datebox('getTheDate'),
              initDate = new Date($this.datebox('getOption', 'defaultValue')),
              newVal = oldTheDate - initDate,
              mod = newVal % 1000,
              seconds = newVal - mod + (mod ? 1000 : 0),
              norm;

          // normalize to be within valid min and max range
          norm = minMax.normalize(seconds);

          if (norm !== seconds) {
            // we've spun to an invalid duration, so reset the inner state to
            // a duration that is valid and trigger a refresh.
            // revisit if datebox api changes...
            $this.datebox('setTheDate', new Date(initDate.getTime() + norm));
            $this.datebox('refresh');
          }
        };
      } else if (passed.method === 'postrefresh' && postRefreshHandler) {
        postRefreshHandler();
        postRefreshHandler = undefined;
        updateRangeDiv();
      }
    });
  };

  RelTimeEditor.prototype.doLoad = function (value) {
    if (!value) {
      return;
    }

    var that = this,
        dom = that.jq(),
        input = dom.find('input:jqmData(role="datebox")'),
        d = value.getDaysPart(),
        h = value.getHoursPart(),
        m = value.getMinutesPart(),
        s = value.getSecondsPart(),
        newValue = "";

    newValue += d + " Day" + (d > 1 ? 's' : '') + ', ';
    newValue += toTimeString(h, m, s);

    input.trigger('datebox', {
      method: 'set',
      value: newValue
    });
  };

  RelTimeEditor.prototype.doRead = function () {
    var input = this.jq().find('input:jqmData(role="datebox")'),
        initDate = new Date(input.datebox('getOption', 'defaultValue')),
        theDate = input.datebox('getTheDate'),
        ms = theDate.getTime() - initDate.getTime();
    ms = Math.ceil(ms / 1000) * 1000;
    return baja.RelTime.make(ms);
  };

  function getRelTimeMinMax(editor) {
    var facets = getFacets(editor),
        max = facets.get('max'),
        min = facets.get('min'),
        maxMillis = null,
        minMillis = null,
        str;

    if (max && max.getType().is('baja:RelTime')) {
      maxMillis = max.getMillis();
    }

    if (min && min.getType().is('baja:RelTime')) {
      minMillis = min.getMillis();
    }

    if (minMillis !== null && maxMillis !== null && minMillis > maxMillis) {
      minMillis = null;
      maxMillis = null;
    }

    if (maxMillis !== null || minMillis !== null) {
      str = '[' + (minMillis === baja.Long.MIN_VALUE ? '-inf' : baja.RelTime.make(minMillis).encodeToString() + 'ms') + ' - ' + (maxMillis === baja.Long.MAX_VALUE ? '+inf' : baja.RelTime.make(maxMillis).encodeToString() + 'ms') + ']';
    }

    return {
      min: minMillis,
      max: maxMillis,
      str: str,
      normalize: function normalize(millis) {
        if (maxMillis !== null && millis > maxMillis) {
          return maxMillis;
        } else if (minMillis !== null && millis < minMillis) {
          return minMillis;
        }
        return millis;
      }
    };
  }

  return RelTimeEditor;
});
