var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/EnumEditor
 */
define(['baja!', 'lex!mobile', 'jquery', 'Promise', 'underscore', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/fieldeditors/mobile/feUtils'], function (baja, lexs, $, Promise, _, MobileFieldEditor, feUtils) {

  'use strict';

  var getEnumRangeDisplay = feUtils.getEnumRangeDisplay,
      _lexs = _slicedToArray(lexs, 1),
      mobileLex = _lexs[0];

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/EnumEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */
  var EnumEditor = function EnumEditor() {
    MobileFieldEditor.apply(this, arguments);
  };
  EnumEditor.prototype = Object.create(MobileFieldEditor.prototype);
  EnumEditor.prototype.constructor = EnumEditor;

  EnumEditor.prototype.doInitialize = function (dom) {
    var input = $('<select data-theme="a" />').attr('name', this.name);

    $('<option/>').attr('value', 'n/a').val(mobileLex.get('loading')).appendTo(input);

    input.appendTo(dom);
  };

  EnumEditor.prototype.doLoad = function (value) {
    var input = this.jq().find('select').empty(),
        range = this.facets.get('range') || value.getRange(),
        ordinals = range.getOrdinals();

    this.range = range;

    var getDisplays = _.map(ordinals, function (ordinal) {
      return getEnumRangeDisplay(ordinal, range);
    });

    return Promise.all(getDisplays).then(function (displays) {
      var options = _.map(displays, function (display, i) {
        return $('<option/>').val(ordinals[i]).text(baja.SlotPath.unescape(display));
      });
      input.html(options);
      input.val(String(value.getOrdinal())).selectmenu('refresh');
    });
  };

  return EnumEditor;
});
