var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/BooleanEditor
 */
define(['baja!', 'lex!baja', 'jquery', 'Promise', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/fieldeditors/mobile/feUtils'], function (baja, lexs, $, Promise, MobileFieldEditor, feUtils) {

  'use strict';

  var getFacets = feUtils.getFacets,
      _lexs = _slicedToArray(lexs, 1),
      bajaLex = _lexs[0];

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/BooleanEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */
  var BooleanEditor = function BooleanEditor() {
    MobileFieldEditor.apply(this, arguments);
  };
  BooleanEditor.prototype = Object.create(MobileFieldEditor.prototype);
  BooleanEditor.prototype.constructor = BooleanEditor;

  BooleanEditor.prototype.doInitialize = function (dom) {
    var that = this;
    return getTrueFalseText(that).spread(function (trueText, falseText) {
      var name = that.name,
          select = $('<select data-role="slider" />').attr('name', name),
          optionTrue = $('<option/>').val('true').text(trueText),
          optionFalse = $('<option/>').val('false').text(falseText);

      select.append(optionFalse).append(optionTrue).appendTo(dom);
    });
  };

  BooleanEditor.prototype.doLoad = function (value) {
    this.jq().find('select').val(value ? 'true' : 'false');
  };

  BooleanEditor.prototype.doRead = function () {
    var select = this.jq().find('select');
    return select.val() === 'true';
  };

  function getTrueFalseText(editor) {
    var facets = editor.facets,
        trueText,
        falseText;

    if (!(facets && facets.get('trueText') && facets.get('falseText'))) {
      facets = getFacets(editor);
    }

    if (facets) {
      trueText = facets.get('trueText');
      falseText = facets.get('falseText');
    }

    if (!trueText || !falseText) {
      trueText = bajaLex.get('true');
      falseText = bajaLex.get('false');
    }

    return Promise.join(baja.Format.format({ pattern: trueText }), baja.Format.format({ pattern: falseText }));
  }

  return BooleanEditor;
});
