var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/AbsTimeEditor
 */
define(['baja!', 'bajaux/events', 'jquery', 'Promise', 'mobile/fieldeditors/MobileFieldEditor'], function (baja, events, $, Promise, MobileFieldEditor) {

  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/AbsTimeEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */

  var AbsTimeEditor = function AbsTimeEditor() {
    MobileFieldEditor.apply(this, arguments);
  };
  AbsTimeEditor.prototype = Object.create(MobileFieldEditor.prototype);
  AbsTimeEditor.prototype.constructor = AbsTimeEditor;

  AbsTimeEditor.prototype.doLoad = function (value) {
    var that = this,
        dom = that.jq(),
        date = value.getDate(),
        time = value.getTime();

    dom.empty();

    that.$offset = value.$offset || 0;

    return Promise.join(that.makeChildFor({ value: date, element: dom }), that.makeChildFor({ value: time, element: dom })).spread(function (dateEditor, timeEditor) {
      that.$dateEditor = dateEditor;
      that.$timeEditor = timeEditor;

      function setEditorModified() {
        that.setModified(true);
        return false;
      }

      //upon a change to the date or time sub-editor, set the
      //parent AbsTime editor to modified and let it bubble up its own
      //modified.fieldeditor event - otherwise any modified listeners on
      //the AbsTime editor will receive the event from the wrong editor
      dateEditor.jq().on(MODIFY_EVENT, setEditorModified);
      timeEditor.jq().on(MODIFY_EVENT, setEditorModified);
    });
  };

  AbsTimeEditor.prototype.doRead = function () {
    var offset = this.$offset;
    return Promise.all([this.$dateEditor.read(), this.$timeEditor.read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          date = _ref2[0],
          time = _ref2[1];

      return baja.AbsTime.make({ date: date, time: time, offset: offset });
    });
  };

  AbsTimeEditor.prototype.doEnabled = function (enabled) {
    var that = this;
    if (that.$dateEditor) {
      that.$dateEditor.doEnabled(enabled);
    }
    if (that.$timeEditor) {
      that.$timeEditor.doEnabled(enabled);
    }
  };

  return AbsTimeEditor;
});
