var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @file The built-in field editors available to all Niagara Mobile
 * apps. These field editors make use of jQuery Mobile with the Datebox plugin.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*jshint strict: false */

define(['baja!baja:Month,baja:UnitConversion', 'jqmDatebox', 'css!mobile/fieldeditors/fieldeditors', 'baja!', 'lex!mobile', 'jquery', 'jquerymobile', 'Promise', 'underscore', 'mobile/fieldeditors/fieldeditors', 'mobile/fieldeditors/fieldeditors.composite', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/fieldeditors/mobile/AbsTimeEditor', 'mobile/fieldeditors/mobile/BooleanEditor', 'mobile/fieldeditors/mobile/BooleanCheckboxEditor', 'mobile/fieldeditors/mobile/DateEditor', 'mobile/fieldeditors/mobile/DynamicEnumEditor', 'mobile/fieldeditors/mobile/FacetsEditor', 'mobile/fieldeditors/mobile/FrozenEnumEditor', 'mobile/fieldeditors/mobile/NonEditableEditor', 'mobile/fieldeditors/mobile/NumericEditor', 'mobile/fieldeditors/mobile/OrdComponentSelector', 'mobile/fieldeditors/mobile/OverrideRelTimeEditor', 'mobile/fieldeditors/mobile/RelTimeEditor', 'mobile/fieldeditors/mobile/StringEditor', 'mobile/fieldeditors/mobile/TimeEditor', 'mobile/fieldeditors/mobile/UnitEditor'], function (types, unused$, unusedCss, baja, lexs, $, jqm, Promise, _, fe, composite, MobileFieldEditor, AbsTimeEditor, BooleanEditor, BooleanCheckboxEditor, DateEditor, DynamicEnumEditor, FacetsEditor, FrozenEnumEditor, NonEditableEditor, NumericEditor, OrdComponentSelector, OverrideRelTimeEditor, RelTimeEditor, StringEditor, TimeEditor, UnitEditor) {
  var register = fe.register,
      toSaveDataComponent = fe.toSaveDataComponent,
      _lexs = _slicedToArray(lexs, 1),
      mobileLex = _lexs[0];

  //exports


  var status = {};

  ////////////////////////////////////////////////////////////////
  // field editors for StatusString, StatusBoolean, etc
  ////////////////////////////////////////////////////////////////

  status = function statusFunctions() {

    var idCounter = 0;

    /**
     * Adds the null/default checkbox to a primitive editor to create a
     * Status field editor.
     * 
     * @private
     * @memberOf niagara.fieldEditors.mobile.status
     * @param {JQuery} div the field editor div to append the checkbox to
     */
    function appendNullDefaultCheckbox(div) {
      var id = 'nulldefault' + idCounter++,
          fieldset = $('<fieldset data-role="controlgroup" class="nulldefault"/>'),
          checkbox = $('<input type="checkbox" data-theme="a" name="nulldefault"/>').attr('id', id).addClass('hidden'),
          label = $('<label/>').attr('for', id).text(mobileLex.get('propsheet.nullDefault'));

      fieldset.append(checkbox).append(label);
      div.append(fieldset);
    }

    /**
     * Given a wrapped editor for a Status type, retrieves the appropriate
     * Status to set depending on whether the Null/Default box is checked.
     * 
     * @private
     * @memberOf niagara.fieldEditors.mobile.status
     * @param {JQuery} div the wrapped field editor
     * @returns {baja.Status} NULL if the check box is checked, ok if not
     */
    function getStatus(div) {
      var nullDefault = div.find('input[name=nulldefault]').is(':checked');
      return nullDefault ? baja.Status.nullStatus : baja.Status.ok;
    }

    /**
     * Sets the input element on a Status editor to readonly or not, depending
     * on whether the Null/Default checkbox is checked.
     * 
     * @private
     * @memberOf niagara.fieldEditors.mobile.status
     * @param {JQuery} div the editor div
     */
    function readOnlyInput(div) {
      var input = div.find('input[type=text], textarea'),
          select = div.find('select'),
          checkbox = div.find('input[type=checkbox]');
      if (checkbox.is(':checked')) {
        input.attr('disabled', 'disabled');
        select.filter(':jqmData(role="slider")').slider('disable');
        select.filter(':jqmData(role!="slider")').selectmenu('disable');
      } else {
        input.removeAttr('disabled');
        select.filter(':jqmData(role="slider")').slider('enable');
        select.filter(':jqmData(role!="slider")').selectmenu('enable');
      }
    }

    /**
     * Creates a Status field editor by wrapping a primitive editor in some
     * extra processing. For instance, it will take an editor for baja:String
     * and return an editor for baja:StatusString.
     * 
     * @private
     * @memberOf niagara.fieldEditors.mobile.status
     * @param {Function} SimpleEditor a primitive field editor constructor
     * @returns {Function} a Status field editor constructor
     */
    function wrapWithStatus(SimpleEditor) {

      return function StatusEditor(container, editedObject, slot, params) {
        var editor = new SimpleEditor(container, editedObject, slot, params),
            validateSteps = editor.$validators.$validators;

        //after building the primitive HTML, append the null/default checkbox
        editor.doInitialize = function (element) {
          var that = this;

          return Promise.resolve(SimpleEditor.prototype.doInitialize.call(that, element)).then(function () {
            appendNullDefaultCheckbox(element);

            //add a handler to enable/disable the input when the checkbox is
            //checked or unchecked
            element.find('input[type="checkbox"]').change(function () {
              if (that.isEnabled()) {
                readOnlyInput(element);
              }
            });
          });
        };

        //when validating, we want to validate the Simple value
        baja.iterate(validateSteps, function (validateStep, i) {
          validateSteps[i] = function (readValue) {
            return validateStep.call(this, readValue.getValue());
          };
        });

        editor.doEnabled = function () {
          var that = this;

          SimpleEditor.prototype.doEnabled.apply(that, arguments);
          if (that.isEnabled()) {
            readOnlyInput(that.jq());
          }
        };

        //after setting the primitive value, set the null/default checkbox also
        editor.doLoad = function (value) {
          var statusValue = value;
          if (!statusValue) {
            return;
          }

          return Promise.resolve(SimpleEditor.prototype.doLoad.call(this, statusValue.getValue())).then(function () {
            var status = statusValue.getStatus(),
                checkbox = editor.jq().find('input[type="checkbox"]');
            checkbox.prop('checked', status.isNull());
          });
        };

        //retrieve the primitive value, then construct a Status object and
        //set its status based on the checkbox's value
        editor.doRead = function () {
          return Promise.resolve(SimpleEditor.prototype.doRead.call(this)).then(function (simpleValue) {
            var status = getStatus(editor.jq()),
                value = editor.value(),
                statusValue = toSaveDataComponent(value);

            statusValue.set({ slot: 'value', value: simpleValue });
            statusValue.set({ slot: 'status', value: status });
            return statusValue;
          });
        };

        //enable/disable input based on checkbox status
        editor.refreshWidgets = function () {
          var that = this;

          SimpleEditor.prototype.refreshWidgets.apply(that, arguments);

          if (that.isEnabled()) {
            readOnlyInput(that.jq());
          }
        };

        return editor;
      };
    }

    /**
     * A namespace containing field editor functions for working with 
     * `BStatusValue`s.
     * @namespace
     * @name niagara.fieldEditors.mobile.status
     */
    return {
      wrapWithStatus: wrapWithStatus
    };
  }();

  (function registerDefaultTypes() {
    function registerAll(obj) {
      baja.iterate(obj, function (Editor, typeSpec) {
        register(typeSpec, Editor);
      });
    }

    var simpleFEs, statusFEs, compositeFEs, nonEditableFEs;

    simpleFEs = {
      'baja:AbsTime': AbsTimeEditor,
      'baja:Boolean': BooleanEditor,
      'baja:Date': DateEditor,
      'baja:DynamicEnum': DynamicEnumEditor,
      'baja:FrozenEnum': FrozenEnumEditor,
      'baja:Number': NumericEditor,
      'baja:RelTime': RelTimeEditor,
      'baja:String': StringEditor,
      'baja:Time': TimeEditor,
      'baja:Facets': FacetsEditor,
      'baja:Unit': UnitEditor
    };

    statusFEs = {
      "baja:StatusBoolean": status.wrapWithStatus(simpleFEs["baja:Boolean"]),
      "baja:StatusEnum": status.wrapWithStatus(simpleFEs["baja:DynamicEnum"]),
      "baja:StatusNumeric": status.wrapWithStatus(simpleFEs["baja:Number"]),
      "baja:StatusString": status.wrapWithStatus(simpleFEs["baja:String"])
    };

    compositeFEs = {
      "control:BooleanOverride": composite.makeComposite([{ slot: 'duration', key: 'override' }, 'value']),
      "control:EnumOverride": composite.makeComposite([{ slot: 'duration', key: 'override' }, 'value']),
      "control:NumericOverride": composite.makeComposite([{ slot: 'duration', key: 'override' }, 'value']),
      "control:Override": composite.makeComposite([{ slot: 'duration', key: 'override' }]),
      "control:StringOverride": composite.makeComposite([{ slot: 'duration', key: 'override' }, 'value']),
      "baja:AbsTimeRange": composite.makeComposite(['startTime', 'endTime']),
      "baja:TimeRange": composite.makeComposite(['startTime', 'endTime'])
    };

    nonEditableFEs = {
      "baja:EnumRange": NonEditableEditor,
      "baja:Password": NonEditableEditor,
      "baja:TimeZone": NonEditableEditor
      //      "baja:TypeSpec": nonEditableFE
    };

    registerAll(simpleFEs);
    registerAll(statusFEs);
    registerAll(compositeFEs);
    registerAll(nonEditableFEs);

    register('baja:Boolean', BooleanCheckboxEditor, 'checkbox');
  })();

  (function registerSpecialTypes() {
    register('baja:RelTime', OverrideRelTimeEditor, 'override');
    register('baja:Ord', OrdComponentSelector, 'componentSelector');
  })();

  /**
   * @namespace
   * @name niagara.fieldEditors.mobile
   */
  return {
    status: status
  };
});
