/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
 
/**
 * Select JavaScript support for BHxSelectFe.
 */
var select = new Select();
function Select()
{ 

  this.addToSelect = function(listName, value, text)
  {
    if(select.findInSelect(listName, value))
      return false;
    
    var option = document.createElement('option');
    option.appendChild(document.createTextNode(text));
    option.value = value;
    option.title=text;
    var colList = select.getElem(listName);
    colList.appendChild(option);
    return true;
  }
  
  this.updateSelect = function(listName, value, text)
  {
    var colList = select.getElem(listName);
    colList.options[value].text = text;
  }
  
  this.findInSelect = function(listName, value)
  {
    var colList = select.getElem(listName);
    for(var i = 0; i<colList.length; i++)
    {
      var option=colList.options[i];
      if(option.value == value)
        return true;
    }
    return false;
  }
  
  this.indexOf = function(listName, value)
  {
    var colList = select.getElem(listName);
    for(var i = 0; i<colList.length; i++)
    {
      var option=colList.options[i];
      if(option.value == value)
        return i;
    }
    return -1;
  }
  
  this.removeFromSelect = function(listName, value)
  {
    var colList = select.getElem(listName);
    var removed = false;
    for(var i = 0; i<colList.length; i++)
    {
      var option=colList.options[i];
      if (removed)
        option.value = option.value - 1;
      if(!removed && option.value == value)
      {
        colList.removeChild(option);
        i--;
        removed = true;
      }
    }                              
  }
  
  this.swap = function(listName, index1, index2)
  {
    var colList = select.getElem(listName);
    var temp = colList.options[index1].text;
    var temp2 = colList.options[index2].text;
    colList.options[index2].text = temp;
    colList.options[index2].selected = "selected";
    colList.options[index1].text = temp2;
  }    
  
  this.clearSelect = function(listName)
  {
    var colList = select.getElem(listName);
    while(colList.length > 0)
    {
      var option=colList.options[colList.length-1];
      colList.removeChild(option);      
    }    
  }
  
  this.getElem = function(listName)
  {
    var colList = document.getElementById(listName);
    if(colList == null)
      colList = document.getElementsByName(listName)[0];
    return colList;
  }
}
