function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

define(['lex!platCrypto', 'nmodule/platCrypto/rc/wb/cert/util/certUtils'], function (lexs, certUtils) {
  'use strict';

  /**
   * Utility functions for parsing a cert.
   *
   *
   * API Status: **Private**
   * @exports nmodule/platCrypto/rc/wb/cert/util/parseCert
   * @since Niagara 4.13
   */
  var exports = {};
  var _lexs = _slicedToArray(lexs, 1),
    platCrypto = _lexs[0];

  /**
   *
   * @param {Object} cert
   * @return {module:nmodule/platCrypto/rc/wb/cert/util/parseCert~DistinguishedName}
   */
  exports.getSubjectDn = function (cert) {
    var returnValue = {};
    var subjectDN = cert.subjectDN;
    if (!subjectDN) {
      return returnValue;
    }
    var array = subjectDN.split(',');
    array.forEach(function (element) {
      var split = element.split("=");
      returnValue[split[0].trim()] = split[1].trim();
    });
    return returnValue;
  };

  /**
   * @param {Object} cert
   * @return {Array.<String>}
   */
  exports.getCertRequestWarnings = function (cert) {
    var warnings = [];
    var _exports$getSubjectDn = exports.getSubjectDn(cert),
      CN = _exports$getSubjectDn.CN,
      O = _exports$getSubjectDn.O,
      L = _exports$getSubjectDn.L,
      ST = _exports$getSubjectDn.ST,
      C = _exports$getSubjectDn.C;
    if (!CN) {
      warnings.push(platCrypto.get('cert.request.dialog.common.name.warning'));
    }
    if (!O) {
      warnings.push(platCrypto.get('cert.request.dialog.organisation.warning'));
    }
    if (!L) {
      warnings.push(platCrypto.get('cert.request.dialog.city.warning'));
    }
    if (!ST) {
      warnings.push(platCrypto.get('cert.request.dialog.state.warning'));
    }
    if (!C) {
      warnings.push(platCrypto.get('cert.request.dialog.country.warning'));
    }
    if (certUtils.isRSA(cert.keyAlgorithm)) {
      var keySize = cert.keySize;
      if (keySize < 2048) {
        warnings.push(platCrypto.get('cert.request.dialog.keysize.warning'));
      }
    }
    return warnings;
  };

  /**
   * @typedef module:nmodule/platCrypto/rc/wb/cert/util/parseCert~DistinguishedName
   * @property {String} [CN] common name
   * @property {String} [O] organization
   * @property {String} [OU] organization unit
   * @property {String} [L] city
   * @property {String} [ST] state
   * @property {String} [C] country
   */

  return exports;
});
