/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

define(['nmodule/platCrypto/rc/wb/cert/forms/Form', 'nmodule/webEditors/rc/fe/feDialogs'], function (Form, feDialogs) {
  'use strict';

  /**
   * Form util
   * TODO - Move the form method to feDialogs?
   *
   * API Status: **Private**
   * @exports nmodule/platCrypto/rc/wb/cert/util/formUtil
   */
  var exports = {};

  /**
   * Builds and displays Form ({@link module:nmodule/platCrypto/rc/wb/cert/forms/Form}) fields in a dialog.
   * For example,
   * return form({
   *   value: { name: 'foo' }
   * }); //displays a simple form with a single string field 'foo' in a dialog.
   * 
   * @param {object} params 
   * @param {module:bajaux/Widget} [params.type]
   * @param {object} [params.value]
   * @param {object} [params.properties]
   * @returns {Promise}
   */
  exports.form = function () {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var type = params.type,
      value = params.value,
      properties = params.properties;
    return feDialogs.showFor({
      type: type || Form,
      value: value,
      properties: properties
    });
  };
  return exports;
});
