function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/*global Intl, setInterval, clearInterval */

define(['dialogs', 'lex!platCrypto', 'underscore', 'Promise', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/certManagerEvents', 'nmodule/webEditors/rc/fe/feDialogs'], function (dialogs, lexs, _, Promise, switchboard, certManagement, certManagerEvents, feDialogs) {
  'use strict';

  var once = _.once;
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var REFRESH_EVENT = certManagerEvents.REFRESH_EVENT;
  var WAITING_MSG = platCryptoLex.get("cert.request.waiting");
  var GENERATE_TEXT = platCryptoLex.get('cert.request.waiting.generate');
  var FAILED_MSG = platCryptoLex.get("cert.generate.failed.msg.noarg");
  var RSA_DISPLAY_VALUE = platCryptoLex.get("cert.field.keyType.RSA");
  var STATUS_SUCCESS = 2;
  var STATUS_FAILURE = -1;
  var regionDisplayNames = function () {
    if ((typeof Intl === "undefined" ? "undefined" : _typeof(Intl)) === 'object' && Intl.DisplayNames) {
      try {
        return new Intl.DisplayNames([], {
          type: 'region'
        });
      } catch (ignore) {}
    }
  }();
  var getValidCountryCodes = once(function () {
    if (!regionDisplayNames) {
      return [];
    }
    var letters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');
    try {
      var allLetterCombos = letters.reduce(function (codes, first) {
        return codes.concat(letters.map(function (second) {
          return first + second;
        }));
      }, []);
      return allLetterCombos.filter(exports.isCountryCodeValid);
    } catch (e) {
      return [];
    }
  });

  /**
   * utilities for working with certificates.
   *
   * API Status: **Private**
   * @exports nmodule/platCrypto/rc/wb/cert/util/certUtils
   */
  var exports = {};
  exports.$getRequestStatusInterval = function () {
    return 1000;
  };

  /**
   * @param {string} countryCode
   * @returns {boolean} if country code is a valid two-letter ISO-3166-1 country code
   */
  exports.isCountryCodeValid = function (countryCode) {
    if (typeof countryCode !== 'string') {
      return false;
    }
    if (countryCode.length !== 2) {
      return false;
    }
    if (!regionDisplayNames) {
      return true; // this browser can't validate
    }
    try {
      countryCode = countryCode.toUpperCase();
      var displayName = regionDisplayNames.of(countryCode);
      return displayName && displayName !== countryCode;
    } catch (e) {
      return false;
    }
  };

  /**
   * @returns {Array.<string>} all valid ISO-3166-1 country codes this browser knows about
   */
  exports.getValidCountryCodes = function () {
    return getValidCountryCodes();
  };

  /**
   * Ensure this logic is kept consistent with the back-end counterpart in CertUtils.java.
   *
   * @param {module:nmodule/platCrypto/rc/rpc/certManagement~Certificate} cert
   * @returns {boolean}
   */
  exports.isCACertificate = function (cert) {
    if (!cert) {
      return false;
    }
    var extensions = cert.extensions;
    var keyUsages = cert.keyUsage.split(',').map(function (s) {
      return s.trim();
    });
    if (keyUsages.includes('keyCertSign')) {
      return true;
    }
    return extensions.some(function (_ref) {
      var oid = _ref.oid,
        value = _ref.value;
      if (isBasicConstraintOID(oid)) {
        return value.isCA;
      }
      if (isKeyUsageOID(oid)) {
        var flags = value.flags;
        return flags && flags.includes('keyCertSign');
      }
    });
  };

  /**
   * Ensure this logic is kept consistent with the back-end counterpart in CertUtils.java.
   *
   * @param {module:nmodule/platCrypto/rc/rpc/certManagement~Certificate} cert
   * @returns {boolean}
   */
  exports.isCodeSigningCertificate = function (cert) {
    if (!cert) {
      return false;
    }
    return isCodeSigningKeyUsage(cert.extendedKeyUsage);
  };

  /**
   * Returns true if the `keyAlgorithmValue` matches the localized value for RSA.
   * @param {String} keyAlgorithmValue
   * @returns {boolean}
   */
  exports.isRSA = function (keyAlgorithmValue) {
    return keyAlgorithmValue === RSA_DISPLAY_VALUE;
  };

  /**
   * Show a loading dialog while the user is waiting for a certificate to generate.
   * If the user isn't interested in waiting, a dialog button will allow the process to
   * be completed in the background without updating the table.
   *
   * @param {Number} requestId
   * @param {module:bajaux/Widget} [tab] if a tab is provided, a successful status will emit a refresh.
   * @returns {Promise}
   */
  exports.showLoadingDialogForRequestId = function (requestId, tab) {
    var showLoading = true;
    var showLoadingCheck = function showLoadingCheck() {
      return showLoading;
    };
    var promise = exports.$waitForRequestId(requestId, showLoadingCheck).then(function (status) {
      if (status === STATUS_SUCCESS) {
        tab && tab.emit(REFRESH_EVENT);
      } else if (status === STATUS_FAILURE) {
        feDialogs.error(FAILED_MSG);
      }
    })["catch"](function (error) {
      feDialogs.error(error, {
        messageSummary: FAILED_MSG
      });
    });
    return dialogs.showLoading({
      promise: promise,
      title: WAITING_MSG,
      loaderTxt: GENERATE_TEXT,
      buttons: [{
        name: "ok",
        handler: function handler() {
          showLoading = false;
        }
      }]
    }).promise();
  };

  /**
   * Retrieve the status of the request.
   *
   * @private
   * @param {Number} requestId
   * @param {function(): boolean} showLoadingCheck
   * @returns {Promise.<Number>}
   */
  exports.$waitForRequestId = function (requestId, showLoadingCheck) {
    var checkRequestStatus = switchboard(function () {
      return certManagement.checkRequestStatus(requestId);
    }, {
      allow: 'oneAtATime',
      onRepeat: 'returnLast'
    });

    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      var timer = setInterval(function () {
        return Promise["try"](function () {
          return checkRequestStatus();
        }).then(function (status) {
          if (status === STATUS_FAILURE || status === STATUS_SUCCESS || !showLoadingCheck()) {
            clearInterval(timer);
            resolve(status);
          }
        })["catch"](function (error) {
          clearInterval(timer);
          reject(error);
        });
      }, exports.$getRequestStatusInterval());
    });
  };
  function isBasicConstraintOID(oid) {
    return /2\.5\.29\.19/.test(oid);
  }
  function isKeyUsageOID(oid) {
    return /2\.5\.29\.15/.test(oid);
  }
  function isCodeSigningKeyUsage() {
    var keyUsage = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    return /1\.3\.6\.1\.5\.5\.7\.3\.3/.test(keyUsage);
  }
  return exports;
});
