function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

define(['lex!platCrypto', 'nmodule/platCrypto/rc/wb/cert/util/ISO8601Column', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyPathColumn'], function (lexs, ISO8601Column, Column, IconColumn, JsonObjectPropertyColumn, JsonObjectPropertyPathColumn) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var UNSEEN = Column.flags.UNSEEN;
  var VALID_COLUMN_CONTEXT = {
    trueText: platCryptoLex.get('cert.field.valid.true'),
    falseText: platCryptoLex.get('cert.field.valid.false')
  };
  var APPROVED_COLUMN_CONTEXT = {
    trueText: platCryptoLex.get('exempt.field.approved.true'),
    falseText: platCryptoLex.get('exempt.field.approved.false')
  };
  function setContext(column, context) {
    column.data('context', context);
    return column;
  }

  /**
   * API Status: **Private**
   *
   * Utility methods for shared column declarations across tabs.
   *
   * @exports nmodule/platCrypto/rc/wb/cert/util/certColumns
   */
  var exports = {};

  /**
   * Columns used in the user key store, system trust store, and user trust
   * store tabs.
   * @returns {Array.<module:nmodule/webEditors/rc/wb/table/model/Column>}
   */
  exports.getStoreColumns = function () {
    return [new IconColumn('icon'), new JsonObjectPropertyColumn('alias', {
      displayName: platCryptoLex.get('cert.field.alias')
    }), new JsonObjectPropertyColumn('issuedBy', {
      displayName: platCryptoLex.get('cert.field.issuedBy'),
      flags: UNSEEN
    }), new JsonObjectPropertyColumn('subject', {
      displayName: platCryptoLex.get('cert.field.subject')
    }), new ISO8601Column('notBefore', {
      displayName: platCryptoLex.get('cert.field.notBefore'),
      flags: UNSEEN
    }), new ISO8601Column('notAfter', {
      displayName: platCryptoLex.get('cert.field.notAfter')
    }), new JsonObjectPropertyColumn('keyAlgorithm', {
      displayName: platCryptoLex.get('cert.field.keyAlgorithm')
    }), new JsonObjectPropertyColumn('keySize', {
      displayName: platCryptoLex.get('cert.field.keySize')
    }), new JsonObjectPropertyColumn('spec', {
      displayName: platCryptoLex.get('cert.field.spec'),
      flags: UNSEEN
    }), new JsonObjectPropertyColumn('signatureAlgorithm', {
      displayName: platCryptoLex.get('cert.field.signatureAlgorithm'),
      flags: UNSEEN
    }), new JsonObjectPropertyColumn('signatureSize', {
      displayName: platCryptoLex.get('cert.field.signatureSize'),
      flags: UNSEEN
    }), setContext(new JsonObjectPropertyColumn('valid', {
      displayName: platCryptoLex.get('cert.field.valid')
    }), VALID_COLUMN_CONTEXT), new JsonObjectPropertyColumn('selfSigned', {
      displayName: platCryptoLex.get('cert.field.selfSigned'),
      flags: UNSEEN
    })];
  };
  exports.getExemptionColumns = function () {
    return [new IconColumn('icon'), new JsonObjectPropertyColumn('host', {
      displayName: platCryptoLex.get('exempt.field.host')
    }), new JsonObjectPropertyPathColumn(['certificate', 'subject'], {
      displayName: platCryptoLex.get('cert.field.subject')
    }), setContext(new JsonObjectPropertyColumn('approved', {
      displayName: platCryptoLex.get('exempt.field.approved')
    }), APPROVED_COLUMN_CONTEXT), new ISO8601Column('created', {
      displayName: platCryptoLex.get('exempt.field.created')
    }), new JsonObjectPropertyPathColumn(['certificate', 'issuedBy'], {
      displayName: platCryptoLex.get('cert.field.issuedBy')
    }), new ISO8601Column(['certificate', 'notBefore'], {
      displayName: platCryptoLex.get('cert.field.notBefore')
    }), new ISO8601Column(['certificate', 'notAfter'], {
      displayName: platCryptoLex.get('cert.field.notAfter')
    }), new JsonObjectPropertyPathColumn(['certificate', 'keyAlgorithm'], {
      displayName: platCryptoLex.get('cert.field.keyAlgorithm'),
      flags: UNSEEN
    }), new JsonObjectPropertyPathColumn(['certificate', 'keySize'], {
      displayName: platCryptoLex.get('cert.field.keySize'),
      flags: UNSEEN
    }), new JsonObjectPropertyPathColumn(['certificate', 'spec'], {
      displayName: platCryptoLex.get('cert.field.spec'),
      flags: UNSEEN
    }), new JsonObjectPropertyPathColumn(['certificate', 'signatureAlgorithm'], {
      displayName: platCryptoLex.get('cert.field.signatureAlgorithm'),
      flags: UNSEEN
    }), new JsonObjectPropertyPathColumn(['certificate', 'signatureSize'], {
      displayName: platCryptoLex.get('cert.field.signatureSize'),
      flags: UNSEEN
    }), setContext(new JsonObjectPropertyPathColumn(['certificate', 'valid'], {
      displayName: platCryptoLex.get('cert.field.valid'),
      flags: UNSEEN
    }), VALID_COLUMN_CONTEXT)];
  };
  return exports;
});
