/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * Every tab on the Cert Manager is presumed to have a table displaying
 * certs.
 *
 * @interface module:nmodule/platCrypto/rc/wb/cert/CertManagerTab
 * @extends module:bajaux/Widget
 */

/**
 * Get the tab's Table.
 *
 * @function
 * @name module:nmodule/platCrypto/rc/wb/cert/CertManagerTab#getTable
 * @returns module:nmodule/webEditors/rc/wb/table/Table
 */

/**
 * Data retrieved from the station by sending up a PEM file to be parsed.
 *
 * @typedef module:nmodule/platCrypto/rc/rpc/certManagement~ParsedPem
 * @property {module:nmodule/platCrypto/rc/rpc/certManagement~PrivateKeyInfo} privateKey
 * @property {object[]} certificates
 * @property {module:nmodule/platCrypto/rc/rpc/certManagement~Certificate} certificates[].certificate
 * @property {string} certificates[].suggestedAlias
 * @property {string} [suggestedKeyStoreAlias] to prompt the user when entering the alias under
 * which to store the cert into the key store
 * @property {string} [existingKeyStoreAlias] if the alias for this cert/key already exists in the
 * key store
 * @property {boolean} [keyStorePrivateKeyPasswordNeeded]
 */

/**
 * @typedef module:nmodule/platCrypto/rc/rpc/certManagement~Certificate
 * @property {string} ASN1String
 * @property {string} basicConstraints
 * @property {string} extendedKeyUsage
 * @property {Array.<module:nmodule/platCrypto/rc/rpc/certManagement~CertificateExtension>} extensions
 * @property {Array.<module:module:nmodule/platCrypto/rc/rpc/certManagement~CertificateFingerprint>} fingerprints
 * @property {string} issuedBy
 * @property {string} issuerDN
 * @property {string} keyAlgorithm
 * @property {number} keySize
 * @property {string} keyUsage key usage, delimited by commas and spaces e.g. `keyEncipherment, digitalSignature`
 * @property {number} notAfter
 * @property {number} notBefore
 * @property {string} pemString
 * @property {boolean} selfSigned
 * @property {string} serialNumber
 * @property {string} signatureAlgorithm
 * @property {number} signatureSize
 * @property {string} spec
 * @property {string} subject
 * @property {string} subjectDN
 * @property {boolean} valid
 * @property {number} version
 */

/**
 * @typedef module:nmodule/platCrypto/rc/rpc/certManagement~CertificateExtension
 * @property {boolean} isCritical
 * @property {string} oid
 * @property {object} value
 */

/**
 * @typedef module:nmodule/platCrypto/rc/rpc/certManagement~CertificateFingerprint
 * @property {string} fingerprint
 * @property {String} fingerprintAlgorithm
 */

/**
 * Information about a private key.
 *
 * @typedef module:nmodule/platCrypto/rc/rpc/certManagement~PrivateKeyInfo
 * @property {string} privateKey
 * @property {boolean} pemPrivateKeyPasswordNeeded
 */

/**
 * Data to be sent to the station to import certificate and private key data into a key store.
 *
 * @typedef module:nmodule/platCrypto/rc/rpc/certManagement~CertificateImportRequest
 * @property {string} storeType
 * @property {string} passwordToDecryptKey
 * @property {string} keyStorePassword
 * @property {string} [passwordToEncryptKey] password to encrypt the key into the key store.
 * Required unless `useGlobalPassword` is set.
 * @property {boolean} [useGlobalPassword] true to encrypt the key using the global password.
 * `passwordToEncryptKey` will be ignored.
 * @property {module:nmodule/platCrypto/rc/rpc/certManagement~PrivateKeyInfo} privateKey
 * @property {object[]} certificates
 * @property {module:nmodule/platCrypto/rc/rpc/certManagement~Certificate} certificates[].certificate
 * @property {string} certificates[].alias
 */
