function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/forms/Form
 */
define(['bajaux/events', 'bajaux/spandrel', 'bajaux/util/CommandButton', 'lex!platCrypto', 'log!nmodule.platCrypto.rc.wb.cert.Form', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/commands/HelpCommand'], function (events, spandrel, CommandButton, lexs, log, Promise, _, HelpCommand) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-Form'
      }
    };
  };
  var _lexs = _slicedToArray(lexs, 1),
    PLAT_CRYPTO_LEX = _lexs[0];
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var logSevere = log.severe.bind(log);
  var isArray = _.isArray;
  function validateRequiredFields(readValue, formData) {
    var keys = Object.keys(formData);
    return Promise.all(keys.map(function (key) {
      var fieldData = formData[key];
      var _fieldData$properties = fieldData.properties,
        properties = _fieldData$properties === void 0 ? {} : _fieldData$properties,
        validate = fieldData.validate;
      var required = properties.required;
      var value = readValue[key];
      if (!value && required) {
        var errorFieldName = key;
        if (fieldData.displayName) {
          errorFieldName = fieldData.displayName;
        }
        throw new Error(PLAT_CRYPTO_LEX.get({
          key: 'NewCertForm.validationErrors.required',
          args: [errorFieldName]
        }));
      }
      if (validate) {
        return validate(value);
      }
    }));
  }
  var makeFormControl = function makeFormControl(name, objValue) {
    var _ref = objValue || {},
      displayName = _ref.displayName,
      value = _ref.value,
      format = _ref.format,
      enabled = _ref.enabled,
      readonly = _ref.readonly,
      _ref$properties = _ref.properties,
      properties = _ref$properties === void 0 ? {} : _ref$properties,
      isEnabled = enabled !== false,
      isReadonly = !!readonly,
      helpKey = properties.helpKey,
      helpModule = properties.helpModule,
      uxFieldEditor = properties.uxFieldEditor,
      required = properties.required,
      datalist = properties.datalist,
      options = properties.options,
      map = properties.map,
      timeFormat = properties.timeFormat;
    var helpCommand;
    if (helpKey && helpModule) {
      helpCommand = new HelpCommand({
        module: helpModule,
        lex: helpKey,
        title: displayName
      });
    }
    var label = displayName,
      widgetProperties = {
        datalist: datalist,
        formFieldName: name,
        uxFieldEditor: uxFieldEditor,
        options: options,
        map: map,
        timeFormat: timeFormat
      },
      trClassList = "-t-ux-form-control ux-table-row form-field-" + name,
      rowKey = "row-" + name,
      helpSpandrelKey = "help-key-" + name;
    var fieldValue = value;
    if (format && format !== 'string' && format !== 'date-time') {
      fieldValue = fieldValue ? String(fieldValue) : '';
    }
    return spandrel.jsx("tr", {
      spandrelKey: rowKey,
      "class": trClassList
    }, spandrel.jsx("td", null, spandrel.jsx("div", {
      "class": "wrapper"
    }, spandrel.jsx("span", null, label), helpCommand ? spandrel.jsx(CommandButton, {
      className: "-t-FormHelp -t-HelpCommand",
      value: helpCommand,
      spandrelKey: helpSpandrelKey
    }) : '')), spandrel.jsx("td", null, spandrel.jsx("div", {
      "class": "widgetWrapper"
    }, spandrel.jsx("any", {
      value: fieldValue,
      "class": "form-field",
      bind: true,
      spandrelKey: "editor",
      properties: widgetProperties,
      enabled: isEnabled,
      readonly: isReadonly
    }), required ? spandrel.jsx("span", {
      "class": "required"
    }, PLAT_CRYPTO_LEX.get('NewCertForm.field.required')) : '')));
  };

  /**
   * A Widget intended to represent the loaded value as a "Form".
   *
   * It can load an object literal or an array of objects.
   * If an object literal is loaded in, it is atleast expected to have a
   * "name" property.
   * Optionally, you can provide a "value" or "format". Only "string" and
   * "date-time" formats are supported at the moment.
   * Additionally an object can have "properties". These properties are analogous to Facets.
   *
   * Example,
   * const object = {
   *    name: "foo",
   *    displayName: "F o o",
   *    value: "bar",
   *    format: "string",
   *    properties: {
   *        description: "",
   *        uxFieldEditor: "webEditors:StringEditor",
   *        required: true,
   *        helpModule: 'fooModule'
   *        helpKey: 'fooKey'
   *    }
   * }
   *
   * The Form widget accepts a "header" property. Set the "type"
   * sub-property to any bajaux/Widget constructor and it will be
   * used to make the Form's header. If instead a string is passed,
   * then it will be set as the header.
   *
   * The Form widget accepts a "helpModule", and "helpKey" properties that can point to a
   * lexiconKey in a module to show help for a field.
   *
   * If your Form is more complex and the form fields are inter-dependent,
   * then you may sub-class this widget. Subclasses can implement the
   * "fieldChanged" event handler which is called passing the form instance
   * and the name of the field that changed. Form has many APIs defined and one
   * useful method to call may be 'form.getFormField('foo')', which returns the
   * Widget instance of the 'foo' field.
   *
   * For example,
   * class MyForm extends Form {
   *    fieldChanged(form, fieldName) {
   *      if (fieldName === 'foo') {
   *        return Promise.resolve({
   *          bar: { value: 'newValue', properties: { datalist: 'a;b;c'}},
   *          buzz: { value: 'anotherNewValue'}
   *        });
   *      }
   *    }
   * }
   * ...
   * return feDialogs.showFor({
   *   type: MyForm,
   *   value: [
   *    { name: 'foo' },
   *    { name: 'bar' },
   *    { name: 'buzz' }
   *   ]
   * })
   *
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/wb/cert/forms/Form
   * @extends module:bajaux/spandrel
   */
  return /*#__PURE__*/function (_spandrel) {
    function Form(params) {
      var _this;
      _classCallCheck(this, Form);
      _this = _callSuper(this, Form, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function (readResult) {
        return validateRequiredFields(readResult, _this.state().formData);
      });
      return _this;
    }
    _inherits(Form, _spandrel);
    return _createClass(Form, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.on(MODIFY_EVENT, '.form-field.editor', function (event, editor) {
          var props = editor && editor.properties(),
            fieldName = props.getValue('formFieldName');
          if (fieldName && typeof _this2.fieldChanged === 'function') {
            _this2.fieldChanged(_this2, fieldName)["catch"](logSevere);
          }
        });
        return _superPropGet(Form, "doInitialize", this, 3)(arguments);
      }
    }, {
      key: "toState",
      value: function toState(data) {
        var _this3 = this;
        var formData = {};
        if (_typeof(data) === 'object' && data.name) {
          data = [data];
        }
        if (isArray(data)) {
          data.forEach(function (obj) {
            var name = obj.name,
              value = obj.value,
              properties = obj.properties,
              displayName = obj.displayName,
              validate = obj.validate,
              enabled = obj.enabled,
              readonly = obj.readonly;
            formData[name] = {
              value: _this3.$getDefaultFieldValue(name, value),
              properties: properties,
              displayName: displayName,
              validate: validate,
              enabled: enabled,
              readonly: readonly
            };
          });
        }
        return {
          formData: formData
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref2) {
        var _this4 = this;
        var formData = _ref2.formData;
        return Promise.all(Object.entries(formData).map(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            key = _ref4[0],
            value = _ref4[1];
          return _this4.getFormField(key).read();
        })).then(function (values) {
          return Object.assign.apply(Object, _toConsumableArray(Object.keys(formData).map(function (key, i) {
            return _defineProperty({}, key, values[i]);
          })));
        });
      }

      /**
       * Gives all form fields a chance to save.
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        return Promise.all(this.getFormFields().map(function (field) {
          return field.save();
        }));
      }
    }, {
      key: "getFormHeaderWidget",
      value: function getFormHeaderWidget() {
        return this.queryWidget('form/header');
      }
    }, {
      key: "getFormContent",
      value: function getFormContent() {
        return this.queryWidget('form/content');
      }

      /**
       * @param {string} fieldName
       * @returns {module:bajaux/Widget} the field editor for the specified form value
       */
    }, {
      key: "getFormField",
      value: function getFormField(fieldName) {
        return this.queryWidget("form/content/0/row-".concat(fieldName, "/1/0/editor"));
      }

      /**
       * @private
       * @param {string} fieldName
       * @returns {module:bajaux/Widget} the row for the specified form value
       */
    }, {
      key: "$getFormRow",
      value: function $getFormRow(fieldName) {
        return this.queryWidget("form/content/0/row-".concat(fieldName));
      }

      /**
       * @returns {Array.<module:bajaux/Widget>} field editors for all form values
       */
    }, {
      key: "getFormFields",
      value: function getFormFields() {
        return this.queryWidgets('form/content/0/*/1/0/editor');
      }
    }, {
      key: "getHelpCommand",
      value: function getHelpCommand(fieldName) {
        var helpCommandButton = this.queryWidgets('form/content/**/help-key-' + fieldName)[0];
        return helpCommandButton && helpCommandButton.value();
      }

      /**
       * @private
       * @param {String} name
       * @param {*} value
       * @returns {*}
       */
    }, {
      key: "$getDefaultFieldValue",
      value: function $getDefaultFieldValue(name, value) {
        var properties = this.properties();
        if (properties.has(name)) {
          return properties.getValue(name);
        } else {
          return value || '';
        }
      }

      /**
       * @private
       * @param {string|object} header
       * @returns {module:bajaux/spandrel~SpandrelData}
       */
    }, {
      key: "$buildFormHeader",
      value: function $buildFormHeader(header) {
        if (!header) {
          return spandrel.jsx("wbr", null);
        }
        if (typeof header === 'string') {
          return spandrel.jsx("h3", {
            spandrelKey: "header"
          }, header);
        } else if (header.type) {
          var HeaderCrt = header.type;
          return spandrel.jsx(HeaderCrt, {
            spandrelKey: "header"
          });
        }
        return spandrel.jsx("wbr", null);
      }

      /**
       * @private
       * @returns {Array.<module:bajaux/spandrel~SpandrelData>}
       */
    }, {
      key: "$buildFormContent",
      value: function $buildFormContent() {
        var _this$state = this.state(),
          formData = _this$state.formData,
          formFields = [];
        if (_typeof(formData) === 'object') {
          Object.entries(formData).forEach(function (_ref6) {
            var _ref7 = _slicedToArray(_ref6, 2),
              name = _ref7[0],
              value = _ref7[1];
            formFields.push(makeFormControl(name, value));
          });
        }
        return formFields;
      }
    }]);
  }(spandrel(function (value, _ref8) {
    var properties = _ref8.properties,
      self = _ref8.self;
    var _ref9 = properties || {},
      header = _ref9.header;

    //since some rows might be temporarily hidden, the `no-stripe` does not work for this scenario
    return spandrel.jsx("div", {
      "class": "-t-ux-form",
      spandrelKey: "form"
    }, self.$buildFormHeader(header), spandrel.jsx("div", {
      "class": "-t-ux-form-section",
      spandrelKey: "content"
    }, spandrel.jsx("table", {
      "class": "ux-table no-stripe"
    }, self.$buildFormContent())));
  }, {
    strategy: 'niagara'
  }));
});
