function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/NewCertCommand
 */
define(['baja!', 'dialogs', 'lex!platCrypto', 'jquery', 'bajaux/commands/Command', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/fe/extensions/KeyUsageEditor', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/NewCertWidget', 'nmodule/platCrypto/rc/wb/cert/util/certUtils', 'nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor', 'nmodule/webEditors/rc/fe/baja/DefaultConfirmPasswordEditor', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/userUtils', 'Promise', 'underscore'], function (baja, dialogs, lexs, $, Command, asyncUtils, CertConstants, KeyUsageEditor, certManagement, NewCertWidget, certUtils, ConfirmPasswordEditor, DefaultConfirmPasswordEditor, feDialogs, userUtils, Promise, _) {
  'use strict';

  var Password = require('bajaScript/baja/obj/Password');
  var _CertConstants$EXTENS = CertConstants.EXTENSION_OID,
    KEY_USAGE_OID = _CertConstants$EXTENS.KEY_USAGE_OID,
    BASIC_CONSTRAINT_OID = _CertConstants$EXTENS.BASIC_CONSTRAINT_OID;
  var DEFAULT_ALIAS = CertConstants.DEFAULT_ALIAS;
  var doRequire = asyncUtils.doRequire;
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var PRIVATE_KEY_PASSWORD_TEXT = platCryptoLex.get('cert.export.privatekey.title');
  var find = _.find;
  function promptForPassword(useDefault) {
    var dom = $('<div class="-t-CertManager-confirm-password"></div>');
    return feDialogs.showFor({
      type: useDefault ? DefaultConfirmPasswordEditor : ConfirmPasswordEditor,
      value: baja.$('baja:Password'),
      title: PRIVATE_KEY_PASSWORD_TEXT,
      validate: function validate(password) {
        return certManagement.passwordStrength().then(function (passwordStrength) {
          return password === Password.DEFAULT || passwordStrength.validatePassword(password.encodeToString());
        });
      },
      dom: dom
    });
  }
  function generateCert(certData, tab, dialog) {
    return certManagement.generateCertificate(certData)["catch"](function (error) {
      dialog.keepOpen();
      feDialogs.error(error);
    }).then(function (requestId) {
      if (typeof requestId === 'number') {
        return certUtils.showLoadingDialogForRequestId(requestId, tab);
      }
    });
  }
  function promptForPasswordIfNeededThenGenerateCert(certData, tab, dialog) {
    var isPasswordNeeded = isPasswordReq(certData);
    return promptForPassword(!isPasswordNeeded).then(function (password) {
      var wasPasswordCancelled = password === null;
      if (wasPasswordCancelled) {
        return;
      }
      if (password) {
        certData.password = password;
      }
      return generateCert(certData, tab, dialog);
    });
  }
  function isPasswordReq(certData) {
    var certUsage = certData.certUsage,
      extensions = certData.extensions;
    var passwordReq = false;
    if (certUsage === 'ca' || certUsage === 'codeSigning') {
      return true;
    }
    extensions.forEach(function (extension) {
      passwordReq = passwordReq || extension.oid === KEY_USAGE_OID && (extension.value.flags & KeyUsageEditor.CERTIFICATE_SIGNING) !== 0 || extension.oid === BASIC_CONSTRAINT_OID && extension.value.isCA;
    });
    return passwordReq;
  }

  /**
   * A command to generate a self signed certificate
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/platCrypto/rc/wb/cert/commands/NewCertCommand
   */
  return /*#__PURE__*/function (_Command) {
    function NewCertCommand(tab) {
      var _this;
      _classCallCheck(this, NewCertCommand);
      _this = _callSuper(this, NewCertCommand, [{
        module: 'platCrypto',
        lex: 'cert.button.new',
        func: function func() {
          return _this.$showNewCertForm(tab);
        }
      }]);
      /**
       * Resolves to true if offline or if online and the current user is a superuser.
       * @returns {Promise.<Boolean>}
       */
      _this.isSuperUserOrOffline = _.once(function () {
        return userUtils.isSuperUserOrOffline();
      });
      return _this;
    }

    /**
     * @private
     * @returns {Promise}
     */
    _inherits(NewCertCommand, _Command);
    return _createClass(NewCertCommand, [{
      key: "$showNewCertForm",
      value: function $showNewCertForm(tab) {
        var _this2 = this;
        return Promise.all([this.$getKeyType(), this.$getKeySize(), this.$getSupportedKeySizes(), this.$getKeySpec(), this.$getSupportedKeySpecs(), this.$getSupportedKeyAlgorithms(), this.$getCertificateUsages(), this.$getReadonlyProperties()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 8),
            keyType = _ref2[0],
            keySize = _ref2[1],
            supportedKeySizes = _ref2[2],
            spec = _ref2[3],
            supportedKeySpecs = _ref2[4],
            supportedKeyAlgorithms = _ref2[5],
            certificateUsages = _ref2[6],
            readonlyProperties = _ref2[7];
          return feDialogs.showFor({
            type: NewCertWidget,
            value: {},
            formFactor: 'mini',
            properties: {
              keyType: keyType,
              keySize: keySize,
              supportedKeySizes: supportedKeySizes,
              spec: spec,
              supportedKeySpecs: supportedKeySpecs,
              supportedKeyAlgorithms: supportedKeyAlgorithms,
              certificateUsages: certificateUsages,
              readonlyProperties: readonlyProperties
            },
            buttons: {
              ok: function ok(dialog, event, editor) {
                return editor.save().then(function () {
                  return editor.read();
                }).then(function (certData) {
                  if (!certData) {
                    return false;
                  }
                  var generateCert = function generateCert() {
                    return promptForPasswordIfNeededThenGenerateCert(certData, tab, dialog);
                  };
                  var alias = certData.alias;
                  if (alias.toLowerCase() === DEFAULT_ALIAS) {
                    return dialogs.showOk({
                      title: platCryptoLex.get('cert.generate.warning.defaultAlias'),
                      text: platCryptoLex.get('cert.generate.warning.defaultAlias.description')
                    }).ok(function () {
                      return dialog.keepOpen();
                    }).promise();
                  } else {
                    return _this2.$aliasExists(alias).then(function (aliasExists) {
                      if (aliasExists) {
                        return dialogs.showYesNo({
                          title: platCryptoLex.get('cert.generate.warning.matchingAlias'),
                          text: platCryptoLex.get({
                            key: 'cert.generate.warning.matchingAlias.description',
                            args: [alias]
                          })
                        }).yes(function () {
                          //check if the existing alias is password protected
                          return Promise.all([certManagement.isPasswordRequired(alias), _this2.isSuperUserOrOffline()]).then(function (_ref3) {
                            var _ref4 = _slicedToArray(_ref3, 2),
                              passwordRequired = _ref4[0],
                              isSuperUserOrOffline = _ref4[1];
                            if (passwordRequired && !isSuperUserOrOffline) {
                              return _this2.$promptForKeyStorePassword(alias, dialog).then(function (password) {
                                if (password) {
                                  certData.keyStorePassword = password.encodeToString();
                                  return generateCert();
                                }
                              });
                            } else {
                              return generateCert();
                            }
                          });
                        }).no(function () {
                          return dialog.keepOpen();
                        }).promise();
                      } else {
                        return generateCert();
                      }
                    });
                  }
                });
              },
              cancel: {}
            }
          });
        });
      }

      /**
       * @private
       * @param {String} alias
       * @param {module:dialogs~Dialog} certDialog
       * @returns {Promise.<module:baja/obj/Password>}
       */
    }, {
      key: "$promptForKeyStorePassword",
      value: function $promptForKeyStorePassword(alias, certDialog) {
        return feDialogs.showFor({
          value: Password.DEFAULT,
          formFactor: 'mini',
          title: platCryptoLex.get('cert.import.keyStoreKey.dialog.title'),
          summary: platCryptoLex.get('cert.import.keyStoreKey.dialog.info', alias),
          properties: {
            prelabel: platCryptoLex.get('cert.password.prelabel'),
            rootCssClass: '-t-CertPasswordDialog'
          },
          buttons: {
            ok: function ok(dialog, event, editor) {
              return editor.read().then(function (password) {
                //if password is valid then resolve to true else show error message
                return certManagement.isKeyStorePasswordValid(alias, password.encodeToString()).then(function (validPassword) {
                  if (validPassword) {
                    return password;
                  } else {
                    dialog.keepOpen();
                    return dialogs.showOk({
                      title: platCryptoLex.get('cert.import.keyStoreKey.errDialog.title'),
                      text: platCryptoLex.get('cert.import.keyStoreKey.errDialog.info')
                    });
                  }
                });
              });
            },
            cancel: function cancel() {
              return certDialog.keepOpen();
            }
          }
        });
      }

      /**
       * @private
       * @returns {Promise.<String>}
       */
    }, {
      key: "$getKeyType",
      value: function $getKeyType() {
        return this.$getSupportedKeyAlgorithms().then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 1),
            firstItem = _ref6[0];
          return firstItem;
        });
      }

      /**
       * @private
       * @returns {Promise.<Number>}
       */
    }, {
      key: "$getKeySize",
      value: function $getKeySize() {
        return certManagement.getDefaultRsaKeySize();
      }

      /**
       * @private
       * @returns {Promise.<Array.<Number>>}
       */
    }, {
      key: "$getSupportedKeySizes",
      value: function $getSupportedKeySizes() {
        return certManagement.getSupportedRsaKeySizes();
      }

      /**
       * @private
       * @returns {Promise.<String>}
       */
    }, {
      key: "$getKeySpec",
      value: function $getKeySpec() {
        return certManagement.getDefaultECKeySpec();
      }

      /**
       * @private
       * @returns {Promise.<Array.<String>>}
       */
    }, {
      key: "$getSupportedKeySpecs",
      value: function $getSupportedKeySpecs() {
        return certManagement.getSupportedECKeySpecs();
      }

      /**
       * @private
       * @returns {Promise.<Array.<String>>}
       */
    }, {
      key: "$getSupportedKeyAlgorithms",
      value: function $getSupportedKeyAlgorithms() {
        return certManagement.getSupportedKeyAlgorithms();
      }

      /**
       * Returns the certificate usages.
       * Can be overriden by child NewCertCommand.
       *
       * @private
       * @returns {Promise.<Array.<Object>>}
       */
    }, {
      key: "$getCertificateUsages",
      value: function $getCertificateUsages() {
        return Promise.resolve([{
          displayName: platCryptoLex.get('cert.field.serverCert'),
          value: 'server',
          selected: true
        }, {
          displayName: platCryptoLex.get('cert.field.clientCert'),
          value: 'client'
        }, {
          displayName: platCryptoLex.get('cert.field.caCert'),
          value: 'ca'
        }, {
          displayName: platCryptoLex.get('cert.field.codeSigningCert'),
          value: 'codeSigning'
        }, {
          displayName: platCryptoLex.get('cert.field.custom'),
          value: 'custom'
        }]);
      }

      /**
       * @private
       * @param {string} newAlias
       * @returns {Promise.<boolean>}
       */
    }, {
      key: "$aliasExists",
      value: function $aliasExists(newAlias) {
        return certManagement.getCertStoreData('userKeyStore').then(function (_ref7) {
          var certs = _ref7.certs;
          return !!find(certs, function (cert) {
            return cert.alias === newAlias;
          });
        });
      }

      /**
       * @private
       * @param {object} data
       * @returns {Promise}
       * @throws {Error}
       */
    }, {
      key: "$validateSchema",
      value: function $validateSchema(data) {
        return doRequire(['nmodule'.toLowerCase() + '/jsTest/ext/ajv.min', 'text!nmodule/platCrypto/rc/schema/CertificateCreationRequest.json']).then(function (_ref8) {
          var _ref9 = _slicedToArray(_ref8, 2),
            Ajv = _ref9[0],
            newCertSchema = _ref9[1];
          var ajv = new Ajv({
              verbose: true
            }),
            valid = ajv.validate(JSON.parse(newCertSchema), data);
          if (!valid) {
            throw new Error(ajv.errors.map(function (_ref10) {
              var data = _ref10.data,
                message = _ref10.message;
              return "".concat(data, " ").concat(message);
            }).join('\n'));
          }
        });
      }

      /**
       * Overriden by children to specify the disabled form fields.
       * By default, all the form fields are enabled.
       *
       * @private
       * @returns {Promise.<Object.<Object>>} {'propertyName': {enabled: true, disabled: false}}
       */
    }, {
      key: "$getReadonlyProperties",
      value: function $getReadonlyProperties() {
        return Promise.resolve({});
      }
    }]);
  }(Command);
});
