function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/ExemptionChangedWidget
 */
define(['baja!', 'lex!platCrypto', 'bajaux/spandrel', 'Promise', 'nmodule/platCrypto/rc/wb/cert/CertDetailsTabs', 'nmodule/platCrypto/rc/wb/cert/CertHeader', 'nmodule/platCrypto/rc/wb/cert/commands/CertTableChanged', 'css!nmodule/platCrypto/rc/platCrypto'], function (baja, lexs, spandrel, Promise, CertDetailsTabs, CertHeader, CertTableChanged) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        beforeMainProperties: [],
        afterMainProperties: []
      }
    };
  };
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var APPROVED_TEXT = platCryptoLex.get('exempt.field.approved.true');
  var NOT_APPROVED_TEXT = platCryptoLex.get('exempt.field.approved.false');
  var APPROVAL_LABEL = platCryptoLex.get('exempt.field.approved');
  var CREATED_LABEL = platCryptoLex.get('exempt.field.created');
  var HOST_LABEL = platCryptoLex.get('exempt.field.host');
  var headerIcon = baja.Icon.make(platCryptoLex.getSafe({
    key: 'cert.warning.x32.icon',
    def: 'module://icons/x32/warning.png'
  }));

  /**
   * Shows the details about a particular exemption along with the changes.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/platCrypto/rc/wb/cert/ExemptionChangedWidget
   */
  return /*#__PURE__*/function (_spandrel) {
    function ExemptionChangedWidget(params) {
      _classCallCheck(this, ExemptionChangedWidget);
      return _callSuper(this, ExemptionChangedWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(ExemptionChangedWidget, _spandrel);
    return _createClass(ExemptionChangedWidget);
  }(spandrel(function (exemption) {
    var certificate = exemption.certificate,
      changed = exemption.changed,
      approved = exemption.approved,
      host = exemption.host,
      created = exemption.created;
    var subject = certificate.subject;
    var changedCert = Object.assign({}, certificate, {
      changed: changed.changedCert
    });
    var changedSubject = changedCert.changed.subject;
    return Promise.all([baja.AbsTime.make({
      jsDate: new Date(created)
    }).toString({}), approved.toString({
      falseText: NOT_APPROVED_TEXT,
      trueText: APPROVED_TEXT
    })]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        createdText = _ref2[0],
        approvedText = _ref2[1];
      var approvedProp = {
        value: approvedText,
        label: APPROVAL_LABEL
      };
      var hostProp = {
        value: host,
        label: HOST_LABEL
      };
      var createdProp = {
        value: createdText,
        label: CREATED_LABEL
      };
      var beforeMainProperties = [createdProp, hostProp, approvedProp];
      return [spandrel.jsx(CertHeader, {
        value: certificate,
        properties: {
          icon: headerIcon,
          title: "".concat(subject, " / ").concat(changedSubject),
          subtitle: platCryptoLex.get('exempt.changed.dialog.info', subject)
        }
      }), spandrel.jsx(CertDetailsTabs, {
        spandrelKey: "tabs",
        value: changedCert,
        properties: {
          beforeMainProperties: beforeMainProperties,
          detailsTableConstructor: CertTableChanged
        }
      })];
    });
  }, {
    strategy: 'niagara'
  }));
});
