function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/CertTableChanged
 */
define(['lex!platCrypto', 'bajaux/spandrel', 'Promise', 'underscore', 'nmodule/platCrypto/rc/wb/cert/commands/CertTable', 'nmodule/platCrypto/rc/wb/cert/commands/ExtensionDetailsWidget'], function (lexs, spandrel, Promise, _, CertTable, ExtensionDetailsWidget) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var findWhere = _.findWhere;
  var ADD_TEXT = platCryptoLex.get('exempt.view.dialog.added');
  var REMOVE_TEXT = platCryptoLex.get('exempt.view.dialog.removed');

  /**
   * The info used to display a given extension in the table along with difference such as changes,
   * additions, and removals.
   *
   * @typedef {Object} module:nmodule/platCrypto/rc/wb/cert/commands/CertTableChanged~extensionInfo
   * @property {Object} [value] the old cert value
   * @property {Object} [changed] the new cert value which can be used to diff with the `value` prop
   * @property {Object} [added] the value of a cert that was added
   * @property {Object} [removed] the value of a cert that was removed
   */

  /**
   * Table section of the cert details view that can diff against a new `changed` cert.
   *
   * @class
   * @extends module:nmodule/platCrypto/rc/wb/cert/commands/CertTable
   * @alias module:nmodule/platCrypto/rc/wb/cert/commands/CertTableChanged
   */
  return /*#__PURE__*/function (_CertTable) {
    function CertTableChanged() {
      _classCallCheck(this, CertTableChanged);
      return _callSuper(this, CertTableChanged, arguments);
    }
    _inherits(CertTableChanged, _CertTable);
    return _createClass(CertTableChanged, [{
      key: "buildPropertyValueDisplay",
      value: function buildPropertyValueDisplay(obj) {
        var value = obj.value,
          changed = obj.changed;
        if (!changed) {
          return _superPropGet(CertTableChanged, "buildPropertyValueDisplay", this, 3)([obj]);
        }
        return [spandrel.jsx("div", null, REMOVE_TEXT, " ", value), spandrel.jsx("div", {
          className: "-t-added"
        }, ADD_TEXT, " ", changed)];
      }
    }, {
      key: "resolvePropertyValue",
      value: function resolvePropertyValue(cert, field) {
        return Promise.all([_superPropGet(CertTableChanged, "resolvePropertyValue", this, 3)([cert, field]), cert.changed[field] !== undefined && _superPropGet(CertTableChanged, "resolvePropertyValue", this, 3)([cert.changed, field])]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            result = _ref2[0],
            changedResult = _ref2[1];
          if (changedResult && changedResult.value !== result.value) {
            result.changed = changedResult.value;
          }
          return result;
        });
      }

      /**
       * @param {module:nmodule/platCrypto/rc/wb/cert/commands/CertTableChanged~extensionInfo} extensionInfo
       * @returns {module:bajaux/spandrel~SpandrelData}
       */
    }, {
      key: "buildExtensionValueDisplay",
      value: function buildExtensionValueDisplay(extensionInfo) {
        var value = extensionInfo.value,
          changed = extensionInfo.changed,
          added = extensionInfo.added,
          removed = extensionInfo.removed;
        if (changed) {
          return [spandrel.jsx("div", {
            className: "-t-removed"
          }, spandrel.jsx("div", {
            className: "-t-changed-text"
          }, REMOVE_TEXT), spandrel.jsx(ExtensionDetailsWidget, {
            value: value
          })), spandrel.jsx("div", {
            className: "-t-added"
          }, spandrel.jsx("div", {
            className: "-t-changed-text"
          }, ADD_TEXT), spandrel.jsx(ExtensionDetailsWidget, {
            value: changed
          }))];
        } else if (added) {
          return [spandrel.jsx("div", {
            className: "-t-added"
          }, spandrel.jsx("div", {
            className: "-t-changed-text"
          }, ADD_TEXT), spandrel.jsx(ExtensionDetailsWidget, {
            value: added
          }))];
        } else if (removed) {
          return spandrel.jsx("div", {
            className: "-t-removed"
          }, spandrel.jsx("div", {
            className: "-t-changed-text"
          }, REMOVE_TEXT), spandrel.jsx(ExtensionDetailsWidget, {
            value: removed
          }));
        }
        return _superPropGet(CertTableChanged, "buildExtensionValueDisplay", this, 3)([{
          value: value
        }]);
      }

      /**
       * @param {Object} cert the cert JSON object to get values for
       * @returns {module:nmodule/platCrypto/rc/wb/cert/commands/CertTableChanged~extensionInfo}
       */
    }, {
      key: "getExtensionValues",
      value: function getExtensionValues(cert) {
        var vals = [];
        var _cert$extensions = cert.extensions,
          extensions = _cert$extensions === void 0 ? [] : _cert$extensions;
        var changedExtensions = cert.changed.extensions || [];
        cert.extensions.forEach(function (extension) {
          var found = findWhere(changedExtensions, {
            oid: extension.oid
          });
          if (found) {
            if (_.isEqual(found, extension)) {
              vals.push({
                value: extension
              });
            } else {
              vals.push({
                value: extension,
                changed: found
              });
            }
          } else {
            vals.push({
              removed: extension
            });
          }
        });
        changedExtensions && changedExtensions.forEach(function (changedExtension) {
          var found = findWhere(extensions, {
            oid: changedExtension.oid
          });
          if (!found) {
            vals.push({
              added: changedExtension
            });
          }
        });
        return vals;
      }
    }]);
  }(CertTable);
});
