function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/CertTable
 */
define(['baja!', 'lex!platCrypto', 'bajaux/spandrel', 'Promise', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/wb/cert/commands/ExtensionDetailsWidget', 'nmodule/platCrypto/rc/wb/cert/util/certUtils'], function (baja, lexs, spandrel, Promise, CertConstants, ExtensionDetailsWidget, certUtils) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-CertTable',
        beforeMainProperties: [],
        afterMainProperties: []
      }
    };
  };
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var PROPERTIES_TEXT = platCryptoLex.get('cert.dialog.properties');
  var EXTENSIONS_TEXT = platCryptoLex.get('cert.dialog.extensions');
  var PROPERTY_FIELDS = CertConstants.PROPERTY_FIELDS,
    CERT_FIELD_LEX_MAPPING = CertConstants.CERT_FIELD_LEX_MAPPING,
    _PROPERTY_FIELDS = _slicedToArray(PROPERTY_FIELDS, 19),
    NOT_BEFORE = _PROPERTY_FIELDS[6],
    NOT_AFTER = _PROPERTY_FIELDS[7],
    MD5_FINGERPRINT = _PROPERTY_FIELDS[16],
    SHA1_FINGERPRINT = _PROPERTY_FIELDS[17],
    VALID = _PROPERTY_FIELDS[18];
  var getCertFieldLexValue = function getCertFieldLexValue(field) {
    var def = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "";
    var mappedFieldName = CERT_FIELD_LEX_MAPPING[field],
      suffix = mappedFieldName || field;
    return platCryptoLex.get({
      key: "cert.field.".concat(suffix),
      def: def
    });
  };
  var fingerprintValue = function fingerprintValue(cert, field) {
    var printAlg = "";
    if (field === MD5_FINGERPRINT) {
      printAlg = 'md5';
    } else if (field === SHA1_FINGERPRINT) {
      printAlg = 'sha1';
    }
    var fingerprints = cert.fingerprints;
    if (!fingerprints || !fingerprints.length) {
      return "";
    }
    var matches = fingerprints.filter(function (print) {
      return String(print.fingerprintAlgorithm).toLowerCase() === printAlg;
    });
    return matches.length ? matches[0].fingerprint : "";
  };

  /**
   * The info used to display given row in a table. Subclasses may build upon this object to provide
   * more customization.
   *
   * @typedef {Object} module:nmodule/platCrypto/rc/wb/cert/commands/CertTable~rowInfo
   * @property {String} label
   * @property {String|*} value
   */

  /**
   * The info used to display a given extension in the table. Subclasses may build upon this object
   * to provide more customization.
   *
   * @typedef {Object} module:nmodule/platCrypto/rc/wb/cert/commands/CertTable~extensionInfo
   * @property {Object} value the cert value
   */

  /**
   * Gets the value for the given cert to be displayed in the table.
   *
   * @param {Object} cert the object to get the field from
   * @param {String} field
   * @inner
   * @returns {Promise.<String>}
   */
  var _resolvePropertyValue = function resolvePropertyValue(cert, field) {
    if (field === MD5_FINGERPRINT || field === SHA1_FINGERPRINT) {
      return Promise.resolve(fingerprintValue(cert, field));
    }
    if (field === VALID) {
      var _val = cert[field] ? getCertFieldLexValue('valid.true') : getCertFieldLexValue('valid.false');
      return Promise.resolve(_val);
    }
    if (field === NOT_BEFORE || field === NOT_AFTER) {
      return baja.AbsTime.make({
        jsDate: new Date(cert[field])
      }).toDateTimeStringWithLongYear();
    }
    var val = cert[field];
    if (!val) {
      return Promise.resolve("");
    }
    return Promise.resolve(String(val));
  };
  var resolveMainProperties = function resolveMainProperties(cert, self) {
    var skipKeySpec = false;
    var keySpecIndex = -1;
    return Promise.all(PROPERTY_FIELDS.map(function (field, index) {
      return self.resolvePropertyValue(cert, field).then(function (resolvedProp) {
        if (field === 'keyAlgorithm' && certUtils.isRSA(resolvedProp.value)) {
          skipKeySpec = true;
        }
        if (field === 'spec') {
          keySpecIndex = index;
        }
        return resolvedProp;
      });
    })).then(function (map) {
      if (!skipKeySpec) {
        return map;
      }
      return map.filter(function (prop, index) {
        return index !== keySpecIndex;
      });
    });
  };

  /**
   * Table section of the cert details view.
   *
   * CertTable supports the following properties:
   *
   * - `beforeMainProperties`: {Array.<module:nmodule/platCrypto/rc/wb/cert/commands/CertTable~rowInfo>}
   *    specifies the properties that should be placed before the properties already in the
   *    properties table of the view
   * - `afterMainProperties`: {Array.<module:nmodule/platCrypto/rc/wb/cert/commands/CertTable~rowInfo>}
   *    specifies the properties that should be placed after the properties already in the properties
   *    table of the view
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/platCrypto/rc/wb/cert/commands/CertTable
   */
  var CertTable = /*#__PURE__*/function (_spandrel) {
    function CertTable() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, CertTable);
      return _callSuper(this, CertTable, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * Turns the provided info in to the display for that value column of the table. Subclasses may
     * override `resolvePropertyValue` to customize the information provided to this method.
     *
     * @param {module:nmodule/platCrypto/rc/wb/cert/commands/CertTable~rowInfo} rowInfo
     * @returns {String|module:bajaux/spandrel~SpandrelData}
     */
    _inherits(CertTable, _spandrel);
    return _createClass(CertTable, [{
      key: "buildPropertyValueDisplay",
      value: function buildPropertyValueDisplay(rowInfo) {
        return rowInfo.value;
      }

      /**
       * This will resolve the value used to build the display for the given field's row.
       *
       * @param {Object} cert the JSON info for the given cert
       * @param {string} field the field key to look up
       * @returns {Promise.<module:nmodule/platCrypto/rc/wb/cert/commands/CertTable~rowInfo>}
       */
    }, {
      key: "resolvePropertyValue",
      value: function resolvePropertyValue(cert, field) {
        return _resolvePropertyValue(cert, field).then(function (value) {
          return {
            value: value,
            label: getCertFieldLexValue(field)
          };
        });
      }

      /**
       * @param {module:nmodule/platCrypto/rc/wb/cert/commands/CertTable~extensionInfo} extensionInfo
       * @returns {module:bajaux/spandrel~SpandrelData}
       */
    }, {
      key: "buildExtensionValueDisplay",
      value: function buildExtensionValueDisplay(extensionInfo) {
        return spandrel.jsx(ExtensionDetailsWidget, {
          value: extensionInfo.value
        });
      }

      /**
       * Gets the extension information to display in the extensions table. The individual results will
       * ultimately be passed to `buildExtensionDisplay` for each entry to be built into the actual
       * display.
       *
       * @param {Object} cert
       * @returns {Array.<module:nmodule/platCrypto/rc/wb/cert/commands/CertTable~extensionInfo>}
       */
    }, {
      key: "getExtensionValues",
      value: function getExtensionValues(cert) {
        if (!cert.extensions) {
          return [];
        }
        return cert.extensions.map(function (ext) {
          return {
            value: ext
          };
        });
      }
    }]);
  }(spandrel(function (cert, _ref) {
    var self = _ref.self,
      properties = _ref.properties;
    var beforeMainProperties = properties.beforeMainProperties,
      afterMainProperties = properties.afterMainProperties;
    return resolveMainProperties(cert, self).then(function (mainProperties) {
      var allProps = beforeMainProperties.concat(mainProperties).concat(afterMainProperties);
      var propRows = allProps.map(function (prop) {
        var label = prop.label;
        return spandrel.jsx("tr", {
          className: "ux-table-row"
        }, spandrel.jsx("td", null, label), spandrel.jsx("td", null, self.buildPropertyValueDisplay(prop)));
      });
      var extensionValues = self.getExtensionValues(cert);
      var extensionRows = extensionValues.map(function (extensionValue) {
        return spandrel.jsx("tr", {
          className: "ux-table-row"
        }, spandrel.jsx("td", null, self.buildExtensionValueDisplay(extensionValue)));
      });
      var hasExtensions = extensionValues.length > 0;
      return [spandrel.jsx("h3", {
        className: "-t-table-title"
      }, PROPERTIES_TEXT, ":"), spandrel.jsx("table", {
        className: "-t-table ux-table -t-property-table"
      }, spandrel.jsx("tbody", null, propRows)), hasExtensions ? spandrel.jsx("h3", {
        className: "-t-table-title -t-extension-title"
      }, EXTENSIONS_TEXT, ":") : '', spandrel.jsx("table", {
        className: "-t-table ux-table -t-extension-table"
      }, spandrel.jsx("tbody", null, extensionRows))];
    });
  }));
  return CertTable;
});
