function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/CertImportWidget
 */
define(['log!nmodule/platCrypto/rc/wb/cert/CertImportWidget', 'bajaux/events', 'lex!platCrypto', 'bajaux/spandrel', 'nmodule/platCrypto/rc/wb/cert/CertHeader', 'nmodule/platCrypto/rc/wb/cert/CertDetailsTabs', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'css!nmodule/platCrypto/rc/platCrypto'], function (log, events, lexs, spandrel, CertHeader, CertDetailsTabs, BooleanEditor, Column, Row, Table, TableModel) {
  'use strict';

  var EDITABLE = Column.flags.EDITABLE;
  var READONLY = Column.flags.READONLY;
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var ALIAS_LABEL = platCryptoLex.get('cert.field.aliasPrompt');
  var SELECTED_LABEL = platCryptoLex.get('cert.import.chooser.editor.selectedLabel');
  var SELECTED_LABEL_TBL = platCryptoLex.get('cert.import.table.selected');
  var ALIAS_LABEL_TBL = platCryptoLex.get('cert.field.alias');
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var logSevere = log.severe.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-CertImportWidget'
      }
    };
  };

  /**
   * The widget for the `CertImportCommand`.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/platCrypto/rc/wb/cert/CertImportWidget
   */
  var CertImportWidget = /*#__PURE__*/function (_spandrel) {
    function CertImportWidget(params) {
      var _this;
      _classCallCheck(this, CertImportWidget);
      _this = _callSuper(this, CertImportWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        var _this$state = _this.state(),
          certs = _this$state.certs;
        var selCerts = certs.filter(function (cert) {
          return cert.selected;
        });
        if (selCerts.length < 1) {
          throw new Error(platCryptoLex.get('cert.import.chooser.noCertificatesSelected'));
        }
      });
      return _this;
    }
    _inherits(CertImportWidget, _spandrel);
    return _createClass(CertImportWidget, [{
      key: "toState",
      value: function toState(importMsg) {
        this.$origImportMsg = importMsg;
        this.$storeName = importMsg.storeName;
        var certs = importMsg.parsedData.certificates;
        if (!certs || certs.length === 0) {
          throw new Error(platCryptoLex.get('cert.import.chooser.editor.noCertificates'));
        }
        var selectedIdx = 0;
        return {
          certs: certs,
          selectedIdx: selectedIdx
        };
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        var origImportMsg = this.$origImportMsg;
        var parsedData = this.$origImportMsg.parsedData;
        parsedData.certificates = state.certs;
        return {
          storeName: origImportMsg.storeName,
          parsedData: parsedData
        };
      }
    }, {
      key: "getSelectedCert",
      value: function getSelectedCert() {
        var _this$state2 = this.state(),
          certs = _this$state2.certs,
          selectedIdx = _this$state2.selectedIdx;
        return certs[selectedIdx];
      }
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        this.$buildTableCols();
        dom.on(MODIFY_EVENT, '.-t-selected', function (e, ed) {
          ed.read().then(function (selected) {
            var selCert = _this2.getSelectedCert();
            selCert.selected = selected;
          })["catch"](logSevere);
        });
        dom.on(MODIFY_EVENT, '.-t-alias', function (e, ed) {
          ed.read().then(function (alias) {
            if (alias) {
              var cert = _this2.getSelectedCert();
              cert.alias = alias;
            }
          })["catch"](logSevere);
        });
        return _superPropGet(CertImportWidget, "doInitialize", this, 3)([dom]);
      }
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this3 = this;
        return _superPropGet(CertImportWidget, "doLoad", this, 1).apply(this, arguments).then(function () {
          var table = _this3.$getCertTable();
          var selection = table.$getSelection();
          selection.on('changed', _this3.$selectionChanged.bind(_this3));
          selection.select(0);
        });
      }

      /**
       * @private
       */
    }, {
      key: "$selectionChanged",
      value: function $selectionChanged() {
        var table = this.$getCertTable();
        var selection = table.$getSelection();
        this.$state.selectedIdx = selection.$anchor;
        return this.rerender();
      }

      /**
       * @private
       */
    }, {
      key: "$buildModel",
      value: function $buildModel() {
        var storeName = this.$storeName;
        var columns = this.$tableColumns;
        var certs = this.state().certs;
        var rows = [];
        for (var i = 0; i < certs.length; i++) {
          var certData = {
            selected: certs[i].selected,
            alias: certs[i].alias
          };
          var row = new Row(certData);
          rows.push(row);
          if (storeName === "userKeyStore") {
            break;
          }
        }
        return new TableModel({
          rows: rows,
          columns: columns
        });
      }

      /**
       * @private
       */
    }, {
      key: "$buildTableCols",
      value: function $buildTableCols() {
        var selectedCol = new Column('selected', {
          displayName: SELECTED_LABEL_TBL,
          flags: EDITABLE
        });
        selectedCol.setSortable(false);
        selectedCol.setHidable(false);
        selectedCol.getValueFor = function (row) {
          return String(row.getSubject().selected);
        };
        var aliasCol = new Column('alias', {
          displayName: ALIAS_LABEL_TBL,
          flags: EDITABLE | READONLY
        });
        aliasCol.setSortable(false);
        aliasCol.setHidable(false);
        aliasCol.getValueFor = function (row) {
          return String(row.getSubject().alias);
        };
        this.$tableColumns = [selectedCol, aliasCol];
      }
    }, {
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var certs = state.certs,
          selectedIdx = state.selectedIdx;
        var currCertEntry = certs[selectedIdx];
        var promptForAlias = currCertEntry.promptForAlias;
        var currCert = currCertEntry.certificate;
        var subtitle = platCryptoLex.get('cert.export.cert.info', currCert.issuedBy);
        var hideTable = certs.length === 1 || this.$storeName === 'userKeyStore';
        return [spandrel.jsx("div", {
          spandrelKey: "importCert"
        }, spandrel.jsx(CertHeader, {
          spandrelKey: "certHeader",
          value: currCert,
          properties: {
            subtitle: subtitle
          }
        }), spandrel.jsx("div", {
          className: "-t-tableContainer",
          style: {
            display: hideTable && 'none'
          }
        }, spandrel.jsx(Table, {
          value: this.$buildModel(),
          className: "-t-cert-table",
          spandrelKey: "certTable",
          properties: {
            fixedHeaders: true
          }
        })), spandrel.jsx("div", {
          className: "-t-settings",
          spandrelKey: "settings"
        }, spandrel.jsx("div", {
          className: "-t-settings-alias",
          spandrelKey: "settingsAlias"
        }, spandrel.jsx("span", {
          className: "-t-alias-label",
          spandrelKey: "aliasLabel"
        }, ALIAS_LABEL), spandrel.jsx("span", {
          spandrelKey: "alias",
          lax: true,
          bind: true,
          value: currCertEntry.alias,
          className: "-t-alias",
          enabled: promptForAlias
        })), spandrel.jsx("div", {
          className: "-t-settings-selected",
          spandrelKey: "settingsSelected",
          style: {
            display: hideTable && 'none'
          }
        }, spandrel.jsx(BooleanEditor, {
          className: "-t-selected",
          bind: true,
          lax: "true",
          value: currCertEntry.selected,
          spandrelKey: "selected",
          properties: {
            displayType: "checkbox",
            trueText: SELECTED_LABEL,
            falseText: SELECTED_LABEL
          }
        }))), spandrel.jsx(CertDetailsTabs, {
          value: currCert,
          spandrelKey: "certDetailTabs"
        }))];
      }

      /**
       * @private
       */
    }, {
      key: "$getCertHeader",
      value: function $getCertHeader() {
        return this.queryWidget("importCert/certHeader");
      }

      /**
       * @private
       */
    }, {
      key: "$getCertTable",
      value: function $getCertTable() {
        return this.queryWidget("importCert/*/certTable");
      }

      /**
       * @private
       */
    }, {
      key: "$getAliasLabel",
      value: function $getAliasLabel() {
        return this.jq().find('.-t-alias-label');
      }

      /**
       * @private
       */
    }, {
      key: "$getAlias",
      value: function $getAlias() {
        return this.queryWidget("importCert/settings/settingsAlias/alias");
      }

      /**
       * @private
       */
    }, {
      key: "$getSelected",
      value: function $getSelected() {
        return this.queryWidget("importCert/settings/settingsSelected/selected");
      }

      /**
       * @private
       */
    }, {
      key: "$getDetailTabs",
      value: function $getDetailTabs() {
        return this.queryWidget("importCert/certDetailTabs");
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return CertImportWidget;
});
