function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/CertImportFileMgr
 */
define(['baja!', 'lex!platCrypto', 'Promise', 'nmodule/webEditors/rc/fe/baja/FileInputEditor', 'nmodule/webEditors/rc/util/Switchboard', 'baja!baja:X509Certificate'], function (baja, lexs, Promise, FileInputEditor, Switchboard) {
  'use strict';

  /*eslint-env browser */ /*jshint browser: true */
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];

  /**
   * An editor for working with `baja:X509Certificate` instances.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/FileInputEditor
   * @alias module:nmodule/platCrypto/rc/wb/cert/commands/CertImportFileMgr
   */
  var CertImportFileMgr = function CertImportFileMgr() {
    var that = this;
    FileInputEditor.apply(this, arguments);
    that.validators().add(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        fileName = _ref2[0],
        x509cert = _ref2[1];
      this.$getErrorJq().text("");
      var certText = x509cert.encodeToString();
      this.$getClearButton().prop('disabled', false);
      if (!certText) {
        this.$getClearButton().prop('disabled', true);
        throw new Error(platCryptoLex.get('cert.import.chooser.dialog.noCertSelected'));
      }
      if (certText !== '' && !CertImportFileMgr.$isCertificateValid(certText)) {
        this.$getErrorJq().text(platCryptoLex.get('cert.import.chooser.invalidCert'));
        throw new Error(platCryptoLex.get('cert.import.chooser.invalidCert'));
      }
    });
    new Switchboard(this).allow('$getLastFileContents').oneAtATime();
  };

  // Extend and set up prototype chain
  CertImportFileMgr.prototype = Object.create(FileInputEditor.prototype);
  CertImportFileMgr.prototype.constructor = CertImportFileMgr;

  /**
   * Initialize the field editor. Add a label to the file input.
   *
   * @param {jQuery} dom
   */
  CertImportFileMgr.prototype.doInitialize = function (dom) {
    FileInputEditor.prototype.doInitialize.call(this, dom);
    dom.addClass('-t-CertImportFileMgr');
    this.$getInput().attr("accept", ".pem,.p12,.crt,.cer,.cert,application/x-pem-file");
    this.$getClearButton().prop('disabled', true);
    dom.append('  <div>\n' + '    <label class=\'certificate-import-error-label\'></label>\n' + '  </div>\n');
  };

  /**
   * Loads the SubjectDn of the certificate into the field editor.
   */
  CertImportFileMgr.prototype.doLoad = function () {
    return resetFileFields(this);
  };
  function resetFileFields(that) {
    that.jq().find('input[type=file]').val('');
    that.$lastChangedFile = undefined;
    that.$lastReadFile = undefined;
    that.$lastFileContents = undefined;
  }
  CertImportFileMgr.prototype.doModified = function (modified) {
    var that = this;
    if (modified === true) {
      return that.$getLastFileContents();
    }
  };

  //TODO: this moves to FileInputEditor
  /**
   * @private
   * @returns {Promise.<string>} the contents of the last selected file
   */
  CertImportFileMgr.prototype.$getLastFileContents = function () {
    FileInputEditor.prototype.doRead.apply(this, arguments);
    var that = this,
      lastUploadedFile = FileInputEditor.getLastUploadedFile(),
      lastReadFile = that.$lastReadFile;
    if (lastReadFile === lastUploadedFile) {
      return Promise.resolve(that.$lastFileContents);
    }
    return CertImportFileMgr.$readFileAsText(lastUploadedFile).then(function (text) {
      that.$lastFileContents = text;
      that.$lastReadFile = lastUploadedFile;
      return text;
    })["catch"](function () {
      throw new Error(platCryptoLex.get('cert.import.chooser.failedRead'));
    });
  };

  /**
   * Override FileInputEditor's doRead to jibe with default Widget#doRead.
   */
  CertImportFileMgr.prototype.doRead = function () {
    var that = this;
    return this.$getLastFileContents().then(function (text) {
      var lastFile = that.$lastReadFile;
      var fileName = lastFile ? lastFile.name : "";
      var cert = baja.$('baja:X509Certificate', text);
      return [fileName, cert];
    });
  };

  //TODO: this moves to FileInputEditor
  /**
   * Read the file and process successful and unsuccessful reads
   *
   * @private
   * @param {File} certFile the file to upload
   * @returns {Promise}
   */
  CertImportFileMgr.$readFileAsText = function (certFile) {
    var reader = new FileReader();

    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      reader.onload = function () {
        resolve(reader.result);
      };
      reader.onerror = function () {
        reject(reader.error);
      };
      reader.readAsText(certFile);
    });
  };

  /**
   * Saves the value of the selected file back to the server. Does some
   * simple validation to make sure the file is a PEM certificate.
   *
   * @private
   * @param {string} certificate a string representing the certificate (PEM format)
   */
  CertImportFileMgr.$isCertificateValid = function (certificate) {
    var certBeg = certificate.indexOf('-----BEGIN CERTIFICATE-----');
    var certEnd = certificate.indexOf('-----END CERTIFICATE-----');
    return certBeg !== -1 && certEnd !== -1 && certEnd > certBeg;
  };

  /**
   * @private
   */
  CertImportFileMgr.prototype.$getErrorJq = function () {
    return this.jq().find('.certificate-import-error-label');
  };

  /**
   * Implementation of the clearButton click event.
   * The button resets all the labels and clears the selected
   * file.
   */
  CertImportFileMgr.prototype.clearButton = function () {
    resetFileFields(this);
    this.setModified(true);
  };
  return CertImportFileMgr;
});
