function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/fe/extensions/KeyUsageEditor
 */
define(['lex!platCrypto', 'bajaux/spandrel', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/BooleanPicker', 'css!nmodule/platCrypto/rc/platCrypto'], function (lexs, spandrel, Widget, Promise, _, BooleanPicker) {
  'use strict';

  var miniFormFactor = Widget.formfactor.mini;
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var each = _.each,
    map = _.map;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-KeyUsageEditor',
        certUsage: 'server'
      }
    };
  };
  var DIGITAL_SIGNATURE = 1 << 7,
    NON_REPUDIATION = 1 << 6,
    KEY_ENCIPHERMENT = 1 << 5,
    DATA_ENCIPHERMENT = 1 << 4,
    KEY_AGREEMENT = 1 << 3,
    CERTIFICATE_SIGNING = 1 << 2,
    CRL_SIGNING = 1 << 1,
    ENCIPHER_ONLY = 1 << 0,
    DECIPHER_ONLY = 1 << 15;
  var certUsageToDefaultFlags = {
    server: DIGITAL_SIGNATURE | KEY_ENCIPHERMENT,
    client: DIGITAL_SIGNATURE,
    ca: CERTIFICATE_SIGNING | CRL_SIGNING,
    codeSigning: DIGITAL_SIGNATURE,
    custom: 0
  };
  var certUsageToReadonlyFlags = {
    server: DIGITAL_SIGNATURE | KEY_ENCIPHERMENT | CERTIFICATE_SIGNING | CRL_SIGNING,
    client: DIGITAL_SIGNATURE | CERTIFICATE_SIGNING | CRL_SIGNING,
    ca: CERTIFICATE_SIGNING | CRL_SIGNING,
    codeSigning: DIGITAL_SIGNATURE | CERTIFICATE_SIGNING | CRL_SIGNING,
    custom: 0
  };
  var indexToBitMask = [DIGITAL_SIGNATURE, NON_REPUDIATION, KEY_ENCIPHERMENT, DATA_ENCIPHERMENT, KEY_AGREEMENT, CERTIFICATE_SIGNING, CRL_SIGNING, ENCIPHER_ONLY, DECIPHER_ONLY];

  /**
   * Editor for KeyUsage Extension
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/fe/extensions/KeyUsageEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.13
   */
  var KeyUsageEditor = /*#__PURE__*/function (_spandrel) {
    function KeyUsageEditor(params) {
      _classCallCheck(this, KeyUsageEditor);
      return _callSuper(this, KeyUsageEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @param {String} certUsage
     * @returns {Array.<module:nmodule/webEditors/rc/fe/baja/BooleanPicker~Choice>}
     */
    _inherits(KeyUsageEditor, _spandrel);
    return _createClass(KeyUsageEditor, [{
      key: "$getChoices",
      value: function $getChoices(certUsage) {
        var choices = [];
        for (var i = 0; i < indexToBitMask.length; i++) {
          var readonly = (certUsageToReadonlyFlags[certUsage] & indexToBitMask[i]) !== 0;
          choices.push({
            value: i,
            display: platCryptoLex.get('cert.field.keyUsage.' + i),
            readonly: readonly
          });
        }
        return choices;
      }

      /**
       * @private
       * @param {Array.<module:nmodule/webEditors/rc/fe/baja/BooleanPicker~Choice>} choices
       * @param {Number} flags
       * @returns{Array.<Number>}
       */
    }, {
      key: "$getSelectedOrdinals",
      value: function $getSelectedOrdinals(choices, flags) {
        var selectedOrdinals = [];
        each(choices, function (choice, index) {
          if ((flags & indexToBitMask[index]) !== 0) {
            selectedOrdinals.push(index);
          }
        });
        return selectedOrdinals;
      }

      /**
       * @private
       * @param {Array.<module:nmodule/webEditors/rc/fe/baja/BooleanPicker~Choice>} choices
       * @param {Array.<Number>} selectedOrdinals
       * @returns{String}
       */
    }, {
      key: "$getPreviewText",
      value: function $getPreviewText(choices, selectedOrdinals) {
        return map(selectedOrdinals, function (ordinal) {
          return choices[ordinal].display;
        }).join(', ');
      }

      /**
       * @private
       * @param {String} certUsage
       * @returns {Promise}
       */
    }, {
      key: "$certificateChanged",
      value: function $certificateChanged(certUsage) {
        this.properties().setValue('certUsage', certUsage);
        var flags = certUsageToDefaultFlags[certUsage];
        if (flags) {
          return this.loadAndModify({
            flags: flags
          });
        }
        return Promise.resolve();
      }
    }, {
      key: "doRead",
      value: function doRead() {
        var picker = this.$getPicker();
        if (!picker) {
          return this.value();
        }
        return picker.read().then(function (selectedOrdinals) {
          var flags = 0;
          each(selectedOrdinals, function (selectedOrdinals) {
            flags |= indexToBitMask[selectedOrdinals];
          });
          return {
            flags: flags
          };
        });
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/BooleanPicker|undefined}
       */
    }, {
      key: "$getPicker",
      value: function $getPicker() {
        return this.queryWidget('picker');
      }
    }]);
  }(spandrel(function (value, _ref) {
    var self = _ref.self,
      formFactor = _ref.formFactor,
      writable = _ref.writable,
      properties = _ref.properties;
    var certUsage = properties.certUsage;
    var choices = self.$getChoices(certUsage);
    var flags = value && value.flags || 0;
    var selectedOrdinals = self.$getSelectedOrdinals(choices, flags);
    var isMini = formFactor === miniFormFactor;
    if (!writable || isMini) {
      var _toString = self.$getPreviewText(choices, selectedOrdinals);
      return [spandrel.jsx("textarea", {
        rows: "4",
        cols: "35",
        readOnly: true
      }, _toString)];
    }
    return [spandrel.jsx(BooleanPicker, {
      spandrelKey: "picker",
      value: selectedOrdinals,
      properties: {
        choices: choices
      }
    })];
  }, {
    strategy: 'niagara'
  }));
  KeyUsageEditor.DIGITAL_SIGNATURE = DIGITAL_SIGNATURE;
  KeyUsageEditor.NON_REPUDIATION = NON_REPUDIATION;
  KeyUsageEditor.KEY_ENCIPHERMENT = KEY_ENCIPHERMENT;
  KeyUsageEditor.DATA_ENCIPHERMENT = DATA_ENCIPHERMENT;
  KeyUsageEditor.KEY_AGREEMENT = KEY_AGREEMENT;
  KeyUsageEditor.CERTIFICATE_SIGNING = CERTIFICATE_SIGNING;
  KeyUsageEditor.CRL_SIGNING = CRL_SIGNING;
  KeyUsageEditor.ENCIPHER_ONLY = ENCIPHER_ONLY;
  KeyUsageEditor.DECIPHER_ONLY = DECIPHER_ONLY;
  return KeyUsageEditor;
});
