function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/hierarchy/rc/bs/levelElemMenuAgent
 */
define(['bajaux/commands/CommandGroup', 'Promise', 'nmodule/webEditors/rc/wb/menu/menuUtils'], function (CommandGroup, Promise, menuUtils) {
  'use strict';

  var ifAllowedByProfile = menuUtils.ifAllowedByProfile,
    makeViewsGroup = menuUtils.makeViewsGroup,
    makeActionsGroup = menuUtils.makeActionsGroup;

  /**
   * Asynchronously require the appropriate command modules and instantiate
   * the `CommandGroup`. Assign the appropriate enabled/disabled status for
   * the different commands depending on the write/invoke permissions on this
   * component.
   *
   * @inner
   * @param {module:bajaux/Widget} widget
   * @param {baja.Component} comp
   * @returns {Promise}
   */
  function makeGroup(widget, comp, rootComp) {
    var group = new CommandGroup();
    return Promise.all([ifAllowedByProfile('viewSelection', function () {
      return makeViewsGroup(comp.getNavOrd());
    }), makeActionsGroup(rootComp)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        viewsGroup = _ref2[0],
        actionGroup = _ref2[1];
      if (viewsGroup) {
        group.add(viewsGroup);
      }
      group.add(actionGroup);
      return group;
    });
    // return makeActionsGroup(rootComp);
  }

  /**
   * Create a command group that can be used to construct a context menu. Note
   * that the component, if mounted, will be leased at this time so any
   * dynamic actions can be included in the menu.
   *
   * @alias module:nmodule/hierarchy/rc/bs/levelElemMenuAgent
   * @param {module:bajaux/Widget} widget
   * @param {baja.Component} comp
   * @returns {Promise} promise to be resolved with a `CommandGroup`
   * for the given component
   */
  var levelElemMenuAgent = function componentMenuAgent(widget, comp) {
    return comp.getNavOrd().resolve({
      lease: true
    }).then(function (target) {
      return makeGroup(widget, comp, target.getComponent());
    });
  };
  return levelElemMenuAgent;
});
