function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/model/columns/ObjectOrdMgrColumn
 * @since Niagara 4.14
 */

define(['baja!', 'baja!bacnet:BacnetExportFolder', 'log!nmodule.bacnet.rc.wb.mgr.model.columns.ObjectOrdMgrColumn', 'Promise', 'nmodule/bacnet/rc/wb/mgr/model/columns/ExportObjectMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn'], function (baja, types, log, Promise, ExportObjectMgrColumn, MgrColumn) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var _types = _slicedToArray(types, 1),
    BACNET_EXPORT_FOLDER_TYPE = _types[0];

  /**
   * @alias module:nmodule/bacnet/rc/wb/mgr/model/columns/ObjectOrdMgrColumn
   * @extends module:nmodule/bacnet/rc/wb/mgr/model/columns/ExportObjectMgrColumn
   */
  return /*#__PURE__*/function (_ExportObjectMgrColum) {
    function ObjectOrdMgrColumn() {
      _classCallCheck(this, ObjectOrdMgrColumn);
      return _callSuper(this, ObjectOrdMgrColumn, arguments);
    }
    _inherits(ObjectOrdMgrColumn, _ExportObjectMgrColum);
    return _createClass(ObjectOrdMgrColumn, [{
      key: "getValueFor",
      value:
      /**
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row 
       * @returns {baja.Ord}
       */
      function getValueFor(row) {
        var value = _superPropGet(ObjectOrdMgrColumn, "getValueFor", this, 3)(arguments);
        return value && baja.Ord.make(value) || baja.Ord.DEFAULT;
      }

      /**
       * Determines if the editor needs to be rebuilt by determining if the editor should be
       * readonly and checking that against the editors current state
       * @param {module:nmodule/webEditors/rc/fe/baja/BaseEditor} editor
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {Boolean}
       */
    }, {
      key: "isEditorSuitable",
      value: function isEditorSuitable(editor, rows) {
        var setReadonly = rows.length !== 1;
        return editor.isReadonly() === setReadonly;
      }

      /**
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows 
       * @returns {Object}
       */
    }, {
      key: "getConfigFor",
      value: function getConfigFor(rows) {
        var config = _superPropGet(ObjectOrdMgrColumn, "getConfigFor", this, 3)(arguments);
        // Set readonly if more than one row is selected
        config.readonly = rows.length > 1;
        return config;
      }

      /**
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows 
       * @returns {*}
       */
    }, {
      key: "coalesceRows",
      value: function coalesceRows(rows) {
        if (rows.length > 1) {
          return _superPropGet(ObjectOrdMgrColumn, "coalesceRows", this, 3)(arguments);
        }
        var value = rows[0].getSubject();
        if (value.getType().is(BACNET_EXPORT_FOLDER_TYPE)) {
          throw new Error();
        }
        return _superPropGet(ObjectOrdMgrColumn, "coalesceRows", this, 3)(arguments);
      }

      /**
       * @param {*} value 
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row 
       * @param {Object} [params] 
       * @returns {Promise}
       */
    }, {
      key: "commit",
      value: function commit(value, row, params) {
        var progressCallback = params && params.progressCallback,
          exportComp = row.getSubject();
        var prom = this.$setObjectOrd(exportComp, value);
        if (progressCallback) {
          progressCallback(MgrColumn.COMMIT_READY);
        }
        return prom;
      }

      /**
       * @private
       * @param {baja.Component} exportComp 
       * @param {baja.Ord} objectOrd 
       * @returns {Promise}
       */
    }, {
      key: "$setObjectOrd",
      value: function $setObjectOrd(exportComp, objectOrd) {
        // TODO - NCCB-59639
        var type = exportComp.getType();
        if (type.is('bacnet:BacnetPointDescriptor') && typeof exportComp.setPointOrd === 'function') {
          return exportComp.setPointOrd(objectOrd);
        } else if (type.is('bacnet:BacnetScheduleDescriptor') && typeof exportComp.setScheduleOrd === 'function') {
          return exportComp.setScheduleOrd(objectOrd);
        } else if (type.is('bacnet:BacnetCalendarDescriptor') && typeof exportComp.setCalendarOrd === 'function') {
          return exportComp.setCalendarOrd(objectOrd);
        } else if (type.is('bacnet:BacnetEventEnrollmentDescriptor') && typeof exportComp.setEventEnrollmentOrd === 'function') {
          return exportComp.setEventEnrollmentOrd(objectOrd);
        } else if (type.is('bacnet:BacnetNotificationClassDescriptor') && typeof exportComp.setAlarmClassOrd === 'function') {
          return exportComp.setAlarmClassOrd(objectOrd);
        } else if (type.is('bacnet:BacnetNiagaraHistoryDescriptor') && typeof exportComp.setHistoryOrd === 'function') {
          return exportComp.setHistoryOrd(objectOrd);
        } else {
          logSevere("Unsupported type: " + type.toString());
        }
        return Promise.resolve();
      }
    }]);
  }(ExportObjectMgrColumn);
});
