function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/model/columns/BacnetWritableMgrColumn
 */
define(['baja!', 'baja!bacnet:BacnetPointDescriptor', 'lex!bacnet', 'Promise', 'underscore', 'nmodule/bacnet/rc/fe/WritableSlotsEditor', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, Promise, _, WritableSlotsEditor, MgrColumn, Column) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bacnetLex = _lexs[0];
  var EDITABLE = Column.flags.EDITABLE;
  var NOT_WRITABLE_TEXT = bacnetLex.get('server.notWritable');

  /**
   * BacnetWritableMgrColumn is a MgrColumn for editing the BACnet writability of a `bacnet:IBacnetExportObject`.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/model/columns/BacnetWritableMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   * @since Niagara 4.14
   */
  var BacnetWritableMgrColumn = /*#__PURE__*/function (_MgrColumn) {
    function BacnetWritableMgrColumn(typeColumn, objectOrdColumn) {
      var _this;
      _classCallCheck(this, BacnetWritableMgrColumn);
      _this = _callSuper(this, BacnetWritableMgrColumn, ['__bacnetWritable', {
        flags: EDITABLE
      }]);
      _this.$typeColumn = typeColumn;
      _this.$objectOrdColumn = objectOrdColumn;
      return _this;
    }
    _inherits(BacnetWritableMgrColumn, _MgrColumn);
    return _createClass(BacnetWritableMgrColumn, [{
      key: "toDisplayName",
      value: function toDisplayName() {
        return Promise.resolve(bacnetLex.get('exportManager.writable'));
      }
    }, {
      key: "buildCell",
      value: function buildCell(row, dom) {
        var text = '';
        var type = this.$typeColumn.getProposedValueFor(row);
        if (type.is('bacnet:BacnetPointDescriptor')) {
          var bacnetWritable = this.getProposedValueFor(row);
          text = bacnetWritable || NOT_WRITABLE_TEXT;
        }
        dom.text(text);
        return Promise.resolve();
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {baja.Component}
       */
    }, {
      key: "$getComponent",
      value: function $getComponent(row) {
        return row.getSubject();
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var complex = this.$getComponent(row);
        var bacnetWritable = complex.get('bacnetWritable');
        return bacnetWritable || '';
      }
    }, {
      key: "getConfigFor",
      value: function getConfigFor(rows) {
        var config = _superPropGet(BacnetWritableMgrColumn, "getConfigFor", this, 3)(arguments);
        config.type = WritableSlotsEditor;
        config.properties = {
          enablePopOut: false
        };
        return config;
      }
    }, {
      key: "coalesceRows",
      value: function coalesceRows(rows) {
        var _this2 = this;
        rows.forEach(function (row) {
          var complex = _this2.$getComponent(row);
          if (complex.get('bacnetWritable') === null) {
            throw new Error('cannot edit a non-BacnetWritableDescriptor');
          }
        });
        return _superPropGet(BacnetWritableMgrColumn, "coalesceRows", this, 3)(arguments);
      }

      /**
       * @param {String} value
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {object} params
       * @param {function} [params.progressCallback]
       * @returns {Promise}
       */
    }, {
      key: "commit",
      value: function commit(value, row, _ref) {
        var progressCallback = _ref.progressCallback;
        function commitReady(prom) {
          if (progressCallback) {
            progressCallback(MgrColumn.COMMIT_READY);
          }
          return prom || Promise.resolve();
        }
        var complex = this.$getComponent(row);
        if (complex.get('bacnetWritable') == null) {
          return commitReady();
        }

        // Reset writable if no target is set (mounted or unmounted)
        //TODO NCCB-59904: once the makeWritable action can handle pointOrd changes, this may need to be adjusted to let the action
        //do this work so that the outdated automated links can be removed too.*/
        var ord = this.$objectOrdColumn.getProposedValueFor(row);
        if (ord.equals(baja.Ord.DEFAULT)) {
          return commitReady(complex.set({
            slot: 'bacnetWritable',
            value: NOT_WRITABLE_TEXT
          }));
        }
        if (!complex.isMounted()) {
          return commitReady(complex.set({
            slot: 'bacnetWritable',
            value: value
          }));
        }
        return commitReady(BacnetWritableMgrColumn.$invokeActionOnBacnetWritables([complex], [value]));
      }

      /**
       * When a manager is finished adding new instances, this static method can be called
       * to call the necessary `makeWritable` action on each `bacnetWritable`.
       * @param {Array.<baja.Component>} instances
       * @return {Promise}
       */
    }], [{
      key: "afterAddInstances",
      value: function afterAddInstances(instances) {
        return BacnetWritableMgrColumn.$invokeActionOnBacnetWritables(instances);
      }

      /**
       * @private
       * @param {Array.<baja.Component>} instances
       * @param {Array.<String>} [bacnetWritableValues] if provided, use this value for the makeWritable argument
       * @returns {Promise}
       */
    }, {
      key: "$invokeActionOnBacnetWritables",
      value: function $invokeActionOnBacnetWritables(instances, bacnetWritableValues) {
        return Promise.all(_.map(instances, function (instance, index) {
          var value = instance.get('bacnetWritable');
          if (bacnetWritableValues && bacnetWritableValues[index] !== undefined) {
            value = bacnetWritableValues[index];
          }
          return value !== null && instance.invoke({
            slot: 'makeWritable',
            value: value
          });
        }));
      }
    }]);
  }(MgrColumn);
  return BacnetWritableMgrColumn;
});
