function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/model/BacnetScheduleExportModel
 * @since Niagara 4.14
 */

define(['baja!', 'baja!bacnet:BacnetScheduleExport', 'lex!bacnet', 'nmodule/driver/rc/wb/mgr/schedule/ScheduleExportModel', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/table/model/Column', 'Promise', 'underscore'], function (baja, types, lexs, ScheduleExportModel, PropertyMgrColumn, NameMgrColumn, TypeMgrColumn, MgrTypeInfo, Column, Promise, _) {
  'use strict';

  var findIndex = _.findIndex;
  var COLUMNS = ScheduleExportModel.COLUMNS;
  var _lexs = _slicedToArray(lexs, 1),
    BACNET_LEX = _lexs[0];
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    READONLY = _Column$flags.READONLY,
    UNSEEN = _Column$flags.UNSEEN;
  var _types = _slicedToArray(types, 1),
    BACNET_SCHEDULE_EXPORT_TYPE = _types[0];

  /**
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/model/BacnetScheduleExportModel
   * @extends module:nmodule/driver/rc/wb/mgr/schedule/ScheduleExportModel
   */
  return /*#__PURE__*/function (_ScheduleExportModel) {
    function BacnetScheduleExportModel() {
      _classCallCheck(this, BacnetScheduleExportModel);
      return _callSuper(this, BacnetScheduleExportModel, arguments);
    }
    _inherits(BacnetScheduleExportModel, _ScheduleExportModel);
    return _createClass(BacnetScheduleExportModel, [{
      key: "addInstances",
      value:
      /**
       * 
       * @param {Array.<baja.Component>} instances the instances to add
       * @param {Array.<String>} [names] the desired slot names for the instances.
       * @returns {Promise.<Array.<baja.Component>>} 
       */
      function addInstances(instances, names) {
        var idx = instances.findIndex(function (instance) {
          return String(instance.get('supervisorOrd')) === 'null';
        });
        var name;
        if (idx > -1) {
          name = names && names.length > 0 ? names[idx] : String(instances[idx].getName());
          return Promise.reject(new Error(BACNET_LEX.get('scheduleManager.export.invalidOrd', 'null', name)));
        }
        return _superPropGet(BacnetScheduleExportModel, "addInstances", this, 3)(arguments);
      }
    }], [{
      key: "make",
      value:
      /**
       * @param {baja.Component} scheduleContainer
       * @returns Promise.<module:nmodule/bacnet/rc/wb/mgr/model/BacnetScheduleExportModel>}
       */
      function make(scheduleContainer) {
        var scheduleModelCols = COLUMNS.slice();

        // Insert "name" and "type" columns
        scheduleModelCols.splice(1, 0, new NameMgrColumn({
          flags: EDITABLE
        }));
        scheduleModelCols.splice(2, 0, new TypeMgrColumn({
          flags: UNSEEN
        }));

        // Replace the "supervisorId" column with "objectId"
        var supIdColIndex = findIndex(scheduleModelCols, function (col) {
          return col.getName() === 'supervisorId';
        });
        scheduleModelCols.splice(supIdColIndex, 1, new PropertyMgrColumn('objectId', {
          displayName: BACNET_LEX.get('learn.objectId'),
          type: BACNET_SCHEDULE_EXPORT_TYPE,
          flags: EDITABLE
        }));

        //Insert "supervisorOrd" column
        scheduleModelCols.splice(supIdColIndex + 1, 0, new PropertyMgrColumn('supervisorOrd', {
          type: BACNET_SCHEDULE_EXPORT_TYPE,
          flags: EDITABLE
        }));

        // Add the "dataType" column
        var dataTypeCol = new PropertyMgrColumn('dataType', {
          displayName: BACNET_LEX.get('scheduleManager.dataType'),
          type: BACNET_SCHEDULE_EXPORT_TYPE,
          flags: EDITABLE | READONLY
        });
        scheduleModelCols.push(dataTypeCol);

        // Add the "priorityForWriting" column
        var priorityForWritingCol = new PropertyMgrColumn('priorityForWriting', {
          type: BACNET_SCHEDULE_EXPORT_TYPE,
          flags: EDITABLE
        });
        scheduleModelCols.push(priorityForWritingCol);

        // Add the "skipWrites" column
        var skipWritesCol = new PropertyMgrColumn('skipWrites', {
          type: BACNET_SCHEDULE_EXPORT_TYPE,
          flags: EDITABLE | UNSEEN
        });
        scheduleModelCols.push(skipWritesCol);

        // Add the "writeEnumAs" column
        var writeEnumAsCol = new PropertyMgrColumn('writeEnumAs', {
          type: BACNET_SCHEDULE_EXPORT_TYPE,
          flags: EDITABLE | UNSEEN
        });
        scheduleModelCols.push(writeEnumAsCol);

        // Add the "outOfService" column
        var outOfServiceCol = new PropertyMgrColumn('outOfService', {
          type: BACNET_SCHEDULE_EXPORT_TYPE,
          flags: EDITABLE | UNSEEN
        });
        scheduleModelCols.push(outOfServiceCol);

        // Make the status column unseen
        var statusCol = scheduleModelCols.find(function (col) {
          return col.getName() === 'status';
        });
        statusCol && statusCol.setUnseen(true);
        return MgrTypeInfo.make({
          from: 'bacnet:BacnetScheduleExport'
        }).then(function (typeInfo) {
          return ScheduleExportModel.make(scheduleContainer, {
            mgrModelConstructor: BacnetScheduleExportModel,
            newTypes: [typeInfo],
            columns: scheduleModelCols
          });
        });
      }
    }]);
  }(ScheduleExportModel);
});
