function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/model/BacnetHistoryImportModel
 * @since Niagara 4.14
 */

define(['baja!', 'baja!driver:HistoryImport,bacnet:BacnetHistoryImport,bacnet:BacnetObjectIdentifier', 'lex!bacnet,driver', 'nmodule/bacnet/rc/wb/mgr/model/columns/LocalHistoryNameColumn', 'nmodule/driver/rc/wb/mgr/history/HistoryImportModel', 'nmodule/driver/rc/wb/mgr/history/historyMgrUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'Promise', 'underscore'], function (baja, types, lexs, LocalHistoryNameColumn, HistoryImportModel, historyMgrUtils, MgrTypeInfo, Column, PropertyMgrColumn, PropertyPathMgrColumn, Promise, _) {
  'use strict';

  var getImportMgrColumns = historyMgrUtils.getImportMgrColumns,
    getArchiveMgrColumns = historyMgrUtils.getArchiveMgrColumns;
  var _types = _slicedToArray(types, 2),
    HISTORY_IMPORT_TYPE = _types[0],
    BACNET_HISTORY_IMPORT = _types[1];
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN,
    READONLY = _Column$flags.READONLY;
  var findIndex = _.findIndex;
  var _lexs = _slicedToArray(lexs, 2),
    BACNET_LEX = _lexs[0],
    DRIVER_LEX = _lexs[1];
  function niagaraSpecificColumns() {
    return [new PropertyMgrColumn('onDemandPollEnabled', {
      type: HISTORY_IMPORT_TYPE,
      flags: EDITABLE
    }), new PropertyMgrColumn('onDemandPollFrequency', {
      type: HISTORY_IMPORT_TYPE,
      flags: EDITABLE
    })];
  }
  function getTimeZoneColumn() {
    return new PropertyPathMgrColumn('configOverrides/timeZone', {
      displayName: DRIVER_LEX.get('HistoryConfig.timeZone'),
      flags: EDITABLE | UNSEEN,
      getDefaultValue: function getDefaultValue() {
        return baja.TimeZone.DEFAULT;
      }
    });
  }
  function getBacnetColumns() {
    return [new PropertyMgrColumn('localHistoryNameFormat', {
      type: BACNET_HISTORY_IMPORT,
      flags: EDITABLE | UNSEEN
    }), new LocalHistoryNameColumn('localHistoryName', {
      type: BACNET_HISTORY_IMPORT
    }), new PropertyMgrColumn('discoveryHistoryType', {
      type: BACNET_HISTORY_IMPORT,
      flags: EDITABLE | READONLY | UNSEEN
    }), new PropertyMgrColumn('alwaysRequestByReferenceTime', {
      type: BACNET_HISTORY_IMPORT,
      flags: EDITABLE | UNSEEN
    })];
  }
  function getNewTypes(newTypes, importTypes) {
    // Filter only the supported import types
    var supportedTypes = [];
    if (importTypes) {
      supportedTypes = importTypes.split(';');
    }
    return newTypes.filter(function (mgrType) {
      return supportedTypes.contains(mgrType.getType().getTypeSpec());
    });
  }

  /**
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/model/BacnetHistoryImportModel
   * @extends module:nmodule/driver/rc/wb/mgr/history/HistoryImportModel
   */
  return /*#__PURE__*/function (_HistoryImportModel) {
    function BacnetHistoryImportModel() {
      _classCallCheck(this, BacnetHistoryImportModel);
      return _callSuper(this, BacnetHistoryImportModel, arguments);
    }
    _inherits(BacnetHistoryImportModel, _HistoryImportModel);
    return _createClass(BacnetHistoryImportModel, [{
      key: "newInstance",
      value:
      /**
       * Override to ensure a default timeZone is set
       * @param {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} typeInfo 
       * @returns {Promise}
       */
      function newInstance(typeInfo) {
        return _superPropGet(BacnetHistoryImportModel, "newInstance", this, 3)([typeInfo]).then(function (historyImportComp) {
          var configOverrides = historyImportComp.get('configOverrides');
          if (!configOverrides.has('timeZone')) {
            return configOverrides.add({
              slot: 'timeZone',
              value: baja.TimeZone.DEFAULT
            }).then(function () {
              return historyImportComp;
            });
          }
          return historyImportComp;
        });
      }
    }], [{
      key: "make",
      value: function make(trendLogsContainer) {
        var importColumns = getImportMgrColumns();
        var niagaraColumns = niagaraSpecificColumns();
        var archiveColumns = getArchiveMgrColumns({
          includesType: true
        });
        var bacnetColumns = getBacnetColumns();
        var historyIdIndex = findIndex(archiveColumns, function (col) {
          return col.getName() === 'historyId';
        });
        archiveColumns[historyIdIndex] = new PropertyPathMgrColumn('objectId', {
          displayName: BACNET_LEX.get('learn.objectId'),
          type: BACNET_HISTORY_IMPORT,
          flags: EDITABLE
        });
        return Promise.all([MgrTypeInfo.make({
          from: 'bacnet:AbstractBacnetHistory',
          concreteTypes: true
        }), trendLogsContainer.invoke({
          slot: 'getImportTypes'
        })]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            newTypes = _ref2[0],
            importTypes = _ref2[1];
          return HistoryImportModel.make(trendLogsContainer, {
            mgrModelConstructor: BacnetHistoryImportModel,
            newTypes: getNewTypes(newTypes, importTypes),
            columns: archiveColumns.concat(importColumns).concat(niagaraColumns).concat([getTimeZoneColumn()]).concat(bacnetColumns)
          });
        });
      }
    }]);
  }(HistoryImportModel);
});
