function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/model/BacnetExportModel
 * @since Niagara 4.14
 */

define(['baja!', 'baja!bacnet:IBacnetExportFolder,bacnet:BacnetExportFolder,bacnet:NextInstArgs,bacnet:BacnetExportTable', 'lex!bacnet', 'Promise', 'underscore', 'nmodule/bacnet/rc/baja/datatypes/BacnetObjectIdentifier', 'nmodule/bacnet/rc/wb/mgr/model/columns/BacnetExportObjectTypeMgrColumn', 'nmodule/bacnet/rc/wb/mgr/model/columns/BacnetWritableMgrColumn', 'nmodule/bacnet/rc/wb/mgr/model/columns/ExportObjectMgrColumn', 'nmodule/bacnet/rc/wb/mgr/model/columns/FriendlyObjectTypePropertyMgrColumn', 'nmodule/bacnet/rc/wb/mgr/model/columns/InstanceNumberPropertyMgrColumn', 'nmodule/bacnet/rc/wb/mgr/model/columns/ObjectOrdMgrColumn', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/folderMgrModelMixin', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource'], function (baja, types, lexs, Promise, _, BacnetObjectIdentifier, BacnetExportObjectTypeMgrColumn, BacnetWritableMgrColumn, ExportObjectMgrColumn, FriendlyObjectTypePropertyMgrColumn, InstanceNumberPropertyMgrColumn, ObjectOrdMgrColumn, compUtils, MgrTypeInfo, IconMgrColumn, NameMgrColumn, PropertyMgrColumn, addFolderMgrModelMixin, MgrModel, Column, ContainerComponentSource) {
  'use strict';

  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN,
    READONLY = _Column$flags.READONLY;
  var _lexs = _slicedToArray(lexs, 1),
    BACNET_LEX = _lexs[0];
  var closest = compUtils.closest;
  var memoize = _.memoize;
  var typeColumn = new BacnetExportObjectTypeMgrColumn({
    flags: EDITABLE | UNSEEN
  });
  var objectOrdColumn = new ObjectOrdMgrColumn('objectOrd', {
    displayName: BACNET_LEX.get('exportManager.exportOrd'),
    flags: EDITABLE | UNSEEN
  });
  var COLUMNS = [new IconMgrColumn(), new NameMgrColumn({
    flags: UNSEEN | EDITABLE | READONLY
  }), new ExportObjectMgrColumn('targetName', {
    displayName: BACNET_LEX.get('exportManager.targetName'),
    flags: READONLY
  }), new PropertyMgrColumn('objectName', {
    displayName: BACNET_LEX.get('exportManager.objectName'),
    flags: EDITABLE
  }), typeColumn, new FriendlyObjectTypePropertyMgrColumn('objectType', {
    displayName: BACNET_LEX.get('exportManager.objectType'),
    flags: EDITABLE | READONLY
  }), new InstanceNumberPropertyMgrColumn('instanceNumber', {
    displayName: BACNET_LEX.get('exportManager.instanceNumber'),
    flags: EDITABLE | UNSEEN
  }), new ExportObjectMgrColumn('targetOutput', {
    displayName: BACNET_LEX.get('exportManager.out')
  }), objectOrdColumn, new PropertyMgrColumn('status', {
    displayName: BACNET_LEX.get('exportManager.exportStatus')
  }), new PropertyMgrColumn('faultCause', {
    displayName: BACNET_LEX.get('exportManager.faultCause'),
    flags: UNSEEN
  }), new PropertyMgrColumn('description', {
    displayName: BACNET_LEX.get('exportManager.description'),
    flags: EDITABLE | UNSEEN
  }), new BacnetWritableMgrColumn(typeColumn, objectOrdColumn)];
  var NEW_TYPES = ['bacnet:BacnetAnalogInputDescriptor', 'bacnet:BacnetAnalogOutputDescriptor', 'bacnet:BacnetAnalogValueDescriptor', 'bacnet:BacnetAnalogValuePrioritizedDescriptor', 'bacnet:BacnetLargeAnalogValueDescriptor', 'bacnet:BacnetLargeAnalogValuePrioritizedDescriptor', 'bacnet:BacnetBinaryInputDescriptor', 'bacnet:BacnetBinaryOutputDescriptor', 'bacnet:BacnetBinaryValueDescriptor', 'bacnet:BacnetBinaryValuePrioritizedDescriptor', 'bacnet:BacnetMultiStateInputDescriptor', 'bacnet:BacnetMultiStateOutputDescriptor', 'bacnet:BacnetMultiStateValueDescriptor', 'bacnet:BacnetMultiStateValuePrioritizedDescriptor', 'bacnet:BacnetNotificationClassDescriptor', 'bacnet:BacnetBooleanScheduleDescriptor', 'bacnet:BacnetNumericScheduleDescriptor', 'bacnet:BacnetEnumScheduleDescriptor', 'bacnet:BacnetStringScheduleDescriptor', 'bacnet:BacnetCalendarDescriptor', 'bacnet:BacnetCharacterStringDescriptor'];

  /**
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/model/BacnetExportModel
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrModel
   */
  var BacnetExportModel = /*#__PURE__*/function (_MgrModel) {
    function BacnetExportModel() {
      _classCallCheck(this, BacnetExportModel);
      return _callSuper(this, BacnetExportModel, arguments);
    }
    _inherits(BacnetExportModel, _MgrModel);
    return _createClass(BacnetExportModel, [{
      key: "addInstances",
      value: function addInstances(instances, names) {
        return _superPropGet(BacnetExportModel, "addInstances", this, 3)(arguments).then(function (instances) {
          return BacnetWritableMgrColumn.afterAddInstances(instances);
        });
      }
    }, {
      key: "newInstances",
      value: function newInstances(_ref) {
        var _this = this;
        var typeInfo = _ref.typeInfo,
          count = _ref.count;
        return _superPropGet(BacnetExportModel, "newInstances", this, 3)(arguments).then(function (exportComps) {
          return Promise.all(exportComps.map(function (exportComp, i) {
            var objectType = exportComp.getObjectId().getObjectType();
            return _this.$generateInstanceNumber(objectType).then(function (instanceNumber) {
              return exportComp.setObjectId(BacnetObjectIdentifier.make(objectType, instanceNumber + i));
            }).then(function () {
              return exportComp;
            });
          }));
        });
      }

      /**
       * @private
       * @param {module:nmodule/bacnet/rc/baja/enums/BacnetObjectType} objectType
       * @returns {Promise.<Number>}
       */
    }, {
      key: "$generateInstanceNumber",
      value: function $generateInstanceNumber(objectType) {
        var exportTable = closest(this.getComponentSource().getContainer(), 'bacnet:BacnetExportTable');
        if (!exportTable) {
          return Promise.resolve(0);
        }
        var getNextInst = memoize(function (objectType) {
          return exportTable.invoke({
            slot: 'getNextInst',
            value: baja.$('bacnet:NextInstArgs', {
              objectType: objectType
            })
          });
        });
        return getNextInst(objectType);
      }

      /**
       * Provides special handling for the row
       * @private
       * @param exportContainer
       * @param row
       * @returns {Promise}
       */
    }], [{
      key: "make",
      value: function make(exportContainer) {
        var _this2 = this;
        return Promise.all([MgrTypeInfo.make({
          from: NEW_TYPES
        }), MgrTypeInfo.make({
          from: 'bacnet:IBacnetExportObject',
          concreteTypes: true
        })]).then(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 2),
            newTypes = _ref3[0],
            allMgrExportTypes = _ref3[1];
          var acceptedTypes = allMgrExportTypes.filter(function (mgrType) {
            return !mgrType.getType().is('bacnet:BacnetFileDescriptor') && !mgrType.getType().is('bacnet:BacnetNiagaraHistoryDescriptor') && !mgrType.getType().is('bacnet:BacnetTrendLogDescriptor');
          }).map(function (mgrType) {
            return mgrType.getType();
          });
          return MgrModel.$makeAsync(BacnetExportModel, {
            componentSource: new ContainerComponentSource({
              container: exportContainer,
              filter: acceptedTypes
            }),
            newTypes: newTypes,
            columns: COLUMNS
          }, function (row) {
            return _this2.$processRow(exportContainer, row);
          });
        }).then(function (model) {
          addFolderMgrModelMixin(model, {
            folderType: baja.lt('bacnet:BacnetExportFolder')
          });
          return model;
        });
      }
    }, {
      key: "$processRow",
      value: function $processRow(exportContainer, row) {
        var comp = row.getSubject();
        // There is a possibility that component might not be mounted any longer when we get here.
        //  This was discovered when new test started to fail.
        var slotPath = comp.getSlotPath();
        if (slotPath) {
          return exportContainer.rpc('getExportData', comp.getSlotPath().getBody(), {}).then(function (result) {
            row.data('exportObjectValue', result);
          });
        }
        return Promise.resolve();
      }
    }]);
  }(MgrModel);
  return BacnetExportModel;
});
