/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'baja!bacnet:BacnetAddress,bacnet:BacnetDevice,bacnet:BacnetDeviceObject,driver:Device', 'lex!bacnet', 'nmodule/bacnet/rc/wb/mgr/model/columns/DeviceIdMgrColumn', 'nmodule/bacnet/rc/wb/mgr/model/columns/MacAddressMgrColumn', 'nmodule/driver/rc/wb/mgr/DeviceMgrModel', 'nmodule/driver/rc/wb/mgr/columns/DeviceExtsMgrColumn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, DeviceIdMgrColumn, MacAddressMgrColumn, DeviceMgrModel, DeviceExtsMgrColumn, MgrTypeInfo, NameMgrColumn, PropertyMgrColumn, PropertyPathMgrColumn, IconMgrColumn, Column) {
  'use strict';

  var BACNET_ADDRESS_TYPE = baja.lt('bacnet:BacnetAddress'),
    BACNET_DEVICE_TYPE = baja.lt('bacnet:BacnetDevice'),
    DEVICE_OBJECT_TYPE = baja.lt('bacnet:BacnetDeviceObject'),
    DEVICE_TYPE = baja.lt('driver:Device'),
    EDITABLE = Column.flags.EDITABLE,
    READONLY = Column.flags.READONLY,
    UNSEEN = Column.flags.UNSEEN,
    bacnetLex = lexs[0];
  function lex(key) {
    return bacnetLex.get(key);
  }
  var COLUMNS = [new IconMgrColumn(), new NameMgrColumn({
    flags: EDITABLE
  }), new DeviceExtsMgrColumn('exts', {
    component: baja.$('bacnet:BacnetDevice')
  }), new DeviceIdMgrColumn(), new PropertyMgrColumn('status', {
    type: DEVICE_TYPE,
    flags: READONLY
  }), new PropertyPathMgrColumn('address/networkNumber', {
    displayName: lex('deviceManager.network'),
    type: BACNET_ADDRESS_TYPE,
    flags: EDITABLE
  }), new MacAddressMgrColumn('address/macAddress', {
    displayName: lex('deviceManager.mac'),
    type: BACNET_ADDRESS_TYPE,
    flags: EDITABLE
  }), new PropertyPathMgrColumn('config/deviceObject/maxAPDULengthAccepted', {
    displayName: lex('deviceManager.maxApdu'),
    type: DEVICE_OBJECT_TYPE,
    flags: UNSEEN
  }), new PropertyPathMgrColumn('config/deviceObject/segmentationSupported', {
    displayName: lex('deviceManager.segmentation'),
    type: DEVICE_OBJECT_TYPE,
    flags: UNSEEN
  }), new PropertyPathMgrColumn('config/deviceObject/vendorName', {
    displayName: lex('deviceManager.vendorName'),
    type: DEVICE_OBJECT_TYPE,
    flags: READONLY
  }), new PropertyPathMgrColumn('config/deviceObject/modelName', {
    displayName: lex('deviceManager.modelName'),
    type: DEVICE_OBJECT_TYPE,
    flags: READONLY
  }), new PropertyPathMgrColumn('config/deviceObject/firmwareRevision', {
    displayName: lex('deviceManager.fwRev'),
    type: DEVICE_OBJECT_TYPE,
    flags: READONLY
  }), new PropertyPathMgrColumn('config/deviceObject/applicationSoftwareVersion', {
    displayName: lex('deviceManager.appSwVer'),
    type: DEVICE_OBJECT_TYPE,
    flags: READONLY
  }), new PropertyMgrColumn('characterSet', {
    displayName: lex('deviceManager.charSet'),
    type: BACNET_DEVICE_TYPE,
    flags: UNSEEN
  }), new PropertyMgrColumn('enabled', {
    type: DEVICE_TYPE,
    flags: EDITABLE | UNSEEN
  }), new PropertyMgrColumn('health', {
    type: DEVICE_TYPE,
    flags: UNSEEN
  }), new PropertyMgrColumn('useCov', {
    type: BACNET_DEVICE_TYPE,
    flags: EDITABLE | UNSEEN
  }), new PropertyMgrColumn('maxCovSubscriptions', {
    type: BACNET_DEVICE_TYPE,
    flags: EDITABLE | UNSEEN
  }), new PropertyMgrColumn('covSubscriptions', {
    type: BACNET_DEVICE_TYPE,
    flags: UNSEEN
  })];

  /**
   * API Status: **Private**
   * @exports nmodule/bacnet/rc/wb/mgr/model/BacnetDeviceMgrModel
   */
  var exports = {};

  /**
   * @param {baja.Component} component component being loaded into the manager
   * @param {Array.<string|Type>} newTypes new types to be added
   * @param {baja.Type} folderType the type of new folders to create
   * @returns {Promise.<module:nmodule/driver/rc/wb/mgr/DeviceMgrModel>}
   */
  exports.make = function (component, newTypes, folderType) {
    return MgrTypeInfo.make(newTypes).then(function (newTypes) {
      return new DeviceMgrModel({
        columns: COLUMNS,
        component: component,
        newTypes: newTypes,
        folderType: folderType
      });
    });
  };
  return exports;
});
