/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'baja!bacnet:BacnetObject', 'lex!bacnet', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/model/folderMgrModelMixin', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, _, compUtils, addFolderMgrModelMixin, MgrModel, MgrTypeInfo, IconMgrColumn, NameMgrColumn, PathMgrColumn, PropertyMgrColumn, TypeMgrColumn, Column) {
  'use strict';

  var bacnetLex = lexs[0],
    closest = compUtils.closest,
    EDITABLE = Column.flags.EDITABLE,
    UNSEEN = Column.flags.UNSEEN,
    READONLY = Column.flags.READONLY,
    BACNET_OBJECT_TYPE = baja.lt('bacnet:BacnetObject');
  function getNewTypes(component) {
    return closest(component, 'bacnet:BacnetConfigDeviceExt').invoke({
      slot: 'getConfigTypes'
    }).then(function (str) {
      return MgrTypeInfo.make(_.without(str.split(';'), 'bacnet:BacnetDeviceObject'));
    }).then(function (newTypes) {
      return newTypes.sort(MgrTypeInfo.BY_DISPLAY_NAME);
    });
  }
  var ToStringPropertyMgrColumn = function ToStringPropertyMgrColumn() {
    PropertyMgrColumn.apply(this, arguments);
  };
  ToStringPropertyMgrColumn.prototype = Object.create(PropertyMgrColumn.prototype);
  ToStringPropertyMgrColumn.prototype.constructor = ToStringPropertyMgrColumn;
  ToStringPropertyMgrColumn.prototype.getValueFor = function (row) {
    return String(row.getSubject());
  };
  function makeColumns() {
    // MgrColumn.mixin(MyOtherManagerColumn);

    return [new IconMgrColumn(), new PathMgrColumn({
      flags: UNSEEN | READONLY
    }), new NameMgrColumn({
      flags: EDITABLE
    }), new TypeMgrColumn({
      flags: EDITABLE | UNSEEN
    }), new ToStringPropertyMgrColumn('value', {
      displayName: bacnetLex.get('configManager.value')
    }), new PropertyMgrColumn('objectId', {
      displayName: bacnetLex.get('learn.objectId'),
      flags: EDITABLE,
      type: BACNET_OBJECT_TYPE
    }), new PropertyMgrColumn('objectName', {
      displayName: bacnetLex.get('configManager.objectName'),
      type: BACNET_OBJECT_TYPE
    }), new PropertyMgrColumn('description', {
      displayName: bacnetLex.get('configManager.description'),
      getDefaultValue: _.constant('')
    }), new PropertyMgrColumn('pollFrequency', {
      flags: EDITABLE | UNSEEN,
      type: BACNET_OBJECT_TYPE
    })];
  }

  /**
   * API Status: **Private**
   * @exports nmodule/bacnet/rc/wb/mgr/model/BacnetConfigMgrModel
   */
  var exports = {};

  /**
   * @param {baja.Component} component component being loaded into the manager
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/model/MgrModel>}
   */
  exports.make = function (component) {
    return getNewTypes(component).then(function (newTypes) {
      var model = new MgrModel({
        columns: makeColumns(),
        componentSource: component,
        newTypes: newTypes
      });
      addFolderMgrModelMixin(model, {
        folderType: 'bacnet:BacnetConfigFolder'
      });

      /**
       * Get the display name from the display name of the root component container.
       * This is used for the title of the tab in the HTML5 hx profile.
       */
      model.getNavDisplayName = function () {
        return component.getNavDisplayName();
      };
      return model;
    });
  };
  return exports;
});
